/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.navigator.net;

import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.ProjectFolder;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.IdeDisplayURLFileSystemHelper;
import oracle.ide.net.URLFileSystem;

public class DMURLFileSystemHelper
extends IdeDisplayURLFileSystemHelper {
    private static final Logger theLogger = Logger.getLogger(DMURLFileSystemHelper.class.getName());
    public static final String DM_PROTOCOL = "dm";

    public String getSuffix(URL uRL) {
        String string = null;
        if (uRL != null) {
            string = uRL.getPath();
            int n = string.lastIndexOf(33);
            string = string.substring(n + 1);
        }
        return string;
    }

    public String getFileName(URL uRL) {
        String string = null;
        if (uRL != null) {
            string = uRL.getPath();
        }
        return string;
    }

    public Class<? extends Node> getDmURLClass(URL uRL) {
        if (!DM_PROTOCOL.equals(uRL.getProtocol())) {
            return null;
        }
        String string = null;
        if (uRL != null) {
            string = uRL.getPath();
            int n = string.indexOf("/");
            if (n < 0) {
                return ConnectionFolder.class;
            }
            if ((n = (string = string.substring(n + 1)).indexOf("/")) < 0) {
                return ProjectFolder.class;
            }
            int n2 = (string = string.substring(n + 1)).indexOf("/");
            if (n2 > 0) {
                return null;
            }
            return WorkflowNode.class;
        }
        return null;
    }

    public static String getProtocol() {
        return DM_PROTOCOL;
    }

    public String getPlatformPathName(URL uRL) {
        return uRL.getPath();
    }

    public URL getParent(URL uRL) {
        String string = uRL.toString();
        int n = string.lastIndexOf("/");
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(0, n);
        URL uRL2 = null;
        try {
            uRL2 = new URL(string2);
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return uRL2;
    }

    public boolean exists(URL uRL) {
        Node node = NodeFactory.find((URL)uRL);
        return node != null;
    }

    public String getName(URL uRL) {
        String string = URLFileSystem.getFileName((URL)uRL);
        return DMURLFileSystemHelper.getName(string);
    }

    public static String getName(String string) {
        int n = string.lastIndexOf("/");
        return n > 0 ? string.substring(n + 1, string.length()) : string;
    }

    public boolean isReadOnly(URL uRL) {
        return false;
    }

    public void rename(URL uRL, URL uRL2) throws IOException {
        Node node = NodeFactory.find((URL)uRL);
        node.setURL(uRL2);
        node.notifyObservers((Object)node, new UpdateMessage(UpdateMessage.OBJECT_RENAMED, (Object)node));
    }
}

