/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.partition;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.ControlsLrb;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.dal.Query;
import oracle.dmt.dataminer.core.dal.sql.SqlDataAccessObject;
import oracle.dmt.dataminer.core.dal.sql.queries.common.build.GetPartitionsColumnsQuery;
import oracle.dmt.dataminer.core.model.common.build.partition.PartitionColumn;
import oracle.dmt.dataminer.core.model.common.build.partition.Rule;
import oracle.dmt.dataminer.core.model.common.build.partition.RulesPartitionFilterData;
import oracle.dmt.dataminer.core.model.common.build.partition.SortColumns;
import oracle.dmt.dataminer.core.model.filter.SortDirection;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.partition.PartitionsLrb;
import oracle.dmt.dataminer.partition.ValueCellEditor;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.ide.Context;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;

public class RulesPartitionFilterSortingPanel
extends JPanel
implements DataminerGUIPanel {
    private Context context;
    private String[] models;
    private String modelsSQL;
    private boolean hasError;
    private boolean hasFiltering;
    private boolean showSorting;
    private boolean isClassification;
    private boolean isFilterVisible;
    private PartitionFilterTableModel model;
    private List<PartitionColumn> partitionColumns;
    private RulesPartitionFilterData filterData;
    private JRadioButton jAscSortBtn;
    private JPanel jContainterPanel;
    private JRadioButton jDescSortBtn;
    private JLabel jErrorLabel;
    private JSpinner jFetchSize;
    private JLabel jFetchSizeLabel;
    private JLabel jFilterInfoLabel;
    private JPanel jFilterPanel;
    private JPanel jInfoPanel;
    private JRadioButton jMatchAllRadio;
    private JRadioButton jMatchAnyRadio;
    private ButtonGroup jMatchGroup;
    private JButton jQueryBtn;
    private JPanel jSetupPanel;
    private JButton jShowBtn;
    private JLabel jSortByLabel;
    private JComboBox<SortColumns> jSortColumnCombo;
    private ButtonGroup jSortGroup;
    private ButtonGroup jSortOrderGroup;
    private JPanel jSortingPanel;
    private DataMinerTablePanel rulesFilteringPanel;
    private JButton addRuleBtn;
    private JButton removeRuleBtn;

    public RulesPartitionFilterSortingPanel() {
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public RulesPartitionFilterSortingPanel(Context context, String[] stringArray) {
        this(context, stringArray, false, false);
    }

    public RulesPartitionFilterSortingPanel(Context context, String[] stringArray, boolean bl, boolean bl2) {
        this.filterData = new RulesPartitionFilterData();
        this.context = context;
        this.models = stringArray;
        this.showSorting = bl;
        this.isClassification = bl2;
        SortColumns sortColumns = bl2 ? SortColumns.CLASSIFICATION_COLUMNS[0] : SortColumns.REGRESSION_COLUMNS[0];
        this.filterData.setSortColumn(sortColumns);
        this.initModelsSQL(stringArray);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initModelsSQL(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append("'");
            stringBuilder.append(string);
            stringBuilder.append("',");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        this.modelsSQL = stringBuilder.toString();
    }

    private void initComponents() {
        this.jMatchGroup = new ButtonGroup();
        this.jSortGroup = new ButtonGroup();
        this.jSortOrderGroup = new ButtonGroup();
        this.jSetupPanel = new JPanel();
        this.jFetchSizeLabel = new JLabel();
        this.jFetchSize = new JSpinner();
        this.jQueryBtn = new JButton();
        this.jShowBtn = new JButton();
        this.jContainterPanel = new JPanel();
        this.jInfoPanel = new JPanel();
        this.jFilterInfoLabel = new JLabel();
        this.jFilterPanel = new JPanel();
        this.jMatchAllRadio = new JRadioButton();
        this.jMatchAnyRadio = new JRadioButton();
        this.rulesFilteringPanel = new DataMinerTablePanel();
        this.jErrorLabel = new JLabel();
        this.jSortingPanel = new JPanel();
        this.jSortColumnCombo = new JComboBox();
        this.jDescSortBtn = new JRadioButton();
        this.jAscSortBtn = new JRadioButton();
        this.jSortByLabel = new JLabel();
        this.setLayout(new BoxLayout(this, 1));
        this.jFetchSizeLabel.setText("Fetch Size:");
        this.jQueryBtn.setText("Query");
        this.jShowBtn.setText("Less");
        GroupLayout groupLayout = new GroupLayout(this.jSetupPanel);
        this.jSetupPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jFetchSizeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jFetchSize, -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 627, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jShowBtn, -1, -1, Short.MAX_VALUE).addComponent(this.jQueryBtn, -1, 100, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(5, 5, 5).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jFetchSizeLabel).addComponent(this.jFetchSize, -2, -1, -2).addComponent(this.jQueryBtn)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jShowBtn).addGap(5, 5, 5)));
        this.add(this.jSetupPanel);
        this.jContainterPanel.setLayout(new BoxLayout(this.jContainterPanel, 3));
        this.jFilterInfoLabel.setText("Active Filter");
        GroupLayout groupLayout2 = new GroupLayout(this.jInfoPanel);
        this.jInfoPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jFilterInfoLabel).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGap(5, 5, 5).addComponent(this.jFilterInfoLabel).addGap(5, 5, 5)));
        this.jContainterPanel.add(this.jInfoPanel);
        this.jMatchGroup.add(this.jMatchAllRadio);
        this.jMatchAllRadio.setSelected(true);
        this.jMatchAllRadio.setText("Match ALL of the following");
        this.jMatchGroup.add(this.jMatchAnyRadio);
        this.jMatchAnyRadio.setText("Match ANY of the following");
        this.jErrorLabel.setHorizontalAlignment(4);
        this.jErrorLabel.setText("A Rule is Incomplete");
        GroupLayout groupLayout3 = new GroupLayout(this.jFilterPanel);
        this.jFilterPanel.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rulesFilteringPanel, -1, 850, Short.MAX_VALUE).addGroup(groupLayout3.createSequentialGroup().addComponent(this.jMatchAllRadio).addGap(18, 18, 18).addComponent(this.jMatchAnyRadio).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jErrorLabel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMatchAllRadio).addComponent(this.jMatchAnyRadio)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.rulesFilteringPanel, -2, 165, -2).addGap(5, 5, 5).addComponent(this.jErrorLabel).addGap(5, 5, 5)));
        this.jContainterPanel.add(this.jFilterPanel);
        this.jSortOrderGroup.add(this.jDescSortBtn);
        this.jDescSortBtn.setSelected(true);
        this.jDescSortBtn.setText("Descending");
        this.jSortOrderGroup.add(this.jAscSortBtn);
        this.jAscSortBtn.setText("Ascending");
        this.jSortByLabel.setText("Sort By");
        GroupLayout groupLayout4 = new GroupLayout(this.jSortingPanel);
        this.jSortingPanel.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addContainerGap().addComponent(this.jSortByLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSortColumnCombo, -2, 200, -2).addGap(18, 18, 18).addComponent(this.jDescSortBtn).addGap(18, 18, 18).addComponent(this.jAscSortBtn).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addGap(5, 5, 5).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSortColumnCombo, -2, -1, -2).addComponent(this.jDescSortBtn).addComponent(this.jAscSortBtn).addComponent(this.jSortByLabel)).addGap(5, 5, 5)));
        this.jContainterPanel.add(this.jSortingPanel);
        this.add(this.jContainterPanel);
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jErrorLabel, null, (String)"");
        ResourceUtils.resButton((AbstractButton)this.jMatchAllRadio, (String)PartitionsLrb.get("FILTER_MATCH_ALL"));
        ResourceUtils.resButton((AbstractButton)this.jMatchAnyRadio, (String)PartitionsLrb.get("FILTER_MATCH_ANY"));
        ResourceUtils.resLabel((JLabel)this.jFilterInfoLabel, null, (String)PartitionsLrb.get("FILTER_NONE"));
        ResourceUtils.resLabel((JLabel)this.jFetchSizeLabel, (Component)this.jFetchSize, (String)PartitionsLrb.get("FILTER_FETCH_SIZE"));
        ResourceUtils.resButton((AbstractButton)this.jAscSortBtn, (String)CommonLrb.get("ASCENDING"));
        ResourceUtils.resButton((AbstractButton)this.jDescSortBtn, (String)CommonLrb.get("DESCENDING"));
        ResourceUtils.resLabel((JLabel)this.jSortByLabel, null, (String)CommonLrb.get("SORT_BY"));
        ResourceUtils.resButton((AbstractButton)this.jQueryBtn, (String)CommonLrb.get("QUERY"));
        this.jQueryBtn.setIcon(OracleIcons.getIcon((String)"run.png"));
        ResourceUtils.resButton((AbstractButton)this.jShowBtn, (String)ControlsLrb.get("FILTER_MORE"));
        this.jShowBtn.setIcon(DataMinerIcons.get(Icons.EXPAND));
        this.jShowBtn.getAccessibleContext().setAccessibleName(ControlsLrb.get("FILTER_MORE"));
        this.jShowBtn.setHorizontalTextPosition(10);
    }

    @Override
    public void initUI() {
        this.initUIComponents();
        this.initRulesFilteringTable();
        this.initUIListeners();
    }

    private void initUIComponents() {
        String string = this.showSorting ? PartitionsLrb.get("FILTER_SORTING_TITLE") : PartitionsLrb.get("FILTER_TITLE");
        this.jContainterPanel.setBorder(BorderFactory.createTitledBorder(string));
        if (this.showSorting) {
            SortColumns[] sortColumnsArray = this.isClassification ? SortColumns.CLASSIFICATION_COLUMNS : SortColumns.REGRESSION_COLUMNS;
            this.jSortColumnCombo.setModel(new DefaultComboBoxModel<SortColumns>(sortColumnsArray));
        }
        this.jFetchSize.setValue(100);
        this.displayFilterSortingPanels();
    }

    private void displayFilterSortingPanels() {
        this.jInfoPanel.setVisible(!this.isFilterVisible);
        this.jFilterPanel.setVisible(this.isFilterVisible);
        this.jSortingPanel.setVisible(this.isFilterVisible && this.showSorting);
    }

    private void initRulesFilteringTable() {
        this.model = new PartitionFilterTableModel();
        this.model.addTableModelListener(new PartitionFilterTableModelListener());
        this.rulesFilteringPanel.setup((TableModel)((Object)this.model), PartitionsLrb.get("FILTER_TITLE"), -1);
        this.rulesFilteringPanel.removeSearchField();
        DataMinerTable dataMinerTable = this.rulesFilteringPanel.getTable();
        ((JTable)((Object)dataMinerTable)).setRowSorter(null);
        ((JTable)((Object)dataMinerTable)).setAutoResizeMode(4);
        ((JTable)((Object)dataMinerTable)).getSelectionModel().addListSelectionListener(new PartitionFilterTableSelectionListener());
        TableColumnModel tableColumnModel = this.rulesFilteringPanel.getTable().getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(1);
        tableColumn.setCellEditor(new OperatorCellEditor());
        TableColumn tableColumn2 = tableColumnModel.getColumn(2);
        tableColumn2.setCellEditor(new ValueCellEditor(this.context, this.modelsSQL));
        this.initRulesFilteringTableToolbar();
    }

    private void initRulesFilteringTableToolbar() {
        this.addRuleBtn = new JButton();
        this.addRuleBtn.setIcon(OracleIcons.getIcon((String)"add.png"));
        this.addRuleBtn.addActionListener(new AddRuleActionListener());
        this.addRuleBtn.setEnabled(false);
        this.removeRuleBtn = new JButton();
        this.removeRuleBtn.setIcon(OracleIcons.getIcon((String)"delete.png"));
        this.removeRuleBtn.addActionListener(new RemoveRuleActionListener());
        this.removeRuleBtn.setEnabled(false);
        this.rulesFilteringPanel.addControlBarComponents(this.addRuleBtn, this.removeRuleBtn);
    }

    private void initUIListeners() {
        this.jShowBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RulesPartitionFilterSortingPanel.this.toogleFilterVisible();
            }
        });
        this.jSortColumnCombo.addActionListener(new SortComboActionListener());
        SortOrderActionListener sortOrderActionListener = new SortOrderActionListener();
        this.jDescSortBtn.addActionListener(sortOrderActionListener);
        this.jAscSortBtn.addActionListener(sortOrderActionListener);
    }

    private void toogleFilterVisible() {
        boolean bl = this.isFilterVisible = !this.isFilterVisible;
        if (this.isFilterVisible) {
            ResourceUtils.resButton((AbstractButton)this.jShowBtn, (String)ControlsLrb.get("FILTER_HIDE"));
            this.jShowBtn.setText(CommonLrb.get("LESS"));
            this.jShowBtn.setIcon(DataMinerIcons.get(Icons.COLLAPSE));
            this.jShowBtn.getAccessibleContext().setAccessibleName(ControlsLrb.get("FILTER_HIDE"));
            this.jShowBtn.getAccessibleContext().setAccessibleDescription(ControlsLrb.get("FILTER_HIDE_ADA"));
        } else {
            ResourceUtils.resButton((AbstractButton)this.jShowBtn, (String)ControlsLrb.get("FILTER_MORE"));
            this.jShowBtn.setText(CommonLrb.get("MORE"));
            this.jShowBtn.setIcon(DataMinerIcons.get(Icons.EXPAND));
            this.jShowBtn.getAccessibleContext().setAccessibleName(ControlsLrb.get("FILTER_MORE"));
            this.jShowBtn.getAccessibleContext().setAccessibleDescription(ControlsLrb.get("FILTER_MORE_ADA"));
        }
        this.jShowBtn.setHorizontalTextPosition(10);
        this.displayFilterSortingPanels();
        if (this.hasError) {
            ResourceUtils.resLabel((JLabel)this.jFilterInfoLabel, null, (String)PartitionsLrb.get("FILTER_COLAPSED_ERROR"));
            this.jFilterInfoLabel.setIcon(DataMinerIcons.get(Icons.ERROR_STATUS));
        } else if (this.hasFiltering) {
            String string = this.showSorting ? PartitionsLrb.get("FILTER_SORTING_COLAPSED_ACTIVE") : PartitionsLrb.get("FILTER_COLAPSED_ACTIVE");
            ResourceUtils.resLabel((JLabel)this.jFilterInfoLabel, null, (String)string);
            this.jFilterInfoLabel.setIcon(OracleIcons.getIcon((String)"filter.png"));
        } else {
            ResourceUtils.resLabel((JLabel)this.jFilterInfoLabel, null, (String)PartitionsLrb.get("FILTER_NONE"));
            this.jFilterInfoLabel.setIcon(null);
        }
        this.jContainterPanel.invalidate();
    }

    private List<Rule> getFilterRules() {
        List list = this.model.getSrcData();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Rule> arrayList = new ArrayList<Rule>();
        for (Rule rule : list) {
            if (!rule.isComplete()) continue;
            arrayList.add(rule);
        }
        return arrayList;
    }

    public RulesPartitionFilterData getCurrentFilterData() {
        this.filterData.setFetchSize(((Integer)this.jFetchSize.getValue()).intValue());
        this.filterData.setMatchAll(this.jMatchAllRadio.isSelected());
        this.filterData.setRules(this.getFilterRules());
        return this.filterData;
    }

    public JButton getQueryButton() {
        return this.jQueryBtn;
    }

    public void validateRules() {
        List list = this.model.getSrcData();
        boolean bl = true;
        if (list.isEmpty()) {
            this.hasFiltering = false;
            this.hasError = false;
        } else {
            int n = 0;
            for (Rule rule : list) {
                if (rule.isEmpty()) {
                    ++n;
                    continue;
                }
                if (rule.isComplete()) continue;
                bl = false;
                break;
            }
            if (bl) {
                this.hasFiltering = n != list.size();
                this.hasError = false;
            } else {
                this.hasError = true;
            }
        }
        this.jErrorLabel.setText(bl ? "" : PartitionsLrb.get("FILTER_ERROR"));
        this.jErrorLabel.setIcon(bl ? null : OracleIcons.getIcon((String)"warning.png"));
        this.jQueryBtn.setEnabled(bl);
    }

    public void loadPartitionColumns() {
        new FindPartitionsColumnsWorker().execute();
    }

    private static class OperatorCellEditor
    extends DefaultCellEditor {
        private static final DefaultComboBoxModel<Rule.OPERATORS> NUMBER_MODEL = new DefaultComboBoxModel();
        private static final DefaultComboBoxModel<Rule.OPERATORS> STRING_MODEL;

        private OperatorCellEditor() {
            super(new JComboBox());
            this.setClickCountToStart(2);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            assert (component instanceof JComboBox);
            JComboBox jComboBox = (JComboBox)component;
            Object object2 = jTable.getValueAt(n, 0);
            assert (object2 instanceof PartitionColumn);
            PartitionColumn partitionColumn = (PartitionColumn)object2;
            DefaultComboBoxModel<Rule.OPERATORS> defaultComboBoxModel = partitionColumn.isStringDataType() ? STRING_MODEL : NUMBER_MODEL;
            jComboBox.setModel(defaultComboBoxModel);
            return component;
        }

        static {
            NUMBER_MODEL.addElement(Rule.OPERATORS.IS);
            NUMBER_MODEL.addElement(Rule.OPERATORS.GREATER_THAN);
            NUMBER_MODEL.addElement(Rule.OPERATORS.LESS_THAN);
            STRING_MODEL = new DefaultComboBoxModel();
            STRING_MODEL.addElement(Rule.OPERATORS.IS);
            STRING_MODEL.addElement(Rule.OPERATORS.IS_NOT);
            STRING_MODEL.addElement(Rule.OPERATORS.CONTAINS);
            STRING_MODEL.addElement(Rule.OPERATORS.NOT_CONTAINS);
            STRING_MODEL.addElement(Rule.OPERATORS.STARTS);
            STRING_MODEL.addElement(Rule.OPERATORS.NOT_START);
            STRING_MODEL.addElement(Rule.OPERATORS.ENDS);
            STRING_MODEL.addElement(Rule.OPERATORS.NOT_END);
        }
    }

    private static class PartitionFilterTableModel
    extends ODMrTableModel<Rule> {
        private static final int PARTITION_KEY = 0;
        private static final int OPERATOR = 1;
        private static final int VALUE = 2;

        private PartitionFilterTableModel() {
            super(new String[]{PartitionsLrb.get("FILTER_COL_PARTITION_KEY"), PartitionsLrb.get("FILTER_COL_OPERATOR"), PartitionsLrb.get("FILTER_COL_VALUE")});
        }

        public Object getValueAt(int n, int n2) {
            Rule rule = (Rule)this.srcData.get(n);
            switch (n2) {
                case 0: {
                    return rule.getPartitionKey();
                }
                case 1: {
                    return rule.getOperator();
                }
                case 2: {
                    return rule.getValue();
                }
            }
            throw new IllegalArgumentException("Invalid column index");
        }

        public void setValueAt(Object object, int n, int n2) {
            Rule rule = (Rule)this.srcData.get(n);
            switch (n2) {
                case 0: {
                    rule.setPartitionKey((PartitionColumn)object);
                    break;
                }
                case 1: {
                    assert (object instanceof Rule.OPERATORS);
                    rule.setOperator((Rule.OPERATORS)object);
                    break;
                }
                case 2: {
                    rule.setValue(object.toString());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid column index");
                }
            }
            this.fireTableCellUpdated(n, n2);
        }

        public boolean isCellEditable(int n, int n2) {
            switch (n2) {
                case 0: 
                case 3: {
                    return true;
                }
                case 1: 
                case 2: {
                    Rule rule = (Rule)this.srcData.get(n);
                    return rule.getPartitionKey() != null;
                }
            }
            return false;
        }
    }

    private class SortComboActionListener
    implements ActionListener {
        private SortComboActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SortColumns sortColumns = (SortColumns)RulesPartitionFilterSortingPanel.this.jSortColumnCombo.getSelectedItem();
            RulesPartitionFilterSortingPanel.this.filterData.setSortColumn(sortColumns);
        }
    }

    private class SortOrderActionListener
    implements ActionListener {
        private SortOrderActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SortDirection sortDirection;
            Object object = this.isDescending(actionEvent) ? SortDirection.DESCENDING : (sortDirection = this.isAscending(actionEvent) ? SortDirection.ASCENDING : null);
            assert (sortDirection != null) : "Invalid source object";
            RulesPartitionFilterSortingPanel.this.filterData.setSortOrder(sortDirection);
        }

        private boolean isDescending(ActionEvent actionEvent) {
            return actionEvent.getSource() == RulesPartitionFilterSortingPanel.this.jDescSortBtn;
        }

        private boolean isAscending(ActionEvent actionEvent) {
            return actionEvent.getSource() == RulesPartitionFilterSortingPanel.this.jAscSortBtn;
        }
    }

    private class RemoveRuleActionListener
    implements ActionListener {
        private RemoveRuleActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RulesPartitionFilterSortingPanel.this.rulesFilteringPanel.getTable().removeEditor();
            this.deleteRows(this.getRowsToDelete());
        }

        private final int[] getRowsToDelete() {
            int[] nArray = new int[]{};
            DataMinerTable dataMinerTable = RulesPartitionFilterSortingPanel.this.rulesFilteringPanel.getTable();
            int n = ((JTable)((Object)dataMinerTable)).getEditingRow();
            nArray = n >= 0 ? new int[]{n} : ((JTable)((Object)dataMinerTable)).getSelectedRows();
            return nArray;
        }

        private final void deleteRows(int[] nArray) {
            ArrayList<Rule> arrayList = new ArrayList<Rule>(nArray.length);
            for (int n : nArray) {
                arrayList.add((Rule)RulesPartitionFilterSortingPanel.this.model.getSrcData().get(n));
            }
            RulesPartitionFilterSortingPanel.this.model.removeRows(arrayList);
        }
    }

    private class AddRuleActionListener
    implements ActionListener {
        private AddRuleActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.addNewRule();
            this.openEditorOnNewRule();
        }

        private void addNewRule() {
            Rule rule = Rule.createEmptyRule();
            rule.setPartitionKey(RulesPartitionFilterSortingPanel.this.partitionColumns.get(0));
            RulesPartitionFilterSortingPanel.this.model.addRow(rule);
        }

        private void openEditorOnNewRule() {
            int n = RulesPartitionFilterSortingPanel.this.model.getRowCount() - 1;
            RulesPartitionFilterSortingPanel.this.rulesFilteringPanel.getTable().setRowSelectionInterval(n, n);
            RulesPartitionFilterSortingPanel.this.rulesFilteringPanel.getTable().editCellAt(n, 0);
            RulesPartitionFilterSortingPanel.this.rulesFilteringPanel.getTable().getEditorComponent().requestFocus();
        }
    }

    private class PartitionFilterTableSelectionListener
    implements ListSelectionListener {
        private PartitionFilterTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            RulesPartitionFilterSortingPanel.this.removeRuleBtn.setEnabled(this.isRowSelected(listSelectionEvent));
        }

        private final boolean isRowSelected(ListSelectionEvent listSelectionEvent) {
            return RulesPartitionFilterSortingPanel.this.rulesFilteringPanel.getTable().getRowCount() > 0;
        }
    }

    private class PartitionFilterTableModelListener
    implements TableModelListener {
        private PartitionFilterTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            if (this.partitionColumnChanged(tableModelEvent)) {
                this.checkDataTypeChange(tableModelEvent);
            }
            if (this.needsValidation(tableModelEvent.getType())) {
                RulesPartitionFilterSortingPanel.this.validateRules();
            }
        }

        private boolean partitionColumnChanged(TableModelEvent tableModelEvent) {
            return tableModelEvent.getType() == 0 && tableModelEvent.getColumn() == 0;
        }

        private void checkDataTypeChange(TableModelEvent tableModelEvent) {
            int n = tableModelEvent.getFirstRow();
            DataMinerTable dataMinerTable = RulesPartitionFilterSortingPanel.this.rulesFilteringPanel.getTable();
            PartitionColumn partitionColumn = (PartitionColumn)((JTable)((Object)dataMinerTable)).getValueAt(n, 0);
            if (partitionColumn == null) {
                return;
            }
            Rule.OPERATORS oPERATORS = (Rule.OPERATORS)((JTable)((Object)dataMinerTable)).getValueAt(n, 1);
            if (this.areDataTypesDifferent(partitionColumn, oPERATORS)) {
                ((JTable)((Object)dataMinerTable)).setValueAt(Rule.OPERATORS.EMPTY, n, 1);
            }
        }

        private boolean areDataTypesDifferent(PartitionColumn partitionColumn, Rule.OPERATORS oPERATORS) {
            if (partitionColumn.isStringDataType()) {
                return !oPERATORS.isStringOperator();
            }
            return !oPERATORS.isNumberOperator();
        }

        private boolean needsValidation(int n) {
            return n == 0 || n == -1 || n == 1;
        }
    }

    private class FindPartitionsColumnsWorker
    extends ODMrSwingWorker<List<PartitionColumn>, Void> {
        private FindPartitionsColumnsWorker() {
            super(RulesPartitionFilterSortingPanel.this);
        }

        @Override
        protected List<PartitionColumn> doInBackground() throws Exception {
            ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(RulesPartitionFilterSortingPanel.this.context);
            SqlDataAccessObject sqlDataAccessObject = new SqlDataAccessObject((ConnectionManager)connectionFolder);
            List<String> list = Arrays.asList(RulesPartitionFilterSortingPanel.this.models);
            GetPartitionsColumnsQuery getPartitionsColumnsQuery = new GetPartitionsColumnsQuery(connectionFolder.getDbVersion(), list);
            return sqlDataAccessObject.readItems((Query)getPartitionsColumnsQuery);
        }

        @Override
        protected void onSuccess(List<PartitionColumn> list) throws Exception {
            this.configurePartitionColumnEditor(list);
        }

        private void configurePartitionColumnEditor(List<PartitionColumn> list) {
            JComboBox<PartitionColumn> jComboBox = new JComboBox<PartitionColumn>();
            TableColumnModel tableColumnModel = RulesPartitionFilterSortingPanel.this.rulesFilteringPanel.getTable().getColumnModel();
            jComboBox.setModel(new DefaultComboBoxModel<PartitionColumn>(list.toArray(new PartitionColumn[list.size()])));
            DefaultCellEditor defaultCellEditor = new DefaultCellEditor(jComboBox);
            defaultCellEditor.setClickCountToStart(2);
            tableColumnModel.getColumn(0).setCellEditor(defaultCellEditor);
            RulesPartitionFilterSortingPanel.this.partitionColumns = list;
            RulesPartitionFilterSortingPanel.this.addRuleBtn.setEnabled(true);
        }
    }
}

