/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.dal.Query;
import oracle.dmt.dataminer.core.dal.sql.queries.ar.ap.GetItemGlobalMetricsQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.ar.ap.GetItemSetsQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.ar.ap.GetMaxLiftQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.ar.ap.GetRulesQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.common.build.GetModelSettingsQuery;
import oracle.dmt.dataminer.core.model.ar.ItemSet;
import oracle.dmt.dataminer.core.model.ar.ItemSetStructure;
import oracle.dmt.dataminer.core.model.ar.Rule;
import oracle.dmt.dataminer.core.model.ar.RulesFilterSetting;
import oracle.dmt.dataminer.core.model.common.NameValuePair;
import oracle.dmt.dataminer.core.model.common.build.MiningModelSettings;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.model.GlobalDetails;
import oracle.dmt.dataminer.server.model.ItemSetsFilterSetting;
import oracle.dmt.dataminer.server.model.Model;

public class AssociationRules
extends Model {
    private boolean onlyOneColumnNameInModelItems = true;
    private boolean onlyOneSubColumnNameInModelItems = true;
    private boolean onlyOneConstantValueInModelItems = true;
    private boolean noSubNameColumnsInModelItems;
    private Integer totalNumberOfSingleOccuringItems = 1000;
    private ItemSetStructure itemSetStructure = ItemSetStructure.NAME;
    private Map<String, Object> globalMetrics;
    private List<String> aggregates;
    private boolean is2dModel;

    public AssociationRules(ConnectionManager connectionManager, String string, String string2) {
        super(connectionManager, string, string2);
    }

    public List<ItemSet> loadItemSets(ItemSetsFilterSetting itemSetsFilterSetting) throws ODMrDAOException {
        this.loadGlobalMetrics();
        this.loadModelSettings();
        return this.getItemSets(itemSetsFilterSetting);
    }

    private void loadModelSettings() throws ODMrDAOException {
        GetModelSettingsQuery getModelSettingsQuery = new GetModelSettingsQuery(this.connectionManager.getDbVersion()).setOwner(this.getUserName()).setModel(this.getModelName()).setSettingsFilter("ASSO_AGGREGATES", new String[]{"ODMS_ITEM_ID_COLUMN_NAME"});
        List list = this.dao.readItems((Query)getModelSettingsQuery);
        MiningModelSettings miningModelSettings = MiningModelSettings.findSetting((String)"ASSO_AGGREGATES", (List)list);
        MiningModelSettings miningModelSettings2 = MiningModelSettings.findSetting((String)"ODMS_ITEM_ID_COLUMN_NAME", (List)list);
        this.checkAggregatesSetting(miningModelSettings);
        this.checkItemIdColumn(miningModelSettings2);
    }

    private void checkAggregatesSetting(MiningModelSettings miningModelSettings) {
        this.aggregates = new ArrayList<String>();
        if (miningModelSettings != null) {
            String[] stringArray = miningModelSettings.getSettingValue().split(",");
            this.aggregates = Arrays.asList(stringArray);
        }
    }

    private void checkItemIdColumn(MiningModelSettings miningModelSettings) {
        this.is2dModel = StringUtils.isNotEmpty(miningModelSettings.getSettingValue());
    }

    public List<ItemSet> getItemSets(ItemSetsFilterSetting itemSetsFilterSetting) throws ODMrDAOException {
        GetItemSetsQuery getItemSetsQuery = new GetItemSetsQuery(this.connectionManager.getDbVersion(), this.modelDescriptor, itemSetsFilterSetting.getFetchSize(), this.aggregates, itemSetsFilterSetting.getSortSpecification(), this.getTransactionCount());
        if (itemSetsFilterSetting.isUseFilterSpecification()) {
            getItemSetsQuery.setMaxItemSetLength(Integer.valueOf(itemSetsFilterSetting.getMaxItemSetLength())).setMinSupport(itemSetsFilterSetting.getMinSupport());
        }
        List list = this.dao.readItems((Query)getItemSetsQuery);
        for (ItemSet itemSet : list) {
            itemSet.setItemSetStructure(this.itemSetStructure);
        }
        return list;
    }

    public List<Rule> loadRules(RulesFilterSetting rulesFilterSetting) throws ODMrDAOException {
        this.loadModelSettings();
        return this.getRules(rulesFilterSetting);
    }

    public List<Rule> getRules(RulesFilterSetting rulesFilterSetting) throws ODMrDAOException {
        GetRulesQuery getRulesQuery = new GetRulesQuery(this.connectionManager.getDbVersion(), this.modelDescriptor, rulesFilterSetting.getFetchSize(), this.aggregates, this.getTransactionCount()).setSorting(rulesFilterSetting.getSortSpecs());
        if (rulesFilterSetting.isFilterEnabled()) {
            getRulesQuery.setFilter(rulesFilterSetting.getFilters());
        }
        List list = this.dao.readItems((Query)getRulesQuery);
        return list;
    }

    public void loadGlobalMetrics() throws ODMrDAOException {
        this.globalMetrics = this.getGlobalDetails();
        Map<String, Object> map = this.getItemGlobalMetrics();
        Number number = this.getMaxLiftValue();
        this.globalMetrics.put("MAXIMUM_LIFT_VALUE", number);
        for (Map.Entry<String, Object> object2 : map.entrySet()) {
            this.globalMetrics.put(object2.getKey(), object2.getValue());
        }
        Integer n = (Integer)this.globalMetrics.get("SINGLE_ITEMSET_COUNT");
        Integer n2 = (Integer)this.globalMetrics.get("ATTRIBUTE_SUBNAME_COUNT");
        String string = (String)this.globalMetrics.get("MIN_ATTRIBUTE_NAME");
        String string2 = (String)this.globalMetrics.get("MAX_ATTRIBUTE_NAME");
        String string3 = (String)this.globalMetrics.get("MIN_ATTRIBUTE_SUBNAME");
        String string4 = (String)this.globalMetrics.get("MAX_ATTRIBUTE_SUBNAME");
        Object object = this.globalMetrics.get("MIN_ATTRIBUTE_VALUE");
        Object object2 = this.globalMetrics.get("MAX_ATTRIBUTE_VALUE");
        Object object3 = "";
        if (!string.equals(string2)) {
            object3 = (String)object3 + "NAME_";
        }
        if (!string3.equals(string4)) {
            object3 = (String)object3 + "SUBNAME_";
        }
        if (object != null && object2 != null) {
            object3 = (String)object3 + "VALUE_";
        }
        if (StringUtils.isNotEmpty((String)object3)) {
            object3 = ((String)object3).substring(0, ((String)object3).length() - 1);
            this.itemSetStructure = ItemSetStructure.valueOf((String)object3);
        } else {
            this.itemSetStructure = ItemSetStructure.NAME;
        }
        if (this.getTotalRulesCount() > 0) {
            this.onlyOneColumnNameInModelItems = string.equals(string2);
            this.onlyOneSubColumnNameInModelItems = string3 != null ? string3.equals(string4) : true;
            this.noSubNameColumnsInModelItems = n2 == 0;
            this.totalNumberOfSingleOccuringItems = n;
            if (object instanceof Number || object instanceof String) {
                this.onlyOneConstantValueInModelItems = object.equals(object2);
            } else if (object == null) {
                this.onlyOneConstantValueInModelItems = true;
            } else assert (false) : "Unknown data type for attribute value in model.";
        }
    }

    private Number getMaxLiftValue() throws ODMrDAOException {
        GetMaxLiftQuery getMaxLiftQuery = new GetMaxLiftQuery(this.connectionManager.getDbVersion(), this.modelDescriptor);
        return this.dao.readItem((Query)getMaxLiftQuery).orElse(0.0);
    }

    protected Map<String, Object> getGlobalDetails() throws ODMrDAOException {
        List<NameValuePair> list = GlobalDetails.getModelDetailsGlobal(this.connectionManager, this.modelDescriptor);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (NameValuePair nameValuePair : list) {
            hashMap.put(nameValuePair.getName(), nameValuePair.getValue());
        }
        return hashMap;
    }

    protected Map<String, Object> getItemGlobalMetrics() throws ODMrDAOException {
        GetItemGlobalMetricsQuery getItemGlobalMetricsQuery = new GetItemGlobalMetricsQuery(this.connectionManager.getDbVersion(), this.modelDescriptor);
        return this.dao.readItem((Query)getItemGlobalMetricsQuery).orElse(Collections.emptyMap());
    }

    public boolean isOnlyOneColumnNameInModelItems() {
        return this.onlyOneColumnNameInModelItems;
    }

    public boolean isOnlyOneSubColumnNameInModelItems() {
        return this.onlyOneSubColumnNameInModelItems;
    }

    public boolean isOnlyOneConstantValueInModelItems() {
        return this.onlyOneConstantValueInModelItems;
    }

    public boolean isNoSubNameColumnsInModelItems() {
        return this.noSubNameColumnsInModelItems;
    }

    public Integer getTotalNumberOfSingleOccuringItems() {
        return this.totalNumberOfSingleOccuringItems;
    }

    public int getTotalRulesCount() {
        int n = ((Double)this.globalMetrics.get("RULE_COUNT")).intValue();
        return n;
    }

    public Double getMaximumLiftValue() {
        Double d = (Double)this.globalMetrics.get("MAXIMUM_LIFT_VALUE");
        return d;
    }

    public int getTotalItemsetCount() {
        int n = ((Double)this.globalMetrics.get("ITEMSET_COUNT")).intValue();
        return n;
    }

    public int getTransactionCount() {
        int n = ((Double)this.globalMetrics.getOrDefault("TRANSACTION_COUNT", 1.0)).intValue();
        return n;
    }

    public List<String> getAggregates() {
        return this.aggregates;
    }

    public boolean is2dModel() {
        return this.is2dModel;
    }

    public ItemSetStructure getItemSetStructure() {
        return this.itemSetStructure;
    }
}

