/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.data;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import oracle.dmt.dataminer.core.dal.sql.ConnectionProperties;
import oracle.dmt.dataminer.core.model.common.ODMTableColumns;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.mviewer.ModelViewerState;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.DataNode;
import oracle.dmt.dataminer.navigator.DataProfilePhysicalNode;
import oracle.dmt.dataminer.navigator.LogicalDataNode;
import oracle.dmt.dataminer.navigator.PhysicalDataNode;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.navigator.modelnodes.AbstractModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.GLMCModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.GLMRModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.RModelNode;
import oracle.dmt.dataminer.navigator.wflownodes.DataProfileNavNode;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.teditor.data.DataEditor;
import oracle.dmt.dataminer.teditor.data.DataLrb;
import oracle.dmt.dataminer.teditor.data.DataSourceViewOption;
import oracle.dmt.dataminer.teditor.data.ODMrResultSetTableModel;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.parallelquery.ParallelQueryPreferences;
import oracle.dmt.dataminer.workflow.parallelquery.ViewDataParallelPanel;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.CGeneralizedLinearModelType;
import oracle.dmt.dataminer.workflow.xmlschema.DataNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataSourceNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAlgorithmType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RGeneralizedLinearModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RModelType;
import oracle.dmt.dataminer.workflow.xmlschema.SuperviseModelType;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.javatools.util.Version;

public class DataViewerState {
    private static final String NOT_IMPLEMENTED_ACTUAL_QUERY = "SELECT 'Not Implemented' AS NOT_IMPLEMENTED FROM DUAL";
    private static final String SELECT_ALL_FROM_QUALIFIED_QUOTED_TABLE_WITH_HINT = "SELECT %s * FROM \"%s\".\"%s\"";
    private static final String SELECT_FROM_QUALIFIED_QUOTED_TABLE_WITH_HINT = "SELECT %s %s FROM \"%s\".\"%s\"";
    private static final String SELECT_ALL_FROM_QUOTED_TABLE_WITH_HINT = "SELECT %s * FROM \"%s\"";
    private static final String SELECT_ALL_FROM_SUBQUERY_WITH_HINT = "SELECT %s * FROM ( %s )";
    private static final String SELECT_ALL_FROM_SUBQUERY = "SELECT * FROM ( %s )";
    private static final ParallelQueryPreferences parallelQueryPreferences = ParallelQueryPreferences.getInstance();
    private static final Logger theLogger = Logger.getLogger(DataViewerState.class.getName());
    private Context context;
    private String connectionName;
    private ModelViewerState modelViewerState;
    private boolean closing;
    private boolean is122AndUp;
    private boolean loadFromSQL;
    private boolean loadFromNode;
    private String tableName;
    private String selectSQL;
    private String schemaName;
    private String cacheTableName;
    private String cacheSchemaName;
    private Node node;
    private DataEditor dataEditor;
    private Connection connection;
    private DataSourceViewOption currentSourceOption;
    private ODMrResultSetTableModel resultSetModel;

    public DataViewerState(Context context, DataEditor dataEditor) {
        assert (context != null) : "Context cannot be passed into constructore as a null.";
        this.context = context;
        this.dataEditor = dataEditor;
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
        this.is122AndUp = DbVersionHelper.isDB122Up((Version)connectionFolder.getDbVersion());
        this.resultSetModel = new ODMrResultSetTableModel(this);
        this.currentSourceOption = DataSourceViewOption.CACHE;
        this.cacheSchemaName = "";
        this.cacheTableName = "";
        this.schemaName = "";
        this.tableName = "";
    }

    public DataViewerState(Context context, DataEditor dataEditor, boolean bl) {
        this(context, dataEditor);
        this.loadFromNode = bl;
        if (this.loadFromNode) {
            this.initSourceData();
        }
    }

    public DataViewerState(Context context, DataEditor dataEditor, String string) {
        this(context, dataEditor);
        this.loadFromSQL = true;
        this.selectSQL = string;
    }

    private void initSourceData() {
        this.node = this.context.getNode();
        assert (this.node != null) : "Tree Node is null";
        assert (this.node instanceof PhysicalDataNode || this.node instanceof GLMRModelNode || this.node instanceof GLMCModelNode || this.node instanceof LogicalDataNode || this.node instanceof DataProfileNavNode || this.node instanceof RModelNode) : "Node is not acceptable with Data Viewer";
        if (this.node instanceof PhysicalDataNode) {
            this.extractSourceFromPhysicalDataNode((PhysicalDataNode)this.node);
        } else if (this.node instanceof LogicalDataNode) {
            this.extractSourceFromLogicalDataNode((LogicalDataNode)this.node);
        } else if (this.node instanceof DataProfilePhysicalNode) {
            this.extractSourceFromDataProfilePhysicalNode((DataProfilePhysicalNode)this.node);
        } else if (this.node instanceof GLMRModelNode || this.node instanceof GLMCModelNode || this.node instanceof RModelNode) {
            this.extractSourceFromModelNode((ModelNode)this.node);
        }
    }

    private void extractSourceFromPhysicalDataNode(PhysicalDataNode physicalDataNode) {
        this.schemaName = physicalDataNode.getUserName();
        this.tableName = physicalDataNode.getTableName();
        this.cacheTableName = physicalDataNode.getCacheTableName();
        this.cacheSchemaName = physicalDataNode.getCacheSchemaName();
        this.setSourceActualIfCacheTableEmpty();
    }

    private void setSourceActualIfCacheTableEmpty() {
        if (this.cacheTableName.length() == 0) {
            this.currentSourceOption = DataSourceViewOption.ACTUAL;
        }
    }

    private void extractSourceFromLogicalDataNode(LogicalDataNode logicalDataNode) {
        this.cacheTableName = logicalDataNode.getCacheTableName();
        this.cacheSchemaName = logicalDataNode.getCacheSchemaName();
        if (this.selectSQL == null) {
            this.selectSQL = this.getStackedSQL();
        }
        this.setSourceActualIfCacheTableEmpty();
    }

    private String getStackedSQL() {
        DataNode dataNode = (DataNode)this.context.getNode();
        WorkflowNode workflowNode = (WorkflowNode)dataNode.getParent().getAncestor(WorkflowNode.class);
        WorkflowModel workflowModel = workflowNode.getWorkflowModel();
        if (workflowModel == null) {
            return null;
        }
        DataNodeType dataNodeType = (DataNodeType)dataNode.getRepositoryData();
        AbstractDataNode abstractDataNode = (AbstractDataNode)workflowModel.findNodeByMetadataId(dataNodeType.getId());
        if (abstractDataNode == null) {
            return null;
        }
        return abstractDataNode.getStackedSQL(workflowModel);
    }

    private void extractSourceFromDataProfilePhysicalNode(DataProfilePhysicalNode dataProfilePhysicalNode) {
        this.schemaName = dataProfilePhysicalNode.getCacheSchemaName();
        this.tableName = dataProfilePhysicalNode.getCacheTableName();
        this.cacheTableName = dataProfilePhysicalNode.getCacheTableName();
        this.cacheSchemaName = dataProfilePhysicalNode.getCacheSchemaName();
        this.setSourceActualIfCacheTableEmpty();
    }

    private void extractSourceFromModelNode(ModelNode modelNode) {
        this.currentSourceOption = DataSourceViewOption.ACTUAL;
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this.context);
        this.schemaName = connectionFolder.getUserAccountName();
        if (this.is122AndUp) {
            Model model = modelNode.getOdmModel();
            String string = this.getTablePrefix(modelNode);
            this.tableName = StringUtils.insertPrefix((String)model.getModelName(), (String)string);
        } else {
            AbstractModelNode abstractModelNode = (AbstractModelNode)modelNode;
            Object object = abstractModelNode.getRepositoryData();
            this.tableName = this.getDiagnosticsTableName((ModelType)object);
        }
    }

    private String getTablePrefix(ModelNode modelNode) {
        String string = "";
        if (modelNode instanceof GLMCModelNode) {
            string = "DM$VA";
        } else if (modelNode instanceof GLMRModelNode) {
            string = "DM$VA";
        } else if (modelNode instanceof RModelNode) {
            string = "DM$VD";
        } else assert (false) : "Model Type Not Supported.";
        return string;
    }

    private String getDiagnosticsTableName(ModelType modelType) {
        String string = "";
        if (modelType instanceof CGeneralizedLinearModelType) {
            string = ((CGeneralizedLinearModelType)modelType).getCGeneralizedLinearAlgo().getGLMSDIAGNOSTICSTABLENAME();
        } else if (modelType instanceof RGeneralizedLinearModelType) {
            string = ((RGeneralizedLinearModelType)modelType).getRGeneralizedLinearModelAlgo().getGLMSDIAGNOSTICSTABLENAME();
        } else assert (false) : "Model Type Not Supported.";
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws Exception {
        DataViewerState dataViewerState = this;
        synchronized (dataViewerState) {
            this.resultSetModel.setConnection(this.getConnection(), this.context);
        }
        if (this.node instanceof GLMRModelNode || this.node instanceof GLMCModelNode) {
            this.modelViewerState = new ModelViewerState(this.context);
            this.modelViewerState.load();
            assert (this.modelViewerState.getModelDesc().isGeneralizedLinearModelAlgorithm()) : "Data Viewer accepts only models of type GLM";
        }
    }

    private synchronized Connection getConnection() throws SQLException {
        if (this.connection == null) {
            this.connection = this.context != null ? ConnectionFolder.getConnection(this.context, ConnectionProperties.UNIQUE, ConnectionProperties.ALTER_SESSION_FIXES) : ConnectionFolder.getConnection(this.connectionName, ConnectionProperties.ALTER_SESSION_FIXES);
        }
        return this.connection;
    }

    public void reloadModel() throws Exception {
        String string = this.resultSetModel.getWhere();
        String string2 = this.resultSetModel.getOrderBy();
        this.resultSetModel = new ODMrResultSetTableModel(this);
        this.resultSetModel.setWhere(string);
        this.resultSetModel.setOrderBy(string2);
        this.loadModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadModel() throws Exception {
        this.resultSetModel.setResultSet(null);
        Object object = this;
        synchronized (object) {
            this.resultSetModel.setConnection(this.getConnection(), this.context);
        }
        object = this.getQuery();
        if (object == null) {
            object = "SELECT '" + DataLrb.get("DATA_VIEWER_ACTUAL_NO_QUERY_AVAILABLE") + "' as MESSAGE FROM DUAL";
            this.resultSetModel.setUseStandardColumnSize(true);
            this.resultSetModel.setStandardColumnSize(800);
        }
        this.resultSetModel.setSql((String)object);
        this.resultSetModel.setTranslatedColNames(true);
        if (this.node instanceof GLMRModelNode || this.node instanceof GLMCModelNode) {
            this.resultSetModel.setUseStandardColumnSize(true);
            this.resultSetModel.setStandardColumnSize(100);
        }
        if (this.node instanceof RModelNode) {
            this.resultSetModel.outputExceptionDetail();
        }
        this.resultSetModel.setThreaded(false);
        this.resultSetModel.setVerticalDisplay(false);
        this.resultSetModel.setSortColumn(-1);
    }

    public String getQuery() {
        String string;
        if (this.loadFromNode) {
            switch (this.currentSourceOption) {
                case CACHE: {
                    string = this.getQueryFromCache();
                    break;
                }
                case ACTUAL: {
                    string = this.getQueryFromActual();
                    break;
                }
                default: {
                    string = "";
                    break;
                }
            }
        } else {
            string = this.loadFromSQL ? this.selectSQL : this.getSelectAllQuery();
        }
        return string;
    }

    private String getQueryFromCache() {
        return this.getSelectAllQueryFromQualifiedSource(this.cacheSchemaName, this.cacheTableName);
    }

    private String getSelectAllQueryFromQualifiedSource(String string, String string2) {
        return String.format(SELECT_ALL_FROM_QUALIFIED_QUOTED_TABLE_WITH_HINT, DataViewerState.getParallelHint(), string, string2);
    }

    private String getSelectFromQueryFromQualifiedSource(String string, String string2, String string3) {
        return String.format(SELECT_FROM_QUALIFIED_QUOTED_TABLE_WITH_HINT, DataViewerState.getParallelHint(), string, string2, string3);
    }

    public static String getParallelHint() {
        Object object = "";
        String string = parallelQueryPreferences.getViewDataProperty(ViewDataParallelPanel.VIEW_KEY, ParallelQueryPreferences.PROPERTY.IS_PARALLEL);
        String string2 = parallelQueryPreferences.getViewDataProperty(ViewDataParallelPanel.VIEW_KEY, ParallelQueryPreferences.PROPERTY.VALUE);
        if (string != null && Boolean.parseBoolean(string)) {
            if (string2 == null || string2.equalsIgnoreCase("System Determined")) {
                object = "PARALLEL (AUTO)";
            } else {
                String string3 = String.valueOf(string2);
                object = StringUtils.getReplacedString((String)"PARALLEL (<DOP>)", (String)"<DOP>", (String)string3);
            }
            object = "/*+ " + (String)object + " */";
        }
        return object;
    }

    private String getQueryFromActual() {
        String string = NOT_IMPLEMENTED_ACTUAL_QUERY;
        if (this.node instanceof PhysicalDataNode || this.node instanceof GLMCModelNode || this.node instanceof GLMRModelNode || this.node instanceof RModelNode) {
            string = this.getSelectAllQuery();
            BaseTreeNode baseTreeNode = (BaseTreeNode)this.node;
            Object object = baseTreeNode.getRepositoryData();
            if (object instanceof DataNodeType) {
                DataNodeType dataNodeType = (DataNodeType)object;
                if (dataNodeType instanceof DataSourceNodeType) {
                    Attributes attributes = ((DataSourceNodeType)dataNodeType).getAttributes();
                    string = this.getQueryFromAttributesMetadata(attributes);
                }
            } else if (this.is122AndUp && DataViewerState.contextHasValidModelNodeForDataViewing(this.context)) {
                string = this.getSelectFromViewQuery(object);
            }
        } else if (this.node instanceof LogicalDataNode) {
            string = this.selectSQL == null ? null : String.format(SELECT_ALL_FROM_SUBQUERY_WITH_HINT, DataViewerState.getParallelHint(), this.selectSQL);
        } else if (this.node instanceof DataProfilePhysicalNode) {
            String string2 = ((DataProfilePhysicalNode)this.node).getStatsTableName();
            string = String.format(SELECT_ALL_FROM_QUOTED_TABLE_WITH_HINT, DataViewerState.getParallelHint(), string2);
        }
        return string;
    }

    private String getSelectFromViewQuery(Object object) {
        String string = this.getColumnsToSelect(object);
        String string2 = this.getSelectFromQueryFromQualifiedSource(string, this.getSchema(), this.getName());
        string2 = this.addPartitionNameCondition(string2);
        return String.format(SELECT_ALL_FROM_SUBQUERY, string2);
    }

    private String getColumnsToSelect(Object object) {
        String string2 = "";
        if (object instanceof SuperviseModelType) {
            List<String> list = this.getGLMColumnList((SuperviseModelType)object);
            string2 = StringUtils.joinElementsByComma(list, string -> string);
        } else if (this.isRModelMetaData(object)) {
            string2 = this.getRViewColumnsToSelect(object);
        }
        return StringUtils.isNotEmpty((String)string2) ? string2 : "*";
    }

    private List<String> getGLMColumnList(SuperviseModelType superviseModelType) {
        String[] stringArray = new String[]{};
        if (superviseModelType instanceof CGeneralizedLinearModelType) {
            stringArray = ODMTableColumns.ODM_GLMC_VA.COLUMN_NAMES;
        } else if (superviseModelType instanceof RGeneralizedLinearModelType) {
            stringArray = ODMTableColumns.ODM_GLMR_VA.COLUMN_NAMES;
        }
        List<String> list = this.removePartitionNameColumn(Arrays.asList(stringArray));
        return list;
    }

    private List<String> removePartitionNameColumn(List<String> list) {
        return list.stream().filter(string -> !"PARTITION_NAME".equals(string) && !"PARTITION_NAME".equals(string)).collect(Collectors.toList());
    }

    private boolean isRModelMetaData(Object object) {
        if (object instanceof RModelType) {
            return true;
        }
        if (object instanceof ModelNodeType.Models.Model) {
            MiningAlgorithmType miningAlgorithmType = ((ModelNodeType.Models.Model)object).getMiningAlgorithm();
            return MiningAlgorithmType.R_EXTENSIBLE.equals((Object)miningAlgorithmType);
        }
        return false;
    }

    private String getRViewColumnsToSelect(Object object) {
        String string = "";
        if (object instanceof RModelType) {
            RModelType rModelType = (RModelType)object;
            RModelType.DetailFunction.Output output = rModelType.getDetailFunction().getOutput();
            string = StringUtils.joinElementsByComma((List)output.getColumn(), column -> column.getName());
        } else if (object instanceof ModelNodeType.Models.Model) {
            ModelNodeType.Models.Model model = (ModelNodeType.Models.Model)object;
            String string2 = this.extractColumnsFromDetailsFormat(model);
            string = StringUtils.isNotEmpty((String)string2) ? string2 : string;
        }
        return string;
    }

    private String extractColumnsFromDetailsFormat(ModelNodeType.Models.Model model) {
        Pattern pattern;
        Matcher matcher;
        String string = "";
        String string2 = MetaDataHelper.getODMSetting(model.getModelSettingsODM().getModelSettingODM(), "RALG_DETAILS_FORMAT");
        if (StringUtils.isNotEmpty((String)string2) && (matcher = (pattern = Pattern.compile("SELECT (.+) FROM DUAL")).matcher(string2.toUpperCase())).find()) {
            string = this.splitExpressionsAndJoinColumnNames(matcher.group(1));
        }
        return string;
    }

    private String splitExpressionsAndJoinColumnNames(String string2) {
        Object[] objectArray = string2.split(",");
        Function<String, String> function = string -> {
            String[] stringArray = string.split(" ");
            return stringArray[stringArray.length - 1];
        };
        String string3 = StringUtils.joinElementsByComma((Object[])objectArray, function);
        return string3;
    }

    private String addPartitionNameCondition(String object) {
        String string = this.dataEditor.getPartitionId();
        object = StringUtils.isEmpty((String)string) ? (String)object + "WHERE PARTITION_NAME IS NULL" : String.format("%s WHERE PARTITION_NAME = '%s'", object, string);
        return object;
    }

    private String getQueryFromAttributesMetadata(Attributes attributes) {
        List list;
        String string = "";
        if (attributes != null && !(list = attributes.getAttribute()).isEmpty()) {
            string = String.format(SELECT_FROM_QUALIFIED_QUOTED_TABLE_WITH_HINT, DataViewerState.getParallelHint(), this.getCommaSeparatedAttributes(list), this.getSchema(), this.getName());
        }
        return StringUtils.isNotEmpty((String)string) ? string : this.getSelectAllQuery();
    }

    private String getCommaSeparatedAttributes(List<AttributeType> list) {
        Function<AttributeType, String> function = attributeType -> {
            String string = attributeType.getAlias();
            if (StringUtils.isNotEmpty((String)string)) {
                return String.format("%s AS %s", StringUtils.addDoubleQuotes((String)attributeType.getName()), StringUtils.addDoubleQuotes((String)string));
            }
            return StringUtils.addDoubleQuotes((String)attributeType.getName());
        };
        String string = StringUtils.joinElementsByComma(list, function);
        return string;
    }

    private String getSelectAllQuery() {
        return this.getSelectAllQueryFromQualifiedSource(this.getSchema(), this.getName());
    }

    protected void finalize() {
        this.close();
    }

    public void close() {
        if (this.resultSetModel != null && this.resultSetModel.isUIUpdated()) {
            try {
                this.resultSetModel.closeConnection();
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
            }
        }
    }

    public void closeRS() {
        if (this.resultSetModel != null) {
            this.resultSetModel.close();
        }
    }

    public boolean isClosing() {
        return this.closing;
    }

    public void setClosing(boolean bl) {
        this.closing = bl;
    }

    public void setCacheTableName(String string) {
        this.cacheTableName = string;
    }

    public void setTableName(String string, String string2) {
        this.schemaName = string;
        this.tableName = string2;
    }

    public void setSqlExpression(String string) {
        this.selectSQL = string;
    }

    public String getSchema() {
        return this.schemaName;
    }

    public String getName() {
        return this.tableName;
    }

    public ODMrResultSetTableModel getResultSetModel() {
        return this.resultSetModel;
    }

    public void setCurrentSourceOption(DataSourceViewOption dataSourceViewOption) throws Exception {
        this.currentSourceOption = dataSourceViewOption;
    }

    public DataSourceViewOption getCurrentSourceOption() {
        return this.currentSourceOption;
    }

    public static boolean contextHasValidModelNodeForDataViewing(Context context) {
        Node node = context.getNode();
        return node instanceof GLMRModelNode || node instanceof GLMCModelNode || node instanceof RModelNode;
    }
}

