/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.data;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.StringReader;
import java.io.StringWriter;
import java.sql.Connection;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.ControlsArb;
import oracle.dbtools.raptor.controls.celleditor.popups.AbstractPopupCellEditor;
import oracle.dmt.dataminer.teditor.data.DataLrb;
import oracle.dmt.dataminer.teditor.data.ODMrGraphOutputPanel;
import oracle.dmt.dataminer.teditor.data.ODMrXMLOutputPanel;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import oracle.ide.util.ResourceUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ODMrLongCharEditPanel
extends AbstractPopupCellEditor {
    IdeSettings settings = Ide.getSettings();
    String _EOLChars = null;
    EnvironOptions envopts;
    protected Object value = null;
    protected boolean canChange = false;
    protected ArrayList<String> _textData = new ArrayList();
    protected ArrayList<String> _imageData = new ArrayList();
    private JTabbedPane _viewerTabPane = new JTabbedPane();
    protected JTextArea jtaEditValue = new JTextArea();
    protected JScrollPane jspEditValue;
    private static String DATA_TAB = DataLrb.get("DATA_VIEWER_RDATA_DATA_TAB");
    private static String GRAPH_TAB = DataLrb.get("DATA_VIEWER_RDATA_GRAPH_TAB");
    private JCheckBox wrapCheckbox = new JCheckBox(DataLrb.get("DATA_VIEWER_WRAP"));
    private static final String LINE_SEPARATOR_PATTERN = "\r\n|[\n\r\u2028\u2029\u0085]";

    public ODMrLongCharEditPanel() {
        this.settings = Ide.getSettings();
        this.envopts = (EnvironOptions)this.settings.getData("environment-options");
        this.getEOLSettings();
        this.getODMrLongCharEditPanel();
    }

    public ODMrLongCharEditPanel(Object object, boolean bl) {
        this();
        this.value = object;
        this.canChange = bl;
    }

    protected void getODMrLongCharEditPanel() {
        this.setLayout(new GridBagLayout());
        this.wrapCheckbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (ODMrLongCharEditPanel.this.wrapCheckbox.isSelected()) {
                    ODMrLongCharEditPanel.this.jtaEditValue.setLineWrap(true);
                    ODMrLongCharEditPanel.this.jtaEditValue.setWrapStyleWord(true);
                } else {
                    ODMrLongCharEditPanel.this.jtaEditValue.setLineWrap(false);
                    ODMrLongCharEditPanel.this.jtaEditValue.setWrapStyleWord(false);
                }
            }
        });
    }

    protected void getEOLSettings() {
        this.settings = Ide.getSettings();
        this.envopts = (EnvironOptions)this.settings.getData("environment-options");
        int n = this.envopts.getLineTerminator();
        this._EOLChars = n == 1 ? "\r\n" : (n == 3 ? "\r" : (n == 2 ? "\n" : System.getProperty("line.separator")));
    }

    public String getEOLChars() {
        return this._EOLChars;
    }

    public EnvironOptions getEnvopts() {
        return this.envopts;
    }

    public void setText(String string) {
        String string2 = string.replaceAll(LINE_SEPARATOR_PATTERN, System.getProperty("line.separator"));
        this.jtaEditValue.setText(string2);
    }

    public String getText() {
        String string = this.jtaEditValue.getText();
        String string2 = string.replaceAll(System.getProperty("line.separator"), this._EOLChars);
        return string2;
    }

    public JComponent getDefaultComponent() {
        return this.jtaEditValue;
    }

    public void dismissPopupEditor() {
        super.dismissPopupEditor();
    }

    public JComponent getComponent() {
        return this;
    }

    public String getHelpTopicId() {
        return "f1_extendeddataedit_html";
    }

    public Object getValue() {
        return this.getText();
    }

    public boolean isEditable() {
        return this.canChange;
    }

    public void setEditable(boolean bl) {
        this.canChange = bl;
        this.jtaEditValue.setEditable(this.canChange);
    }

    public boolean isNULL() {
        return false;
    }

    public void setValue(Object object) {
        if (object != null) {
            this.setText(object.toString());
        }
        boolean bl = this.getRData(object.toString());
        this.removeAll();
        if (bl) {
            this._viewerTabPane.removeAll();
            for (String object2 : this._textData) {
                ODMrXMLOutputPanel oDMrXMLOutputPanel = new ODMrXMLOutputPanel(object2);
                this._viewerTabPane.addTab(DATA_TAB, oDMrXMLOutputPanel);
            }
            for (int i = 0; i < this._imageData.size(); ++i) {
                ODMrGraphOutputPanel oDMrGraphOutputPanel = new ODMrGraphOutputPanel(this._imageData.get(i));
                if (i > 0) {
                    this._viewerTabPane.addTab(GRAPH_TAB + "~" + i, oDMrGraphOutputPanel);
                    continue;
                }
                this._viewerTabPane.addTab(GRAPH_TAB, oDMrGraphOutputPanel);
            }
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 23;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            this.add(this._viewerTabPane, gridBagConstraints);
        } else {
            JLabel jLabel = new JLabel();
            ResourceUtils.resLabel((JLabel)jLabel, (Component)this.jtaEditValue, (String)ControlsArb.getString((String)"RESULTSET_EDIT_VALUE"));
            this.jspEditValue = new JScrollPane(this.jtaEditValue);
            this.jspEditValue.setHorizontalScrollBarPolicy(30);
            this.jspEditValue.setVerticalScrollBarPolicy(20);
            this.jtaEditValue.setRows(5);
            this.jtaEditValue.setEditable(this.canChange);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 23;
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            this.add(jLabel, gridBagConstraints);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 2;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.gridwidth = 1;
            gridBagConstraints2.gridheight = 1;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints2.anchor = 24;
            this.add(this.wrapCheckbox, gridBagConstraints2);
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            this.add(this.jspEditValue, gridBagConstraints);
        }
    }

    public String validateValue() {
        return null;
    }

    public void setConnection(Connection connection) {
    }

    public void setPopupDialog(JEWTDialog jEWTDialog) {
    }

    private boolean getRData(String string) {
        boolean bl = false;
        this._imageData.clear();
        this._textData.clear();
        try {
            InputSource inputSource = new InputSource(new StringReader(string));
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputSource);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            if (document.getElementsByTagName("root") != null) {
                Object object;
                Object object2;
                Object object3;
                NodeList nodeList = document.getElementsByTagName("img");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element = (Element)nodeList.item(i);
                    object3 = new DOMSource(element);
                    object2 = new StreamResult(new StringWriter());
                    transformer.transform((Source)object3, (Result)object2);
                    object = ((StreamResult)object2).getWriter().toString();
                    this._imageData.add((String)object);
                }
                nodeList = document.getElementsByTagName("root");
                Element element = (Element)nodeList.item(0);
                nodeList = element.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    object3 = nodeList.item(i);
                    if (!(object3 instanceof Element) || (element = (Element)nodeList.item(i)).getTagName().equals("images") || !element.hasChildNodes()) continue;
                    object2 = new DOMSource(element);
                    object = new StreamResult(new StringWriter());
                    transformer.transform((Source)object2, (Result)object);
                    String string2 = ((StreamResult)object).getWriter().toString();
                    this._textData.add(string2);
                }
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }
}

