/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.data;

import java.awt.Component;
import java.awt.Window;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.teditor.data.DataEditor;
import oracle.dmt.dataminer.teditor.data.DataLrb;
import oracle.dmt.dataminer.teditor.data.DataViewerState;
import oracle.dmt.dataminer.teditor.data.ODMrResultSetTableCellEditor;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdbc.OracleResultSet;
import oracle.sql.CHAR;
import oracle.sql.ROWID;
import oracle.xdb.XMLType;

public abstract class ODMrResultSetTableModelBase
extends AbstractTableModel {
    protected static final String[] LINK_COLS = new String[]{"SDEV_LINK_OWNER", "SDEV_LINK_NAME", "SDEV_LINK_TYPE"};
    protected static final int FETCH_SIZE = 50;
    protected static final String SORT_A = " asc";
    protected static final String SORT_D = " desc";
    private static final int STANDARD_COLUMN_SIZE = 200;
    protected boolean error;
    protected boolean canceled;
    protected boolean isRunning;
    protected boolean isSorting;
    protected boolean uiUpdated;
    protected boolean runInThread;
    protected boolean areAllFetched;
    protected boolean verticalDisplay;
    protected boolean useStandardColumnSize;
    protected boolean translatedColumnNames;
    private boolean outputExceptionDetail;
    protected int count;
    protected int fetchSize;
    protected int sortColumn;
    protected int standardColumnSize;
    protected int[] types;
    protected int[] columnSizes;
    protected String sqlCode;
    protected String tableName;
    protected String whereClause;
    protected String orderByClause;
    protected String sortDirection;
    private String errorMessage;
    protected Context context;
    protected final Object lock;
    protected DataViewerState state;
    protected Connection connection;
    protected List<String> columnNames;
    protected List<List<String>> rows;
    protected List<List<String>> newRows;
    protected List<List<String>> tableRows;
    protected List<List<String>> backUpRows;
    protected final List<String> skipColumns;
    protected volatile ProgressRunnable runner;
    protected Map<String, String> columnNameToType;
    protected Map<String, Integer> columnNameOccurance;
    protected Map<String, String> columnsTranslations;
    protected Map<Connection, ReentrantLock> connectionLocks;
    protected JLabel label;

    public ODMrResultSetTableModelBase(DataViewerState dataViewerState) {
        this.state = dataViewerState;
        this.lock = new Object();
        this.connectionLocks = new HashMap<Connection, ReentrantLock>();
        this.skipColumns = new ArrayList<String>();
        this.label = new JLabel();
        this.translatedColumnNames = true;
        this.standardColumnSize = 200;
        this.errorMessage = DataLrb.get("DATA_VIEWER_FAILURE_MESG");
    }

    public boolean isUIUpdated() {
        return this.uiUpdated;
    }

    public int[] getColSizes() {
        return this.columnSizes;
    }

    public void setUseStandardColumnSize(boolean bl) {
        this.useStandardColumnSize = bl;
    }

    public void setStandardColumnSize(int n) {
        this.standardColumnSize = n;
    }

    public int getStandardColumnSize() {
        return this.standardColumnSize;
    }

    public boolean isUseStandardColumnSize() {
        return this.useStandardColumnSize;
    }

    public void setTranslatedColNames(boolean bl) {
        this.translatedColumnNames = bl;
    }

    public boolean isTranslatedColumnNames() {
        return this.translatedColumnNames;
    }

    public void setThreaded(boolean bl) {
        this.runInThread = bl;
    }

    public boolean isThreaded() {
        return this.runInThread;
    }

    public void setVerticalDisplay(boolean bl) {
        this.verticalDisplay = bl;
    }

    public boolean isVerticalDisplay() {
        return this.verticalDisplay;
    }

    public void setWhere(String string) {
        this.whereClause = string;
    }

    public String getWhere() {
        return this.whereClause;
    }

    public String getOrderBy() {
        return this.orderByClause;
    }

    public void setOrderBy(String string) {
        this.orderByClause = string;
    }

    public boolean isErrorCondition() {
        return this.error;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public boolean isSorting() {
        return this.isSorting;
    }

    public String getSortDirection() {
        return this.sortDirection;
    }

    public void setSortDirection(String string) {
        this.sortDirection = string;
    }

    public int getSortColumn() {
        return this.sortColumn;
    }

    public int getType(int n) {
        if (n < 0) {
            return 0;
        }
        return this.types != null && this.types.length > n ? this.types[n] : 0;
    }

    public void setTypes(int[] nArray) {
        this.types = nArray;
    }

    @Override
    public int getColumnCount() {
        int n = this.columnNames != null ? this.columnNames.size() : 0;
        return n + 1;
    }

    public void setSql(String string) {
        this.sqlCode = string;
        int n = this.sqlCode.toLowerCase().indexOf("from");
        this.tableName = n < 0 ? "" : this.sqlCode.substring(n + "from".length(), this.sqlCode.length()).trim();
    }

    public void setSortColumn(int n) {
        if (this.sortColumn == n && SORT_A.equals(this.sortDirection)) {
            this.sortDirection = SORT_A.equals(this.sortDirection) ? SORT_D : SORT_A;
        } else {
            this.sortDirection = SORT_A;
            this.sortColumn = n;
        }
        this.orderByClause = null;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection, Context context) {
        this.context = context;
        if (this.connection == null) {
            this.connection = connection;
        }
    }

    public boolean open() {
        return this.open(this.getFetchSize());
    }

    protected int getFetchSize() {
        return 50;
    }

    public int getLoadedCount() {
        int n = 0;
        if (this.tableRows != null) {
            n = this.tableRows.size();
        } else if (this.backUpRows != null) {
            n = this.backUpRows.size();
        }
        return n;
    }

    public boolean allFetched() {
        return this.areAllFetched;
    }

    public String getRawColumnName(int n) {
        String string = this.columnNames.get(n);
        String string2 = this.columnNameToType.get(string);
        try {
            if (!DatabaseMetadataUtils.isDataTypeSupported(string2)) {
                return null;
            }
            if (DatabaseMetadataUtils.isACustomDataType(this.context, string2)) {
                return null;
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)"Unexpected Exception");
            return null;
        }
        return string;
    }

    public String getColumnType(String string) {
        return this.columnNameToType.get(string);
    }

    public void setSorting(boolean bl) {
        this.isSorting = bl;
        this.updateEditor();
    }

    public void setRunning(boolean bl) {
        this.isRunning = bl;
        this.updateEditor();
    }

    private void updateEditor() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Editor editor = EditorManager.getEditorManager().getCurrentEditor();
                if (editor != null && editor.getContext() != null && editor instanceof DataEditor) {
                    ((DataEditor)editor).updateToolbar();
                }
            }
        });
    }

    public boolean isCellEditorEditable(int n, int n2) {
        return false;
    }

    public void closeConnection() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                SQLHelper.close(this.connection);
                this.connection = null;
            }
        }
        catch (SQLException sQLException) {
            this.logError(sQLException);
        }
    }

    protected boolean lock(ReentrantLock reentrantLock) {
        boolean bl = false;
        do {
            try {
                if (!reentrantLock.tryLock(500L, TimeUnit.MILLISECONDS)) continue;
                bl = true;
                break;
            }
            catch (InterruptedException interruptedException) {
                this.getLogger().log(Level.FINEST, "Interrupted while trying to get a lock");
            }
        } while (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)"Connection currrently busy.  Try again?", (String)"Connection busy", null, (boolean)false, (String)"Try Again", (String)"Abort"));
        return bl;
    }

    public static void handleException() {
        MessageDialog.error((Component)Ide.getMainWindow(), (Object)DataLrb.get("DATA_VIEWER_FAILURE_MESDAGE"), (String)DataLrb.get("DATA_VIEWER_FAILURE_TITLE"), null);
    }

    public static void handleExceptionDetailed(Exception exception) {
        MessageDialog.error((Component)Ide.getMainWindow(), (Object)exception.getLocalizedMessage(), (String)DataLrb.get("DATA_VIEWER_FAILURE_TITLE"), null);
    }

    protected String translate(String string) {
        String string2 = string;
        if (this.columnsTranslations != null) {
            String string3 = this.columnsTranslations.get(string);
            string2 = string3 != null ? string3 : string;
        }
        return string2;
    }

    protected void cacheObjectInARow(List list, int n, ResultSet resultSet) throws SQLException {
        Object object = null;
        try {
            object = resultSet instanceof OracleResultSet ? ((OracleResultSet)resultSet).getOracleObject(n) : resultSet.getObject(n);
        }
        catch (SQLException sQLException) {
            object = resultSet.getObject(n);
        }
        int n2 = resultSet.getMetaData().getColumnType(n);
        if (object instanceof byte[]) {
            list.add(this.rawToHex((byte[])object));
        } else if (n2 == 1111 && object instanceof ROWID) {
            String string = resultSet.getString(n);
            byte[] byArray = string.getBytes();
            list.add(new ROWID(byArray));
        } else if (n2 == 93 && resultSet instanceof OracleResultSet) {
            list.add(((OracleResultSet)resultSet).getDATE(n));
        } else if (n2 == -102 && resultSet instanceof OracleResultSet) {
            list.add(((OracleResultSet)resultSet).getTIMESTAMPLTZ(n));
        } else if (n2 == -101 && resultSet instanceof OracleResultSet) {
            list.add(((OracleResultSet)resultSet).getTIMESTAMPTZ(n));
        } else if (n2 == 91 && resultSet instanceof OracleResultSet) {
            list.add(((OracleResultSet)resultSet).getDATE(n));
        } else if (n2 == 2005 && resultSet instanceof OracleResultSet) {
            list.add(resultSet.getString(n));
        } else if (object instanceof OracleResultSet) {
            ArrayList arrayList = new ArrayList();
            try {
                OracleResultSet oracleResultSet = (OracleResultSet)object;
                ArrayList<String> arrayList2 = new ArrayList<String>();
                for (int i = 1; i <= oracleResultSet.getMetaData().getColumnCount(); ++i) {
                    arrayList2.add(oracleResultSet.getMetaData().getColumnName(i));
                }
                arrayList.add(arrayList2);
                while (oracleResultSet.next()) {
                    ArrayList arrayList3 = new ArrayList();
                    for (int i = 1; i <= oracleResultSet.getMetaData().getColumnCount(); ++i) {
                        this.cacheObjectInARow(arrayList3, i, (ResultSet)oracleResultSet);
                    }
                    arrayList.add(arrayList3);
                }
            }
            catch (SQLException sQLException) {
                this.logError(sQLException);
            }
            list.add(arrayList);
        } else if (n == 1 && object instanceof CHAR) {
            String string = StringUtils.trimDoubleQuotes(object.toString());
            list.add(string);
        } else if (object instanceof XMLType) {
            XMLType xMLType = (XMLType)object;
            String string = xMLType.getStringVal();
            list.add(string);
        } else {
            list.add(object);
        }
    }

    protected String rawToHex(byte[] byArray) {
        int n = byArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            int n2 = byArray[i] & 0xFF;
            int n3 = n2 >>> 4;
            stringBuffer.append(this.nibbleToChar(n3));
            int n4 = n2 & 0xF;
            stringBuffer.append(this.nibbleToChar(n4));
        }
        return stringBuffer.toString();
    }

    protected char nibbleToChar(int n) {
        int n2 = 48;
        if (n < 10) {
            n2 = (char)(48 + n);
        } else if (n == 10) {
            n2 = 65;
        } else if (n == 11) {
            n2 = 66;
        } else if (n == 12) {
            n2 = 67;
        } else if (n == 13) {
            n2 = 68;
        } else if (n == 14) {
            n2 = 69;
        } else if (n == 15) {
            n2 = 70;
        }
        return (char)n2;
    }

    protected boolean lock(Connection connection) {
        ReentrantLock reentrantLock = this.getLock(connection);
        return this.lock(reentrantLock);
    }

    protected void unlock(Connection connection) {
        ReentrantLock reentrantLock = this.getLock(connection);
        reentrantLock.unlock();
    }

    protected ReentrantLock getLock(Connection connection) {
        if (this.connectionLocks.get(connection) == null) {
            this.connectionLocks.put(connection, new ReentrantLock());
        }
        return this.connectionLocks.get(connection);
    }

    protected String getSql() {
        return this.sqlCode;
    }

    public void setColumnsTranslations(Map<String, String> map) {
        this.columnsTranslations = map;
    }

    public void setColSizes(int[] nArray) {
        this.columnSizes = nArray;
    }

    public int[] getTypes() {
        return this.types;
    }

    protected void backupRows() {
        if (this.tableRows != null && !this.tableRows.isEmpty()) {
            this.backUpRows = null;
            this.backUpRows = new ArrayList<List<String>>(this.tableRows.size());
            this.backUpRows.addAll(this.tableRows);
            this.tableRows.clear();
            this.tableRows = null;
        }
    }

    public Map<String, String> getColumnTranslations() {
        return this.columnsTranslations;
    }

    public void setSkipCols(List<String> list) {
        this.skipColumns.clear();
        for (String string : LINK_COLS) {
            this.skipColumns.add(string);
        }
        if (list != null) {
            this.skipColumns.addAll(list);
        }
    }

    protected String getUniqueColumnName(String string) {
        if (this.columnNames.contains(string)) {
            this.columnNameOccurance.put(string, this.columnNameOccurance.get(string) + 1);
            return string + "_" + (this.columnNameOccurance.get(string) - 1);
        }
        this.columnNameOccurance.put(string, 1);
        return string;
    }

    public void reorderColumnNamesList(int n, int n2) throws Exception {
        if (!this.verticalDisplay) {
            if (this.types != null) {
                this.reorderArray(this.types, n, n2);
            }
            if (this.columnSizes != null) {
                this.reorderArray(this.columnSizes, n, n2);
            }
            if (this.columnNames != null) {
                String string = this.columnNames.get(n);
                this.columnNames.remove(n);
                this.columnNames.add(n2, string);
            }
        }
    }

    protected void reorderArray(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        if (n > n2) {
            System.arraycopy(nArray, n2, nArray, n2 + 1, n - n2);
        } else {
            System.arraycopy(nArray, n + 1, nArray, n, n2 - n);
        }
        nArray[n2] = n3;
    }

    protected void createErrorColumnNamesList() {
        this.columnNames = new ArrayList<String>();
        this.columnNameOccurance = new HashMap<String, Integer>();
        this.types = new int[1];
        this.columnSizes = new int[1];
        this.columnNames.add(this.translate("Name"));
        this.columnSizes[0] = 1500;
        this.types[0] = 12;
    }

    protected static String sanitizeOracleSQL(String string) {
        String string2 = string.trim();
        String string3 = string2.toUpperCase();
        if (string2.endsWith(";") && !string3.endsWith("END;")) {
            string2 = string2.substring(0, string2.lastIndexOf(";"));
        }
        return string2;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        Object object = this.getValueAt(0, n);
        return object != null ? object.getClass() : Object.class;
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0) {
            return DataLrb.get("DATA_VIEWER_ROW_NUMBER");
        }
        if (!this.translatedColumnNames) {
            return this.columnNames.get(n - 1);
        }
        return this.columnNames != null ? this.translate(this.columnNames.get(n - 1)) : null;
    }

    @Override
    public int getRowCount() {
        int n = 0;
        if (this.tableRows != null) {
            n = this.tableRows.size();
        } else if (this.backUpRows != null) {
            n = this.backUpRows.size();
        }
        if (n > 0 && !this.areAllFetched) {
            n += this.getFetchSize() + 1;
        }
        return n;
    }

    @Override
    public final boolean isCellEditable(int n, int n2) {
        int n3 = this.getType(n2 - 1);
        return !ODMrResultSetTableCellEditor.isInPlaceEditingAllowed(n3) || ODMrResultSetTableCellEditor.hasExtendedEdit(n3);
    }

    protected void setErrorMessage(String string) {
        if (StringUtils.isNotEmpty(string)) {
            this.errorMessage = string;
        }
    }

    protected String getErrorMessage() {
        return this.errorMessage;
    }

    protected void outputExceptionDetail() {
        this.outputExceptionDetail = true;
    }

    protected boolean useExceptionDetail() {
        return this.outputExceptionDetail;
    }

    public abstract boolean open(int var1);

    public abstract void interruptSorting();

    public abstract void fetchAll();

    public abstract void prepareForSort();

    public abstract void close();

    public void setResultSet(ResultSet resultSet) {
    }

    public abstract String getSQL();

    protected abstract void logError(Exception var1);

    protected abstract Logger getLogger();
}

