/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.navigator.AbstractTestNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.TestResultNode;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.repository.Activity;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.tviewer.TestCompareNode;
import oracle.dmt.dataminer.tviewer.performance.PerformanceMetric;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.ClassificationBuildNode;
import oracle.dmt.dataminer.workflow.model.RegressionBuildNode;
import oracle.dmt.dataminer.workflow.model.TestNode;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TestNodeType;
import oracle.dss.graph.Graph;
import oracle.dss.graph.Series;
import oracle.dss.util.SeriesOutOfRangeException;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.javatools.util.Version;

public class SharedTestEditorState {
    private static final Logger theLogger = Logger.getLogger(SharedTestEditorState.class.getName());
    public static final Color LIFT_IDEAL_LINE = Color.GREEN;
    public static final Color LIFT_RANDOM_LINE = Color.RED;
    public static final Color LIFT_QUANTILE_LINE = Color.BLUE;
    public static final Color PROFIT_BUDGET_LINE = Color.GREEN;
    public static final Color PROFIT_POPULATION_LINE = Color.BLUE;
    public static final String global_results = "partition_name is null";
    public static final String partition_clause = "<partition_clause>";
    public static final String partition_name = "<partition_name>";
    public static final String partition_var = "partition_name = <partition_name>";
    public static final String performance_table = "<performanceTable>";
    private static final List<Color> RESERVED_COLORS = Arrays.asList(Color.GREEN, Color.RED, Color.BLUE);
    private long lastUpdateTime;
    private boolean generatePartitions;
    private List<TestResult> allTestResults;
    private List<TestResult> testResults;
    private String selectTestResult;
    private List<Color> testResultGraphColors;
    private Map<String, Color> allTestResultGraphColors;
    private List<PerformanceMetric> performanceMetrics;
    private Context context;
    private Activity parentActivity;
    private TestResultNode testResultNode;
    private TestCompareNode testCompareNode;
    private String selectedPartition;

    public SharedTestEditorState(Node node) {
        boolean bl;
        Object object;
        Object object2;
        Object object3;
        AbstractTestNode abstractTestNode;
        String string = null;
        if (node instanceof TestResultNode) {
            abstractTestNode = (TestResultNode)node;
            this.testResultNode = abstractTestNode;
            TestResult testResult = (TestResult)abstractTestNode.getRepositoryData();
            assert (testResult != null) : "model cannot be null";
            this.testResults = new ArrayList<TestResult>();
            this.testResults.add(testResult);
            this.context = abstractTestNode.getContext();
            string = ((TestResultNode)abstractTestNode).getParentClassificationNodeId();
        } else if (node instanceof TestCompareNode) {
            abstractTestNode = (TestCompareNode)node;
            this.testCompareNode = abstractTestNode;
            assert (((TestCompareNode)abstractTestNode).getTestResults() != null) : "models cannot be null";
            this.testResults = ((TestCompareNode)abstractTestNode).getTestResults();
            this.context = abstractTestNode.getContext();
            string = ((TestCompareNode)abstractTestNode).getParentNodeId();
        } else assert (false) : "Node is not of type TestResultNode or TestCompareNode";
        abstractTestNode = ConnectionFolder.getConnectionFolder(this.context).getDbVersion();
        boolean bl2 = DbVersionHelper.isDB122Up((Version)abstractTestNode);
        if (bl2 && (object3 = WorkflowNode.findParentWorkflowNode(this.getContext())) != null && string != null) {
            TestNodeType testNodeType;
            List list;
            Object object4;
            object2 = ((WorkflowNode)object3).getWorkflowModel();
            AbstractNode object6 = (AbstractNode)((WorkflowModel)((Object)object2)).findNodeByMetadataId(string);
            if (object6 instanceof ClassificationBuildNode) {
                object4 = (ClassificationBuildNode)object6;
                ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)((AbstractNode)object4).getData();
                object = classificationBuildNodeType.getPartitionExpressions();
                if (object != null && !(list = object.getPartitionExpression()).isEmpty()) {
                    this.generatePartitions = true;
                }
            } else if (object6 instanceof RegressionBuildNode) {
                object4 = (RegressionBuildNode)object6;
                RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)((AbstractNode)object4).getData();
                object = regressionBuildNodeType.getPartitionExpressions();
                if (object != null && !(list = object.getPartitionExpression()).isEmpty()) {
                    this.generatePartitions = true;
                }
            } else if (object6 instanceof TestNode && (object = (testNodeType = (TestNodeType)((AbstractNode)(object4 = (TestNode)object6)).getData()).getTestModels()) != null) {
                this.generatePartitions = object.isGeneratePartitions();
            }
        }
        object3 = new TreeMap();
        for (TestResult testResult : this.testResults) {
            object3.put(testResult.toString(), testResult);
        }
        this.testResults = new ArrayList(object3.values());
        object2 = ConnectionFolder.getUserAccountName(this.context);
        object2 = StringUtils.isDoubleQuotedString((String)object2) ? StringUtils.trimDoubleQuotes((String)object2) : ((String)object2).toUpperCase();
        boolean bl3 = false;
        for (TestResult testResult : this.testResults) {
            object = testResult.getModelSchema();
            if (object == null || ((String)object).compareTo((String)object2) == 0) continue;
            bl = true;
            break;
        }
        if (bl) {
            for (TestResult testResult : this.testResults) {
                testResult.setShowSchema(true);
            }
        }
        this.allTestResults = new ArrayList<TestResult>();
        this.allTestResults.addAll(this.testResults);
        this.assignColors();
        this.lastUpdateTime = System.currentTimeMillis();
    }

    public void setSelectedPartition(String string) {
        this.selectedPartition = string;
    }

    public String getSelectedPartition() {
        return this.selectedPartition;
    }

    public boolean isEnabledPartitioning() {
        return this.generatePartitions;
    }

    public static String setPartitionClause(String string, String string2) {
        String string3 = null;
        if (string2 == null) {
            string3 = StringUtils.getReplacedString(string, partition_clause, global_results);
        } else {
            string3 = StringUtils.getReplacedString(string, partition_clause, partition_var);
            string3 = StringUtils.getReplacedString(string3, partition_name, StringUtils.addSingleQuotes(string2));
        }
        return string3;
    }

    public void updateTime() {
        this.lastUpdateTime = System.currentTimeMillis();
    }

    public List<TestResult> getTestResults() {
        return this.testResults;
    }

    public Activity getParentActivity() {
        return this.parentActivity;
    }

    public List<Color> getTestResultGraphColors() {
        return this.testResultGraphColors;
    }

    public Color getTestResultGraphColor(String string) {
        return this.allTestResultGraphColors.get(string);
    }

    public Context getContext() {
        return this.context;
    }

    public void setTestResults(List<TestResult> list) {
        this.testResults = list;
        this.testResultGraphColors.clear();
        for (TestResult testResult : this.testResults) {
            Color color = this.allTestResultGraphColors.get(testResult.toString());
            this.testResultGraphColors.add(color);
        }
        this.lastUpdateTime = System.currentTimeMillis();
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setPerformanceMetrics(List<PerformanceMetric> list) {
        this.performanceMetrics = list;
    }

    public List<PerformanceMetric> getPerformanceMetrics() {
        return this.performanceMetrics;
    }

    private void assignColors() {
        Graph graph = new Graph();
        Object[] objectArray = new Object[]{"TempRowLable1", "TempRowLable2"};
        Object[] objectArray2 = new Object[this.testResults.size() + RESERVED_COLORS.size()];
        Object[][] objectArray3 = new Object[2][this.testResults.size() + RESERVED_COLORS.size()];
        int n = 0;
        for (int i = 0; i < RESERVED_COLORS.size(); ++i) {
            objectArray2[n] = "Color-" + n;
            objectArray3[0][n] = 0.5;
            objectArray3[1][n] = 1.0;
            ++n;
        }
        for (TestResult iterator : this.allTestResults) {
            objectArray2[n] = iterator.getName();
            objectArray3[0][n] = 0.5;
            objectArray3[1][n] = 1.0;
            ++n;
        }
        graph.setGridData(objectArray, objectArray2, objectArray3);
        Series series = graph.getSeries();
        n = 0;
        for (Color color : RESERVED_COLORS) {
            try {
                series.setColor(color, n++);
            }
            catch (SeriesOutOfRangeException seriesOutOfRangeException) {
                theLogger.log(Level.SEVERE, seriesOutOfRangeException.getMessage(), seriesOutOfRangeException);
            }
        }
        this.allTestResultGraphColors = new HashMap<String, Color>();
        this.testResultGraphColors = new ArrayList<Color>();
        for (TestResult testResult : this.allTestResults) {
            try {
                Color color = series.getColor(n++);
                this.allTestResultGraphColors.put(testResult.toString(), color);
                this.testResultGraphColors.add(color);
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
    }

    public List<TestResult> getAllTestResults() {
        return this.allTestResults;
    }

    public void setSelectTestResult(String string) {
        this.selectTestResult = string;
    }

    public String getSelectTestResult() {
        return this.selectTestResult;
    }

    public TestResultNode getTestResultNode() {
        return this.testResultNode;
    }

    public TestCompareNode getTestCompareNode() {
        return this.testCompareNode;
    }

    public Map<String, Integer> getBuildRowsCount(String string, boolean bl) throws ODMrDAOException {
        Map<String, Integer> map = this.getActualAbstractTestNode().getBuildRowsCount(string, bl);
        return map;
    }

    private AbstractTestNode getActualAbstractTestNode() {
        AbstractTestNode abstractTestNode = null;
        if (this.testResultNode != null) {
            abstractTestNode = this.testResultNode;
        } else if (this.testCompareNode != null) {
            abstractTestNode = this.testCompareNode;
        } else assert (false) : "Invalid node type";
        return abstractTestNode;
    }
}

