/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.matrix;

import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.dmt.dataminer.controls.models.SimpleBaseTableModel;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.matrix.PMatrixSummaryTableModel;

public class PMatrixTargetCompareTableModel
extends SimpleBaseTableModel {
    private Vector<Vector<Object>> values;
    private Vector<String> columnNames;
    private List<String> selectedResults;
    private int selectedValueMetricIndex;
    private int totalValue;
    private Map<String, PMatrixSummaryTableModel> matrixSummaryMapByName;

    public PMatrixTargetCompareTableModel(List<String> list, int n, Map<String, PMatrixSummaryTableModel> map) {
        this.selectedResults = list;
        this.columnNames = new Vector<String>(this.selectedResults);
        this.columnNames.add(0, TestViewerLrb.get("PMATRIX_TARGET_VALUE"));
        this.selectedValueMetricIndex = n;
        this.matrixSummaryMapByName = map;
        this.setupTable();
    }

    public int getTotalValue() {
        if (this.totalValue == 0) {
            return 1;
        }
        return this.totalValue;
    }

    public void setupTable() {
        this.values = new Vector();
        if (this.selectedResults == null || this.selectedResults.size() == 0) {
            Vector<String> vector = new Vector<String>();
            vector.add(TestViewerLrb.get("PMATRIX_SELECT_TEST_RESULT"));
            this.values.add(vector);
            this.columnNames = new Vector();
            this.columnNames.add("...");
        } else {
            boolean bl = true;
            for (String string : this.selectedResults) {
                List[] listArray;
                PMatrixSummaryTableModel pMatrixSummaryTableModel = this.matrixSummaryMapByName.get(string);
                if (pMatrixSummaryTableModel == null || (listArray = pMatrixSummaryTableModel.getSummaryInfo()) == null || null == listArray[0]) continue;
                for (int i = 0; i < listArray[0].size(); ++i) {
                    Vector<Object> vector;
                    if (bl) {
                        vector = new Vector();
                        vector.add(listArray[0].get(i));
                        if (listArray[this.selectedValueMetricIndex].get(i) == null) {
                            vector.add(0.0);
                        } else {
                            this.totalValue = (int)((double)this.totalValue + Math.ceil(((Number)listArray[this.selectedValueMetricIndex].get(i)).doubleValue()));
                            vector.add(listArray[this.selectedValueMetricIndex].get(i));
                        }
                        this.values.add(vector);
                        continue;
                    }
                    vector = this.values.get(i);
                    if (listArray[this.selectedValueMetricIndex].get(i) == null) {
                        vector.add(0.0);
                        continue;
                    }
                    vector.add(listArray[this.selectedValueMetricIndex].get(i));
                }
                bl = false;
            }
        }
        super.setDataVector(this.values, this.columnNames);
    }
}

