/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.roc;

import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.controls.models.SimpleBaseTableModel;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.roc.ROCData;
import oracle.dmt.dataminer.tviewer.roc.StatisticsData;

public class ROCTableModel
extends SimpleBaseTableModel {
    private int start = 0;
    private int MODEL = this.start++;
    private int AREA_UNDER_CURVE = this.start++;
    private int MAX_OVERALL = this.start++;
    private int MAX_AVG = this.start++;
    private int CUSTOM = this.start++;
    private int CURRENT = this.start++;
    private int ALGORITHM = this.start++;
    private int BUILD_ROWS = -1;
    private int TEST_ROWS = -1;
    private int CREATION_DATE = -1;
    protected String[] _columnNames;
    protected Map<String, StatisticsData> _statData;
    protected Map<String, List<ROCData>> _rocData;

    public ROCTableModel(Map<String, StatisticsData> map, Map<String, List<ROCData>> map2, boolean bl) {
        this._statData = map;
        this._rocData = map2;
        this.createColumns(bl);
        this.updateColumnIndices(bl);
        this.setColumnIdentifiers(this._columnNames);
        this.setRowCount(this._statData.size());
    }

    public int getMODEL() {
        return this.MODEL;
    }

    public int getAREA_UNDER_CURVE() {
        return this.AREA_UNDER_CURVE;
    }

    public int getMAX_OVERALL() {
        return this.MAX_OVERALL;
    }

    public int getMAX_AVG() {
        return this.MAX_AVG;
    }

    public int getCUSTOM() {
        return this.CUSTOM;
    }

    public int getCURRENT() {
        return this.CURRENT;
    }

    public int getALGORITHM() {
        return this.ALGORITHM;
    }

    public int getBUILD_ROWS() {
        return this.BUILD_ROWS;
    }

    public int getTEST_ROWS() {
        return this.TEST_ROWS;
    }

    public int getCREATION_DATE() {
        return this.CREATION_DATE;
    }

    protected void createColumns(boolean bl) {
        this._columnNames = bl ? new String[]{TestViewerLrb.get("RESULT_NAME"), TestViewerLrb.get("AREA_UNDER_CURVE"), TestViewerLrb.get("MAX_OVERALL_ACCURACY_COL"), TestViewerLrb.get("MAX_AVG_ACCURACY_COL"), TestViewerLrb.get("CUSTOM_ACCURACY_COL"), TestViewerLrb.get("CURRENT_ACCURACY_COL"), TestViewerLrb.get("ALGORITHM"), TestViewerLrb.get("BUILD_ROWS"), TestViewerLrb.get("TEST_ROWS"), TestViewerLrb.get("CREATION_DATE")} : new String[]{TestViewerLrb.get("RESULT_NAME"), TestViewerLrb.get("AREA_UNDER_CURVE"), TestViewerLrb.get("MAX_OVERALL_ACCURACY_COL"), TestViewerLrb.get("MAX_AVG_ACCURACY_COL"), TestViewerLrb.get("CUSTOM_ACCURACY_COL"), TestViewerLrb.get("CURRENT_ACCURACY_COL"), TestViewerLrb.get("ALGORITHM"), TestViewerLrb.get("CREATION_DATE")};
    }

    protected void updateColumnIndices(boolean bl) {
        if (bl) {
            this.BUILD_ROWS = this.start++;
            this.TEST_ROWS = this.start++;
            this.CREATION_DATE = this.start++;
        } else {
            this.CREATION_DATE = this.start++;
        }
    }

    public Object getValueAt(int n, int n2) {
        Object[] objectArray = this._statData.keySet().toArray();
        List<ROCData> list = this._rocData.get(objectArray[n]);
        boolean bl = list.size() > 0;
        int n3 = 0;
        if (n2 == this.getMODEL()) {
            return objectArray[n];
        }
        if (n2 == this.getAREA_UNDER_CURVE()) {
            return this._statData.get(objectArray[n]).getAreaUnderCurve();
        }
        if (n2 == this.getMAX_OVERALL()) {
            n3 = this._statData.get(objectArray[n]).getMaxOverallAccuracyIdx();
            return bl ? list.get(n3).getAccuracy() : 0.0;
        }
        if (n2 == this.getMAX_AVG()) {
            n3 = this._statData.get(objectArray[n]).getMaxAvgAccuracyIdx();
            return bl ? list.get(n3).getAvgAccuracy() : 0.0;
        }
        if (n2 == this.getCUSTOM()) {
            n3 = this._statData.get(objectArray[n]).getCustomAccuracyIdx();
            if (n3 >= 0) {
                return bl ? list.get(n3).getAccuracy() : 0.0;
            }
            return 0.0;
        }
        if (n2 == this.getCURRENT()) {
            n3 = this._statData.get(objectArray[n]).getModelAccuracyIdx();
            return bl ? list.get(n3).getAccuracy() : 0.0;
        }
        if (n2 == this.getALGORITHM()) {
            return this._statData.get(objectArray[n]).getAlgorithm();
        }
        if (n2 == this.getCREATION_DATE()) {
            return this._statData.get(objectArray[n]).getCreationDate();
        }
        if (n2 == this.getBUILD_ROWS()) {
            return this._statData.get(objectArray[n]).getBuildRows();
        }
        if (n2 == this.getTEST_ROWS()) {
            return this._statData.get(objectArray[n]).getTestRows();
        }
        return "Undefined";
    }
}

