/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dmt.dataminer.controls.dialog.DialogHelper;
import oracle.dmt.dataminer.core.model.common.ColumnDataRow;
import oracle.dmt.dataminer.core.utils.ObjectUtils;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.Workflow;
import oracle.dmt.dataminer.runner.RunManagerLrb;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.RefreshWFInputDefThread;
import oracle.dmt.dataminer.workflow.RefreshWFInputNodeRecord;
import oracle.dmt.dataminer.workflow.RefreshWFInputResultPanel;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.DataSourceNode;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.SQLQueryNode;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.DataNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataSourceNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.SQLQueryNodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.dialogs.ProgressBar;
import oracle.javatools.dialogs.MessageDialog;

public class RefreshWFInputDefinition {
    private ProgressBar progressBar;
    private int maxRecordToProcess;
    private int index;
    private WorkflowNode wfNode;
    private Workflow wf;
    private WorkflowModel wfm;
    private List<Node> selectedNodeList;
    private Context context;
    private List<RefreshWFInputNodeRecord> processedNodes = new ArrayList<RefreshWFInputNodeRecord>();

    private void runRefreshProcessSelectedNodes() throws Exception {
        if (this.selectedNodeList == null) {
            return;
        }
        this.maxRecordToProcess += this.selectedNodeList.size();
        for (Node node : this.selectedNodeList) {
            DataSourceNodeType dataSourceNodeType;
            NodeType nodeType = node.getData();
            RefreshWFInputNodeRecord refreshWFInputNodeRecord = new RefreshWFInputNodeRecord(nodeType.getName(), "");
            if (nodeType instanceof DataSourceNodeType) {
                dataSourceNodeType = (DataSourceNodeType)nodeType;
                refreshWFInputNodeRecord.setDataSourceSchema(dataSourceNodeType.getSourceTable().getSchema());
                refreshWFInputNodeRecord.setDataSourceTableName(dataSourceNodeType.getSourceTable().getName());
                refreshWFInputNodeRecord.setDataNodeType((DataNodeType)dataSourceNodeType);
                refreshWFInputNodeRecord.setNodeType(RunManagerLrb.get("WORKFLOW_REFRESH_DATA_SOURCE_TYPE"));
            } else if (nodeType instanceof SQLQueryNodeType) {
                dataSourceNodeType = (SQLQueryNodeType)nodeType;
                AbstractNode abstractNode = (AbstractNode)this.wfm.findNodeByMetadataId(dataSourceNodeType.getId());
                if (abstractNode instanceof SQLQueryNode) {
                    SQLQueryNode sQLQueryNode = (SQLQueryNode)abstractNode;
                    refreshWFInputNodeRecord.setSQLQueryNode(sQLQueryNode);
                }
                refreshWFInputNodeRecord.setDataNodeType((DataNodeType)dataSourceNodeType);
                refreshWFInputNodeRecord.setNodeType(RunManagerLrb.get("WORKFLOW_REFRESH_SQL_QUERY_TYPE"));
            }
            ++this.index;
            this.processedNodes.add(refreshWFInputNodeRecord);
        }
    }

    public void refreshDataSourceDataDefinition(WorkflowModel workflowModel, RefreshWFInputNodeRecord refreshWFInputNodeRecord) throws Exception {
        DataSourceNodeType dataSourceNodeType = (DataSourceNodeType)refreshWFInputNodeRecord.getDataNodeType();
        AbstractNode abstractNode = (AbstractNode)workflowModel.findNodeByMetadataId(dataSourceNodeType.getId());
        if (abstractNode instanceof DataSourceNode) {
            DataSourceNode dataSourceNode = (DataSourceNode)abstractNode;
            Attributes attributes = new Attributes();
            ArrayList arrayList = new ArrayList(dataSourceNodeType.getAttributes().getAttribute());
            attributes.getAttribute().addAll(arrayList);
            if (dataSourceNodeType.isIncludeAllAvailableAttributes() != null && dataSourceNodeType.isIncludeAllAvailableAttributes().booleanValue()) {
                this.updateColumns(dataSourceNodeType.getAttributes().getAttribute(), refreshWFInputNodeRecord.getTableCurrentAtts());
                this.remInvalidColumns(dataSourceNodeType.getAttributes().getAttribute(), refreshWFInputNodeRecord.getTableCurrentAtts());
                dataSourceNodeType.getAttributes().getAttribute().addAll(this.getNewColumnsOnTable(dataSourceNodeType.getAttributes().getAttribute(), refreshWFInputNodeRecord.getTableCurrentAtts()));
                ArrayList<ComplexProperty> arrayList2 = new ArrayList<ComplexProperty>();
                ComplexProperty complexProperty = new ComplexProperty("dataSourceAttributes", dataSourceNodeType.getAttributes());
                complexProperty.setOldData(attributes);
                arrayList2.add(complexProperty);
                OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)dataSourceNode.getUndoFilter();
                odmrSDMUndoFilter.prepareUndoComplexPropertyList(dataSourceNode, workflowModel.getContext(), arrayList2);
            }
            dataSourceNode.validate(true);
        }
    }

    public void refreshSQLQueryDataDefinition(WorkflowModel workflowModel, RefreshWFInputNodeRecord refreshWFInputNodeRecord) throws Exception {
        SQLQueryNodeType sQLQueryNodeType = (SQLQueryNodeType)refreshWFInputNodeRecord.getDataNodeType();
        if (sQLQueryNodeType.getSQLExpression() == null) {
            return;
        }
        Pattern pattern = Pattern.compile("[.]?\\*");
        Matcher matcher = pattern.matcher(sQLQueryNodeType.getSQLExpression());
        boolean bl = matcher.find();
        AbstractNode abstractNode = (AbstractNode)workflowModel.findNodeByMetadataId(sQLQueryNodeType.getId());
        if (abstractNode instanceof SQLQueryNode) {
            SQLQueryNode sQLQueryNode = (SQLQueryNode)abstractNode;
            if (sQLQueryNodeType.isIncludeAllAvailableAttributes()) {
                if (bl) {
                    this.updateColumns(sQLQueryNodeType.getSQLQueryOutputColumns().getAttribute(), refreshWFInputNodeRecord.getTableCurrentAtts());
                    this.remInvalidColumns(sQLQueryNodeType.getSQLQueryOutputColumns().getAttribute(), refreshWFInputNodeRecord.getTableCurrentAtts());
                    sQLQueryNodeType.getSQLQueryOutputColumns().getAttribute().addAll(this.getNewColumnsOnTable(sQLQueryNodeType.getSQLQueryOutputColumns().getAttribute(), refreshWFInputNodeRecord.getTableCurrentAtts()));
                } else {
                    this.remInvalidColumns(sQLQueryNodeType.getSQLQueryOutputColumns().getAttribute(), refreshWFInputNodeRecord.getTableCurrentAtts());
                }
            }
            sQLQueryNode.validate(true);
        }
    }

    private void runRefreshProcessAllNodes() throws Exception {
        WorkflowNode workflowNode = (WorkflowNode)this.context.getNode();
        if (workflowNode == null) {
            return;
        }
        HashMap<String, List<? extends NodeType>> hashMap = MetaDataHelper.getRootNodeCollectionMap(this.wf.getWorkflowProcess());
        for (List<? extends NodeType> list : hashMap.values()) {
            if (list == null) continue;
            this.maxRecordToProcess += list.size();
        }
        for (List<? extends NodeType> list : hashMap.values()) {
            for (NodeType nodeType : list) {
                DataSourceNodeType dataSourceNodeType;
                RefreshWFInputNodeRecord refreshWFInputNodeRecord = new RefreshWFInputNodeRecord(nodeType.getName(), "");
                if (nodeType instanceof DataSourceNodeType) {
                    dataSourceNodeType = (DataSourceNodeType)nodeType;
                    refreshWFInputNodeRecord.setDataSourceSchema(dataSourceNodeType.getSourceTable().getSchema());
                    refreshWFInputNodeRecord.setDataSourceTableName(dataSourceNodeType.getSourceTable().getName());
                    refreshWFInputNodeRecord.setDataNodeType((DataNodeType)dataSourceNodeType);
                    refreshWFInputNodeRecord.setNodeType(RunManagerLrb.get("WORKFLOW_REFRESH_DATA_SOURCE_TYPE"));
                } else if (nodeType instanceof SQLQueryNodeType) {
                    dataSourceNodeType = (SQLQueryNodeType)nodeType;
                    AbstractNode abstractNode = (AbstractNode)this.wfm.findNodeByMetadataId(dataSourceNodeType.getId());
                    if (abstractNode instanceof SQLQueryNode) {
                        SQLQueryNode sQLQueryNode = (SQLQueryNode)abstractNode;
                        refreshWFInputNodeRecord.setSQLQueryNode(sQLQueryNode);
                    }
                    refreshWFInputNodeRecord.setDataNodeType((DataNodeType)dataSourceNodeType);
                    refreshWFInputNodeRecord.setNodeType(RunManagerLrb.get("WORKFLOW_REFRESH_SQL_QUERY_TYPE"));
                }
                this.processedNodes.add(refreshWFInputNodeRecord);
                ++this.index;
            }
        }
    }

    private void updateColumns(List<AttributeType> list, List<ColumnDataRow> list2) {
        for (ColumnDataRow columnDataRow : list2) {
            for (AttributeType attributeType : list) {
                String string = attributeType.getName();
                if (attributeType.getAlias() != null) {
                    string = attributeType.getAlias();
                }
                if (!ObjectUtils.areEqual((Object)string, (Object)columnDataRow.getName()) || ObjectUtils.areEqual((Object)attributeType.getDataTypeQualifier(), (Object)columnDataRow.getDataTypeQualifier()) && ObjectUtils.areEqual((Object)attributeType.getDataType(), (Object)columnDataRow.getDataType())) continue;
                attributeType.setDataType(columnDataRow.getDataType());
                attributeType.setDataTypeQualifier(columnDataRow.getDataTypeQualifier());
            }
        }
    }

    private List<AttributeType> getNewColumnsOnTable(List<AttributeType> list, List<ColumnDataRow> list2) {
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
        for (ColumnDataRow columnDataRow : list2) {
            boolean bl = false;
            for (AttributeType attributeType : list) {
                String string = attributeType.getName();
                if (attributeType.getAlias() != null) {
                    string = attributeType.getAlias();
                }
                if (!string.equals(columnDataRow.getName())) continue;
                bl = true;
            }
            if (bl || !DatabaseMetadataUtils.isDataTypeSupported(columnDataRow.getDataType())) continue;
            AttributeType attributeType = new AttributeType();
            attributeType.setAlias(null);
            attributeType.setDataType(columnDataRow.getDataType());
            attributeType.setDataTypeQualifier(columnDataRow.getDataTypeQualifier());
            attributeType.setName(columnDataRow.getName());
            attributeType.setStatus(AttributeStatus.VALID);
            arrayList.add(attributeType);
        }
        return arrayList;
    }

    private void remInvalidColumns(List<AttributeType> list, List<ColumnDataRow> list2) {
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
        for (AttributeType attributeType : list) {
            boolean bl = false;
            for (ColumnDataRow columnDataRow : list2) {
                String string = attributeType.getName();
                if (attributeType.getAlias() != null) {
                    string = attributeType.getAlias();
                }
                if (!string.equals(columnDataRow.getName())) continue;
                bl = true;
            }
            if (bl) continue;
            arrayList.add(attributeType);
        }
        list.removeAll(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processNodes(boolean bl, Context context, List<Node> list) {
        this.wfNode = (WorkflowNode)context.getNode();
        this.wf = (Workflow)this.wfNode.getRepositoryData();
        this.wfm = this.wfNode.getWorkflowModel();
        this.context = context;
        this.selectedNodeList = list;
        try {
            if (bl) {
                this.runRefreshProcessSelectedNodes();
            } else {
                this.runRefreshProcessAllNodes();
            }
            HashMap<String, List<? extends NodeType>> hashMap = MetaDataHelper.getRootNodeCollectionMap(this.wf.getWorkflowProcess());
            RefreshWFInputDefThread refreshWFInputDefThread = new RefreshWFInputDefThread(context, this.processedNodes);
            ProgressBar progressBar = new ProgressBar((Component)Ide.getMainWindow(), WorkflowEditorLrb.get("REFRESH_WF_DATA_DEFINITION"), (Runnable)refreshWFInputDefThread, true);
            progressBar.setCancelable(true);
            refreshWFInputDefThread.setProgressBar(progressBar);
            progressBar.start("", "", 0, hashMap.values().size(), 50);
            progressBar.waitUntilDone();
            CommandProcessor.getInstance().beginTrans(RunManagerLrb.get("WORKFLOW_REFRESH_PROCESSING"));
            for (RefreshWFInputNodeRecord object2 : this.processedNodes) {
                if (object2.getDataNodeType() instanceof DataSourceNodeType) {
                    this.refreshDataSourceDataDefinition(this.wfm, object2);
                    continue;
                }
                if (!(object2.getDataNodeType() instanceof SQLQueryNodeType)) continue;
                this.refreshSQLQueryDataDefinition(this.wfm, object2);
            }
            CommandProcessor.getInstance().endTrans();
            RefreshWFInputResultPanel refreshWFInputResultPanel = new RefreshWFInputResultPanel(this.processedNodes);
            DialogHelper dialogHelper = new DialogHelper(refreshWFInputResultPanel);
            dialogHelper.showAsDialog();
        }
        catch (Exception exception) {
            CommandProcessor.getInstance().abortTrans();
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)exception.getMessage(), (String)RunManagerLrb.get("WORKFLOW_REFRESH_ERROR_MSG"), null);
        }
        finally {
            if (CommandProcessor.getInstance().isTransactionActive()) {
                CommandProcessor.getInstance().endTrans();
            }
        }
    }
}

