/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.aggregate;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.dmt.dataminer.controls.DataMinerCombBox;
import oracle.dmt.dataminer.controls.ToolTipComboBoxRenderer;
import oracle.dmt.dataminer.controls.dialog.DialogHelper;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.AttributeNameValidator;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.UITools;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregateDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregateEditMainDialog;
import oracle.dmt.dataminer.workflow.dialog.data.DataConsumerAttributesBase;
import oracle.dmt.dataminer.workflow.dialog.data.DataConsumerPanel;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.AggregationNode;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationElementType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.GroupingElementType;
import oracle.ide.Context;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public class AddAggregationAttributePanel
extends DataConsumerAttributesBase<AggregationNode>
implements DataConsumerPanel {
    private static final int MAXIMUM = 30;
    private static final int MAXIMUM_EX = 128;
    protected AggregationElementType thisAggregationElement;
    protected GroupingElementType mainGroupBy;
    protected List<AggregationElementType> allAggregationColumns;
    protected Map<String, AttributeType> dataProviderAttributes = new HashMap<String, AttributeType>();
    protected static final String _EMPTY_ELEMENT = AggregateDialogsLrb.get("ADD_AGGREGATION_DLG_EMPTY_COLUMN");
    protected JButton jBtnEdit;
    protected JCheckBox jChkAuto;
    protected JComboBox<String> jCmbColumns;
    protected JComboBox<String> jCmbFunctions;
    private JLabel jLblColumn;
    private JLabel jLblFunction;
    private JLabel jLblOutput;
    private JLabel jLblSubGroupBy;
    protected JTextField jTxtOutput;
    protected JTextField jtxtSubGroupBy;

    public AddAggregationAttributePanel(Context context, AggregationNode aggregationNode) {
        super(context, aggregationNode);
    }

    public AddAggregationAttributePanel(Context context, AggregationNode aggregationNode, GroupingElementType groupingElementType, List<AggregationElementType> list) {
        super(context, aggregationNode);
        AbstractNode abstractNode = aggregationNode.findParentNode();
        assert (abstractNode instanceof AbstractDataNode);
        List<AttributeType> list2 = this.getAvailableAttributes((AbstractDataNode)abstractNode);
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
        for (AttributeType attributeType : list2) {
            String string = attributeType.getDataType();
            try {
                if (DatabaseMetadataUtils.isKeyDataTypeSupported(string)) {
                    arrayList.add(attributeType);
                    continue;
                }
                if (!DatabaseMetadataUtils.isATimeStampOracleDataType(string)) continue;
                arrayList.add(attributeType);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)UITools.getParentDialog(this), (Exception)exception, (String)"Unexpected Exception");
            }
        }
        assert (arrayList != null) : "Available attribute collection must not be null";
        this.allAggregationColumns = list;
        this.mainGroupBy = groupingElementType;
        for (AttributeType attributeType : arrayList) {
            this.dataProviderAttributes.put(attributeType.getName(), attributeType);
        }
        this.thisAggregationElement = new AggregationElementType();
        this.thisAggregationElement.setSource(new GroupingElementType());
        Iterator<Object> iterator = new GroupingElementType();
        iterator.setAttributes(new Attributes());
        this.thisAggregationElement.setSubGroupBy(iterator);
        this.initUIComponents();
    }

    protected void initUIComponents() {
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jLblOutput = new JLabel();
        this.jTxtOutput = new JTextField();
        this.jChkAuto = new JCheckBox();
        this.jLblColumn = new JLabel();
        this.jCmbColumns = new DataMinerCombBox<String>();
        this.jLblFunction = new JLabel();
        this.jCmbFunctions = new DataMinerCombBox<String>();
        this.jLblSubGroupBy = new JLabel();
        this.jtxtSubGroupBy = new JTextField();
        this.jBtnEdit = new JButton();
        this.jLblOutput.setText("Output:");
        this.jChkAuto.setText("Auto Generate");
        this.jLblColumn.setText("Column:");
        this.jCmbColumns.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLblFunction.setText("Function:");
        this.jCmbFunctions.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLblSubGroupBy.setText("Sub Group By");
        this.jBtnEdit.setText("Edit");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGap(16, 16, 16).addComponent(this.jtxtSubGroupBy, -1, 291, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLblFunction, -1, -1, Short.MAX_VALUE).addComponent(this.jLblColumn, -1, -1, Short.MAX_VALUE).addComponent(this.jLblOutput, -1, 66, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCmbFunctions, 0, 226, Short.MAX_VALUE).addComponent(this.jCmbColumns, GroupLayout.Alignment.TRAILING, 0, 226, Short.MAX_VALUE).addComponent(this.jTxtOutput, GroupLayout.Alignment.TRAILING, -1, 226, Short.MAX_VALUE)))).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jBtnEdit).addComponent(this.jChkAuto))).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jLblSubGroupBy, -2, 170, -2))).addContainerGap()));
        groupLayout.linkSize(0, this.jLblColumn, this.jLblFunction, this.jLblOutput);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(20, 20, 20).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblOutput).addComponent(this.jTxtOutput, -2, -1, -2).addComponent(this.jChkAuto)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblColumn).addComponent(this.jCmbColumns, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblFunction).addComponent(this.jCmbFunctions, -2, -1, -2)).addGap(12, 12, 12).addComponent(this.jLblSubGroupBy).addGap(16, 16, 16).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jtxtSubGroupBy, -2, -1, -2).addComponent(this.jBtnEdit)).addContainerGap(26, Short.MAX_VALUE)));
        groupLayout.linkSize(1, this.jCmbColumns, this.jCmbFunctions, this.jTxtOutput);
        groupLayout.linkSize(1, this.jLblColumn, this.jLblFunction, this.jLblOutput);
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jLblOutput, (Component)this.jTxtOutput, (String)AggregateDialogsLrb.get("ADD_AGGREGATION_DLG_OUTPUT"));
        ResourceUtils.resLabel((JLabel)this.jLblColumn, this.jCmbColumns, (String)AggregateDialogsLrb.get("ADD_AGGREGATION_DLG_COLUMN"));
        ResourceUtils.resLabel((JLabel)this.jLblFunction, this.jCmbFunctions, (String)AggregateDialogsLrb.get("ADD_AGGREGATION_DLG_FUNCTION"));
        ResourceUtils.resButton((AbstractButton)this.jChkAuto, (String)AggregateDialogsLrb.get("ADD_AGGREGATION_DLG_AUTO_GENERATE"));
        ResourceUtils.resLabel((JLabel)this.jLblSubGroupBy, (Component)this.jtxtSubGroupBy, (String)AggregateDialogsLrb.get("ADD_AGGREGATION_DLG_SUB_GROUP_BY"));
        ResourceUtils.resButton((AbstractButton)this.jBtnEdit, (String)AggregateDialogsLrb.get("ADD_AGGREGATION_DLG_EDIT_SUB_GROUP_BY"));
        this.jLblOutput.setHorizontalTextPosition(2);
        this.jLblSubGroupBy.setHorizontalTextPosition(2);
    }

    protected JLabel getLableOutput() {
        return this.jLblOutput;
    }

    @Override
    public void initUI() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.dataProviderAttributes.keySet().toArray(new String[this.dataProviderAttributes.size()]);
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        Collections.sort(arrayList);
        Vector vector = new Vector(arrayList);
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(vector);
        defaultComboBoxModel.addElement(_EMPTY_ELEMENT);
        this.jCmbColumns.setModel(defaultComboBoxModel);
        this.jCmbColumns.setSelectedItem(_EMPTY_ELEMENT);
        this.jCmbColumns.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                String string;
                if (AddAggregationAttributePanel.this.jChkAuto.isSelected()) {
                    AddAggregationAttributePanel.this.setOutputText("");
                }
                if ((string = (String)AddAggregationAttributePanel.this.jCmbColumns.getSelectedItem()).equals(_EMPTY_ELEMENT)) {
                    AddAggregationAttributePanel.this.jCmbFunctions.setEnabled(false);
                    AddAggregationAttributePanel.this.jBtnEdit.setEnabled(false);
                    return;
                }
                List<String> list = null;
                AttributeType attributeType = AddAggregationAttributePanel.this.dataProviderAttributes.get(string);
                String string2 = attributeType.getDataType();
                if (attributeType != null && string2 != null) {
                    if ("DATE".equals(string2) || DatabaseMetadataUtils.isTimestampDerived(string2)) {
                        list = DatabaseMetadataUtils.AggregateFunctions.listDateTimestampFunctions();
                    } else {
                        object = DatabaseMetadataUtils.getDefaultMiningType(string2);
                        if (((String)object).equalsIgnoreCase("Categorical")) {
                            list = DatabaseMetadataUtils.AggregateFunctions.listCategoricFunctions();
                        }
                        if (((String)object).equalsIgnoreCase("Numerical")) {
                            list = DatabaseMetadataUtils.AggregateFunctions.listNumericFunctions();
                        }
                    }
                }
                if (list == null) {
                    AddAggregationAttributePanel.this.jCmbFunctions.setEnabled(false);
                    AddAggregationAttributePanel.this.jBtnEdit.setEnabled(false);
                    return;
                }
                AddAggregationAttributePanel.this.jCmbFunctions.setEnabled(true);
                AddAggregationAttributePanel.this.jBtnEdit.setEnabled(true);
                object = new DefaultComboBoxModel<String>(new Vector<String>(list));
                ((DefaultComboBoxModel)object).addElement(_EMPTY_ELEMENT);
                AddAggregationAttributePanel.this.jCmbFunctions.setModel((ComboBoxModel<String>)object);
                AddAggregationAttributePanel.this.jCmbFunctions.setSelectedItem(_EMPTY_ELEMENT);
                AttributeType attributeType2 = AddAggregationAttributePanel.this.dataProviderAttributes.get(string);
                if (attributeType2 != null) {
                    GroupingElementType groupingElementType = new GroupingElementType();
                    Attributes attributes = new Attributes();
                    attributes.getAttribute().add(attributeType2);
                    groupingElementType.setAttributes(attributes);
                    AddAggregationAttributePanel.this.thisAggregationElement.setSource(groupingElementType);
                }
            }
        });
        this.jCmbColumns.setRenderer(new ToolTipComboBoxRenderer());
        this.jCmbFunctions.setEnabled(false);
        DefaultComboBoxModel<String> defaultComboBoxModel2 = new DefaultComboBoxModel<String>(new String[]{_EMPTY_ELEMENT});
        this.jCmbFunctions.setModel(defaultComboBoxModel2);
        this.jCmbFunctions.setSelectedItem(_EMPTY_ELEMENT);
        this.jCmbFunctions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)AddAggregationAttributePanel.this.jCmbColumns.getSelectedItem();
                String string2 = (String)AddAggregationAttributePanel.this.jCmbFunctions.getSelectedItem();
                boolean bl = string2.equals(DatabaseMetadataUtils.AggregateFunctions.CAST_COLLECT.toString());
                AddAggregationAttributePanel.this.jBtnEdit.setEnabled(!bl);
                if (AddAggregationAttributePanel.this.jChkAuto.isSelected()) {
                    AddAggregationAttributePanel.this.setOutputText("");
                    if (string2.equals(_EMPTY_ELEMENT)) {
                        return;
                    }
                    String string3 = AttributeTypeHelper.createUniqueAggregationOutputName(AddAggregationAttributePanel.this._context, string, DatabaseMetadataUtils.AggregateFunctions.toAggregateName(string2), AddAggregationAttributePanel.this.allAggregationColumns);
                    AddAggregationAttributePanel.this.setOutputText(string3);
                }
            }
        });
        this.jChkAuto.setSelected(true);
        this.jChkAuto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddAggregationAttributePanel.this.jTxtOutput.setEditable(!AddAggregationAttributePanel.this.jChkAuto.isSelected());
                if (AddAggregationAttributePanel.this.jChkAuto.isSelected()) {
                    String string = (String)AddAggregationAttributePanel.this.jCmbFunctions.getSelectedItem();
                    String string2 = (String)AddAggregationAttributePanel.this.jCmbColumns.getSelectedItem();
                    if (!string.equals(_EMPTY_ELEMENT) && !string2.equals(_EMPTY_ELEMENT)) {
                        String string3 = AttributeTypeHelper.createUniqueAggregationOutputName(AddAggregationAttributePanel.this._context, string2, DatabaseMetadataUtils.AggregateFunctions.toAggregateName(string), AddAggregationAttributePanel.this.allAggregationColumns);
                        AddAggregationAttributePanel.this.setOutputText(string3);
                    }
                }
            }
        });
        this.jTxtOutput.setEditable(!this.jChkAuto.isSelected());
        this.jtxtSubGroupBy.setEditable(false);
        this.jBtnEdit.setEnabled(false);
        this.jBtnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AggregationNode aggregationNode = (AggregationNode)AddAggregationAttributePanel.this.getData();
                AbstractNode abstractNode = aggregationNode.findParentNode();
                assert (abstractNode instanceof AbstractDataNode);
                String string = (String)AddAggregationAttributePanel.this.jCmbFunctions.getSelectedItem();
                AddAggregationAttributePanel.this.thisAggregationElement.setAggregationFunction(string);
                AttributeTypeHelper.setOutputAttributeType(AddAggregationAttributePanel.this._context, AddAggregationAttributePanel.this.jTxtOutput.getText(), AddAggregationAttributePanel.this.thisAggregationElement);
                AggregateEditMainDialog aggregateEditMainDialog = new AggregateEditMainDialog(AddAggregationAttributePanel.this._context, aggregationNode, (AbstractDataNode)abstractNode, AddAggregationAttributePanel.this.thisAggregationElement, AddAggregationAttributePanel.this.mainGroupBy);
                DialogHelper dialogHelper = new DialogHelper(aggregateEditMainDialog);
                if (dialogHelper.showAsDialog(AddAggregationAttributePanel.this)) {
                    GroupingElementType groupingElementType = aggregateEditMainDialog.getGroupByElement();
                    AddAggregationAttributePanel.this.thisAggregationElement.setSubGroupBy(groupingElementType);
                    if (null != AddAggregationAttributePanel.this.thisAggregationElement.getSubGroupBy().getExpression()) {
                        AddAggregationAttributePanel.this.setSubGroupByText(AddAggregationAttributePanel.this.thisAggregationElement.getSubGroupBy().getExpression());
                    } else {
                        StringBuilder stringBuilder = new StringBuilder();
                        for (AttributeType attributeType : AddAggregationAttributePanel.this.thisAggregationElement.getSubGroupBy().getAttributes().getAttribute()) {
                            if (stringBuilder.length() > 0) {
                                stringBuilder.append(",");
                            }
                            stringBuilder.append(attributeType.getName());
                        }
                        AddAggregationAttributePanel.this.setSubGroupByText(stringBuilder.toString());
                    }
                }
            }
        });
    }

    protected void setOutputText(String string) {
        this.jTxtOutput.setText(string);
        this.jTxtOutput.setToolTipText(string);
        this.jTxtOutput.setCaretPosition(0);
    }

    protected void setSubGroupByText(String string) {
        this.jtxtSubGroupBy.setText(string);
        this.jtxtSubGroupBy.setToolTipText(string);
        this.jtxtSubGroupBy.setCaretPosition(0);
    }

    @Override
    public boolean doWork() {
        boolean bl = true;
        boolean bl2 = false;
        String string = (String)this.jCmbColumns.getSelectedItem();
        if (string == null || string.equals(_EMPTY_ELEMENT)) {
            return false;
        }
        String string2 = (String)this.jCmbFunctions.getSelectedItem();
        if (string2 == null || string2.equals(_EMPTY_ELEMENT)) {
            return false;
        }
        AttributeType attributeType = this.dataProviderAttributes.get(string);
        if (attributeType == null) {
            return false;
        }
        String string3 = this.jTxtOutput.getText().trim();
        if (null == string3 || string3.isEmpty()) {
            MessageDialog.error((Component)this, (Object)AggregateDialogsLrb.get("OUTPUT_NAME_IS_EMPTY"), (String)AggregateDialogsLrb.get("OUTPUT_NAME_IS_EMPTY_TITLE"), null);
            return false;
        }
        boolean bl3 = SQLHelper.isExpandedObjNameEnabled(this._context);
        if (bl3) {
            if (string3.length() > 128) {
                MessageDialog.error((Component)this, (Object)AggregateDialogsLrb.get("OUTPUT_NAME_TOO_LONG_EX"), (String)AggregateDialogsLrb.get("OUTPUT_NAME_IS_EMPTY_TITLE"), null);
                return false;
            }
        } else if (string3.length() > 30) {
            MessageDialog.error((Component)this, (Object)AggregateDialogsLrb.get("OUTPUT_NAME_TOO_LONG"), (String)AggregateDialogsLrb.get("OUTPUT_NAME_IS_EMPTY_TITLE"), null);
            return false;
        }
        if (StringUtils.checkDataLossWithMsg(this.getContext(), string3, AggregateDialogsLrb.get("OUTPUT_NAME_IS_INVALID"))) {
            return false;
        }
        this.thisAggregationElement.setAggregationFunction(string2);
        boolean bl4 = StringUtils.isDoubleQuotedString(string3);
        if (!bl4) {
            string3 = string3.toUpperCase();
        }
        if (!AttributeNameValidator.validateAttributeName(string3, null, this._context, true)) {
            return false;
        }
        if (!bl4 && !Character.isLetter(string3.charAt(0))) {
            MessageDialog.error((Component)this, (Object)AggregateDialogsLrb.get("OUTPUT_NAME_IS_INVALID"), (String)AggregateDialogsLrb.get("OUTPUT_NAME_IS_EMPTY_TITLE"), null);
            return false;
        }
        if (null != this.thisAggregationElement.getOutput() && null != this.thisAggregationElement.getOutput().getName()) {
            if (!string3.equals(this.thisAggregationElement.getOutput().getName()) && !AttributeTypeHelper.isUniqueAggregationOutputName(string3, this.allAggregationColumns, this.dataProviderAttributes)) {
                bl2 = true;
            }
        } else if (!AttributeTypeHelper.isUniqueAggregationOutputName(string3, this.allAggregationColumns, this.dataProviderAttributes)) {
            bl2 = true;
        }
        if (bl2) {
            MessageDialog.error((Component)this, (Object)AggregateDialogsLrb.get("OUTPUT_NAME_IS_DUPLICATE"), (String)AggregateDialogsLrb.get("OUTPUT_NAME_IS_EMPTY_TITLE"), null);
            return false;
        }
        AttributeTypeHelper.setOutputAttributeType(this._context, string3, this.thisAggregationElement);
        return bl;
    }

    public AggregationElementType getNewAggregationElement() {
        return this.thisAggregationElement;
    }

    public JLabel getLabelSubGroupBy() {
        return this.jLblSubGroupBy;
    }

    @Override
    protected String getDialogTitle() {
        return AggregateDialogsLrb.get("ADD_AGGREGATE_ELEMENT_DIALOG_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        return "aggregation_node_add_element";
    }
}

