/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.aggregate;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregateDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregateEditMainPanel;
import oracle.dmt.dataminer.workflow.dialog.data.DataConsumerAttributesDialog;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AggregationNode;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationElementType;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.GroupingElementType;
import oracle.ide.Context;

public class AggregateEditMainDialog
extends DataConsumerAttributesDialog<AggregationNode> {
    private AggregateEditMainPanel content;
    private AggregationNodeType cachedAggregationNodeData;
    private AggregationElementType cachedAggregationElement;
    private GroupingElementType mainGroupBy;

    public AggregateEditMainDialog(Context context, AggregationNode aggregationNode, AbstractDataNode abstractDataNode, AggregationNodeType aggregationNodeType) {
        super(context, aggregationNode, abstractDataNode);
        this.cachedAggregationNodeData = aggregationNodeType;
    }

    public AggregateEditMainDialog(Context context, AggregationNode aggregationNode, AbstractDataNode abstractDataNode, AggregationElementType aggregationElementType, GroupingElementType groupingElementType) {
        super(context, aggregationNode, abstractDataNode);
        this.cachedAggregationElement = aggregationElementType;
        this.mainGroupBy = groupingElementType;
    }

    public GroupingElementType getGroupByElement() {
        return this.content.getGroupByElement();
    }

    @Override
    protected String getDialogTitle() {
        return AggregateDialogsLrb.get("ADD_AGGREGATE_MAIN_GROUP_BY_DIALOG_TITLE");
    }

    @Override
    protected String getHelpId() {
        return "aggregation_node_edit_group";
    }

    @Override
    protected JPanel getDialogContent() {
        List<AttributeType> list = this.getAvailableAttributes(this.data);
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
        for (AttributeType attributeType : list) {
            String string = attributeType.getDataType();
            if (DatabaseMetadataUtils.isKeyDataTypeSupported(string)) {
                arrayList.add(attributeType);
                continue;
            }
            if (!DatabaseMetadataUtils.isATimeStampOracleDataType(string)) continue;
            arrayList.add(attributeType);
        }
        if (this.cachedAggregationNodeData != null) {
            this.content = new AggregateEditMainPanel(this.context, this.data, this.cachedAggregationNodeData, arrayList);
        } else if (this.cachedAggregationElement != null) {
            this.content = new AggregateEditMainPanel(this.context, this.data, this.cachedAggregationElement, this.mainGroupBy, arrayList);
        }
        return this.content;
    }
}

