/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import oracle.dmt.dataminer.controls.dialog.DialogDisplayable;
import oracle.dmt.dataminer.controls.dialog.DialogExecutionException;
import oracle.dmt.dataminer.controls.dialog.Dialogable;
import oracle.dmt.dataminer.controls.dialog.DialogableExecutableAdapter;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.dialog.AbstractPanel;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditModelsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.build.BuildNodeTableModel;
import oracle.dmt.dataminer.workflow.dialog.build.DataUsagePanel;
import oracle.dmt.dataminer.workflow.dialog.build.PartitionPanel;
import oracle.dmt.dataminer.workflow.dialog.build.TextSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.CommonSettingDataObject;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.ModelARAggregatePanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.ModelARFilterPanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.SamplingSettingsPanel;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AnomalyDetectionBuildNode;
import oracle.dmt.dataminer.workflow.model.AssociationBuildNode;
import oracle.dmt.dataminer.workflow.model.ClassificationBuildNode;
import oracle.dmt.dataminer.workflow.model.ClusteringBuildNode;
import oracle.dmt.dataminer.workflow.model.ExplicitFeatureExtractionBuildNode;
import oracle.dmt.dataminer.workflow.model.FeatureExtractionBuildNode;
import oracle.dmt.dataminer.workflow.model.RBuildNode;
import oracle.dmt.dataminer.workflow.model.RegressionBuildNode;
import oracle.dmt.dataminer.workflow.xmlschema.AssociationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ExtensibleBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressionType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressions;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionModelType;
import oracle.dmt.dataminer.workflow.xmlschema.SuperviseBuildNodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.Version;

public class BuildEditDialog
implements DialogDisplayable {
    private static final Logger theLogger = Logger.getLogger(BuildEditDialog.class.getName());
    private static int lastTabIndex = 0;
    private JTabbedPane tabs;
    private Context context;
    private AbstractBuildNode node;
    private List<String> selectedModels;

    public BuildEditDialog(Context context, AbstractBuildNode abstractBuildNode, List<String> list) {
        this.context = context;
        this.node = abstractBuildNode;
        this.selectedModels = list;
    }

    public static String getModelsDeleteMessage(JTable jTable) {
        int[] nArray = jTable.getSelectedRows();
        String[] stringArray = new String[3];
        if (nArray.length == 1) {
            stringArray[0] = BuildEditorLrb.get("REMOVE_MODEL_SPEC_MSG");
            stringArray[1] = BuildEditorLrb.get("REMOVE_MODEL_TEST_MSG");
            stringArray[2] = BuildEditorLrb.get("REMOVE_MODEL_NON_MSG");
        } else {
            stringArray[0] = BuildEditorLrb.get("REMOVE_MODEL_MULT_MSG");
            stringArray[1] = BuildEditorLrb.get("REMOVE_MODEL_TEST_MULT_MSG");
            stringArray[2] = BuildEditorLrb.get("REMOVE_MODEL_NON_MULT_MSG");
        }
        List<ModelType> list = ((BuildNodeTableModel)((Object)jTable.getModel())).getDataList();
        String string = null;
        for (int n : nArray) {
            ModelType modelType = list.get(n);
            if (modelType.getCreationDate() == null && string == null) {
                string = stringArray[0];
                continue;
            }
            if (modelType.getCreationDate() == null) continue;
            if (modelType instanceof ClassificationModelType || modelType instanceof RegressionModelType) {
                string = stringArray[1];
                continue;
            }
            string = stringArray[2];
            return string;
        }
        return string;
    }

    @Override
    public Dialogable asDialog() {
        return new DialogableExecutableAdapter(){
            TabbedContainer content;

            @Override
            public void onOK() throws DialogExecutionException {
                this.content.doWork();
                lastTabIndex = BuildEditDialog.this.tabs.getSelectedIndex();
            }

            @Override
            public boolean canBeCanceled() {
                boolean bl = true;
                if (this.content.isDirty()) {
                    int n = MessageDialog.confirmOrCancel((Component)Ide.getMainWindow(), (Object)BuildEditorLrb.get("BUILD_DIALOG_CHANGES_PENDING_MSG"), (String)BuildEditorLrb.get("BUILD_DIALOG_CHANGES_PENDING_TITLE"));
                    if (n == -1) {
                        bl = false;
                    } else if (n == 1) {
                        if (!this.content.doWork()) {
                            bl = false;
                        }
                        lastTabIndex = BuildEditDialog.this.tabs.getSelectedIndex();
                    }
                }
                return bl;
            }

            @Override
            public String getTitle() {
                if (BuildEditDialog.this.node == null) {
                    return "Not Found";
                }
                if (BuildEditDialog.this.node instanceof ClassificationBuildNode) {
                    return BuildEditorLrb.get("HEURISTIC_DETAILS_EDIT_CLASSIFICATION_NODE_TITLE");
                }
                if (BuildEditDialog.this.node instanceof RegressionBuildNode) {
                    return BuildEditorLrb.get("HEURISTIC_DETAILS_EDIT_REGRESSION_NODE_TITLE");
                }
                if (BuildEditDialog.this.node instanceof ClusteringBuildNode) {
                    return BuildEditorLrb.get("HEURISTIC_DETAILS_EDIT_CLUSTERING_NODE_TITLE");
                }
                if (BuildEditDialog.this.node instanceof AssociationBuildNode) {
                    return BuildEditorLrb.get("HEURISTIC_DETAILS_EDIT_ASSOCIATION_NODE_TITLE");
                }
                if (BuildEditDialog.this.node instanceof AnomalyDetectionBuildNode) {
                    return BuildEditorLrb.get("HEURISTIC_DETAILS_EDIT_ANOMALY_DETECTION_NODE_TITLE");
                }
                if (BuildEditDialog.this.node instanceof FeatureExtractionBuildNode) {
                    return BuildEditorLrb.get("HEURISTIC_DETAILS_EDIT_FEATURE_EXTRACTION_NODE_TITLE");
                }
                if (BuildEditDialog.this.node instanceof ExplicitFeatureExtractionBuildNode) {
                    return BuildEditorLrb.get("HEURISTIC_DETAILS_EDIT_EXPLICIT_FEATURE_EXTRACTION_NODE_TITLE");
                }
                if (BuildEditDialog.this.node instanceof RBuildNode) {
                    return BuildEditorLrb.get("HEURISTIC_DETAILS_EDIT_R_NODE_TITLE");
                }
                assert (false) : "Not Supported";
                return "Not Found";
            }

            @Override
            public String getHelpTopic() {
                String string = null;
                if (BuildEditDialog.this.node instanceof AssociationBuildNode) {
                    string = "association_node_edit";
                } else if (BuildEditDialog.this.node instanceof ClassificationBuildNode) {
                    string = "classification_node_edit";
                } else if (BuildEditDialog.this.node instanceof ClusteringBuildNode) {
                    string = "clustering_node_edit";
                } else if (BuildEditDialog.this.node instanceof RegressionBuildNode) {
                    string = "regression_node_edit";
                } else if (BuildEditDialog.this.node instanceof AnomalyDetectionBuildNode) {
                    string = "anomaly_node_edit";
                } else if (BuildEditDialog.this.node instanceof FeatureExtractionBuildNode) {
                    string = "feature_node_edit";
                } else if (BuildEditDialog.this.node instanceof ExplicitFeatureExtractionBuildNode) {
                    string = "esa_node_edit";
                } else if (BuildEditDialog.this.node instanceof RBuildNode) {
                    string = "r_node_edit";
                }
                return string;
            }

            @Override
            public JComponent getContent() {
                this.content = new TabbedContainer(BuildEditDialog.this.context, BuildEditDialog.this.node);
                return this.content;
            }
        };
    }

    private class TabbedContainer
    extends AbstractPanel<AbstractBuildNode> {
        private BuildNodeType nodeData;
        private BuildNodeType nodeDataCopy;
        private DataUsagePanel dataPanel;
        private TextSettingsPanel textPanel;
        private PartitionPanel partitionPanel;
        private ModelARFilterPanel filterPanel;
        private BuildEditModelsPanel buildPanel;
        private SamplingSettingsPanel samplingPanel;
        private ModelARAggregatePanel aggregatePanel;
        private Version dbVersion;

        public TabbedContainer(Context context, AbstractBuildNode abstractBuildNode) {
            super(context, abstractBuildNode);
            this.nodeData = (BuildNodeType)BuildEditDialog.this.node.getData();
            this.nodeDataCopy = (BuildNodeType)MetaDataHelper.copyMetadataObject(abstractBuildNode.getData());
            this.dbVersion = ConnectionFolder.getConnectionFolder(context).getDbVersion();
            this.initUI();
        }

        public boolean isDirty() {
            return this.buildPanel.isDirty() || this.dataPanel != null && this.dataPanel.isDirty() || this.textPanel != null && this.textPanel.isDirty() || this.filterPanel != null && this.filterPanel.isDirty() || this.aggregatePanel != null && this.aggregatePanel.isDirty() || this.partitionPanel != null && this.partitionPanel.isDirty() || this.samplingPanel != null && this.samplingPanel.isDirty();
        }

        @Override
        public void initUI() {
            Object object;
            Object object2;
            this.setLayout(new BorderLayout());
            HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
            HashMap<String, AttributeType> hashMap2 = new HashMap<String, AttributeType>();
            HashMap<String, AttributeType> hashMap3 = new HashMap<String, AttributeType>();
            if (this.nodeDataCopy instanceof SuperviseBuildNodeType) {
                object2 = ((SuperviseBuildNodeType)this.nodeDataCopy).getTargetAttribute();
                if (object2 != null) {
                    hashMap.put(object2.getName(), (AttributeType)object2);
                }
            } else if (this.nodeDataCopy instanceof ExtensibleBuildNodeType && (object2 = ((ExtensibleBuildNodeType)this.nodeDataCopy).getTargetAttribute()) != null) {
                hashMap.put(object2.getName(), (AttributeType)object2);
            }
            object2 = this.nodeDataCopy.getCaseAttributes().getAttribute();
            PartitionExpressions partitionExpressions = object2.iterator();
            while (partitionExpressions.hasNext()) {
                object = (AttributeType)partitionExpressions.next();
                hashMap2.put(object.getName(), (AttributeType)object);
            }
            partitionExpressions = this.nodeDataCopy.getPartitionExpressions();
            if (partitionExpressions != null) {
                for (PartitionExpressionType partitionExpressionType : this.nodeDataCopy.getPartitionExpressions().getPartitionExpression()) {
                    if (partitionExpressionType.getSQLExpression() != null) continue;
                    AttributeType attributeType = partitionExpressionType.getPartitionAttribute();
                    hashMap3.put(attributeType.getName(), attributeType);
                }
            }
            BuildEditDialog.this.tabs = new JTabbedPane();
            this.buildPanel = new BuildEditModelsPanel(BuildEditDialog.this.context, BuildEditDialog.this.node, this.nodeDataCopy, new ArrayList<String>());
            BuildEditDialog.this.tabs.add(BuildEditorLrb.get("BUILD_TAB"), this.buildPanel);
            if (DbVersionHelper.isDB122Up((Version)this.dbVersion)) {
                this.partitionPanel = new PartitionPanel(BuildEditDialog.this.context, BuildEditDialog.this.node, this.nodeDataCopy);
                BuildEditDialog.this.tabs.add(BuildEditorLrb.get("PARTITION_TAB"), this.partitionPanel);
                if (BuildEditDialog.this.node instanceof AssociationBuildNode) {
                    object = new HashMap();
                    this.filterPanel = new ModelARFilterPanel(BuildEditDialog.this.context, BuildEditDialog.this.node, this.nodeDataCopy);
                    this.filterPanel.setStateMap((Map<String, CommonSettingDataObject>)object);
                    BuildEditDialog.this.tabs.add(BuildEditorLrb.get("FILTER_TAB"), this.filterPanel);
                    this.buildPanel.setModelARFilterPanelRef(this.filterPanel);
                    this.aggregatePanel = new ModelARAggregatePanel(BuildEditDialog.this.node, this.nodeDataCopy, BuildEditDialog.this.context, (Map<String, CommonSettingDataObject>)object);
                    BuildEditDialog.this.tabs.add(BuildEditorLrb.get("AGGREGATE_TAB"), this.aggregatePanel);
                    this.buildPanel.setModelARAggregatePanelRef(this.aggregatePanel);
                }
                this.samplingPanel = new SamplingSettingsPanel(BuildEditDialog.this.node, this.nodeDataCopy, BuildEditDialog.this.context);
                BuildEditDialog.this.tabs.add(BuildEditorLrb.get("SAMPLING_TAB"), this.samplingPanel);
            }
            if (!(BuildEditDialog.this.node instanceof AssociationBuildNode)) {
                this.dataPanel = new DataUsagePanel(BuildEditDialog.this.context, BuildEditDialog.this.node, this.nodeDataCopy, this.nodeDataCopy.getMiningAttributes(), hashMap, hashMap2, hashMap3, 6);
                BuildEditDialog.this.tabs.add(BuildEditorLrb.get("DATA_TAB"), this.dataPanel);
                this.buildPanel.setDataUsagePanel(this.dataPanel);
                this.buildPanel.addEditChangeListener(this.dataPanel);
                if (this.partitionPanel != null) {
                    this.partitionPanel.addEditChangeListener(this.dataPanel);
                }
                this.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentResized(ComponentEvent componentEvent) {
                        TabbedContainer.this.dataPanel.resizeTable(TabbedContainer.this.getSize());
                    }
                });
            }
            if (DbVersionHelper.isDB121Up((Version)this.dbVersion) && !(BuildEditDialog.this.node instanceof AssociationBuildNode)) {
                this.textPanel = new TextSettingsPanel(BuildEditDialog.this.context, BuildEditDialog.this.node, this.nodeDataCopy);
                this.textPanel.addEditChangeListener(this.dataPanel);
                BuildEditDialog.this.tabs.add(BuildEditorLrb.get("TEXT_TAB"), this.textPanel);
            }
            this.add(BuildEditDialog.this.tabs);
            if (BuildEditDialog.this.tabs.getTabCount() < lastTabIndex + 1) {
                lastTabIndex = 0;
            }
            BuildEditDialog.this.tabs.setSelectedIndex(lastTabIndex);
        }

        public boolean doWork() {
            Object object;
            if (!this.buildPanel.doWork()) {
                return false;
            }
            if (!(BuildEditDialog.this.node instanceof AssociationBuildNode) && !this.dataPanel.doWork()) {
                return false;
            }
            if (this.textPanel != null && !this.textPanel.doWork()) {
                return false;
            }
            if (this.partitionPanel != null && !this.partitionPanel.doWork()) {
                return false;
            }
            if (DbVersionHelper.isDB122Up((Version)this.dbVersion)) {
                if (this.filterPanel != null) {
                    this.filterPanel.processItemChanged();
                    if (!MetaDataHelper.isEqualRuleSettings(this.nodeData, this.nodeDataCopy)) {
                        MetaDataHelper.setModelsStatus(this.nodeDataCopy, ModelStatusType.READY);
                    }
                }
                if (this.aggregatePanel != null) {
                    this.aggregatePanel.processItemChanged();
                    if (!MetaDataHelper.isEqualAggregateSettings(this.nodeData, this.nodeDataCopy)) {
                        MetaDataHelper.setModelsStatus(this.nodeDataCopy, ModelStatusType.READY);
                    }
                }
                if (this.samplingPanel != null) {
                    this.samplingPanel.processItemChanged();
                    if (!MetaDataHelper.isEqualSampleSetting(this.nodeData, this.nodeDataCopy)) {
                        MetaDataHelper.setModelsStatus(this.nodeDataCopy, ModelStatusType.READY);
                    }
                }
            }
            if (!this.isDirty()) {
                return true;
            }
            boolean bl = true;
            List<ModelType> list = MetaDataHelper.getModelsCollection(this.nodeData);
            HashMap<String, ModelType> hashMap = new HashMap<String, ModelType>();
            ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
            for (ModelType modelType : list) {
                object = MetaDataHelper.findModelById(this.nodeDataCopy, modelType.getId());
                if (object == null || object.getName().equals(modelType.getName())) continue;
                hashMap.put(object.getName(), modelType);
                arrayList.add((ModelType)object);
            }
            if (!MetaDataHelper.isEqualTargetAndCaseID(this.nodeData, this.nodeDataCopy)) {
                MetaDataHelper.setModelsStatus(this.nodeDataCopy, ModelStatusType.READY);
            } else if (this.nodeData instanceof AssociationBuildNodeType) {
                if (!MetaDataHelper.isEqualAssociationSettings(this.nodeData, this.nodeDataCopy)) {
                    MetaDataHelper.setModelsStatus(this.nodeDataCopy, ModelStatusType.READY);
                }
            } else if (this.nodeData instanceof ExtensibleBuildNodeType) {
                if (!MetaDataHelper.isEqualMiningFunction(this.nodeData, this.nodeDataCopy)) {
                    MetaDataHelper.setModelsStatus(this.nodeDataCopy, ModelStatusType.READY);
                }
            } else if (!hashMap.isEmpty()) {
                MetaDataHelper.setModelsStatus(this.nodeDataCopy, arrayList, ModelStatusType.READY);
            } else if (this.partitionPanel != null && !MetaDataHelper.isEqualPartitionColumns(this.nodeData, this.nodeDataCopy)) {
                MetaDataHelper.setModelsStatus(this.nodeDataCopy, ModelStatusType.READY);
            }
            if (this.dataPanel != null) {
                boolean bl2 = this.dataPanel.getAutoBtn().isSelected();
                boolean bl3 = this.dataPanel.getOriginalAutoValue();
                if (!bl2 && BuildEditDialog.this.node instanceof ClassificationBuildNode) {
                    object = MetaDataHelper.getModelsCollection(this.nodeDataCopy);
                    Iterator<Object> iterator = object.iterator();
                    while (iterator.hasNext()) {
                        ModelType modelType = (ModelType)iterator.next();
                        if (this.dataPanel.isValidRowWeightColumn(modelType, "")) continue;
                        return false;
                    }
                }
                if (bl2 != bl3) {
                    MetaDataHelper.setModelsStatus(this.nodeDataCopy, ModelStatusType.READY);
                }
            }
            try {
                CommandProcessor.getInstance().beginTrans(BuildEditorLrb.get("EDIT_NODE"));
                OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)BuildEditDialog.this.node.getUndoFilter();
                odmrSDMUndoFilter.prepareUndo(BuildEditDialog.this.node, BuildEditDialog.this.context, "nodetype", this.nodeDataCopy);
                if (hashMap.size() > 0) {
                    List<RefModelType> list2 = MetaDataHelper.getModelsCollection(this.nodeDataCopy, BuildEditDialog.this.context);
                    object = new HashMap();
                    for (RefModelType refModelType : list2) {
                        if (!hashMap.containsKey(refModelType.getName())) continue;
                        object.put(((ModelType)hashMap.get(refModelType.getName())).getName(), refModelType);
                    }
                    BuildEditDialog.this.node.refactorChildModelReferences((Map<String, RefModelType>)object, false);
                }
                BuildEditDialog.this.node.validateAfterEdit();
                CommandProcessor.getInstance().endTrans();
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                bl = false;
                CommandProcessor.getInstance().abortTrans();
            }
            return bl;
        }

        @Override
        public void initRes() {
        }
    }
}

