/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dmt.dataminer.controls.DataMinerCombBox;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.ToolTipComboBoxRenderer;
import oracle.dmt.dataminer.controls.dialog.DialogHelper;
import oracle.dmt.dataminer.controls.models.SimpleBaseTableModel;
import oracle.dmt.dataminer.core.model.common.build.TargetItem;
import oracle.dmt.dataminer.core.utils.comparator.AttributeTypeComparator;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.utils.TimeUtils;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.dialog.build.AbstractEditPanel;
import oracle.dmt.dataminer.workflow.dialog.build.AdvancedSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditDialog;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.build.BuildNodeTableModel;
import oracle.dmt.dataminer.workflow.dialog.build.CaseEditRecord;
import oracle.dmt.dataminer.workflow.dialog.build.DataUsagePanel;
import oracle.dmt.dataminer.workflow.dialog.build.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.EditChangeListener;
import oracle.dmt.dataminer.workflow.dialog.build.ModelDataUsageCellRenderer;
import oracle.dmt.dataminer.workflow.dialog.build.ModelNameCellEditor;
import oracle.dmt.dataminer.workflow.dialog.build.ModelsTable;
import oracle.dmt.dataminer.workflow.dialog.build.NewModelPanel;
import oracle.dmt.dataminer.workflow.dialog.build.NewRModelPanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AlgSettingsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.ModelARAggregatePanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.ModelARFilterPanel;
import oracle.dmt.dataminer.workflow.inspect.EditCaseAttributesDialog;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AnomalyDetectionBuildNode;
import oracle.dmt.dataminer.workflow.model.AssociationBuildNode;
import oracle.dmt.dataminer.workflow.model.ClassificationBuildNode;
import oracle.dmt.dataminer.workflow.model.ClusteringBuildNode;
import oracle.dmt.dataminer.workflow.model.ExplicitFeatureExtractionBuildNode;
import oracle.dmt.dataminer.workflow.model.ExtensibleBuildNode;
import oracle.dmt.dataminer.workflow.model.FeatureExtractionBuildNode;
import oracle.dmt.dataminer.workflow.model.RBuildNode;
import oracle.dmt.dataminer.workflow.model.RegressionBuildNode;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.AssociationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CaseAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ExplicitFeatureExtractionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ExtensibleBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.InputMiningData;
import oracle.dmt.dataminer.workflow.xmlschema.InputMiningDataType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.SuperviseBuildNodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.TransparentPanel;
import oracle.javatools.util.Version;

public class BuildEditModelsPanel
extends AbstractEditPanel {
    private static final Logger LOGGER = Logger.getLogger(BuildEditModelsPanel.class.getName());
    private static final String[] COLUMNS = new String[]{BuildEditorLrb.get("BUILD_MODEL_NAME"), BuildEditorLrb.get("BUILD_MODEL_ALGORITHM"), BuildEditorLrb.get("BUILD_MODEL_LAST_BUILT"), BuildEditorLrb.get("BUILD_MODEL_USAGE")};
    private static final String[] FUNCTION_MODEL = new String[]{BuildEditorLrb.get("BUILD_NODE_FUNCTION_HINT"), BuildEditorLrb.get("EXTENSIBLE_CLASSIFICATION_TYPE"), BuildEditorLrb.get("EXTENSIBLE_REGRESSION_TYPE"), BuildEditorLrb.get("EXTENSIBLE_CLUSTERING_TYPE"), BuildEditorLrb.get("EXTENSIBLE_FEATURE_EXTRACTION_TYPE")};
    private JButton addBtn;
    private JButton editBtn;
    private JButton removeBtn;
    private JButton duplicateBtn;
    private ModelsTableModel modelsTblModel;
    private BuildNodeType nodeData;
    private BuildNodeType nodeDataCopy;
    private DataUsagePanel dataUsagePanel;
    private boolean dirty;
    private Object previousSelItemID;
    private List<String> selectedModels;
    private List<TargetItem> availableTargets;
    private List<MiningAttributeType> attributes;
    private DefaultComboBoxModel<String> functionComboModel;
    private DefaultComboBoxModel<TargetItem> targetComboModel;
    private ModelsTable jModelsTable;
    private MiningFunctionType functionType;
    private ModelARFilterPanel modelARFilterPanelRef;
    private ModelARAggregatePanel modelARAggregatePanelRef;
    private Version dbVersion;
    private JButton jBtnCaseIds;
    private DataMinerCombBox jCaseCombo;
    private JLabel jCaseLabel;
    private JComboBox<String> jFunctionChoice;
    private JLabel jFunctionLabel;
    private DataMinerCombBox jItemIDCombo;
    private DataMinerCombBox jItemValueCombo;
    private JLabel jLblCaseIds;
    private JLabel jLblItemID;
    private JLabel jLblItemValue;
    private TransparentPanel jModelsTablePanel;
    private ComponentWithTitlebar<JComponent> jModelsToolbar;
    private DataMinerCombBox<TargetItem> jTargetChoice;
    private JLabel jTargetLabel;
    private JTextField jTextCaseIds;
    private JLabel statusIconCase;
    private JLabel statusIconCaseIDs;
    private JLabel statusIconFunction;
    private JLabel statusIconTarget;
    private JLabel statusItemId;
    private JLabel statusItemValue;

    public BuildEditModelsPanel(Context context, AbstractBuildNode abstractBuildNode, BuildNodeType buildNodeType, List<String> list) {
        super(context, abstractBuildNode);
        this.jModelsTable = new ModelsTable(buildNodeType, 3);
        this.nodeData = (BuildNodeType)abstractBuildNode.getData();
        this.selectedModels = list;
        this.nodeDataCopy = buildNodeType;
        this.attributes = this.nodeData.getMiningAttributes().getMiningAttribute();
        Collections.sort(this.attributes, AttributeTypeComparator.getComparator());
        this.dbVersion = ConnectionFolder.getConnectionFolder(context).getDbVersion();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public void setModelARFilterPanelRef(ModelARFilterPanel modelARFilterPanel) {
        this.modelARFilterPanelRef = modelARFilterPanel;
    }

    public void setModelARAggregatePanelRef(ModelARAggregatePanel modelARAggregatePanel) {
        this.modelARAggregatePanelRef = modelARAggregatePanel;
    }

    private void initComponents() {
        this.jModelsTablePanel = new TransparentPanel();
        this.jModelsToolbar = new ComponentWithTitlebar();
        this.jTargetLabel = new JLabel();
        this.jTargetChoice = new DataMinerCombBox();
        this.jCaseLabel = new JLabel();
        this.jCaseCombo = new DataMinerCombBox();
        this.jLblCaseIds = new JLabel();
        this.jTextCaseIds = new JTextField();
        this.jBtnCaseIds = new JButton();
        this.jItemIDCombo = new DataMinerCombBox();
        this.jLblItemID = new JLabel();
        this.jLblItemValue = new JLabel();
        this.jItemValueCombo = new DataMinerCombBox();
        this.statusIconTarget = new JLabel();
        this.statusIconCase = new JLabel();
        this.statusItemId = new JLabel();
        this.statusItemValue = new JLabel();
        this.statusIconCaseIDs = new JLabel();
        this.jFunctionLabel = new JLabel();
        this.jFunctionChoice = new JComboBox();
        this.statusIconFunction = new JLabel();
        this.jModelsToolbar.setPreferredSize(new Dimension(0, 0));
        this.jTargetLabel.setText("Target:");
        this.jTargetLabel.setHorizontalTextPosition(2);
        this.jCaseLabel.setText("Case ID:");
        this.jCaseLabel.setHorizontalTextPosition(2);
        this.jLblCaseIds.setText("Case IDs:");
        this.jTextCaseIds.setEditable(false);
        this.jTextCaseIds.setMargin(new Insets(2, 2, 2, 0));
        this.jBtnCaseIds.setAlignmentY(0.0f);
        this.jBtnCaseIds.setMaximumSize(new Dimension(0, 0));
        this.jBtnCaseIds.setMinimumSize(new Dimension(0, 0));
        this.jBtnCaseIds.setPreferredSize(new Dimension(5, 5));
        this.jLblItemID.setText("Item ID:");
        this.jLblItemValue.setText("Item Value:");
        this.statusIconTarget.setText("warnIcon");
        this.statusIconTarget.setHorizontalTextPosition(4);
        this.statusIconCase.setText("warnIcon");
        this.statusIconCase.setHorizontalTextPosition(4);
        this.statusItemId.setText("warnIcon");
        this.statusItemValue.setText("warnIcon");
        this.statusIconCaseIDs.setText("warnIcon");
        this.jFunctionLabel.setText("Function:");
        this.statusIconFunction.setText("warnIcon");
        this.statusIconFunction.setHorizontalTextPosition(4);
        GroupLayout groupLayout = new GroupLayout((Container)this.jModelsTablePanel);
        this.jModelsTablePanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jModelsToolbar, -1, -1, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jCaseLabel).addComponent(this.jLblItemValue, -1, -1, Short.MAX_VALUE).addComponent(this.jLblCaseIds, -1, -1, Short.MAX_VALUE).addComponent(this.jLblItemID, -1, -1, Short.MAX_VALUE).addComponent(this.jFunctionLabel).addComponent(this.jTargetLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jTextCaseIds, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusIconCaseIDs).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jBtnCaseIds, -2, 23, -2)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jItemValueCombo, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusItemValue)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jItemIDCombo, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusItemId)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jCaseCombo, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusIconCase)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jTargetChoice, -1, 220, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusIconTarget)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jFunctionChoice, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusIconFunction))).addContainerGap(394, Short.MAX_VALUE)));
        groupLayout.linkSize(0, this.jCaseCombo, this.jItemIDCombo, this.jItemValueCombo, this.jTargetChoice, this.jTextCaseIds);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jFunctionChoice, -2, -1, -2).addComponent(this.jFunctionLabel).addComponent(this.statusIconFunction)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTargetLabel).addComponent(this.jTargetChoice, -2, -1, -2).addComponent(this.statusIconTarget)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCaseLabel).addComponent(this.jCaseCombo, -2, -1, -2).addComponent(this.statusIconCase)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblCaseIds).addComponent(this.jTextCaseIds, -2, -1, -2).addComponent(this.statusIconCaseIDs)).addComponent(this.jBtnCaseIds, -2, 20, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblItemID).addComponent(this.jItemIDCombo, -2, -1, -2).addComponent(this.statusItemId)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblItemValue).addComponent(this.jItemValueCombo, -2, -1, -2).addComponent(this.statusItemValue)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.jModelsToolbar, -1, 188, Short.MAX_VALUE)));
        groupLayout.linkSize(1, this.jLblCaseIds, this.jTextCaseIds);
        groupLayout.linkSize(1, this.jTargetChoice, this.jTargetLabel);
        groupLayout.linkSize(1, this.jItemIDCombo, this.jLblItemID);
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent((Component)this.jModelsTablePanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent((Component)this.jModelsTablePanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jFunctionLabel, this.jFunctionChoice, (String)BuildEditorLrb.get("BUILD_NODE_FUNCTION"));
        ResourceUtils.resLabel((JLabel)this.jTargetLabel, this.jTargetChoice, (String)BuildEditorLrb.get("BUILD_NODE_TARGET"));
        ResourceUtils.resLabel((JLabel)this.jCaseLabel, (Component)this.jCaseCombo, (String)(this.nodeData instanceof ExplicitFeatureExtractionBuildNodeType ? BuildEditorLrb.get("BUILD_NODE_TOPICID") : BuildEditorLrb.get("BUILD_NODE_CASEID")));
        ResourceUtils.resLabel((JLabel)this.jLblCaseIds, (Component)this.jTextCaseIds, (String)BuildEditorLrb.get("BUILD_NODE_TXN_ID"));
        ResourceUtils.resLabel((JLabel)this.jLblItemID, (Component)this.jItemIDCombo, (String)BuildEditorLrb.get("BUILD_NODE_ITEM_ID"));
        ResourceUtils.resLabel((JLabel)this.jLblItemValue, (Component)this.jItemValueCombo, (String)BuildEditorLrb.get("BUILD_NODE_ITEM_VALUE"));
        ResourceUtils.resButton((AbstractButton)this.jBtnCaseIds, (String)"");
        this.jBtnCaseIds.setIcon(OracleIcons.getIcon((String)"edit.png"));
        this.jBtnCaseIds.setBorder(null);
        this.jBtnCaseIds.setRolloverEnabled(true);
        this.jBtnCaseIds.setToolTipText(BuildEditorLrb.get("BUILD_NODE_CASEIDS_SELECT"));
        this.statusIconTarget.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this.statusIconTarget.setToolTipText(BuildEditorLrb.get("BUILD_NODE_TARGET_INVALID_TIP"));
        this.statusIconTarget.setText("");
        this.statusIconCase.setIcon(OracleIcons.getIcon((String)"warning.png"));
        if (this.nodeData instanceof ExplicitFeatureExtractionBuildNodeType) {
            this.statusIconCase.setToolTipText(BuildEditorLrb.get("BUILD_NODE_TOPICID_INVALID_TIP"));
        } else {
            this.statusIconCase.setToolTipText(BuildEditorLrb.get("BUILD_NODE_CASEID_INVALID_TIP"));
        }
        this.statusIconCase.setText("");
        this.statusIconCaseIDs.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this.statusIconCaseIDs.setToolTipText(BuildEditorLrb.get("BUILD_NODE_CASEIDS_INVALID_TIP"));
        this.statusIconCaseIDs.setText("");
        this.statusItemId.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this.statusItemId.setText("");
        this.statusItemValue.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this.statusItemValue.setText("");
        this.statusIconFunction.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this.statusIconFunction.setToolTipText(BuildEditorLrb.get("BUILD_NODE_FUNCTION_INVALID_TIP"));
        this.statusIconFunction.setText("");
        this.initHelp();
    }

    private void initHelp() {
        if (this.getData() instanceof AssociationBuildNode) {
            HelpUtils.setHelpID((JComponent)this, (String)"association_node_edit");
        } else if (this.getData() instanceof ClassificationBuildNode) {
            HelpUtils.setHelpID((JComponent)this, (String)"classification_node_edit");
        } else if (this.getData() instanceof ClusteringBuildNode) {
            HelpUtils.setHelpID((JComponent)this, (String)"clustering_node_edit");
        } else if (this.getData() instanceof RegressionBuildNode) {
            HelpUtils.setHelpID((JComponent)this, (String)"regression_node_edit");
        } else if (this.getData() instanceof AnomalyDetectionBuildNode) {
            HelpUtils.setHelpID((JComponent)this, (String)"anomaly_node_edit");
        } else if (this.getData() instanceof FeatureExtractionBuildNode) {
            HelpUtils.setHelpID((JComponent)this, (String)"feature_node_edit");
        } else if (this.getData() instanceof ExplicitFeatureExtractionBuildNode) {
            HelpUtils.setHelpID((JComponent)this, (String)"esa_node_edit");
        } else if (this.getData() instanceof RBuildNode) {
            HelpUtils.setHelpID((JComponent)this, (String)"r_node_edit");
        }
    }

    @Override
    public void initUI() {
        int[] nArray;
        if (this.nodeData instanceof AssociationBuildNodeType) {
            this.initializeARControls();
        } else if (this.nodeData instanceof ExtensibleBuildNodeType) {
            this.initializeExtensibilityControls();
        } else {
            this.initializeBuildControls();
        }
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.jModelsTable));
        this.jModelsToolbar.setComponent((JComponent)jScrollPane);
        this.jModelsToolbar.setLabel(new JLabel(BuildEditorLrb.get("BUILD_MODEL_SETTINGS_LBL")));
        this.installModelActions();
        List<ModelType> list = MetaDataHelper.getModelsCollection((BuildNodeType)((AbstractBuildNode)this.getData()).getData());
        this.modelsTblModel = new ModelsTableModel(list, COLUMNS);
        this.jModelsTable.setModel((TableModel)((Object)this.modelsTblModel));
        this.jModelsTable.setSorted(true);
        this.jModelsTable.setUpdateSelectionOnSort(true);
        this.jModelsTable.getTableHeader().setReorderingAllowed(false);
        WorkflowModel workflowModel = null;
        try {
            workflowModel = WorkflowUtils.getWorkflowModel((WorkflowNode)this.getContext().getNode());
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
        }
        this.jModelsTable.getColumnModel().getColumn(0).setCellEditor(new ModelNameCellEditor(this._context, workflowModel, this.nodeDataCopy));
        this.jModelsTable.getColumnModel().getColumn(3).setCellRenderer(new ModelDataUsageCellRenderer(false, true, true));
        if (this.nodeData instanceof AssociationBuildNodeType) {
            this.jModelsTable.removeColumn(this.jModelsTable.getColumnModel().getColumn(3));
        }
        this.jModelsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                BuildEditModelsPanel.this.handleModelSelectionChanged(listSelectionModel);
            }
        });
        this.jModelsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    BuildEditModelsPanel.this.launchAdvancedDialog();
                }
            }
        });
        if (list.size() > 0 && this.selectedModels != null && (nArray = this.modelsTblModel.getIndexesOf(this.selectedModels)).length != 0) {
            this.jModelsTable.setSelectedRowsInModel(nArray);
        }
        this.jCaseCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                Object object2;
                Object object3;
                JComboBox jComboBox;
                Object object4;
                AttributeType attributeType = MetaDataHelper.getCaseId(BuildEditModelsPanel.this.nodeDataCopy);
                if (attributeType != null) {
                    MetaDataHelper.setModelsAttributeProperties(BuildEditModelsPanel.this.nodeDataCopy, attributeType, true, true);
                    if (BuildEditModelsPanel.this.dataUsagePanel != null) {
                        BuildEditModelsPanel.this.dataUsagePanel.setOldCaseId(attributeType);
                    }
                }
                if ((object4 = (jComboBox = (JComboBox)actionEvent.getSource()).getSelectedItem()) instanceof CaseIdItem) {
                    object3 = (CaseIdItem)object4;
                    object2 = ((CaseIdItem)object3).item;
                    if (object2.getStatus().equals((Object)AttributeStatus.INVALID)) {
                        BuildEditModelsPanel.this.statusIconCase.setVisible(true);
                    } else {
                        BuildEditModelsPanel.this.statusIconCase.setVisible(false);
                    }
                    object = new CaseAttributes();
                    object.getAttribute().add(object2);
                    BuildEditModelsPanel.this.nodeDataCopy.setCaseAttributes((CaseAttributes)object);
                    BuildEditModelsPanel.this.setIsDirty(true);
                    MetaDataHelper.setModelsAttributeProperties(BuildEditModelsPanel.this.nodeDataCopy, (AttributeType)object2, false, true);
                } else {
                    object3 = new CaseAttributes();
                    object3.getAttribute().clear();
                    BuildEditModelsPanel.this.nodeDataCopy.setCaseAttributes((CaseAttributes)object3);
                    BuildEditModelsPanel.this.checkEmptyCaseID();
                    BuildEditModelsPanel.this.setIsDirty(true);
                }
                object3 = BuildEditModelsPanel.this.nodeDataCopy.getCaseAttributes().getAttribute();
                object2 = new HashMap();
                object = object3.iterator();
                while (object.hasNext()) {
                    AttributeType object5 = (AttributeType)object.next();
                    object2.put(object5.getName(), object5);
                }
                for (EditChangeListener editChangeListener : BuildEditModelsPanel.this.getChangeListeners()) {
                    editChangeListener.caseIdsChanged((Map<String, AttributeType>)object2);
                }
            }
        });
        this.jTargetChoice.addActionListener(new TargetListener());
        this.jTargetChoice.setRenderer(new ToolTipComboBoxRenderer());
        this.jItemIDCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                Object object = jComboBox.getSelectedItem();
                if (object instanceof CaseIdItem) {
                    DataMinerTablePanel dataMinerTablePanel;
                    CaseIdItem caseIdItem = (CaseIdItem)object;
                    AttributeType attributeType = caseIdItem.item;
                    String string = attributeType.getName();
                    if (attributeType.getAlias() != null) {
                        string = attributeType.getAlias();
                    }
                    if (DbVersionHelper.isDB122Up((Version)BuildEditModelsPanel.this.dbVersion)) {
                        dataMinerTablePanel = BuildEditModelsPanel.this.modelARAggregatePanelRef.getAggregationTablePanel();
                        TableModel tableModel = dataMinerTablePanel.getTable().getModel();
                        for (int i = 0; i < tableModel.getRowCount(); ++i) {
                            String string2 = tableModel.getValueAt(i, 0).toString();
                            if (!string.equals(string2)) continue;
                            String string3 = MessageFormat.format(AlgSettingsLrb.get("ASSO_FILTER_AGGREGATE_ITEM_IS_ITEM_ID"), string);
                            if (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string3, (String)DialogsLrb.get("WARNING_TITLE"), null) || BuildEditModelsPanel.this.previousSelItemID == null) continue;
                            object = BuildEditModelsPanel.this.previousSelItemID;
                            caseIdItem = (CaseIdItem)object;
                            attributeType = caseIdItem.item;
                        }
                    }
                    dataMinerTablePanel = (AssociationBuildNodeType)BuildEditModelsPanel.this.nodeDataCopy;
                    dataMinerTablePanel.setItemID((AttributeType)MetaDataHelper.copyMetadataObject(attributeType));
                    BuildEditModelsPanel.this.setIsDirty(true);
                    if (attributeType.getStatus().equals((Object)AttributeStatus.INVALID)) {
                        BuildEditModelsPanel.this.statusItemId.setVisible(true);
                    } else {
                        BuildEditModelsPanel.this.statusItemId.setVisible(false);
                    }
                    if (jComboBox.getItemAt(0) instanceof String) {
                        jComboBox.removeItemAt(0);
                    }
                    if (BuildEditModelsPanel.this.modelARFilterPanelRef != null) {
                        BuildEditModelsPanel.this.modelARFilterPanelRef.enableControls(true);
                    }
                    if (BuildEditModelsPanel.this.modelARAggregatePanelRef != null) {
                        BuildEditModelsPanel.this.modelARAggregatePanelRef.enableControls(true);
                    }
                    BuildEditModelsPanel.this.previousSelItemID = object;
                }
            }
        });
        this.jItemValueCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                Object object = jComboBox.getSelectedItem();
                if (object instanceof CaseIdItem) {
                    CaseIdItem caseIdItem = (CaseIdItem)object;
                    AttributeType attributeType = caseIdItem.item;
                    AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)BuildEditModelsPanel.this.nodeDataCopy;
                    associationBuildNodeType.setItemValue((AttributeType)MetaDataHelper.copyMetadataObject(attributeType));
                    BuildEditModelsPanel.this.setIsDirty(true);
                    if (attributeType.getStatus().equals((Object)AttributeStatus.INVALID)) {
                        BuildEditModelsPanel.this.statusItemValue.setVisible(true);
                    } else {
                        BuildEditModelsPanel.this.statusItemValue.setVisible(false);
                    }
                } else {
                    AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)BuildEditModelsPanel.this.nodeDataCopy;
                    associationBuildNodeType.setItemValue(null);
                    BuildEditModelsPanel.this.setIsDirty(true);
                    BuildEditModelsPanel.this.statusItemValue.setVisible(false);
                }
            }
        });
        this.jBtnCaseIds.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                Object object22;
                CaseEditRecord caseEditRecord = new CaseEditRecord(new CaseAttributes());
                List list = BuildEditModelsPanel.this.nodeDataCopy.getCaseAttributes().getAttribute();
                for (Object object22 : list) {
                    object = (AttributeType)MetaDataHelper.copyMetadataObject(object22);
                    caseEditRecord.getCaseAttributes().getAttribute().add(object);
                }
                WorkflowNode workflowNode = (WorkflowNode)BuildEditModelsPanel.this.getContext().getNode();
                object22 = WorkflowUtils.getWorkflowModel(workflowNode);
                object = (AbstractBuildNode)BuildEditModelsPanel.this.getData();
                EditCaseAttributesDialog editCaseAttributesDialog = new EditCaseAttributesDialog(BuildEditModelsPanel.this.getContext(), ((AbstractBuildNode)object).findBuildDataNode((WorkflowModel)((Object)object22)), caseEditRecord);
                DialogHelper dialogHelper = new DialogHelper(editCaseAttributesDialog);
                boolean bl = dialogHelper.showAsDialog(BuildEditModelsPanel.this);
                if (bl) {
                    CaseAttributes caseAttributes = caseEditRecord.getCaseAttributes();
                    if (DbVersionHelper.isDB122Up((Version)BuildEditModelsPanel.this.dbVersion)) {
                        List list2 = caseAttributes.getAttribute();
                        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
                        for (AttributeType attributeType : list2) {
                            String string = attributeType.getName();
                            if (attributeType.getAlias() != null) {
                                string = attributeType.getAlias();
                            }
                            DataMinerTablePanel dataMinerTablePanel = BuildEditModelsPanel.this.modelARAggregatePanelRef.getAggregationTablePanel();
                            TableModel tableModel = dataMinerTablePanel.getTable().getModel();
                            for (int i = 0; i < tableModel.getRowCount(); ++i) {
                                String string2 = tableModel.getValueAt(i, 0).toString();
                                if (!string.equals(string2) || MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)AlgSettingsLrb.get("ASSO_FILTER_AGGREGATE_ITEM_IS_ITEM_ID"), (String)oracle.dmt.dataminer.expressionbuilder.DialogsLrb.get("WARNING_TITLE"), null)) continue;
                                arrayList.add(attributeType);
                            }
                        }
                        for (AttributeType attributeType : arrayList) {
                            caseAttributes.getAttribute().remove(attributeType);
                        }
                    }
                    BuildEditModelsPanel.this.nodeDataCopy.setCaseAttributes(caseAttributes);
                    BuildEditModelsPanel.this.initMultiCaseIdUI();
                    BuildEditModelsPanel.this.setIsDirty(true);
                }
            }
        });
    }

    private void initializeARControls() {
        this.removeExtensibilityControls();
        this.jTargetLabel.setVisible(false);
        this.remove(this.jTargetLabel);
        this.jTargetChoice.setVisible(false);
        this.remove(this.jTargetChoice);
        this.statusIconTarget.setVisible(false);
        this.remove(this.statusIconTarget);
        this.jCaseLabel.setVisible(false);
        this.remove(this.jCaseLabel);
        this.jCaseCombo.setVisible(false);
        this.remove(this.jCaseCombo);
        this.statusIconCase.setVisible(false);
        this.remove(this.statusIconCase);
        this.initMultiCaseIdUI();
        WorkflowModel workflowModel = null;
        try {
            AbstractDataNode abstractDataNode;
            workflowModel = WorkflowUtils.getWorkflowModel((WorkflowNode)this.getContext().getNode());
            AbstractDataNode abstractDataNode2 = abstractDataNode = ((AbstractBuildNode)this.getData()).findBuildDataNode(workflowModel);
            ArrayList<AttributeType> arrayList = new ArrayList();
            if (abstractDataNode2 != null) {
                arrayList = abstractDataNode2.getAttributes().getAttribute();
            }
            this.initItemIDUI((AssociationBuildNodeType)this.nodeData, arrayList);
            this.initItemValueUI((AssociationBuildNodeType)this.nodeData, arrayList);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    private void removeARBuildControls() {
        this.jLblCaseIds.setVisible(false);
        this.remove(this.jLblCaseIds);
        this.jTextCaseIds.setVisible(false);
        this.remove(this.jTextCaseIds);
        this.jBtnCaseIds.setVisible(false);
        this.remove(this.jBtnCaseIds);
        this.statusIconCaseIDs.setVisible(false);
        this.remove(this.statusIconCaseIDs);
        this.jLblItemID.setVisible(false);
        this.remove(this.jLblItemID);
        this.statusItemId.setVisible(false);
        this.remove(this.statusItemId);
        this.jItemIDCombo.setVisible(false);
        this.remove(this.jItemIDCombo);
        this.jLblItemValue.setVisible(false);
        this.remove(this.jLblItemValue);
        this.statusItemValue.setVisible(false);
        this.remove(this.statusItemValue);
        this.jItemValueCombo.setVisible(false);
        this.remove(this.jItemValueCombo);
    }

    private void initializeExtensibilityControls() {
        this.removeARBuildControls();
        this.functionComboModel = new DefaultComboBoxModel<String>(FUNCTION_MODEL);
        this.jFunctionChoice.setModel(this.functionComboModel);
        this.targetComboModel = new DefaultComboBoxModel();
        this.jTargetChoice.setModel(this.targetComboModel);
        ExtensibleBuildNodeType extensibleBuildNodeType = (ExtensibleBuildNodeType)this.nodeData;
        this.functionType = extensibleBuildNodeType.getMiningFunction();
        boolean bl = false;
        if (this.functionType == null) {
            this.functionComboModel.setSelectedItem(BuildEditorLrb.get("BUILD_NODE_FUNCTION_HINT"));
        } else {
            switch (this.functionType) {
                case CLASSIFICATION: {
                    bl = true;
                    this.functionComboModel.setSelectedItem(BuildEditorLrb.get("EXTENSIBLE_CLASSIFICATION_TYPE"));
                    break;
                }
                case REGRESSION: {
                    bl = true;
                    this.functionComboModel.setSelectedItem(BuildEditorLrb.get("EXTENSIBLE_REGRESSION_TYPE"));
                    break;
                }
                case CLUSTERING: {
                    this.functionComboModel.setSelectedItem(BuildEditorLrb.get("EXTENSIBLE_CLUSTERING_TYPE"));
                    break;
                }
                case FEATURE_EXTRACTION: {
                    this.functionComboModel.setSelectedItem(BuildEditorLrb.get("EXTENSIBLE_FEATURE_EXTRACTION_TYPE"));
                    break;
                }
                default: {
                    assert (false) : "Invalid Option";
                    break;
                }
            }
            if (BuildEditorLrb.get("BUILD_NODE_FUNCTION_HINT").equals(this.functionComboModel.getElementAt(0))) {
                this.functionComboModel.removeElementAt(0);
            }
            this.statusIconFunction.setVisible(false);
        }
        RBuildNodeType rBuildNodeType = (RBuildNodeType)this.nodeData;
        if (!rBuildNodeType.getModels().getRModel().isEmpty()) {
            this.statusIconFunction.setIcon(OracleIcons.getIcon((String)"info.png"));
            this.statusIconFunction.setToolTipText(BuildEditorLrb.get("R_MINING_FUNCTION_CHANGE"));
            this.statusIconFunction.setVisible(true);
            this.jFunctionChoice.setEnabled(false);
        }
        this.initTargetAttrUI(extensibleBuildNodeType.getTargetAttribute());
        this.jTargetChoice.setEnabled(true);
        if (!bl) {
            this.jTargetChoice.setEnabled(false);
            this.jTargetChoice.setSelectedIndex(0);
            this.statusIconTarget.setVisible(true);
            this.statusIconTarget.setIcon(OracleIcons.getIcon((String)"info.png"));
            this.statusIconTarget.setToolTipText(BuildEditorLrb.get("R_BUILD_NO_TARGET_NEEDED"));
        }
        this.initCaseIdUI(this.attributes);
        this.jFunctionChoice.addActionListener(actionEvent -> this.functionSelectionAction());
    }

    private void removeExtensibilityControls() {
        this.jFunctionLabel.setVisible(false);
        this.remove(this.jFunctionLabel);
        this.jFunctionChoice.setVisible(false);
        this.jFunctionChoice.setEnabled(false);
        this.remove(this.jFunctionChoice);
        this.statusIconFunction.setVisible(false);
        this.remove(this.statusIconFunction);
    }

    private void initializeBuildControls() {
        this.removeExtensibilityControls();
        this.removeARBuildControls();
        this.targetComboModel = new DefaultComboBoxModel();
        this.jTargetChoice.setModel(this.targetComboModel);
        if (this.nodeData instanceof SuperviseBuildNodeType) {
            this.initTargetAttrUI(((SuperviseBuildNodeType)this.nodeData).getTargetAttribute());
        } else {
            this.jTargetLabel.setVisible(false);
            this.jTargetChoice.setVisible(false);
            this.remove(this.jTargetChoice);
            this.remove(this.jTargetLabel);
            this.statusIconTarget.setVisible(false);
            this.remove(this.statusIconTarget);
        }
        this.initCaseIdUI(this.attributes);
    }

    private void functionSelectionAction() {
        boolean bl = true;
        boolean bl2 = false;
        for (ActionListener actionListener : this.jTargetChoice.getActionListeners()) {
            this.jTargetChoice.removeActionListener(actionListener);
        }
        ExtensibleBuildNodeType extensibleBuildNodeType = (ExtensibleBuildNodeType)this.nodeDataCopy;
        String string = (String)this.jFunctionChoice.getSelectedItem();
        if (BuildEditorLrb.get("BUILD_NODE_FUNCTION_HINT").equals(string)) {
            this.functionType = null;
        } else {
            bl = false;
            if (BuildEditorLrb.get("EXTENSIBLE_CLASSIFICATION_TYPE").equals(string)) {
                bl2 = true;
                this.functionType = MiningFunctionType.CLASSIFICATION;
            } else if (BuildEditorLrb.get("EXTENSIBLE_REGRESSION_TYPE").equals(string)) {
                bl2 = true;
                this.functionType = MiningFunctionType.REGRESSION;
            } else if (BuildEditorLrb.get("EXTENSIBLE_CLUSTERING_TYPE").equals(string)) {
                this.functionType = MiningFunctionType.CLUSTERING;
            } else if (BuildEditorLrb.get("EXTENSIBLE_FEATURE_EXTRACTION_TYPE").equals(string)) {
                this.functionType = MiningFunctionType.FEATURE_EXTRACTION;
            }
            if (BuildEditorLrb.get("BUILD_NODE_FUNCTION_HINT").equals(this.functionComboModel.getElementAt(0))) {
                this.functionComboModel.removeElementAt(0);
            }
        }
        ExtensibleBuildNode.setMiningFunctionType(extensibleBuildNodeType, this.functionType);
        this.statusIconFunction.setVisible(bl);
        this.addBtn.setEnabled(!bl);
        if (bl2) {
            this.initTargetAttrUI(null);
            this.jTargetChoice.setEnabled(true);
            this.jTargetChoice.addActionListener(new TargetListener());
        } else {
            this.targetComboModel.addElement(TargetItem.NONE);
            this.jTargetChoice.setEnabled(false);
            this.statusIconTarget.setVisible(true);
            this.statusIconTarget.setIcon(OracleIcons.getIcon((String)"info.png"));
            this.statusIconTarget.setToolTipText(BuildEditorLrb.get("R_BUILD_NO_TARGET_NEEDED"));
            extensibleBuildNodeType.setTargetAttribute(null);
        }
        this.setIsDirty(true);
    }

    private void launchAdvancedDialog() {
        Object object;
        int[] nArray = this.jModelsTable.getSelectedRows();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < nArray.length; ++i) {
            int n = this.jModelsTable.convertRowIndexToModel(nArray[i]);
            object = this.modelsTblModel.getDataList().get(n);
            arrayList.add(object.getId());
        }
        AdvancedSettingsPanel advancedSettingsPanel = new AdvancedSettingsPanel(this.getContext(), (AbstractBuildNode)this.getData(), this.nodeDataCopy, arrayList);
        if (advancedSettingsPanel.showAsDialog(this)) {
            boolean bl;
            if (!advancedSettingsPanel.isDirty()) {
                return;
            }
            this.setIsDirty(true);
            List<ModelType> list = MetaDataHelper.getModelsCollection(this.nodeDataCopy);
            object = this.modelsTblModel.getDataList();
            boolean bl2 = bl = list.size() != object.size();
            if (!bl) {
                for (int i = 0; i < list.size(); ++i) {
                    ModelType object22 = list.get(i);
                    ModelType modelType = (ModelType)object.get(i);
                    if (object22.getId().equals(modelType.getId())) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                ModelType modelType;
                int n;
                int[] nArray2 = this.jModelsTable.getSelectedRows();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                for (int i = 0; i < nArray2.length; ++i) {
                    n = this.jModelsTable.convertRowIndexToModel(nArray2[i]);
                    modelType = this.modelsTblModel.getDataList().get(n);
                    arrayList2.add(modelType.getId());
                }
                this.modelsTblModel = new ModelsTableModel(list, COLUMNS);
                this.jModelsTable.setModel((TableModel)((Object)this.modelsTblModel));
                this.jModelsTable.setSorted(true);
                this.jModelsTable.setUpdateSelectionOnSort(true);
                if (this.nodeData instanceof AssociationBuildNodeType) {
                    this.jModelsTable.removeColumn(this.jModelsTable.getColumnModel().getColumn(3));
                }
                if (arrayList2.size() > 0) {
                    ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
                    for (n = 0; n < this.modelsTblModel.getDataList().size(); ++n) {
                        modelType = this.modelsTblModel.getDataList().get(n);
                        if (!arrayList2.contains(modelType.getId())) continue;
                        arrayList3.add(n);
                    }
                    if (arrayList3.size() > 0) {
                        int[] nArray3 = new int[arrayList3.size()];
                        for (int i = 0; i < arrayList3.size(); ++i) {
                            nArray3[i] = (Integer)arrayList3.get(i);
                        }
                        this.jModelsTable.setSelectedRowsInModel(nArray3);
                    }
                }
            } else {
                this.jModelsTable.repaint();
            }
            if (this.isDirty()) {
                for (EditChangeListener editChangeListener : this.getChangeListeners()) {
                    editChangeListener.modelsDataUsageChanged();
                }
            }
        }
    }

    private void installModelActions() {
        Object object;
        ControlBar controlBar = new ControlBar();
        this.addBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
        this.addBtn.setToolTipText(BuildEditorLrb.get("MODELS_ADD_TOOLTIP"));
        this.addBtn.addActionListener(actionEvent -> {
            AbstractBuildNode abstractBuildNode = (AbstractBuildNode)this.getData();
            ModelType modelType = abstractBuildNode instanceof RBuildNode ? NewRModelPanel.addNewModel(this, this.nodeDataCopy, this.getContext(), abstractBuildNode) : NewModelPanel.addNewModel(this, this.nodeDataCopy, this.getContext(), abstractBuildNode);
            if (modelType != null) {
                MetaDataHelper.addModel(this.nodeDataCopy, modelType);
                int[] nArray = new int[]{this.modelsTblModel.addModel(modelType)};
                this.jModelsTable.setSelectedRowsInModel(nArray);
                if (this.jFunctionChoice.isEnabled()) {
                    this.statusIconFunction.setIcon(OracleIcons.getIcon((String)"info.png"));
                    this.statusIconFunction.setToolTipText(BuildEditorLrb.get("R_MINING_FUNCTION_CHANGE"));
                    this.statusIconFunction.setVisible(true);
                    this.jFunctionChoice.setEnabled(false);
                }
                this.setIsDirty(true);
            }
        });
        controlBar.add((Component)this.addBtn);
        if (this.nodeData instanceof ExtensibleBuildNodeType && ((ExtensibleBuildNode)(object = (ExtensibleBuildNode)this.getData())).getMiningFunctionType() == null) {
            this.addBtn.setEnabled(false);
        }
        this.editBtn = new JButton(OracleIcons.getIcon((String)"edit.png"));
        this.editBtn.setToolTipText(BuildEditorLrb.get("MODELS_EDIT_TOOLTIP"));
        this.editBtn.addActionListener(actionEvent -> this.launchAdvancedDialog());
        controlBar.add((Component)this.editBtn);
        this.removeBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this.removeBtn.setToolTipText(BuildEditorLrb.get("MODELS_DELETE_TOOLTIP"));
        this.removeBtn.addActionListener(actionEvent -> {
            Object object;
            int n;
            String string = BuildEditDialog.getModelsDeleteMessage((JTable)((Object)this.jModelsTable));
            if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string, (String)BuildEditorLrb.get("REMOVE_MODELS_TITLE"), null, (boolean)true)) {
                return;
            }
            int[] nArray = this.jModelsTable.getSelectedRows();
            int[] nArray2 = new int[nArray.length];
            List<ModelType> list = this.modelsTblModel.getDataList();
            for (n = 0; n < nArray.length; ++n) {
                nArray2[n] = this.jModelsTable.convertRowIndexToModel(nArray[n]);
                object = list.get(nArray2[n]);
                MetaDataHelper.removeModel(this.nodeDataCopy, object);
            }
            this.modelsTblModel.removeRows(nArray2);
            if (this.modelsTblModel.getDataList().size() != 0) {
                n = nArray[0] - 1 < 0 ? 0 : nArray[0] - 1;
                n = this.jModelsTable.convertRowIndexToModel(n);
                object = new int[]{n};
                this.jModelsTable.setSelectedRowsInModel((int[])object);
            }
            if (this.modelsTblModel.getDataList().isEmpty()) {
                this.statusIconFunction.setVisible(false);
                this.jFunctionChoice.setEnabled(true);
            }
            this.setIsDirty(true);
        });
        controlBar.add((Component)this.removeBtn);
        this.duplicateBtn = new JButton(OracleIcons.getIcon((String)"duplicate.png"));
        this.duplicateBtn.setToolTipText(BuildEditorLrb.get("MODELS_DUPLICATE_TOOLTIP"));
        this.duplicateBtn.addActionListener(actionEvent -> {
            Object object;
            Object object2;
            ModelType modelType;
            WorkflowModel workflowModel = WorkflowUtils.getWorkflowModel((WorkflowNode)this._context.getNode());
            int[] nArray = this.jModelsTable.getSelectedRows();
            ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
            for (int i = 0; i < nArray.length; ++i) {
                modelType = this.modelsTblModel.getDataList().get(this.jModelsTable.convertRowIndexToModel(nArray[i]));
                object2 = MetaDataHelper.findModelById(this.nodeDataCopy, modelType.getId());
                object = (ModelType)MetaDataHelper.copyMetadataObject(object2);
                object.setUseForOutput(true);
                arrayList.add((ModelType)object);
            }
            List<RefModelType> list = MetaDataHelper.getModelsCollection(this.nodeDataCopy, arrayList, this._context);
            modelType = MetaDataHelper.getModelsCollection(this.nodeDataCopy);
            object2 = WorkflowUtils.refactorModels(this._context, list, (List<ModelType>)modelType, workflowModel, false);
            AbstractBuildNode.applyRefactoredModels((Map<String, RefModelType>)object2, arrayList);
            for (ModelType modelType2 : arrayList) {
                MetaDataHelper.addModel(this.nodeDataCopy, modelType2);
            }
            object = new int[arrayList.size()];
            int n = 0;
            for (ModelType modelType3 : arrayList) {
                object[n++] = (ModelType)this.modelsTblModel.addModel(modelType3);
            }
            this.jModelsTable.setSelectedRowsInModel((int[])object);
            this.setIsDirty(true);
        });
        controlBar.add((Component)this.duplicateBtn);
        object = this.jModelsTable.getSelectionModel();
        this.editBtn.setEnabled(!object.isSelectionEmpty());
        this.removeBtn.setEnabled(!object.isSelectionEmpty());
        this.duplicateBtn.setEnabled(!object.isSelectionEmpty());
        this.jModelsToolbar.setControlBar(controlBar);
    }

    private void initCaseIdUI(List<MiningAttributeType> list) {
        List list2 = this.nodeDataCopy.getCaseAttributes().getAttribute();
        AttributeType attributeType = null;
        if (list2.size() != 0) {
            attributeType = (AttributeType)list2.get(0);
        }
        boolean bl = false;
        this.jCaseCombo.removeAllItems();
        this.jCaseCombo.addItem(BuildEditorLrb.get("BUILD_NODE_CASEID_HINT"));
        for (Object object : list) {
            if (!DatabaseMetadataUtils.isCaseIdDataTypeSupported(this.getContext(), DatabaseMetadataUtils.getJSONDataType(object.getDataType(), object.getDataTypeQualifier()))) continue;
            this.jCaseCombo.addItem(new CaseIdItem((AttributeType)object));
            if (attributeType == null || !object.getName().equals(attributeType.getName()) || !object.getDataType().equals(attributeType.getDataType())) continue;
            bl = true;
        }
        this.jCaseCombo.setRenderer(new ToolTipComboBoxRenderer());
        if (attributeType != null && !bl) {
            this.jCaseCombo.setEditable(true);
            this.jCaseCombo.setSelectedItem(new CaseIdItem(attributeType));
            this.jCaseCombo.setEditable(false);
        }
        if (list2.size() == 0) {
            this.jCaseCombo.setSelectedIndex(0);
        }
        if (attributeType != null && bl) {
            for (int i = 0; i < this.jCaseCombo.getItemCount(); ++i) {
                Object object;
                if (!(this.jCaseCombo.getItemAt(i) instanceof CaseIdItem)) continue;
                object = (CaseIdItem)this.jCaseCombo.getItemAt(i);
                if (!attributeType.getName().equals(object.item.getName()) || !attributeType.getDataType().equals(object.item.getDataType())) continue;
                this.jCaseCombo.setSelectedIndex(i);
            }
        }
        if (attributeType != null && attributeType.getStatus().equals((Object)AttributeStatus.VALID)) {
            this.statusIconCase.setVisible(false);
        } else if (attributeType != null && attributeType.getStatus().equals((Object)AttributeStatus.INVALID)) {
            this.statusIconCase.setText("");
            this.statusIconCase.setVisible(true);
        } else if (attributeType == null) {
            this.checkEmptyCaseID();
        }
    }

    public void checkEmptyCaseID() {
        if (this.nodeData instanceof RegressionBuildNodeType || this.nodeData instanceof ClassificationBuildNodeType || this.nodeData instanceof ExplicitFeatureExtractionBuildNodeType || this.nodeData instanceof ExtensibleBuildNodeType) {
            this.statusIconCase.setVisible(true);
            if (this.nodeData instanceof ExplicitFeatureExtractionBuildNodeType) {
                this.statusIconCase.setToolTipText(BuildEditorLrb.get("BUILD_NODE_TOPICID_REQUIRED_TIP"));
            } else {
                this.statusIconCase.setText(BuildEditorLrb.get("BUILD_NODE_CASE_ID_WARN"));
            }
        } else {
            this.statusIconCase.setVisible(false);
        }
    }

    private void initMultiCaseIdUI() {
        List list = null;
        boolean bl = false;
        list = this.nodeDataCopy.getCaseAttributes().getAttribute();
        if (list.size() != 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (AttributeType attributeType : list) {
                stringBuilder.append(attributeType.getName());
                stringBuilder.append(", ");
                if (!attributeType.getStatus().equals((Object)AttributeStatus.INVALID)) continue;
                bl = true;
            }
            stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
            this.jTextCaseIds.setText(stringBuilder.toString());
        } else {
            this.jTextCaseIds.setText(BuildEditorLrb.get("BUILD_NODE_MULTICASEID_HINT"));
            bl = true;
        }
        this.statusIconCaseIDs.setVisible(bl);
    }

    private void initTargetAttrUI(AttributeType attributeType) {
        this.targetComboModel.removeAllElements();
        this.targetComboModel.addElement(TargetItem.NONE);
        if (this.isClassificationEdition()) {
            this.availableTargets = this.attributes.stream().filter(miningAttributeType -> DatabaseMetadataUtils.isTargetCategoricalDataTypeSupported(this._context, DatabaseMetadataUtils.getJSONDataType(miningAttributeType.getDataType(), miningAttributeType.getDataTypeQualifier()))).map(miningAttributeType -> new TargetItem(miningAttributeType)).collect(Collectors.toList());
        } else if (this.isRegressionEdition()) {
            this.availableTargets = this.attributes.stream().filter(miningAttributeType -> DatabaseMetadataUtils.isTargetNumericalDataTypeSupported(this._context, DatabaseMetadataUtils.getJSONDataType(miningAttributeType.getDataType(), miningAttributeType.getDataTypeQualifier()))).map(miningAttributeType -> new TargetItem(miningAttributeType)).collect(Collectors.toList());
        }
        if (this.availableTargets != null) {
            this.availableTargets.forEach(targetItem -> this.targetComboModel.addElement(new TargetItem(targetItem.getItem())));
        }
        this.statusIconTarget.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this.statusIconTarget.setToolTipText(BuildEditorLrb.get("BUILD_NODE_TARGET_INVALID_TIP"));
        if (attributeType == null) {
            this.jTargetChoice.setSelectedIndex(0);
            this.statusIconTarget.setVisible(true);
        } else {
            if (TargetItem.NONE.equals((Object)this.targetComboModel.getElementAt(0))) {
                this.targetComboModel.removeElementAt(0);
            }
            if (AttributeStatus.VALID.equals((Object)attributeType.getStatus())) {
                Optional<TargetItem> optional = this.availableTargets.stream().filter(targetItem -> attributeType.getName().equals(targetItem.getItem().getName()) && attributeType.getDataType().equals(targetItem.getItem().getDataType())).findFirst();
                if (optional.isPresent()) {
                    this.targetComboModel.setSelectedItem(optional.get());
                    this.statusIconTarget.setVisible(false);
                } else {
                    LOGGER.log(Level.SEVERE, "Could not find the target value even though it is valid");
                }
            } else if (AttributeStatus.INVALID.equals((Object)attributeType.getStatus())) {
                MiningAttributeType miningAttributeType2 = MetaDataHelper.createMiningAttributeFrom(attributeType);
                TargetItem targetItem2 = new TargetItem(miningAttributeType2);
                this.targetComboModel.setSelectedItem(targetItem2);
                this.jTargetChoice.setEditable(false);
                this.statusIconTarget.setVisible(true);
            }
        }
    }

    private boolean isClassificationEdition() {
        AbstractBuildNode abstractBuildNode = (AbstractBuildNode)this.getData();
        if (abstractBuildNode instanceof ClassificationBuildNode) {
            return true;
        }
        if (abstractBuildNode instanceof ExtensibleBuildNode) {
            return MiningFunctionType.CLASSIFICATION.equals((Object)((ExtensibleBuildNodeType)this.nodeDataCopy).getMiningFunction());
        }
        return false;
    }

    private boolean isRegressionEdition() {
        AbstractBuildNode abstractBuildNode = (AbstractBuildNode)this.getData();
        if (abstractBuildNode instanceof RegressionBuildNode) {
            return true;
        }
        if (abstractBuildNode instanceof ExtensibleBuildNode) {
            return MiningFunctionType.REGRESSION.equals((Object)((ExtensibleBuildNodeType)this.nodeDataCopy).getMiningFunction());
        }
        return false;
    }

    private void initItemIDUI(AssociationBuildNodeType associationBuildNodeType, List<AttributeType> list) {
        AttributeType attributeType = associationBuildNodeType.getItemID();
        this.jItemIDCombo.removeAllItems();
        this.jItemIDCombo.addItem(BuildEditorLrb.get("BUILD_NODE_ITEMID_HINT"));
        try {
            if (list != null && list.size() > 0) {
                Collections.sort(list, AttributeTypeComparator.getComparator());
            }
            for (AttributeType attributeType2 : list) {
                if (!DatabaseMetadataUtils.isTargetCategoricalDataTypeSupported(this._context, DatabaseMetadataUtils.getJSONDataType(attributeType2.getDataType(), attributeType2.getDataTypeQualifier()))) continue;
                this.jItemIDCombo.addItem(new CaseIdItem(attributeType2));
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
        }
        if (attributeType == null) {
            this.jItemIDCombo.setSelectedIndex(0);
            this.statusItemId.setVisible(true);
        } else {
            CaseIdItem caseIdItem;
            boolean bl = false;
            for (int i = 0; i < this.jItemIDCombo.getItemCount(); ++i) {
                if (!(this.jItemIDCombo.getItemAt(i) instanceof CaseIdItem)) continue;
                caseIdItem = (CaseIdItem)this.jItemIDCombo.getItemAt(i);
                if (!attributeType.getName().equals(caseIdItem.item.getName()) || !attributeType.getDataType().equals(caseIdItem.item.getDataType())) continue;
                this.jItemIDCombo.setSelectedIndex(i);
                bl = true;
            }
            if (attributeType.getStatus().equals((Object)AttributeStatus.VALID)) {
                if (!bl) {
                    LOGGER.log(Level.SEVERE, "Could not find the item id even though it is valid");
                } else {
                    this.statusItemId.setVisible(false);
                }
            } else {
                this.statusItemId.setVisible(true);
                if (!bl) {
                    MiningAttributeType miningAttributeType = MetaDataHelper.createMiningAttributeFrom(attributeType);
                    caseIdItem = new CaseIdItem((AttributeType)miningAttributeType);
                    this.jItemIDCombo.setEditable(true);
                    this.jItemIDCombo.setSelectedItem(caseIdItem);
                    this.jItemIDCombo.setEditable(false);
                }
            }
        }
        this.jItemIDCombo.setRenderer(new ToolTipComboBoxRenderer());
        this.previousSelItemID = this.jItemIDCombo.getSelectedObjects();
    }

    private void initItemValueUI(AssociationBuildNodeType associationBuildNodeType, List<AttributeType> list) {
        AttributeType attributeType = associationBuildNodeType.getItemValue();
        this.jItemValueCombo.removeAllItems();
        this.jItemValueCombo.addItem(BuildEditorLrb.get("BUILD_NODE_ITEMVALUE_EXISTENCE"));
        if (list != null && list.size() > 0) {
            Collections.sort(list, AttributeTypeComparator.getComparator());
        }
        for (AttributeType attributeType2 : list) {
            try {
                if (!DatabaseMetadataUtils.isTargetCategoricalDataTypeSupported(this._context, DatabaseMetadataUtils.getJSONDataType(attributeType2.getDataType(), attributeType2.getDataTypeQualifier()))) continue;
                this.jItemValueCombo.addItem(new CaseIdItem(attributeType2));
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)"Unexpected Exception");
                return;
            }
        }
        if (attributeType == null) {
            this.jItemValueCombo.setSelectedIndex(0);
            this.statusItemValue.setVisible(false);
        } else {
            CaseIdItem caseIdItem;
            boolean bl = false;
            for (int i = 0; i < this.jItemValueCombo.getItemCount(); ++i) {
                if (!(this.jItemValueCombo.getItemAt(i) instanceof CaseIdItem)) continue;
                caseIdItem = (CaseIdItem)this.jItemValueCombo.getItemAt(i);
                if (!attributeType.getName().equals(caseIdItem.item.getName()) || !attributeType.getDataType().equals(caseIdItem.item.getDataType())) continue;
                this.jItemValueCombo.setSelectedIndex(i);
                bl = true;
            }
            if (attributeType.getStatus().equals((Object)AttributeStatus.VALID)) {
                if (!bl) {
                    LOGGER.log(Level.SEVERE, "Could not find the item value even though it is valid");
                } else {
                    this.statusItemValue.setVisible(false);
                }
            } else {
                this.statusItemValue.setVisible(true);
                if (!bl) {
                    MiningAttributeType miningAttributeType = MetaDataHelper.createMiningAttributeFrom(attributeType);
                    caseIdItem = new CaseIdItem((AttributeType)miningAttributeType);
                    this.jItemValueCombo.setEditable(true);
                    this.jItemValueCombo.setSelectedItem(caseIdItem);
                    this.jItemValueCombo.setEditable(false);
                }
            }
        }
        this.jItemValueCombo.setRenderer(new ToolTipComboBoxRenderer());
    }

    public boolean doWork() {
        TableCellEditor tableCellEditor;
        return !this.jModelsTable.isEditing() || (tableCellEditor = this.jModelsTable.getCellEditor()).stopCellEditing();
    }

    private void handleModelSelectionChanged(ListSelectionModel listSelectionModel) {
        this.editBtn.setEnabled(!listSelectionModel.isSelectionEmpty());
        this.removeBtn.setEnabled(!listSelectionModel.isSelectionEmpty());
        this.duplicateBtn.setEnabled(!listSelectionModel.isSelectionEmpty());
    }

    public void setIsDirty(boolean bl) {
        this.dirty = bl;
    }

    public void setDataUsagePanel(DataUsagePanel dataUsagePanel) {
        this.dataUsagePanel = dataUsagePanel;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private class TargetListener
    implements ActionListener {
        private TargetListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ExtensibleBuildNodeType extensibleBuildNodeType = null;
            SuperviseBuildNodeType superviseBuildNodeType = null;
            if (BuildEditModelsPanel.this.nodeDataCopy instanceof SuperviseBuildNodeType) {
                superviseBuildNodeType = (SuperviseBuildNodeType)BuildEditModelsPanel.this.nodeDataCopy;
            } else {
                extensibleBuildNodeType = (ExtensibleBuildNodeType)BuildEditModelsPanel.this.nodeDataCopy;
            }
            AttributeType attributeType = superviseBuildNodeType != null ? superviseBuildNodeType.getTargetAttribute() : extensibleBuildNodeType.getTargetAttribute();
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            Object object = jComboBox.getSelectedItem();
            if (object instanceof TargetItem) {
                TargetItem targetItem = (TargetItem)object;
                AttributeType attributeType2 = targetItem.getItem();
                AttributeType attributeType3 = (AttributeType)MetaDataHelper.copyMetadataObject(attributeType2);
                if (attributeType != null) {
                    MetaDataHelper.setModelsAttributeProperties((BuildNodeType)(superviseBuildNodeType != null ? superviseBuildNodeType : extensibleBuildNodeType), attributeType, true, true);
                }
                MetaDataHelper.setModelsTargetPropertiesWithDefaults((BuildNodeType)(superviseBuildNodeType != null ? superviseBuildNodeType : extensibleBuildNodeType), attributeType3);
                if (superviseBuildNodeType != null) {
                    superviseBuildNodeType.setTargetAttribute(attributeType3);
                } else {
                    extensibleBuildNodeType.setTargetAttribute(attributeType3);
                }
                BuildEditModelsPanel.this.setIsDirty(true);
                BuildEditModelsPanel.this.statusIconTarget.setVisible(AttributeStatus.INVALID.equals((Object)attributeType2.getStatus()));
                if (TargetItem.NONE.equals((Object)BuildEditModelsPanel.this.targetComboModel.getElementAt(0))) {
                    BuildEditModelsPanel.this.targetComboModel.removeElementAt(0);
                }
                HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
                hashMap.put(attributeType2.getName(), attributeType2);
                for (EditChangeListener editChangeListener : BuildEditModelsPanel.this.getChangeListeners()) {
                    editChangeListener.targetsChanged(hashMap);
                }
            }
        }
    }

    private static class CaseIdItem {
        AttributeType item = new AttributeType();

        CaseIdItem(AttributeType attributeType) {
            this.item.setAlias(attributeType.getAlias());
            this.item.setDataType(attributeType.getDataType());
            this.item.setName(attributeType.getName());
            this.item.setStatus(AttributeStatus.fromValue((String)attributeType.getStatus().value()));
        }

        public String toString() {
            return this.item.getName();
        }
    }

    private class ModelsTableModel
    extends SimpleBaseTableModel
    implements BuildNodeTableModel {
        private List<ModelType> data;
        public static final int NAME = 0;
        public static final int ALGORITHM = 1;
        public static final int MODEL_CREATED_ON = 2;
        public static final int AUTO = 3;

        public ModelsTableModel(List<ModelType> list, String[] stringArray) {
            this.data = list;
            this.setColumnIdentifiers(stringArray);
            this.setRowCount(this.data.size());
        }

        public int[] getIndexesOf(List<String> list) {
            Vector<Integer> vector = new Vector<Integer>();
            for (String string : list) {
                for (int i = 0; i < this.data.size(); ++i) {
                    ModelType modelType = this.data.get(i);
                    if (!modelType.getName().equals(string)) continue;
                    vector.add(i);
                }
            }
            if (vector.size() == 0) {
                return new int[0];
            }
            Object object = new int[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                object[i] = (Integer)vector.get(i);
            }
            return object;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 3) {
                return String.class;
            }
            if (n == 2) {
                return XMLGregorianCalendar.class;
            }
            return String.class;
        }

        public int addModel(ModelType modelType) {
            this.data.add(modelType);
            int n = this.data.size() - 1;
            this.setRowCount(this.data.size());
            this.fireTableRowsInserted(n, n);
            return this.data.size() - 1;
        }

        public void removeRows(int[] nArray) {
            ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
            for (int i = 0; i < nArray.length; ++i) {
                arrayList.add(this.data.get(nArray[i]));
            }
            for (ModelType modelType : arrayList) {
                int n = this.data.indexOf(modelType);
                this.fireTableRowsDeleted(n, n);
                this.removeModel(n);
            }
        }

        public void removeModel(int n) {
            this.data.remove(n);
            this.setRowCount(this.data.size());
        }

        @Override
        public String getOriginalModelName(int n) {
            String string = null;
            ModelType modelType = this.data.get(n);
            ModelType modelType2 = MetaDataHelper.findModelById(BuildEditModelsPanel.this.nodeData, modelType.getId());
            if (modelType2 != null) {
                string = modelType2.getName();
            }
            return string;
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            ModelType modelType = this.data.get(n);
            String string = null;
            ModelType modelType2 = MetaDataHelper.findModelById(BuildEditModelsPanel.this.nodeDataCopy, modelType.getId());
            if (modelType2 == null) {
                modelType2 = modelType;
            }
            switch (n2) {
                case 0: {
                    string = modelType2.getName();
                    break;
                }
                case 1: {
                    string = MetaDataHelper.getAlgorithmName(modelType2);
                    break;
                }
                case 2: {
                    XMLGregorianCalendar xMLGregorianCalendar = modelType2.getCreationDate();
                    if (xMLGregorianCalendar != null) {
                        string = TimeUtils.formatDate(xMLGregorianCalendar);
                        break;
                    }
                    string = null;
                    break;
                }
                case 3: {
                    string = modelType2.getInputMiningData().getDataUsage().equals((Object)InputMiningDataType.AUTO) ? "Auto" : "Custom";
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return string;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public void setValueAt(Object object, int n, int n2) {
            ModelType modelType = this.data.get(n);
            ModelType modelType2 = MetaDataHelper.findModelById(BuildEditModelsPanel.this.nodeDataCopy, modelType.getId());
            if (modelType2 == null) {
                throw new RuntimeException("Model not found in edit cache");
            }
            if (n2 == 3) {
                InputMiningData inputMiningData = modelType2.getInputMiningData();
                Boolean bl = (Boolean)object;
                if (bl.equals(Boolean.TRUE)) {
                    inputMiningData.setDataUsage(InputMiningDataType.AUTO);
                    inputMiningData.setMiningUsage(InputMiningDataType.AUTO);
                } else {
                    inputMiningData.setDataUsage(InputMiningDataType.MANUAL);
                    inputMiningData.setMiningUsage(InputMiningDataType.MANUAL);
                }
            } else if (n2 == 0) {
                modelType2.setName((String)object);
            }
            BuildEditModelsPanel.this.setIsDirty(true);
        }

        @Override
        public List<ModelType> getDataList() {
            return this.data;
        }
    }
}

