/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.controls.dialog.DialogDisplayable;
import oracle.dmt.dataminer.controls.dialog.DialogExecutionException;
import oracle.dmt.dataminer.controls.dialog.DialogHelper;
import oracle.dmt.dataminer.controls.dialog.Dialogable;
import oracle.dmt.dataminer.controls.dialog.DialogableExecutableAdapter;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.ModelNameValidationDocument;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AnomalyDetectionBuildNode;
import oracle.dmt.dataminer.workflow.model.AssociationBuildNode;
import oracle.dmt.dataminer.workflow.model.ClassificationBuildNode;
import oracle.dmt.dataminer.workflow.model.ClusteringBuildNode;
import oracle.dmt.dataminer.workflow.model.ExplicitFeatureExtractionBuildNode;
import oracle.dmt.dataminer.workflow.model.FeatureExtractionBuildNode;
import oracle.dmt.dataminer.workflow.model.RegressionBuildNode;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.AnomalyDetectionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AssociationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClusteringBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ExplicitFeatureExtractionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.FeatureExtractionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.SuperviseBuildNodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.Version;

public class NewModelPanel
extends JPanel
implements DialogDisplayable {
    private static final int MAX_COMMENT_LENGTH = 10000;
    public static final int NAME_MAX_LEN_EX = 123;
    public static final int NAME_MAX_LEN = 25;
    private static final Logger theLogger = Logger.getLogger(NewModelPanel.class.getName());
    private Collection<String> wfInMemoryModelNames;
    private AbstractBuildNode buildNode;
    private String miningFunction;
    private boolean nameTouched;
    private ModelType newModel;
    private String modelName;
    private String algorithm;
    private Context context;
    private String comment;
    private String[] algorithms;
    private Object[] items;
    private JComboBox<Object> jAlgorithm;
    private JLabel jAlgorithmLabel;
    private JLabel jCommentLabel;
    private JTextArea jCommentText;
    private JTextField jModelName;
    private JLabel jModelNameLabel;
    private JScrollPane textScrolPane;

    public NewModelPanel(Context context, AbstractBuildNode abstractBuildNode, Collection<String> collection) {
        this.buildNode = abstractBuildNode;
        this.context = context;
        this.algorithms = null;
        this.items = null;
        this.wfInMemoryModelNames = collection;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jModelNameLabel = new JLabel();
        this.jModelName = new JTextField();
        this.jAlgorithmLabel = new JLabel();
        this.jAlgorithm = new JComboBox();
        this.jCommentLabel = new JLabel();
        this.textScrolPane = new JScrollPane();
        this.jCommentText = new JTextArea();
        this.jModelNameLabel.setText("Name:");
        this.jAlgorithmLabel.setText("Algorithm:");
        this.jCommentLabel.setText("Comment:");
        this.jCommentText.setColumns(20);
        this.jCommentText.setRows(5);
        this.textScrolPane.setViewportView(this.jCommentText);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jAlgorithmLabel).addComponent(this.jModelNameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jAlgorithm, 0, 351, Short.MAX_VALUE).addComponent(this.jModelName, -1, 351, Short.MAX_VALUE))).addGroup(groupLayout.createSequentialGroup().addComponent(this.jCommentLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textScrolPane, -1, 351, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jAlgorithmLabel).addComponent(this.jAlgorithm, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jModelNameLabel).addComponent(this.jModelName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jCommentLabel).addContainerGap(70, Short.MAX_VALUE)).addComponent(this.textScrolPane, -1, 84, Short.MAX_VALUE))));
    }

    private void initRes() {
        ResourceUtils.resLabel((JLabel)this.jAlgorithmLabel, this.jAlgorithm, (String)BuildEditorLrb.get("MODEL_ALGO"));
        ResourceUtils.resLabel((JLabel)this.jModelNameLabel, (Component)this.jModelName, (String)BuildEditorLrb.get("MODEL_NAME"));
        ResourceUtils.resLabel((JLabel)this.jCommentLabel, (Component)this.jCommentText, (String)BuildEditorLrb.get("MODEL_COMMENT"));
    }

    private void initUI() {
        BuildNodeType buildNodeType = (BuildNodeType)this.buildNode.getData();
        this.initAvailableAlgorithms((NodeType)buildNodeType);
        this.jModelName.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                NewModelPanel.this.nameTouched = true;
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        int n = this.jAlgorithm.getSelectedIndex();
        if (n < 0) {
            n = 0;
        }
        String string = this.algorithms[n];
        try {
            this.modelName = WorkflowUtils.getNewModelNameWfid(this.context, this.wfInMemoryModelNames, this.miningFunction, string);
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            this.modelName = "";
        }
        boolean bl = SQLHelper.isExpandedObjNameEnabled(this.context);
        this.jModelName.setDocument(new ModelNameValidationDocument(bl ? 123 : 25, true));
        this.jModelName.setText(this.modelName);
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(this.items);
        this.jAlgorithm.setModel(defaultComboBoxModel);
        this.jAlgorithm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (NewModelPanel.this.nameTouched) {
                    return;
                }
                String string = NewModelPanel.this.algorithms[NewModelPanel.this.jAlgorithm.getSelectedIndex()];
                String string2 = "";
                try {
                    string2 = WorkflowUtils.getNewModelNameWfid(NewModelPanel.this.context, NewModelPanel.this.wfInMemoryModelNames, NewModelPanel.this.miningFunction, string);
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
                NewModelPanel.this.jModelName.setText(string2);
            }
        });
    }

    private void initAvailableAlgorithms(NodeType nodeType) {
        Version version = ConnectionFolder.getConnectionFolder(this.context).getDbVersion();
        Boolean bl = DbVersionHelper.isDB121Up((Version)version);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (nodeType instanceof ClassificationBuildNodeType) {
            arrayList.add(BuildEditorLrb.get("ALGO_DT"));
            arrayList.add(BuildEditorLrb.get("ALGO_GLM"));
            arrayList.add(BuildEditorLrb.get("ALGO_NB"));
            arrayList.add(BuildEditorLrb.get("ALGO_SVM"));
            arrayList2.add("ALGO_DECISION_TREE");
            arrayList2.add("ALGO_GENERALIZED_LINEAR_MODEL");
            arrayList2.add("ALGO_NAIVE_BAYES");
            arrayList2.add("ALGO_SUPPORT_VECTOR_MACHINES");
            this.miningFunction = "CLASSIFICATION";
        } else if (nodeType instanceof RegressionBuildNodeType) {
            arrayList.add(BuildEditorLrb.get("ALGO_GLM"));
            arrayList.add(BuildEditorLrb.get("ALGO_SVM"));
            arrayList2.add("ALGO_GENERALIZED_LINEAR_MODEL");
            arrayList2.add("ALGO_SUPPORT_VECTOR_MACHINES");
            this.miningFunction = "REGRESSION";
        } else if (nodeType instanceof ClusteringBuildNodeType) {
            arrayList.add(BuildEditorLrb.get("ALGO_KMCL"));
            arrayList.add(BuildEditorLrb.get("ALGO_OCL"));
            arrayList2.add("ALGO_KMEANS");
            arrayList2.add("ALGO_O_CLUSTER");
            if (bl.booleanValue()) {
                arrayList.add(BuildEditorLrb.get("ALGO_EM"));
                arrayList2.add("ALGO_EXPECTATION_MAXIMIZATION");
            }
            this.miningFunction = "CLUSTERING";
        } else if (nodeType instanceof AssociationBuildNodeType) {
            arrayList.add(BuildEditorLrb.get("ALGO_AR"));
            arrayList2.add("ALGO_APRIORI_ASSOCIATION_RULES");
            this.miningFunction = "ASSOCIATION";
        } else if (nodeType instanceof AnomalyDetectionBuildNodeType) {
            arrayList.add(BuildEditorLrb.get("ALGO_SVM"));
            arrayList2.add("ALGO_SUPPORT_VECTOR_MACHINES");
            this.miningFunction = "ANOMALY_DETECTION";
        } else if (nodeType instanceof FeatureExtractionBuildNodeType) {
            arrayList.add(BuildEditorLrb.get("ALGO_NMF"));
            arrayList2.add("ALGO_NONNEGATIVE_MATRIX_FACTOR");
            if (bl.booleanValue()) {
                arrayList.add(BuildEditorLrb.get("ALGO_SVD"));
                arrayList.add(BuildEditorLrb.get("ALGO_PCA"));
                arrayList2.add("ALGO_SINGULAR_VALUE_DECOMP");
                arrayList2.add("ALGO_PRINCIPAL_COMPONENT_ANALYSIS");
            }
            this.miningFunction = "FEATURE_EXTRACTION";
        } else if (nodeType instanceof ExplicitFeatureExtractionBuildNodeType) {
            arrayList.add(BuildEditorLrb.get("ALGO_ESA"));
            arrayList2.add("ALGO_EXPLICIT_SEMANTIC_ANALYS");
            this.miningFunction = "FEATURE_EXTRACTION";
        }
        this.items = arrayList.toArray(new String[arrayList.size()]);
        this.algorithms = arrayList2.toArray(new String[arrayList2.size()]);
    }

    private boolean validateForm() {
        boolean bl = true;
        this.modelName = this.jModelName.getText();
        this.comment = this.jCommentText.getText();
        this.algorithm = this.algorithms[this.jAlgorithm.getSelectedIndex()];
        if (!NewModelPanel.validateName(this.modelName, this.context, this, this.wfInMemoryModelNames, null)) {
            bl = false;
        }
        if (StringUtils.checkDataLossWithMsg(this.context, this.modelName, BuildEditorLrb.get("MODEL_NAME_INVALID_TITLE"))) {
            bl = false;
        }
        if (!this.validateComment(this.comment)) {
            bl = false;
        }
        if (bl) {
            this.newModel = this.buildNode.createNewModel(this.modelName, this.comment, this.miningFunction, this.algorithm);
        }
        if (this.newModel != null) {
            this.newModel.setUseForOutput(true);
        }
        return bl;
    }

    public static boolean validateName(String string, Context context, Component component, Collection<String> collection, String string2) {
        boolean bl = true;
        boolean bl2 = SQLHelper.isExpandedObjNameEnabled(context);
        if (string.length() == 0) {
            Object[] objectArray = new Object[]{bl2 ? 123 : 25};
            String string3 = MessageFormat.format(BuildEditorLrb.get("ADD_NAME_ERROR"), objectArray);
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string3, (String)BuildEditorLrb.get("ADD_NAME_ERROR_TITLE"), null);
            return false;
        }
        if (bl2) {
            if (string.length() > 123) {
                Object[] objectArray = new Object[]{123};
                String string4 = MessageFormat.format(BuildEditorLrb.get("ADD_NAME_ERROR"), objectArray);
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)string4, (String)BuildEditorLrb.get("ADD_NAME_ERROR_TITLE"), null);
                return false;
            }
        } else if (string.length() > 25) {
            Object[] objectArray = new Object[]{25};
            String string5 = MessageFormat.format(BuildEditorLrb.get("ADD_NAME_ERROR"), objectArray);
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string5, (String)BuildEditorLrb.get("ADD_NAME_ERROR_TITLE"), null);
            return false;
        }
        if (!StringUtils.containsOnlyValidDBNameCharacters(string)) {
            Object[] objectArray = new Object[]{bl2 ? 123 : 25};
            String string6 = MessageFormat.format(BuildEditorLrb.get("MODEL_NAME_INVALID"), objectArray);
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string6, (String)BuildEditorLrb.get("MODEL_NAME_INVALID_TITLE"), null);
            return false;
        }
        if (string2 == null || !string2.equals(string)) {
            bl = WorkflowUtils.validateUserModelName(context, string, component, collection, WorkflowUtils.getAllInMemoryModelNames(context));
        }
        return bl;
    }

    private boolean validateComment(String string) {
        boolean bl = true;
        if (string.length() > 10000) {
            bl = false;
        }
        return bl;
    }

    public void setModelName(String string) {
        this.modelName = string;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setAlgorithm(String string) {
        this.algorithm = string;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public String getComment() {
        return this.comment;
    }

    public ModelType getNewModel() {
        return this.newModel;
    }

    public static ModelType addNewModel(Component component, BuildNodeType buildNodeType, Context context, AbstractBuildNode abstractBuildNode, Collection<String> collection) {
        WorkflowModel workflowModel = WorkflowUtils.getWorkflowModel((WorkflowNode)context.getNode());
        Collection<String> collection2 = WorkflowUtils.getInMemoryModelNames(workflowModel, buildNodeType);
        collection2.addAll(collection);
        ModelType modelType = null;
        NewModelPanel newModelPanel = new NewModelPanel(context, abstractBuildNode, collection2);
        DialogHelper dialogHelper = new DialogHelper(newModelPanel);
        if (dialogHelper.showAsDialog(component)) {
            Object object;
            modelType = newModelPanel.getNewModel();
            MetaDataHelper.setModelTargetPropertiesWithDefaultsFromModel(buildNodeType, modelType);
            MetaDataHelper.disableInvalidInputsInModel(modelType);
            if (buildNodeType instanceof SuperviseBuildNodeType) {
                object = (SuperviseBuildNodeType)buildNodeType;
                AttributeType attributeType = object.getTargetAttribute();
                MetaDataHelper.setModelTargetPropertiesWithDefaults(buildNodeType, modelType, attributeType);
            }
            object = buildNodeType.getCaseAttributes().getAttribute();
            MetaDataHelper.setModelCaseIDsPropertiesWithDefaults(buildNodeType, modelType, (List<AttributeType>)object);
        }
        return modelType;
    }

    public static ModelType addNewModel(Component component, BuildNodeType buildNodeType, Context context, AbstractBuildNode abstractBuildNode) {
        return NewModelPanel.addNewModel(component, buildNodeType, context, abstractBuildNode, new ArrayList<String>());
    }

    @Override
    public Dialogable asDialog() {
        return new DialogableExecutableAdapter(){

            @Override
            public String getTitle() {
                return BuildEditorLrb.get("NEW_MODEL_DIALOG_TITLE");
            }

            @Override
            public String getHelpTopic() {
                String string = null;
                if (NewModelPanel.this.buildNode instanceof AssociationBuildNode) {
                    string = "association_node_pi_models_build";
                } else if (NewModelPanel.this.buildNode instanceof ClassificationBuildNode) {
                    string = "classification_node_pi_models_build";
                } else if (NewModelPanel.this.buildNode instanceof ClusteringBuildNode) {
                    string = "clustering_node_pi_models_build";
                } else if (NewModelPanel.this.buildNode instanceof RegressionBuildNode) {
                    string = "regression_node_pi_models_build";
                } else if (NewModelPanel.this.buildNode instanceof AnomalyDetectionBuildNode) {
                    string = "anomaly_node_pi_models_build";
                } else if (NewModelPanel.this.buildNode instanceof FeatureExtractionBuildNode) {
                    string = "feature_node_pi_models_build";
                } else if (NewModelPanel.this.buildNode instanceof ExplicitFeatureExtractionBuildNode) {
                    string = "esa_node_pi_models_build";
                }
                return string;
            }

            @Override
            public JComponent getContent() {
                return NewModelPanel.this;
            }

            @Override
            public void onOK() throws DialogExecutionException {
                if (!NewModelPanel.this.validateForm()) {
                    throw new DialogExecutionException(CommonLrb.get("ERROR"), BuildEditorLrb.get("MODEL_INVALID"), null);
                }
            }
        };
    }
}

