/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build.algorithm;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.dialog.DialogDisplayable;
import oracle.dmt.dataminer.controls.dialog.DialogExecutionException;
import oracle.dmt.dataminer.controls.dialog.Dialogable;
import oracle.dmt.dataminer.controls.dialog.DialogableExecutableAdapter;
import oracle.dmt.dataminer.controls.models.SingleColumnTableModel;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.dal.Query;
import oracle.dmt.dataminer.core.dal.sql.ConnectionProperties;
import oracle.dmt.dataminer.core.dal.sql.SqlDataAccessObject;
import oracle.dmt.dataminer.core.dal.sql.queries.ar.ap.GetDistinctItemsQuery;
import oracle.dmt.dataminer.core.model.ar.filter.ModelARAddFilterItem;
import oracle.dmt.dataminer.core.model.ar.filter.ModelARAddFilterSettingsBean;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.model.filter.SortDirection;
import oracle.dmt.dataminer.core.res.CoreCommonLrb;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.mviewer.arrules.ARPreferences;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.queries.ar.ap.GetDistinctItemsFromSourceQuery;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.dmt.dataminer.utils.UITools;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.ARAddFilterTableModel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AlgSettingsLrb;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.xmlschema.AssociationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.Header;
import oracle.javatools.ui.HeaderGroup;
import oracle.javatools.util.Version;

public class ModelARAddFilterPanel
extends JPanel
implements DialogDisplayable {
    private JButton remExcAntecedentBtn;
    private AbstractBuildNode node;
    private BuildNodeType nodeDataCopy;
    private DataMinerTable targetTable;
    private String preprocessedTableName;
    private String owner;
    private String model;
    private String partitionId;
    private SqlDataAccessObject dao;
    private Version dbVersion;
    private Mode mode;
    private JButton addButton;
    private JComboBox<String> fetchFromComboBox;
    private JLabel fetchFromLabel;
    private JLabel fetchSizeLabel;
    private JSpinner fetchSizeSpinner;
    private DataMinerTablePanel foundItemsTablePanel;
    private JPanel jPanel1;
    private JPanel jSettingsContainer;
    private JComboBox<SortDirection> orderByComboBox;
    private JLabel sampleSizeLabel;
    private JSpinner sampleSizeSpinner;
    private JButton searchButton;
    private JLabel searchForLabel;
    private JTextField searchForTextField;
    private DataMinerTablePanel selectedItemsTablePanel;
    private Header settingsHeader;
    private JPanel settingsPanel;
    private JComboBox<String> sortByComboBox;
    private JLabel sortByLabel;
    private JCheckBox useAllDataCheckbox;

    public ModelARAddFilterPanel(Context context, DataMinerTable dataMinerTable, AbstractBuildNode abstractBuildNode, String string, BuildNodeType buildNodeType) {
        this.preprocessedTableName = string;
        this.node = abstractBuildNode;
        this.nodeDataCopy = buildNodeType;
        this.targetTable = dataMinerTable;
        this.mode = Mode.BUILD_NODE;
        this.init(context);
    }

    public ModelARAddFilterPanel(Context context, DataMinerTable dataMinerTable, String string, String string2, String string3) {
        this.targetTable = dataMinerTable;
        this.owner = string;
        this.model = string2;
        this.partitionId = string3;
        this.mode = Mode.MODEL_VIEWER;
        this.init(context);
    }

    private void init(Context context) {
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
        this.dao = new SqlDataAccessObject((ConnectionManager)connectionFolder);
        this.dbVersion = connectionFolder.getDbVersion();
        this.initComponents();
        this.initUI();
    }

    private void initUI() {
        this.remExcAntecedentBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this.remExcAntecedentBtn.setToolTipText(AlgSettingsLrb.get("ASSO_FILTER_ITEM_DELETE_TOOLTIP"));
        this.remExcAntecedentBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelARAddFilterPanel.this.addItemstoSelectedList(ModelARAddFilterPanel.this.selectedItemsTablePanel, ModelARAddFilterPanel.this.foundItemsTablePanel);
            }
        });
        this.selectedItemsTablePanel.addControlBarComponents(this.remExcAntecedentBtn);
        ARAddFilterTableModel aRAddFilterTableModel = new ARAddFilterTableModel();
        this.selectedItemsTablePanel.setup((TableModel)((Object)aRAddFilterTableModel), AlgSettingsLrb.get("ASSO_FILTER_PANEL_SELECTED_ITEMS"), 0);
        if (Mode.MODEL_VIEWER.equals((Object)this.mode)) {
            this.selectedItemsTablePanel.getTable().setHiddenColumns(new int[]{1});
        }
        this.sortByComboBox.removeAllItems();
        this.sortByComboBox.addItem(CoreCommonLrb.get((String)"ITEM"));
        if (Mode.BUILD_NODE.equals((Object)this.mode)) {
            this.sortByComboBox.addItem(CoreCommonLrb.get((String)"COUNT"));
        }
        this.sortByComboBox.addItem(AlgSettingsLrb.get("ASSO_FILTER_SORT_BY_SUPPORT"));
        this.orderByComboBox.removeAllItems();
        this.orderByComboBox.addItem(SortDirection.ASCENDING);
        this.orderByComboBox.addItem(SortDirection.DESCENDING);
        Integer n = ARPreferences.getInstance().getFindItemsFetchSize();
        this.fetchSizeSpinner.setValue(n);
        this.fetchFromComboBox.removeAllItems();
        this.fetchFromComboBox.addItem(AlgSettingsLrb.get("ASSO_FILTER_FETCH_ACTUAL"));
        if (StringUtils.isNotEmpty((String)this.preprocessedTableName) && !"NONE".equals(this.preprocessedTableName)) {
            this.fetchFromComboBox.addItem(AlgSettingsLrb.get("ASSO_FILTER_FETCH_CACHE"));
            this.fetchFromComboBox.setSelectedIndex(1);
            this.enableCacheControls();
        }
        this.settingsHeader.setText(CoreCommonLrb.get((String)"SETTINGS"));
        this.settingsHeader.setLevel(Header.Level.PAGE);
        this.settingsHeader.setExpandable(true);
        this.settingsHeader.setExpanded(false);
        HeaderGroup headerGroup = new HeaderGroup(this.settingsHeader);
        headerGroup.add((Component)this.jSettingsContainer);
        this.searchForTextField.addKeyListener(new ItemsTxtKeyListener());
        this.searchForTextField.getDocument().addDocumentListener(new SearchForDocumentListener());
        this.searchButton.setEnabled(false);
        if (Mode.MODEL_VIEWER.equals((Object)this.mode)) {
            this.hideComponentsModelViewer();
        }
    }

    private void hideComponentsModelViewer() {
        this.fetchFromLabel.setVisible(false);
        this.fetchFromComboBox.setVisible(false);
        this.sampleSizeLabel.setVisible(false);
        this.sampleSizeSpinner.setVisible(false);
        this.useAllDataCheckbox.setVisible(false);
    }

    private void initComponents() {
        this.jSettingsContainer = new JPanel();
        this.settingsPanel = new JPanel();
        this.sortByLabel = new JLabel();
        this.sortByComboBox = new JComboBox();
        this.orderByComboBox = new JComboBox();
        this.fetchSizeLabel = new JLabel();
        this.fetchSizeSpinner = new JSpinner();
        this.fetchFromLabel = new JLabel();
        this.fetchFromComboBox = new JComboBox();
        this.sampleSizeLabel = new JLabel();
        this.sampleSizeSpinner = new JSpinner();
        this.useAllDataCheckbox = new JCheckBox();
        this.settingsHeader = new Header();
        this.searchForLabel = new JLabel();
        this.searchForTextField = new JTextField();
        this.searchButton = new JButton();
        this.selectedItemsTablePanel = new DataMinerTablePanel();
        this.foundItemsTablePanel = new DataMinerTablePanel();
        this.jPanel1 = new JPanel();
        this.addButton = new JButton();
        this.jSettingsContainer.setBorder(BorderFactory.createEtchedBorder());
        this.settingsPanel.setLayout(new GridBagLayout());
        this.sortByLabel.setText("Sort by:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 0, 0, 0);
        this.settingsPanel.add((Component)this.sortByLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 100;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.settingsPanel.add(this.sortByComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.ipadx = 130;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 15, 0, 0);
        this.settingsPanel.add(this.orderByComboBox, gridBagConstraints);
        this.fetchSizeLabel.setLabelFor(this.fetchSizeSpinner);
        this.fetchSizeLabel.setText("Fetch Size:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 0, 5, 0);
        this.settingsPanel.add((Component)this.fetchSizeLabel, gridBagConstraints);
        this.fetchSizeSpinner.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)10));
        this.fetchSizeSpinner.setMinimumSize(new Dimension(101, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 65;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.settingsPanel.add((Component)this.fetchSizeSpinner, gridBagConstraints);
        this.fetchFromLabel.setText("Fetch from:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 15, 0, 0);
        this.settingsPanel.add((Component)this.fetchFromLabel, gridBagConstraints);
        this.fetchFromComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelARAddFilterPanel.this.fetchFromComboBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 8, 0, 0);
        this.settingsPanel.add(this.fetchFromComboBox, gridBagConstraints);
        this.sampleSizeLabel.setLabelFor(this.sampleSizeSpinner);
        this.sampleSizeLabel.setText("Sample Size:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 0, 5, 0);
        this.settingsPanel.add((Component)this.sampleSizeLabel, gridBagConstraints);
        this.sampleSizeSpinner.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 65;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.settingsPanel.add((Component)this.sampleSizeSpinner, gridBagConstraints);
        this.useAllDataCheckbox.setText("Use all Data");
        this.useAllDataCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelARAddFilterPanel.this.useAllDataCheckboxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        this.settingsPanel.add((Component)this.useAllDataCheckbox, gridBagConstraints);
        GroupLayout groupLayout = new GroupLayout(this.jSettingsContainer);
        this.jSettingsContainer.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.settingsPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.settingsPanel, -1, -1, -2).addGap(0, 0, 0)));
        this.settingsHeader.setName("excludeHeader");
        this.settingsHeader.setText("Settings");
        this.searchForLabel.setText("Search For:");
        this.searchButton.setText("Find");
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelARAddFilterPanel.this.searchButtonActionPerformed(actionEvent);
            }
        });
        this.addButton.setText("Add");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelARAddFilterPanel.this.addButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.addButton);
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.settingsHeader, -1, -1, Short.MAX_VALUE).addComponent(this.foundItemsTablePanel, -1, -1, Short.MAX_VALUE).addComponent(this.jSettingsContainer, -1, -1, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addComponent(this.searchForLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchForTextField, -2, 135, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchButton).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.selectedItemsTablePanel, -1, 502, Short.MAX_VALUE)).addGap(3, 3, 3))).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.searchForLabel).addComponent(this.searchForTextField, -2, -1, -2).addComponent(this.searchButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.settingsHeader, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jSettingsContainer, -2, -1, -2).addGap(11, 11, 11).addComponent(this.foundItemsTablePanel, -1, 152, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -2, 28, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.selectedItemsTablePanel, -1, 153, Short.MAX_VALUE).addContainerGap()));
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        this.addItemstoSelectedList(this.foundItemsTablePanel, this.selectedItemsTablePanel);
    }

    private void useAllDataCheckboxActionPerformed(ActionEvent actionEvent) {
        this.sampleSizeSpinner.setEnabled(!this.useAllDataCheckbox.isSelected());
    }

    private void searchButtonActionPerformed(ActionEvent actionEvent) {
        this.searchItems();
    }

    private void fetchFromComboBoxActionPerformed(ActionEvent actionEvent) {
        if (this.fetchFromComboBox.getSelectedIndex() == 0) {
            this.enableActualSearchControls();
        } else if (this.fetchFromComboBox.getModel().getSize() > 1) {
            this.enableCacheControls();
        }
    }

    private void enableActualSearchControls() {
        this.fetchSizeSpinner.setEnabled(true);
        this.sampleSizeSpinner.setEnabled(false);
        this.useAllDataCheckbox.setEnabled(false);
    }

    private void enableCacheControls() {
        this.fetchSizeSpinner.setEnabled(false);
        this.sampleSizeSpinner.setEnabled(false);
        this.useAllDataCheckbox.setEnabled(true);
        this.useAllDataCheckbox.setSelected(true);
        this.sampleSizeSpinner.setValue(4000);
    }

    private void searchItems() {
        if (this.searchForTextField.getText().isEmpty()) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)AlgSettingsLrb.get("ASSO_FILTER_ADD_ITEMS_MISSING_TEXT"), (String)AlgSettingsLrb.get("ASSO_FILTER_ADD_ITEMS_TITLE_ERROR"), null);
        } else {
            SwingWorker<List<ModelARAddFilterItem>, Void> swingWorker = this.getNewWorker();
            swingWorker.execute();
        }
    }

    private void copyAllRowsToTable(DataMinerTable dataMinerTable, DataMinerTable dataMinerTable2) {
        ARAddFilterTableModel aRAddFilterTableModel = (ARAddFilterTableModel)((Object)dataMinerTable.getModel());
        SingleColumnTableModel singleColumnTableModel = (SingleColumnTableModel)((Object)dataMinerTable2.getModel());
        ArrayList<String> arrayList = new ArrayList<String>(aRAddFilterTableModel.getSrcData().size());
        for (ModelARAddFilterItem modelARAddFilterItem : aRAddFilterTableModel.getSrcData()) {
            if (singleColumnTableModel.contains(modelARAddFilterItem.getName())) continue;
            arrayList.add(modelARAddFilterItem.getName());
        }
        singleColumnTableModel.addRows(arrayList);
    }

    private void addItemstoSelectedList(DataMinerTablePanel dataMinerTablePanel, DataMinerTablePanel dataMinerTablePanel2) {
        int n;
        int[] nArray = dataMinerTablePanel.getTable().getSelectedRowsInModel();
        if (nArray.length < 1) {
            return;
        }
        ARAddFilterTableModel aRAddFilterTableModel = (ARAddFilterTableModel)((Object)dataMinerTablePanel.getTable().getModel());
        ARAddFilterTableModel aRAddFilterTableModel2 = (ARAddFilterTableModel)((Object)dataMinerTablePanel2.getTable().getModel());
        ArrayList<ModelARAddFilterItem> arrayList = new ArrayList<ModelARAddFilterItem>();
        for (n = 0; n < nArray.length; ++n) {
            ModelARAddFilterItem modelARAddFilterItem = (ModelARAddFilterItem)aRAddFilterTableModel.getSrcData().get(nArray[n]);
            arrayList.add(modelARAddFilterItem);
            aRAddFilterTableModel2.addRow(modelARAddFilterItem);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            int n2 = aRAddFilterTableModel.getSrcData().indexOf(arrayList.get(n));
            aRAddFilterTableModel.removeRow(n2);
        }
        UITools.getParentDialog(this).setOKButtonEnabled(true);
    }

    public void enableControls(boolean bl) {
        this.searchButton.setEnabled(bl);
    }

    public SwingWorker<List<ModelARAddFilterItem>, Void> getNewWorker() {
        ODMrSwingWorker oDMrSwingWorker = null;
        if (Mode.BUILD_NODE.equals((Object)this.mode)) {
            oDMrSwingWorker = new LoadUI(this.searchForTextField.getText());
        } else if (Mode.MODEL_VIEWER.equals((Object)this.mode)) {
            oDMrSwingWorker = new LoadForModelViewer(this.searchForTextField.getText());
        }
        return oDMrSwingWorker;
    }

    private void setupFoundItemsTable(List<ModelARAddFilterItem> list) {
        ARAddFilterTableModel aRAddFilterTableModel = new ARAddFilterTableModel(list);
        this.foundItemsTablePanel.setup((TableModel)((Object)aRAddFilterTableModel), AlgSettingsLrb.get("ASSO_FILTER_ITEMS_FOUND"), 0);
        boolean bl = SortDirection.ASCENDING.equals(this.orderByComboBox.getSelectedItem());
        int n = this.foundItemsTablePanel.getTable().getColumn(this.sortByComboBox.getSelectedItem()).getModelIndex();
        this.foundItemsTablePanel.getTable().setSortColumn(n, bl);
        if (list.size() > 0) {
            this.foundItemsTablePanel.getTable().setNoEntryInstructionText("");
        }
    }

    @Override
    public Dialogable asDialog() {
        return new DialogableExecutableAdapter(){

            @Override
            public void customizeDialogProperties(JEWTDialog jEWTDialog) {
                super.customizeDialogProperties(jEWTDialog);
                jEWTDialog.setOKButtonEnabled(false);
                jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

                    @Override
                    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                        boolean bl = ModelARAddFilterPanel.this.searchForTextField.hasFocus();
                        if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)propertyChangeEvent) && bl) {
                            throw new PropertyVetoException("onOK", propertyChangeEvent);
                        }
                    }
                });
            }

            @Override
            public void onOK() throws DialogExecutionException {
                ModelARAddFilterPanel.this.copyAllRowsToTable(ModelARAddFilterPanel.this.selectedItemsTablePanel.getTable(), ModelARAddFilterPanel.this.targetTable);
                Integer n = (Integer)ModelARAddFilterPanel.this.fetchSizeSpinner.getValue();
                ARPreferences.getInstance().setFindItemsFetchSize(n);
            }

            @Override
            public String getTitle() {
                return AlgSettingsLrb.get("ASSO_FILTER_FIND_ITEMS");
            }

            @Override
            public String getHelpTopic() {
                return "model_ar_add_filter";
            }

            @Override
            public JPanel getContent() {
                return ModelARAddFilterPanel.this;
            }
        };
    }

    private static enum Mode {
        BUILD_NODE,
        MODEL_VIEWER;

    }

    class LoadForModelViewer
    extends ODMrSwingWorker<List<ModelARAddFilterItem>, Void> {
        private String filterText;

        private LoadForModelViewer(String string) {
            super(ModelARAddFilterPanel.this, null, ModelARAddFilterPanel.this.foundItemsTablePanel.getTable());
            ModelARAddFilterPanel.this.enableControls(false);
            this.filterText = string;
        }

        @Override
        protected List<ModelARAddFilterItem> doInBackground() throws Exception {
            Integer n = (Integer)ModelARAddFilterPanel.this.fetchSizeSpinner.getValue();
            ModelDescriptor modelDescriptor = new ModelDescriptor(ModelARAddFilterPanel.this.owner, ModelARAddFilterPanel.this.model, ModelARAddFilterPanel.this.partitionId);
            GetDistinctItemsQuery getDistinctItemsQuery = new GetDistinctItemsQuery(ModelARAddFilterPanel.this.dbVersion, modelDescriptor, this.filterText);
            boolean bl = CoreCommonLrb.get((String)"ITEM").equals(ModelARAddFilterPanel.this.sortByComboBox.getSelectedItem());
            SortDirection sortDirection = (SortDirection)ModelARAddFilterPanel.this.orderByComboBox.getSelectedItem();
            if (bl) {
                getDistinctItemsQuery.orderByName(sortDirection);
            } else {
                getDistinctItemsQuery.orderBySupport(sortDirection);
            }
            List list = ModelARAddFilterPanel.this.dao.readItems((Query)getDistinctItemsQuery, 1, n.intValue());
            return list;
        }

        @Override
        protected void onSuccess(List<ModelARAddFilterItem> list) {
            ModelARAddFilterPanel.this.setupFoundItemsTable(list);
            ModelARAddFilterPanel.this.foundItemsTablePanel.getTable().setHiddenColumns(new int[]{1});
        }

        @Override
        protected void onFinally() {
            ModelARAddFilterPanel.this.enableControls(true);
        }
    }

    class LoadUI
    extends ODMrSwingWorker<List<ModelARAddFilterItem>, Void> {
        private String filterText;

        private LoadUI(String string) {
            super(ModelARAddFilterPanel.this, null, ModelARAddFilterPanel.this.foundItemsTablePanel.getTable());
            ModelARAddFilterPanel.this.enableControls(false);
            this.filterText = string;
        }

        @Override
        protected List<ModelARAddFilterItem> doInBackground() throws Exception {
            AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)ModelARAddFilterPanel.this.nodeDataCopy;
            AttributeType attributeType = associationBuildNodeType.getItemID();
            ModelARAddFilterSettingsBean modelARAddFilterSettingsBean = new ModelARAddFilterSettingsBean();
            modelARAddFilterSettingsBean.setColumnToSearch(attributeType.getName());
            if (ModelARAddFilterPanel.this.fetchFromComboBox.getSelectedIndex() == 0) {
                modelARAddFilterSettingsBean.setFetchFromActual(true);
                modelARAddFilterSettingsBean.setPreprocessedTableName("");
            } else if (ModelARAddFilterPanel.this.fetchFromComboBox.getModel().getSize() > 1) {
                modelARAddFilterSettingsBean.setFetchFromActual(false);
                modelARAddFilterSettingsBean.setPreprocessedTableName(ModelARAddFilterPanel.this.preprocessedTableName);
            }
            Integer n = (Integer)ModelARAddFilterPanel.this.fetchSizeSpinner.getValue();
            modelARAddFilterSettingsBean.setFetchSize(n.intValue());
            Integer n2 = (Integer)ModelARAddFilterPanel.this.sampleSizeSpinner.getValue();
            modelARAddFilterSettingsBean.setSampleSize(n2.intValue());
            modelARAddFilterSettingsBean.setSearchText(this.filterText);
            modelARAddFilterSettingsBean.setUseAllData(ModelARAddFilterPanel.this.useAllDataCheckbox.isSelected());
            modelARAddFilterSettingsBean.setOrder((SortDirection)ModelARAddFilterPanel.this.orderByComboBox.getSelectedItem());
            modelARAddFilterSettingsBean.setSortByColumn(ModelARAddFilterPanel.this.sortByComboBox.getSelectedIndex());
            GetDistinctItemsFromSourceQuery getDistinctItemsFromSourceQuery = new GetDistinctItemsFromSourceQuery(ModelARAddFilterPanel.this.node, modelARAddFilterSettingsBean);
            ModelARAddFilterPanel.this.dao.setConnectionProperties(new ConnectionProperties[]{ConnectionProperties.ALTER_SESSION_FIXES});
            List list = ModelARAddFilterPanel.this.dao.readItems((Query)getDistinctItemsFromSourceQuery);
            return list;
        }

        @Override
        protected void onSuccess(List<ModelARAddFilterItem> list) {
            ModelARAddFilterPanel.this.setupFoundItemsTable(list);
        }

        @Override
        protected void onFinally() {
            ModelARAddFilterPanel.this.enableControls(true);
        }
    }

    private class SearchForDocumentListener
    implements DocumentListener {
        private SearchForDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            ModelARAddFilterPanel.this.searchButton.setEnabled(true);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            boolean bl = !ModelARAddFilterPanel.this.searchForTextField.getText().isEmpty();
            ModelARAddFilterPanel.this.searchButton.setEnabled(bl);
        }
    }

    private class ItemsTxtKeyListener
    extends KeyAdapter {
        private ItemsTxtKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            boolean bl;
            boolean bl2 = keyEvent.getKeyChar() == '\n';
            boolean bl3 = bl = !ModelARAddFilterPanel.this.searchForTextField.getText().isEmpty();
            if (bl2 && bl) {
                ModelARAddFilterPanel.this.searchItems();
            }
        }
    }
}

