/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.columnFilter;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.core.utils.comparator.AttributeTypeComparator;
import oracle.dmt.dataminer.workflow.dialog.columnFilter.ADSettingsTableEntry;
import oracle.dmt.dataminer.workflow.dialog.columnFilter.DialogsLrb;

class ADSettingsTableModel
extends ODMrTableModel<ADSettingsTableEntry> {
    Map<String, Boolean> allAttrsOutput;
    static final int ATTRIBUTE = 0;
    static final int IMPORTANCE = 1;
    static final int WEIGHTED_DEPENDENCY = 2;
    static final int DEPENDENCY = 3;
    static final int INCLUDED = 4;
    private static final String[] columns = new String[]{DialogsLrb.get("COLUMN_FILTER_COLUMN_TABLE_TITLE"), DialogsLrb.get("COLUMN_FILTER_COLUMN_IMPORTANCE"), DialogsLrb.get("DEPENDENCY_WEIGHTED"), DialogsLrb.get("DEPENDENCY"), DialogsLrb.get("COLUMN_FILTER_COLUMN_OUTPUT")};

    public ADSettingsTableModel(List<ADSettingsTableEntry> list, Map<String, Boolean> map) {
        super(columns, list);
        this.allAttrsOutput = map;
    }

    public Object getValueAt(int n, int n2) {
        Object object = null;
        ADSettingsTableEntry aDSettingsTableEntry = (ADSettingsTableEntry)this.srcData.get(n);
        switch (n2) {
            case 0: {
                object = aDSettingsTableEntry.getAttribute();
                break;
            }
            case 1: {
                object = aDSettingsTableEntry.getImportance();
                break;
            }
            case 2: {
                object = aDSettingsTableEntry.getWeightedDependency();
                break;
            }
            case 3: {
                object = aDSettingsTableEntry.getDependency();
                break;
            }
            case 4: {
                object = this.allAttrsOutput.get(aDSettingsTableEntry.getAttribute().getName());
                break;
            }
            default: {
                assert (false) : "Out of bounds column";
                break;
            }
        }
        return object;
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 == 4;
    }

    public void setValueAt(Object object, int n, int n2) {
        ADSettingsTableEntry aDSettingsTableEntry = (ADSettingsTableEntry)this.srcData.get(n);
        switch (n2) {
            case 4: {
                this.allAttrsOutput.put(aDSettingsTableEntry.getAttribute().getName(), (Boolean)object);
                this.fireTableCellUpdated(n, n2);
                break;
            }
            default: {
                assert (false) : "Invalid index";
                break;
            }
        }
    }

    @Override
    public String getStringValueAt(int n, int n2) {
        ADSettingsTableEntry aDSettingsTableEntry = (ADSettingsTableEntry)this.srcData.get(n);
        String string = "";
        switch (n2) {
            case 0: {
                string = aDSettingsTableEntry.getAttribute().getName();
                break;
            }
            case 1: {
                string = Double.toString(aDSettingsTableEntry.getImportance());
                break;
            }
            case 2: {
                string = Double.toString(aDSettingsTableEntry.getWeightedDependency());
                break;
            }
            case 3: {
                string = Double.toString(aDSettingsTableEntry.getDependency());
                break;
            }
            case 4: {
                string = Boolean.toString(this.allAttrsOutput.get(aDSettingsTableEntry.getAttribute().getName()));
                break;
            }
            default: {
                assert (false) : "Out of bounds column";
                break;
            }
        }
        return string;
    }

    public Comparator getColumnSortComparator(int n) {
        switch (n) {
            case 0: {
                return AttributeTypeComparator.getComparator();
            }
        }
        return super.getColumnSortComparator(n);
    }
}

