/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.dynamic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Icon;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicApplyHelper;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicApplyOutputColumnNameGenerator;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicNodesLrb;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicState;
import oracle.dmt.dataminer.workflow.dialog.dynamic.partition.PartitionTableModel;
import oracle.dmt.dataminer.workflow.model.AbstractTransformNode;
import oracle.dmt.dataminer.workflow.model.DynamicNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.CaseAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicApplyOutputColumnType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicApplyOutputColumns;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicNodeBaseSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressionType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressions;
import oracle.dmt.dataminer.workflow.xmlschema.SupplementalAttributesType;
import oracle.dmt.dataminer.workflow.xmlschema.TargetAttributes;
import oracle.ide.Context;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.icons.OracleIcons;

public abstract class DynamicNodeEditorState
implements DynamicState {
    public static final String INPUT = "Yes";
    public static final String IGNORE = "No";
    public static final String FORCE = "Force";
    public static final String MULTI_SELECT_RES = DynamicNodesLrb.get("BUILD_DATA_USAGE_MULTI_SELECT");
    public static String _none = DynamicNodesLrb.get("DYNAMIC_EDITOR_PANEL_CASE_ID_NONE");
    private static Icon _editIcon;
    protected boolean _loaded;
    protected Context _context;
    private AbstractTransformNode _node;
    private DynamicNodeBaseSettingsType _baseSettings;
    protected DynamicApplyOutputColumns _dynamicApplyOutputColumns;
    protected Map<String, MiningAttributeType> _mapInputMiningAttributes;
    private String _selectedCaseAttribute;
    protected DynamicApplyOutputColumnNameGenerator _outputColumnNameGenerator;
    private PartitionTableModel tableModelPartitions;
    private Map<String, PartitionExpressionType> partExpNames = new HashMap<String, PartitionExpressionType>();

    public DynamicNodeEditorState(Context context, DynamicNode dynamicNode, DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType) {
        assert (context != null) : "Context cannot be passed into constructor as a null.";
        this._loaded = false;
        this._context = context;
        this._node = dynamicNode;
        this._baseSettings = dynamicNodeBaseSettingsType;
        List list = dynamicNodeBaseSettingsType.getCaseAttributes().getAttribute();
        if (!list.isEmpty()) {
            this._selectedCaseAttribute = ((AttributeType)list.get(0)).getName();
        }
        this._outputColumnNameGenerator = dynamicNode.getNameGenerator();
        this.initRes();
        this.tableModelPartitions = new PartitionTableModel(this._baseSettings.getPartitionExpressions());
        for (PartitionExpressionType partitionExpressionType : this._baseSettings.getPartitionExpressions().getPartitionExpression()) {
            if (null == partitionExpressionType.getSQLExpression()) continue;
            this.partExpNames.put(partitionExpressionType.getPartitionAttribute().getName(), partitionExpressionType);
        }
    }

    @Override
    public AbstractTransformNode getNode() {
        return this._node;
    }

    @Override
    public boolean doesNameExist(String string) {
        return this._outputColumnNameGenerator.doesNameExist(string);
    }

    @Override
    public String createUniqueName(String string, String string2, boolean bl) {
        String string3 = this._outputColumnNameGenerator.generateColumnName(string, string2, bl);
        return string3;
    }

    @Override
    public void addUniqueName(String string) {
        this._outputColumnNameGenerator.addUniqueName(string);
    }

    @Override
    public void removeUniqueName(String string) {
        this._outputColumnNameGenerator.removeUniqueName(string);
    }

    public PartitionExpressions getPartitionExpressions() {
        return this._baseSettings.getPartitionExpressions();
    }

    public void removeUniqueName(DynamicApplyOutputColumnType dynamicApplyOutputColumnType) {
        this._outputColumnNameGenerator.removeUniqueName(dynamicApplyOutputColumnType);
    }

    public Context getContext() {
        return this._context;
    }

    public static Icon getRemoveIcon() {
        return OracleIcons.getIcon((String)"delete.png");
    }

    public static Icon getEditIcon() {
        return _editIcon;
    }

    private void initRes() {
        if (null != _editIcon) {
            return;
        }
        _editIcon = InspectorArb.getIcon((int)24);
    }

    public PartitionTableModel getTableModelPartitions() {
        return this.tableModelPartitions;
    }

    public void addPartitionExpression(PartitionExpressionType partitionExpressionType) {
        this.getPartitionExpressions().getPartitionExpression().add(partitionExpressionType);
        this.tableModelPartitions = new PartitionTableModel(this._baseSettings.getPartitionExpressions());
    }

    public void addPartitionExpressions(List<PartitionExpressionType> list) {
        this.getPartitionExpressions().getPartitionExpression().addAll(list);
        this.tableModelPartitions = new PartitionTableModel(this._baseSettings.getPartitionExpressions());
    }

    public void removeExpressionsFromList(List<PartitionExpressionType> list) {
        List list2 = this._baseSettings.getPartitionExpressions().getPartitionExpression();
        list2.removeAll(list);
        this.tableModelPartitions = new PartitionTableModel(this._baseSettings.getPartitionExpressions());
        for (PartitionExpressionType partitionExpressionType : list) {
            String string;
            if (null != partitionExpressionType.getSQLExpression() || null == this.partExpNames.get(string = partitionExpressionType.getPartitionAttribute().getName())) continue;
            this.partExpNames.remove(string);
        }
    }

    public String generatePartitionExpressionName(PartitionExpressionType partitionExpressionType) {
        String string;
        List list;
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder(PARTITION_EXPRESSION_TEMPLATE);
        if (this.getPartitionExpressions() != null) {
            list = this.getMiningAttributes().getMiningAttribute();
            PartitionExpressions partitionExpressions = this.getPartitionExpressions();
            for (Object object : partitionExpressions.getPartitionExpression()) {
                if (null == object.getSQLExpression() && !object.getPartitionAttribute().getName().startsWith(DynamicState.PARTITION_EXPRESSION_TEMPLATE)) continue;
                string = object.getPartitionAttribute().getName();
                String string2 = string.substring(TEMPLATE_LENGTH, string.length());
                n = Math.max(n, Integer.parseInt(string2));
            }
        }
        list = this._baseSettings.getMiningAttributes();
        for (MiningAttributeType miningAttributeType : list.getMiningAttribute()) {
            Object object;
            if (!miningAttributeType.getName().startsWith(DynamicState.PARTITION_EXPRESSION_TEMPLATE)) continue;
            object = miningAttributeType.getName();
            string = ((String)object).substring(DynamicState.TEMPLATE_LENGTH, ((String)object).length());
            n = Math.max(n, Integer.parseInt(string));
        }
        stringBuilder.append(n + 1);
        this.partExpNames.put(stringBuilder.toString(), partitionExpressionType);
        return stringBuilder.toString();
    }

    public MiningAttributes getMiningAttributes() {
        return this._baseSettings.getMiningAttributes();
    }

    public SupplementalAttributesType getSupplementalAttributes() {
        return this._baseSettings.getSupplementalAttributes();
    }

    public void setSupplementalAttributes(SupplementalAttributesType supplementalAttributesType) {
        this._baseSettings.setSupplementalAttributes(supplementalAttributesType);
    }

    public CaseAttributes getCaseAttributes() {
        return this._baseSettings.getCaseAttributes();
    }

    public boolean isCaseIdValid() {
        boolean bl = false;
        for (AttributeType attributeType : this.getCaseAttributes().getAttribute()) {
            if (!attributeType.getName().equals(this._selectedCaseAttribute)) continue;
            bl = attributeType.getStatus().equals((Object)AttributeStatus.VALID);
            break;
        }
        return bl;
    }

    public String getSelectedCaseAttribute() {
        return this._selectedCaseAttribute;
    }

    public void setSelectedCaseAttribute(String string) {
        MiningAttributeType miningAttributeType = null;
        if (!this.getMiningAttributes().getMiningAttribute().isEmpty()) {
            for (MiningAttributeType miningAttributeType2 : this.getMiningAttributes().getMiningAttribute()) {
                if (!miningAttributeType2.getName().equals(string)) continue;
                miningAttributeType = miningAttributeType2;
                break;
            }
        }
        this.getCaseAttributes().getAttribute().clear();
        if (null != miningAttributeType) {
            AttributeType attributeType = MetaDataHelper.createAttributeFrom(miningAttributeType);
            this.getCaseAttributes().getAttribute().add(attributeType);
            this._selectedCaseAttribute = miningAttributeType.getName();
        }
        this.updateAutoSupplementalList();
    }

    public DynamicNodeBaseSettingsType getBaseSettings() {
        return this._baseSettings;
    }

    public List<PartitionExpressionType> getListOfPartitionColumnsToRemove(List<MiningAttributeType> list) {
        ArrayList<PartitionExpressionType> arrayList = new ArrayList<PartitionExpressionType>();
        ArrayList<PartitionExpressionType> arrayList2 = new ArrayList<PartitionExpressionType>();
        for (Object object : this._baseSettings.getPartitionExpressions().getPartitionExpression()) {
            if (null != object.getSQLExpression()) continue;
            arrayList2.add((PartitionExpressionType)object);
        }
        if (list == null || list.isEmpty()) {
            return arrayList2;
        }
        HashMap hashMap = new HashMap();
        for (MiningAttributeType miningAttributeType : list) {
            hashMap.put(miningAttributeType.getName(), miningAttributeType);
        }
        for (PartitionExpressionType partitionExpressionType : arrayList2) {
            if (null != hashMap.get(partitionExpressionType.getPartitionAttribute().getName())) continue;
            arrayList.add(partitionExpressionType);
        }
        return arrayList;
    }

    public List<PartitionExpressionType> getListOfPartitionColumnsToAdd(List<MiningAttributeType> list) {
        ArrayList<PartitionExpressionType> arrayList = new ArrayList<PartitionExpressionType>();
        if (list == null || list.isEmpty()) {
            return arrayList;
        }
        HashMap<String, PartitionExpressionType> hashMap = new HashMap<String, PartitionExpressionType>();
        List list2 = this._baseSettings.getPartitionExpressions().getPartitionExpression();
        for (PartitionExpressionType partitionExpressionType : list2) {
            if (null != partitionExpressionType.getSQLExpression()) continue;
            hashMap.put(partitionExpressionType.getPartitionAttribute().getName(), partitionExpressionType);
        }
        for (MiningAttributeType miningAttributeType : list) {
            if (null != hashMap.get(miningAttributeType.getName())) continue;
            PartitionExpressionType partitionExpressionType = new PartitionExpressionType();
            partitionExpressionType.setPartitionAttribute(MetaDataHelper.createAttributeFrom(miningAttributeType));
            arrayList.add(partitionExpressionType);
        }
        return arrayList;
    }

    public boolean isTargetAttribute(MiningAttributeType miningAttributeType) {
        return false;
    }

    public List<MiningAttributeType> getTargetAttributeList() {
        return new ArrayList<MiningAttributeType>();
    }

    public boolean isCaseIdAttribute(AttributeType attributeType) {
        boolean bl = false;
        for (AttributeType attributeType2 : this._baseSettings.getCaseAttributes().getAttribute()) {
            if (!attributeType2.getName().equals(attributeType.getName())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public List<MiningAttributeType> getSelectedTargetAttributes() {
        return null;
    }

    @Override
    public Map<String, Vector<Object>> getAllTargetValues() {
        return null;
    }

    public TargetAttributes getTargetAttributes() {
        return new TargetAttributes();
    }

    @Override
    public Vector<Object> getNodeSpecificTargetValues(String string) {
        return null;
    }

    public boolean isInputAutomatic() {
        AutoSpecType autoSpecType = this.getMiningAttributes().getAutoSpec();
        return autoSpecType.equals((Object)AutoSpecType.YES);
    }

    public boolean isOutputAutomatic() {
        AutoSpecType autoSpecType = this.getSupplementalAttributes().getAutoSpec();
        return autoSpecType != null && autoSpecType.equals((Object)AutoSpecType.YES);
    }

    public void updateAutoSupplementalList() {
        if (!this.isOutputAutomatic()) {
            return;
        }
        List list = this.getSupplementalAttributes().getAttribute();
        list.clear();
        List<MiningAttributeType> list2 = this.getTargetAttributeList();
        for (MiningAttributeType miningAttributeType : list2) {
            AttributeType attributeType = MetaDataHelper.createAttributeFrom(miningAttributeType);
            list.add(attributeType);
        }
        list.addAll(this.getCaseAttributes().getAttribute());
        for (MiningAttributeType miningAttributeType : this.getPartitionExpressions().getPartitionExpression()) {
            list.add(miningAttributeType.getPartitionAttribute());
        }
    }

    public void replacePredictionTarget(DynamicApplyOutputColumnType dynamicApplyOutputColumnType, DynamicApplyOutputColumnType dynamicApplyOutputColumnType2) {
        List list = this._dynamicApplyOutputColumns.getDynamicApplyOutputColumn();
        String string = DynamicApplyHelper.getColumnName(dynamicApplyOutputColumnType);
        DynamicApplyOutputColumnType dynamicApplyOutputColumnType3 = null;
        for (DynamicApplyOutputColumnType dynamicApplyOutputColumnType4 : list) {
            String string2 = DynamicApplyHelper.getColumnName(dynamicApplyOutputColumnType4);
            if (!string2.equals(string)) continue;
            dynamicApplyOutputColumnType3 = dynamicApplyOutputColumnType4;
            break;
        }
        if (dynamicApplyOutputColumnType3 != null) {
            list.remove(dynamicApplyOutputColumnType3);
            list.add(dynamicApplyOutputColumnType2);
        }
        this.updatePredictionOutputsModel();
        this.constructDynamicApplyOutputColumnMaps();
    }

    public void removePredictionOutputColumnsFromList(List<DynamicApplyOutputColumnType> list) {
        List list2 = this._dynamicApplyOutputColumns.getDynamicApplyOutputColumn();
        list2.removeAll(list);
        this.updatePredictionOutputsModel();
        this.constructDynamicApplyOutputColumnMaps();
        for (DynamicApplyOutputColumnType dynamicApplyOutputColumnType : list) {
            this.removeUniqueName(dynamicApplyOutputColumnType);
        }
    }

    public boolean isApplyOutputColumnListEmpty() {
        return this._dynamicApplyOutputColumns.getDynamicApplyOutputColumn().isEmpty();
    }

    public abstract void updatePredictionOutputsModel();

    protected void constructDynamicApplyOutputColumnMaps() {
    }
}

