/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.dynamic.partition;

import java.util.List;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.workflow.dialog.dynamic.partition.PartitionLrb;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressionType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressions;

public class PartitionTableModel
extends ODMrTableModel<PartitionExpressionType> {
    private static final String[] _columnNames = new String[]{PartitionLrb.get("PARTITION_TABLE_COLUMN_NAME"), PartitionLrb.get("PARTITION_TABLE_COLUMN_DATA_TYPE"), PartitionLrb.get("PARTITION_TABLE_COLUMN_TYPE")};
    private static String EXPRESSION = PartitionLrb.get("PARTITION_TABLE_COLUMN_TYPE_EXPRESSION");
    private static String COLUMN = PartitionLrb.get("PARTITION_TABLE_COLUMN_TYPE_COLUMN");
    public static final int NAME = 0;
    public static final int DATA_TYPE = 1;
    public static final int TYPE = 2;

    public PartitionTableModel(PartitionExpressions partitionExpressions) {
        List list = partitionExpressions.getPartitionExpression();
        for (PartitionExpressionType partitionExpressionType : list) {
            this.srcData.add(partitionExpressionType);
        }
        this.setColumnIdentifiers(_columnNames);
    }

    public Object getValueAt(int n, int n2) {
        PartitionExpressionType partitionExpressionType = (PartitionExpressionType)this.srcData.get(n);
        String string = partitionExpressionType.getSQLExpression();
        AttributeType attributeType = partitionExpressionType.getPartitionAttribute();
        String string2 = null;
        if (n2 == 0) {
            if (string == null) {
                assert (attributeType != null);
                string2 = attributeType.getName();
            } else {
                string2 = attributeType.getName();
            }
        } else if (n2 == 1) {
            String string3 = attributeType.getDataType();
            String string4 = attributeType.getDataTypeQualifier();
            string2 = DatabaseMetadataUtils.isACharacterOracleDataType(string3) ? DatabaseMetadataUtils.getJSONDataType(string3, string4) : string3;
        } else if (n2 == 2) {
            string2 = string == null ? COLUMN : EXPRESSION;
        } else assert (false) : "Out of bounds column when accessing items";
        return string2 != null ? string2 : "";
    }

    public void RefreshModel(PartitionExpressions partitionExpressions) {
        List list = partitionExpressions.getPartitionExpression();
        this.srcData.clear();
        for (PartitionExpressionType partitionExpressionType : list) {
            this.srcData.add(partitionExpressionType);
        }
        this.fireTableDataChanged();
    }

    public PartitionExpressions getModel() {
        PartitionExpressions partitionExpressions = new PartitionExpressions();
        for (int i = 0; i < this.srcData.size(); ++i) {
            PartitionExpressionType partitionExpressionType = (PartitionExpressionType)this.srcData.get(i);
            partitionExpressions.getPartitionExpression().add(partitionExpressionType);
        }
        return partitionExpressions;
    }

    public void moveRow2(int n, int n2) {
        PartitionExpressionType partitionExpressionType = (PartitionExpressionType)this.srcData.get(n);
        this.srcData.remove(n);
        this.srcData.add(n2, partitionExpressionType);
        this.fireTableDataChanged();
    }
}

