/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.jsonQuery;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.table.DefaultTableCellRenderer;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.AggregationPanel;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.JSONQueryEditorPanel;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.JSONAttributeType;
import oracle.ide.Context;
import oracle.javatools.icons.OracleIcons;

public abstract class JSONDataMinerTablePanel
extends DataMinerTablePanel {
    protected int numberOfAttributes = 0;
    protected JSONQueryEditorPanel _parent;
    protected AggregationPanel _enclosingPanel;
    protected Context _context;
    private JToggleButton showBtn = new JToggleButton(DialogsLrb.get("JSON_QUERY_PREVIEW_DATA_SHOW_PATH"), DataMinerIcons.get(Icons.SHOW_JSON_PATH));
    private JButton addBtn;
    private JButton editBtn;
    private JButton removeBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));

    public void setParent(Context context, JSONQueryEditorPanel jSONQueryEditorPanel, AggregationPanel aggregationPanel) {
        this._parent = jSONQueryEditorPanel;
        this._context = context;
        this._enclosingPanel = aggregationPanel;
    }

    protected abstract boolean showAddButton();

    protected abstract boolean showEditButton();

    public void initRes() {
        this.showBtn.setToolTipText(DialogsLrb.get("JSON_QUERY_PREVIEW_DATA_SHOW_PATH_TOOLTIP"));
        this.showBtn.setSelected(true);
    }

    public void initUI() {
        this.showBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSONDataMinerTablePanel.this.showJSONPaths();
            }
        });
        if (this.showAddButton()) {
            this.addBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
            this.addBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JSONDataMinerTablePanel.this.addAction(actionEvent);
                }
            });
            this.addBtn.setToolTipText(DialogsLrb.get("JSON_QUERY_AGGREGATION_ADD_ELEMENT"));
            this.addBtn.setEnabled(false);
        }
        if (this.showEditButton()) {
            this.editBtn = new JButton(this.getEditIcon());
            this.editBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JSONDataMinerTablePanel.this.editAction(actionEvent);
                }
            });
            this.setToolTip(this.editBtn);
            this.enableEditBtn(false);
        }
        this.removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSONDataMinerTablePanel.this.removeAction(actionEvent);
            }
        });
        this.removeBtn.setToolTipText(DialogsLrb.get("JSON_QUERY_AGGREGATION_DELETE_ELEMENT"));
        this.enableRemoveButton(false);
    }

    protected abstract void setToolTip(JButton var1);

    protected Icon getEditIcon() {
        return OracleIcons.getIcon((String)"edit.png");
    }

    protected abstract void configureSearchField();

    protected void enableEditBtn(boolean bl) {
        this.editBtn.setEnabled(bl);
    }

    public void enableRemoveButton(boolean bl) {
        this.removeBtn.setEnabled(bl);
    }

    @Override
    public void addControlBarComponents(Component ... componentArray) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        arrayList.add(this.showBtn);
        if (this.showAddButton()) {
            arrayList.add(this.addBtn);
        }
        if (this.showEditButton()) {
            arrayList.add(this.editBtn);
        }
        arrayList.add(this.removeBtn);
        for (int i = 0; i < componentArray.length; ++i) {
            arrayList.add(componentArray[i]);
        }
        super.addControlBarComponents(arrayList.toArray(new Component[arrayList.size()]));
    }

    public String getTableHeaderText() {
        return this.getTableTitle() + String.valueOf(this.numberOfAttributes);
    }

    public abstract String getTableTitle();

    protected abstract void showJSONPaths();

    protected void addAction(ActionEvent actionEvent) {
    }

    protected void editAction(ActionEvent actionEvent) {
    }

    protected void removeAction(ActionEvent actionEvent) {
    }

    protected abstract boolean isValidElement(int var1);

    protected boolean isValidJSONAttributeType(JSONAttributeType jSONAttributeType) {
        return jSONAttributeType.getStatus().equals((Object)AttributeStatus.VALID);
    }

    public boolean isShowPath() {
        return this.showBtn.isSelected();
    }

    protected class CustomCellRenderer
    extends DefaultTableCellRenderer {
        int columnIndex;

        CustomCellRenderer(int n) {
            this.columnIndex = n;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            Icon icon = null;
            if (n2 == this.columnIndex) {
                Icon icon2 = icon = JSONDataMinerTablePanel.this.isValidElement(n) ? OracleIcons.getIcon((String)"attribute.png") : OracleIcons.getIcon((String)"warning.png");
            }
            if (icon != null) {
                this.setIcon(icon);
            }
            return component;
        }
    }
}

