/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.model;

import java.awt.Dimension;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.controls.dialog.DialogDisplayable;
import oracle.dmt.dataminer.controls.dialog.Dialogable;
import oracle.dmt.dataminer.controls.dialog.DialogableAdapter;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.dal.Query;
import oracle.dmt.dataminer.core.dal.sql.SqlDataAccessObject;
import oracle.dmt.dataminer.core.dal.sql.queries.common.build.GetPartitionsDefinitionQuery;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.model.common.build.partition.PartitionColumn;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.dmt.dataminer.workflow.dialog.model.DialogsLrb;
import oracle.ide.Context;
import oracle.javatools.ui.BlockingComponent;

public class EditModelNodePartitionDefPanel
extends JPanel
implements DialogDisplayable {
    private String owner;
    private Context context;
    private String modelName;
    private BlockingComponent overlayPanel;
    private ConnectionManager connectionManager;
    private PartitionDefinitionTableModel tableModel;
    private JTable jPartitionKeysTab;
    private JScrollPane jScrollPane1;

    public EditModelNodePartitionDefPanel(Context context, String string, String string2) {
        this.owner = string;
        this.context = context;
        this.modelName = string2;
        this.connectionManager = ConnectionFolder.getConnectionFolder(context);
        this.initComponents();
        this.initUI();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jPartitionKeysTab = new JTable();
        this.jScrollPane1.setViewportView(this.jPartitionKeysTab);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGap(15, 15, 15).addComponent(this.jScrollPane1, -1, 375, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 278, Short.MAX_VALUE));
    }

    private void initUI() {
        this.overlayPanel = new BlockingComponent((JComponent)this);
        this.tableModel = new PartitionDefinitionTableModel(this.owner, this.modelName);
        this.jPartitionKeysTab.setModel((TableModel)((Object)this.tableModel));
    }

    public void load() {
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    @Override
    public Dialogable asDialog() {
        return new DialogableAdapter(){

            @Override
            public void customizeDialogProperties(JEWTDialog jEWTDialog) {
                super.customizeDialogProperties(jEWTDialog);
                jEWTDialog.setMaximumInitialSize(new Dimension(1200, 500));
            }

            @Override
            public int getButtonMask() {
                return 3;
            }

            @Override
            public String getTitle() {
                return DialogsLrb.get("MODEL_NODE_PARTITION_KEYS");
            }

            @Override
            public String getHelpTopic() {
                return null;
            }

            @Override
            public JComponent getContent() {
                return EditModelNodePartitionDefPanel.this.overlayPanel.getBlockingComponent();
            }
        };
    }

    private class LoadUI
    extends ODMrSwingWorker<List<PartitionColumn>, Void> {
        private SqlDataAccessObject dao;
        private GetPartitionsDefinitionQuery query;

        private LoadUI() {
            super(EditModelNodePartitionDefPanel.this, EditModelNodePartitionDefPanel.this.overlayPanel);
            this.dao = new SqlDataAccessObject(EditModelNodePartitionDefPanel.this.connectionManager);
        }

        @Override
        protected void onSuccess(List<PartitionColumn> list) throws Exception {
            for (PartitionColumn partitionColumn : list) {
                EditModelNodePartitionDefPanel.this.tableModel.addRow(partitionColumn);
            }
        }

        @Override
        protected List<PartitionColumn> doInBackground() throws Exception {
            ModelDescriptor modelDescriptor = new ModelDescriptor(EditModelNodePartitionDefPanel.this.owner, EditModelNodePartitionDefPanel.this.modelName);
            this.query = new GetPartitionsDefinitionQuery(EditModelNodePartitionDefPanel.this.connectionManager.getDbVersion(), modelDescriptor);
            return this.dao.readItems((Query)this.query);
        }
    }

    private static class PartitionDefinitionTableModel
    extends ODMrTableModel<PartitionColumn> {
        private static final int NAME = 0;
        private static final int DATATYPE = 1;
        private static final int DATASOURCE = 2;
        private static final String[] COLUMNS = new String[]{DialogsLrb.get("MODEL_NODE_COLUMN_NAME"), DialogsLrb.get("MODEL_NODE_TARGET_DATA_TYPE"), DialogsLrb.get("MODEL_NODE_SOURCE")};
        private String modelName;
        private String owner;

        public PartitionDefinitionTableModel(String string, String string2) {
            super(COLUMNS);
            this.owner = string;
            this.modelName = string2;
        }

        public Object getValueAt(int n, int n2) {
            PartitionColumn partitionColumn = (PartitionColumn)this.srcData.get(n);
            String string = null;
            switch (n2) {
                case 0: {
                    string = partitionColumn.getColumnName();
                    break;
                }
                case 1: {
                    string = partitionColumn.getDataType();
                    break;
                }
                case 2: {
                    string = partitionColumn.getDataSource();
                    break;
                }
                default: {
                    assert (false) : "Not a valid column";
                    break;
                }
            }
            return string;
        }

        public String getColumnName(int n) {
            return COLUMNS[n];
        }

        public int getColumnCount() {
            return COLUMNS.length;
        }

        public boolean isCellEditable(int n, int n2) {
            return true;
        }
    }
}

