/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListSelectionModel;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.controls.dialog.DialogHelper;
import oracle.dmt.dataminer.controls.models.SimpleBaseTableModel;
import oracle.dmt.dataminer.core.model.common.NameValuePair;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.utils.ConverterHelper;
import oracle.dmt.dataminer.utils.TimeUtils;
import oracle.dmt.dataminer.utils.comparator.NameValuePairComparator;
import oracle.dmt.dataminer.workflow.dialog.transformations.AddEditCategoricalBinAssignmentDlg;
import oracle.dmt.dataminer.workflow.dialog.transformations.BinningDatePickerPanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.BinningDetailsNumeric;
import oracle.dmt.dataminer.workflow.dialog.transformations.BinningPanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.CustomBinningType;
import oracle.dmt.dataminer.workflow.dialog.transformations.EditCustomNumericBinningPanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.NullBinsSelectionPanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationStatisticsState;
import oracle.dmt.dataminer.workflow.dialog.transformations.XformDialogsLrb;
import oracle.dmt.dataminer.workflow.xmlschema.BinLabels;
import oracle.dmt.dataminer.workflow.xmlschema.CategoricalBin;
import oracle.dmt.dataminer.workflow.xmlschema.DateBin;
import oracle.dmt.dataminer.workflow.xmlschema.NumericBin;
import oracle.dmt.dataminer.workflow.xmlschema.StringCollection;
import oracle.dmt.dataminer.workflow.xmlschema.TimestampTimezoneBin;
import oracle.dmt.dataminer.workflow.xmlschema.TransformNulls;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationType;
import oracle.ide.Ide;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.table.GenericTable;

public abstract class BinningCustomBase
extends JPanel
implements BinningDetailsNumeric,
CustomBinningType {
    private static final Logger theLogger = Logger.getLogger(BinningCustomBase.class.getName());
    protected Object customBinning;
    private String binningType;
    protected int dataType;
    private TransformationStatisticsState _state;
    private String srcColumnName;
    private String srcColumnType;
    protected static final String SHOW_BIN_REASSIGNEMNET_WARNING = "bin_reassignment_warning";
    protected TransformNulls transformNulls;
    protected DataMinerTable _jAttributesTable = new DataMinerTable();
    protected JButton resetBtn;
    protected JButton removeBtn;
    protected JButton editBtn;
    protected JButton addBtn;
    protected JToggleButton labelsBtn;
    protected static Icon editIcon = InspectorArb.getIcon((int)24);
    protected static Icon labelsUpIcon = DataMinerIcons.get(Icons.CUSTOM_TRANSFORMATION_LABEL_UP_ICON);
    protected static Icon labelsDownIcon = DataMinerIcons.get(Icons.CUSTOM_TRANSFORMATION_LABEL_DOWN_ICON);
    protected static String labelsTextTipEditable = XformDialogsLrb.get("TRANSFORMATION_CUSTOM_BINNING_LABELS_EDIT_TOOLTIP");
    protected static String labelsTextTipAuto = XformDialogsLrb.get("TRANSFORMATION_CUSTOM_BINNING_LABELS_AUTO_TOOLTIP");
    protected static String _default_other = XformDialogsLrb.get("CUSTOM_BINNING_PANEL_OTHER_DEFAULT");
    private static final String _EDIT_FIELD = "_EDIT_FIELD";
    private static final String _EXPLANATION_LABEL = "_EXPLANATION_LABEL";
    static String _status = XformDialogsLrb.get("CUSTOM_BINNING_PANEL_STATUS");
    static String _loading = XformDialogsLrb.get("CUSTOM_BINNING_PANEL_STATUS_LOADING");
    static String _bin_names = XformDialogsLrb.get("CUSTOM_BINNING_PANEL_BIN_NAMES");
    static String _bin_values = XformDialogsLrb.get("CUSTOM_BINNING_PANEL_BIN_VALUES");
    static String _bin_Lower_bound = XformDialogsLrb.get("CUSTOM_BINNING_PANEL_LOWER_BOUND");
    static String _bin_ranges = XformDialogsLrb.get("CUSTOM_BINNING_PANEL_RANGES_COLUMN");
    static int _BIN_NAME = 0;
    static int _BIN_VALUE = 1;
    static int _BIN_RANGE = 2;
    private String[] _columnNames;

    public BinningCustomBase(String string, String string2, TransformationStatisticsState transformationStatisticsState, String string3, Object object, int n, TransformNulls transformNulls) {
        this.srcColumnName = StringUtils.addDoubleQuotes(string);
        this.srcColumnType = string2;
        this._state = transformationStatisticsState;
        this.binningType = string3;
        this.dataType = n;
        this.transformNulls = transformNulls;
        if (object != null) {
            this.customBinning = object;
        } else if (n == 2) {
            this.customBinning = new TransformationType.Binning.CustomCategorical();
        } else if (n == 1) {
            TransformationType.Binning.CustomNumeric customNumeric = new TransformationType.Binning.CustomNumeric();
            BinLabels binLabels = new BinLabels();
            binLabels.setRange(new BinLabels.Range());
            customNumeric.setBinLabels(binLabels);
            this.customBinning = customNumeric;
        } else if (n == 3 || n == 4 || n == 5) {
            this.customBinning = new TransformationType.Binning.CustomDate();
        } else if (n == 6) {
            this.customBinning = new TransformationType.Binning.CustomTimestamp();
        }
    }

    protected void loadComponents() {
        this.initRes();
        this.initUI();
    }

    public boolean isInvalidRange() {
        return false;
    }

    @Override
    public TransformNulls getResultTransformNulls() {
        String string;
        if (null != this.getLabelExplanation() && !this.getLabelExplanation().isValidBinValue()) {
            return null;
        }
        TransformNulls transformNulls = AttributeTypeHelper.cloneTransformNulls(this.transformNulls);
        if (null != this.getTxtNullValue()) {
            string = StringUtils.trimSingleQuotes(this.getTxtNullValue().getText());
            string = StringUtils.escapeSingleQuotesForSQL(string);
            transformNulls.setLabel(StringUtils.addSingleQuotes(string));
        }
        if (null != this.getLabelExplanation()) {
            string = this.getLabelExplanation().getNullValuePlacementSelection();
            transformNulls.setNullBinsSelection(string);
            transformNulls.setNullBinId(BigInteger.valueOf(this.getLabelExplanation().geMaxBinId()));
        }
        return transformNulls;
    }

    @Override
    public TransformNulls getSrcTransformNulls() {
        return this.transformNulls;
    }

    protected abstract JLabel getJLabelOther();

    protected abstract JCheckBox getCheckBoxBoxXformNulls();

    protected abstract NullBinsSelectionPanel getLabelExplanation();

    public abstract JPanel getHostPanel();

    protected abstract void addTransfromNullsActionListener();

    public abstract JTextField getJTextFieldOther();

    public JTextField getTxtNullValue() {
        return null;
    }

    public abstract void enableNullBins(boolean var1);

    protected abstract ComponentWithTitlebar<JComponent> getComponentWithTitlebar();

    public void initRes() {
        if (this.customBinning instanceof TransformationType.Binning.CustomDate || this.customBinning instanceof TransformationType.Binning.CustomTimestamp) {
            if (null != this.getJLabelOther()) {
                this.getJLabelOther().setVisible(false);
                this.getJTextFieldOther().setVisible(false);
            }
        } else if (this.customBinning instanceof TransformationType.Binning.CustomCategorical) {
            this.getJLabelOther().setText(XformDialogsLrb.get("CUSTOM_BINNING_PANEL_OTHER"));
            this.getJLabelOther().setLabelFor(this.getJTextFieldOther());
        }
        this.getCheckBoxBoxXformNulls().setText(_TRANSFORM_NULLS);
        this.getCheckBoxBoxXformNulls().setSelected(this.transformNulls.isIncludeNulls());
        this.addTransfromNullsActionListener();
    }

    protected String getOther(TransformationType.Binning.CustomCategorical customCategorical) {
        String string = null;
        for (CategoricalBin categoricalBin : customCategorical.getCategoricalBin()) {
            if (!categoricalBin.isIsOther()) continue;
            string = categoricalBin.getName();
            break;
        }
        return string != null ? string : _default_other;
    }

    protected boolean isNumericNumbers() {
        TransformationType.Binning.CustomNumeric customNumeric = (TransformationType.Binning.CustomNumeric)this.customBinning;
        boolean bl = customNumeric.getBinLabels() != null && customNumeric.getBinLabels().getNumberSequence() != null;
        return bl;
    }

    protected boolean isDateNumbers() {
        TransformationType.Binning.CustomDate customDate = (TransformationType.Binning.CustomDate)this.customBinning;
        boolean bl = customDate.getBinLabels() != null && customDate.getBinLabels().getNumberSequence() != null;
        return bl;
    }

    protected boolean isTimestampNumbers() {
        TransformationType.Binning.CustomTimestamp customTimestamp = (TransformationType.Binning.CustomTimestamp)this.customBinning;
        boolean bl = customTimestamp.getBinLabels() != null && customTimestamp.getBinLabels().getNumberSequence() != null;
        return bl;
    }

    public void initUI() {
        BinsTableModel binsTableModel = null;
        if (this.isCustomCategoricalBinning()) {
            binsTableModel = new BinsTableModel(BinningCustomBase.fromCustomCategoricaltoNameValuePairs(this.customBinning), false);
            if (null != this.getJTextFieldOther()) {
                this.getJTextFieldOther().setText(this.getOther((TransformationType.Binning.CustomCategorical)this.customBinning));
            }
        } else if (this.customBinning instanceof TransformationType.Binning.CustomNumeric) {
            binsTableModel = new ExBinsTableModel(BinningCustomBase.fromCustomNumerictoNameValuePairs(this.customBinning), this.isNumericNumbers());
        } else if (this.customBinning instanceof TransformationType.Binning.CustomDate) {
            binsTableModel = new ExBinsTableModel(BinningCustomBase.fromCustomDatetoNameValuePairs(this.customBinning), this.isDateNumbers());
        } else if (this.customBinning instanceof TransformationType.Binning.CustomTimestamp) {
            binsTableModel = new ExBinsTableModel(BinningCustomBase.fromCustomTimestamptoNameValuePairs(this.customBinning), this.isTimestampNumbers());
        }
        if (!this.isCustomCategoricalBinning()) {
            this.labelsBtn = new JToggleButton(labelsDownIcon);
            this.labelsBtn.setToolTipText(labelsTextTipEditable);
            this.labelsBtn.setSelected(true);
            this.labelsBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
                    if (jToggleButton.isSelected()) {
                        BinningCustomBase.this.labelsBtn.setIcon(labelsDownIcon);
                        BinningCustomBase.this.labelsBtn.setToolTipText(labelsTextTipEditable);
                    } else {
                        BinningCustomBase.this.labelsBtn.setIcon(labelsUpIcon);
                        BinningCustomBase.this.labelsBtn.setToolTipText(labelsTextTipAuto);
                    }
                }
            });
        }
        if (null != this.getHostPanel()) {
            this.getHostPanel().add(_EDIT_FIELD, this.getTxtNullValue());
            this.getHostPanel().add(_EXPLANATION_LABEL, this.getLabelExplanation());
        }
        this.resetBtn = new JButton(XformDialogsLrb.get("CUSTOM_RESET_BUTTON"));
        this.resetBtn.setToolTipText(XformDialogsLrb.get("TOOLTIP_CUSTOM_RESET_BUTTON"));
        this.removeBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this.removeBtn.setToolTipText(XformDialogsLrb.get("TOOLTIP_REMOVE_BIN_DEFINITION"));
        this.editBtn = new JButton(editIcon);
        this.editBtn.setToolTipText(XformDialogsLrb.get("TOOLTIP_EDIT_BIN_DEFINITION"));
        this.addBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
        this.addBtn.setToolTipText(XformDialogsLrb.get("TOOLTIP_ADD_BIN_DEFINITION"));
        this.editBtn.setEnabled(false);
        this.removeBtn.setEnabled(false);
        this.addBtn.setEnabled(false);
        ControlBar controlBar = new ControlBar();
        if (this.labelsBtn != null) {
            controlBar.add((Component)this.labelsBtn);
        }
        controlBar.add((Component)this.resetBtn);
        controlBar.add((Component)this.editBtn);
        controlBar.add((Component)this.removeBtn);
        controlBar.add((Component)this.addBtn);
        this.setupItemsTable(binsTableModel, this._jAttributesTable);
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this._jAttributesTable));
        this.getComponentWithTitlebar().setComponent((JComponent)jScrollPane);
        this.getComponentWithTitlebar().setLabel(new JLabel(XformDialogsLrb.get("CUSTOM_BINNING_PANEL_BIN_VALUES_TABLE")));
        if (this.customBinning instanceof TransformationType.Binning.CustomDate || this.customBinning instanceof TransformationType.Binning.CustomTimestamp) {
            this._jAttributesTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    ListSelectionModel listSelectionModel;
                    if (mouseEvent.getClickCount() == 2 && !(listSelectionModel = BinningCustomBase.this._jAttributesTable.getSelectionModel()).isSelectionEmpty() && listSelectionModel.getMinSelectionIndex() == listSelectionModel.getMaxSelectionIndex()) {
                        GregorianCalendar gregorianCalendar;
                        SimpleDateFormat simpleDateFormat;
                        int[] nArray = BinningCustomBase.this._jAttributesTable.getSelectedRowsInModel();
                        BinsTableModel binsTableModel = (BinsTableModel)((Object)BinningCustomBase.this._jAttributesTable.getModel());
                        if (nArray == null || nArray.length != 1) {
                            return;
                        }
                        Vector vector = binsTableModel.getDataVector();
                        NameValuePair nameValuePair = (NameValuePair)vector.get(nArray[0]);
                        boolean bl = BinningCustomBase.this.customBinning instanceof TransformationType.Binning.CustomTimestamp;
                        String string = nameValuePair.getValue().toString();
                        if (string.equals(TransformationStatisticsState.NO_LOWER_BOUND)) {
                            simpleDateFormat = (NameValuePair)vector.get(1);
                            string = simpleDateFormat.getValue().toString();
                        }
                        if ((gregorianCalendar = BinningCustomBase.toDate(simpleDateFormat = bl ? TimeUtils.getShortSimpleDateFormatZoneRFCTZ() : TimeUtils.getShortSimpleDateFormatZoneRFC2(), string, bl)) == null) {
                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)XformDialogsLrb.get("CUSTOM_TRANSFORMATION_DIALOG_OUT_OF_BOUNDS_BOUNDS"), (String)XformDialogsLrb.get("CUSTOM_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
                            return;
                        }
                        BinningDatePickerPanel binningDatePickerPanel = new BinningDatePickerPanel(BinningCustomBase.this._state.getContext(), gregorianCalendar, bl, BinningCustomBase.this, nArray[0], vector, BinningCustomBase.this.labelsBtn.isSelected());
                        if (binningDatePickerPanel.showAsDialog(BinningCustomBase.this)) {
                            Calendar calendar = binningDatePickerPanel.getCalendar();
                            Date date = calendar.getTime();
                            TimeZone timeZone = calendar.getTimeZone();
                            simpleDateFormat.setTimeZone(timeZone);
                            StringBuffer stringBuffer = new StringBuffer();
                            simpleDateFormat.format(date, stringBuffer, new FieldPosition(0));
                            if (BinningCustomBase.this.labelsBtn.isSelected()) {
                                String string2 = binningDatePickerPanel.getBinLabel();
                                binsTableModel.setValueAt(string2, nArray[0], _BIN_NAME);
                            }
                            binsTableModel.setValueAt(TimeUtils.removeGMT(stringBuffer.toString()), nArray[0], _BIN_VALUE);
                        }
                    }
                }
            });
        } else if (this.customBinning instanceof TransformationType.Binning.CustomCategorical) {
            this._jAttributesTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    ListSelectionModel listSelectionModel;
                    if (mouseEvent.getClickCount() == 2 && !(listSelectionModel = BinningCustomBase.this._jAttributesTable.getSelectionModel()).isSelectionEmpty() && listSelectionModel.getMinSelectionIndex() == listSelectionModel.getMaxSelectionIndex()) {
                        int[] nArray = BinningCustomBase.this._jAttributesTable.getSelectedRowsInModel();
                        BinsTableModel binsTableModel = (BinsTableModel)((Object)BinningCustomBase.this._jAttributesTable.getModel());
                        Vector vector = binsTableModel.getDataVector();
                        String string = BinningCustomBase.this.getJTextFieldOther().getText();
                        NameValuePair nameValuePair = (NameValuePair)vector.get(nArray[0]);
                        AddEditCategoricalBinAssignmentDlg addEditCategoricalBinAssignmentDlg = new AddEditCategoricalBinAssignmentDlg(BinningCustomBase.this._state.getContext(), vector, BinningCustomBase.this._state.getDistinctValues(BinningCustomBase.this.srcColumnName), BinningCustomBase.this._state.getFrequencies(BinningCustomBase.this.srcColumnName), nameValuePair.getName(), string);
                        DialogHelper dialogHelper = new DialogHelper(addEditCategoricalBinAssignmentDlg);
                        if (dialogHelper.showAsDialog(BinningCustomBase.this)) {
                            binsTableModel = new BinsTableModel(addEditCategoricalBinAssignmentDlg.getResults(), false);
                            BinningCustomBase.this.setupItemsTable(binsTableModel, BinningCustomBase.this._jAttributesTable);
                            BinningCustomBase.this.loadCustomCategoricBinning(addEditCategoricalBinAssignmentDlg.getResults());
                        }
                    }
                }
            });
        } else if (this.customBinning instanceof TransformationType.Binning.CustomNumeric) {
            this._jAttributesTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    ListSelectionModel listSelectionModel;
                    if (mouseEvent.getClickCount() == 2 && !(listSelectionModel = BinningCustomBase.this._jAttributesTable.getSelectionModel()).isSelectionEmpty() && listSelectionModel.getMinSelectionIndex() == listSelectionModel.getMaxSelectionIndex()) {
                        int[] nArray = BinningCustomBase.this._jAttributesTable.getSelectedRowsInModel();
                        BinsTableModel binsTableModel = (BinsTableModel)((Object)BinningCustomBase.this._jAttributesTable.getModel());
                        if (nArray != null && nArray.length == 1) {
                            Vector vector = binsTableModel.getDataVector();
                            EditCustomNumericBinningPanel editCustomNumericBinningPanel = new EditCustomNumericBinningPanel(BinningCustomBase.this._state.getContext(), BinningCustomBase.this, nArray[0], vector, BinningCustomBase.this.labelsBtn.isSelected());
                            if (editCustomNumericBinningPanel.showAsDialog(BinningCustomBase.this)) {
                                binsTableModel.setRowData(editCustomNumericBinningPanel.getEditedValue(), nArray[0]);
                            }
                        }
                    }
                }
            });
        }
        this.removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Vector<NameValuePair> vector;
                int[] nArray = BinningCustomBase.this._jAttributesTable.getSelectedRowsInModel();
                int n = nArray[0];
                BinsTableModel binsTableModel = (BinsTableModel)((Object)BinningCustomBase.this._jAttributesTable.getModel());
                Vector vector2 = binsTableModel.getDataVector();
                Vector<NameValuePair> vector3 = new Vector<NameValuePair>();
                for (int i = 0; i < nArray.length; ++i) {
                    vector3.add((NameValuePair)vector2.get(nArray[i]));
                    if (n <= nArray[i]) continue;
                    n = nArray[i];
                }
                --n;
                Vector<NameValuePair> vector4 = new Vector<NameValuePair>();
                vector4.addAll(vector2);
                for (NameValuePair nameValuePair : vector3) {
                    vector4.remove(nameValuePair);
                }
                if (BinningCustomBase.this.isCustomNumericBinning()) {
                    vector = BinningCustomBase.this.adjustCustomNumericBinning(BinningCustomBase.this.labelsBtn.isSelected(), vector4);
                    BinningCustomBase.this.loadCustomNumericBinning(vector);
                    binsTableModel = new ExBinsTableModel(vector, BinningCustomBase.this.isNumericNumbers());
                    BinningCustomBase.this.setExplanation((TransformationType.Binning.CustomNumeric)BinningCustomBase.this.customBinning);
                } else if (BinningCustomBase.this.isCustomCategoricalBinning()) {
                    BinningCustomBase.this.loadCustomCategoricBinning(vector4);
                    binsTableModel = new BinsTableModel(vector4, false);
                } else if (BinningCustomBase.this.isCustomDateBinning()) {
                    vector = BinningCustomBase.this.adjustCustomDateBinning(BinningCustomBase.this.labelsBtn.isSelected(), vector4);
                    BinningCustomBase.this.loadCustomDateBinning(vector);
                    binsTableModel = new ExBinsTableModel(vector, BinningCustomBase.this.isDateNumbers());
                    BinningCustomBase.this.setExplanation((TransformationType.Binning.CustomDate)BinningCustomBase.this.customBinning);
                } else if (BinningCustomBase.this.isCustomTimestampBinning()) {
                    vector = BinningCustomBase.this.adjustCustomDateBinning(BinningCustomBase.this.labelsBtn.isSelected(), vector4);
                    BinningCustomBase.this.loadCustomTimestampBinning(vector);
                    binsTableModel = new ExBinsTableModel(vector, BinningCustomBase.this.isTimestampNumbers());
                    BinningCustomBase.this.setExplanation((TransformationType.Binning.CustomTimestamp)BinningCustomBase.this.customBinning);
                }
                BinningCustomBase.this.setupItemsTable(binsTableModel, BinningCustomBase.this._jAttributesTable);
                if (n != -1) {
                    BinningCustomBase.this._jAttributesTable.setSelectedRowInModel(n);
                }
            }
        });
        this.editBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                NameValuePair nameValuePair;
                Object object2;
                Object object3;
                Object object4;
                int[] nArray = BinningCustomBase.this._jAttributesTable.getSelectedRowsInModel();
                if (BinningCustomBase.this.isCustomNumericBinning()) {
                    object4 = (BinsTableModel)((Object)BinningCustomBase.this._jAttributesTable.getModel());
                    object3 = object4.getDataVector();
                    object2 = new EditCustomNumericBinningPanel(BinningCustomBase.this._state.getContext(), BinningCustomBase.this, nArray[0], (Vector<NameValuePair>)object3, BinningCustomBase.this.labelsBtn.isSelected());
                    if (((DialogDisplayer)object2).showAsDialog(BinningCustomBase.this)) {
                        object4.setRowData(((EditCustomNumericBinningPanel)object2).getEditedValue(), nArray[0]);
                    }
                }
                if (BinningCustomBase.this.isCustomCategoricalBinning()) {
                    object4 = (BinsTableModel)((Object)BinningCustomBase.this._jAttributesTable.getModel());
                    object3 = object4.getDataVector();
                    object2 = BinningCustomBase.this.getJTextFieldOther().getText();
                    nameValuePair = (NameValuePair)((Vector)object3).get(nArray[0]);
                    AddEditCategoricalBinAssignmentDlg addEditCategoricalBinAssignmentDlg = new AddEditCategoricalBinAssignmentDlg(BinningCustomBase.this._state.getContext(), (Vector<NameValuePair>)object3, BinningCustomBase.this._state.getDistinctValues(BinningCustomBase.this.srcColumnName), BinningCustomBase.this._state.getFrequencies(BinningCustomBase.this.srcColumnName), nameValuePair.getName(), (String)object2);
                    object = new DialogHelper(addEditCategoricalBinAssignmentDlg);
                    if (((DialogHelper)object).showAsDialog(BinningCustomBase.this)) {
                        object4 = new BinsTableModel(addEditCategoricalBinAssignmentDlg.getResults(), false);
                        BinningCustomBase.this.setupItemsTable((BinsTableModel)((Object)object4), BinningCustomBase.this._jAttributesTable);
                        BinningCustomBase.this.loadCustomCategoricBinning(addEditCategoricalBinAssignmentDlg.getResults());
                    }
                }
                if (!BinningCustomBase.this.isCustomDateBinning() && !BinningCustomBase.this.isCustomTimestampBinning()) {
                    return;
                }
                object4 = BinningCustomBase.this._jAttributesTable.getSelectionModel();
                if (!object4.isSelectionEmpty() && object4.getMinSelectionIndex() == object4.getMaxSelectionIndex()) {
                    GregorianCalendar gregorianCalendar;
                    SimpleDateFormat simpleDateFormat;
                    object3 = (BinsTableModel)((Object)BinningCustomBase.this._jAttributesTable.getModel());
                    object2 = ((BinsTableModel)((Object)object3)).getDataVector();
                    nameValuePair = (NameValuePair)((Vector)object2).get(nArray[0]);
                    boolean bl = BinningCustomBase.this.customBinning instanceof TransformationType.Binning.CustomTimestamp;
                    object = nameValuePair.getValue().toString();
                    if (((String)object).equals(TransformationStatisticsState.NO_LOWER_BOUND)) {
                        simpleDateFormat = (NameValuePair)((Vector)object2).get(1);
                        object = simpleDateFormat.getValue().toString();
                    }
                    if ((gregorianCalendar = BinningCustomBase.toDate(simpleDateFormat = bl ? TimeUtils.getShortSimpleDateFormatZoneRFCTZ() : TimeUtils.getShortSimpleDateFormatZoneRFC2(), object, bl)) == null) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)XformDialogsLrb.get("CUSTOM_TRANSFORMATION_DIALOG_OUT_OF_BOUNDS_BOUNDS"), (String)XformDialogsLrb.get("CUSTOM_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
                        return;
                    }
                    BinningDatePickerPanel binningDatePickerPanel = new BinningDatePickerPanel(BinningCustomBase.this._state.getContext(), gregorianCalendar, bl, BinningCustomBase.this, nArray[0], (Vector<NameValuePair>)object2, BinningCustomBase.this.labelsBtn.isSelected());
                    if (binningDatePickerPanel.showAsDialog(BinningCustomBase.this)) {
                        Calendar calendar = binningDatePickerPanel.getCalendar();
                        Date date = calendar.getTime();
                        TimeZone timeZone = calendar.getTimeZone();
                        simpleDateFormat.setTimeZone(timeZone);
                        StringBuffer stringBuffer = new StringBuffer();
                        simpleDateFormat.format(date, stringBuffer, new FieldPosition(0));
                        if (BinningCustomBase.this.labelsBtn.isSelected()) {
                            String string = binningDatePickerPanel.getBinLabel();
                            ((BinsTableModel)((Object)object3)).setValueAt(string, nArray[0], _BIN_NAME);
                        }
                        ((BinsTableModel)((Object)object3)).setValueAt(TimeUtils.removeGMT(stringBuffer.toString()), nArray[0], _BIN_VALUE);
                    }
                }
            }
        });
        this.addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = BinningCustomBase.this._jAttributesTable.getSelectedRowsInModel();
                BinsTableModel binsTableModel = (BinsTableModel)((Object)BinningCustomBase.this._jAttributesTable.getModel());
                Vector vector = binsTableModel.getDataVector();
                if (BinningCustomBase.this.isCustomNumericBinning()) {
                    NameValuePair nameValuePair = (NameValuePair)vector.get(nArray[0]);
                    NameValuePair nameValuePair2 = (NameValuePair)vector.get(nArray[0] - 1);
                    Object object = nameValuePair.getValue();
                    Object object2 = nameValuePair2.getValue();
                    Vector<NameValuePair> vector2 = new Vector<NameValuePair>();
                    vector2.addAll(vector);
                    Double d = Double.valueOf(object.toString());
                    String[] stringArray = d.toString().split("\\.");
                    int n = stringArray[1].length();
                    NumberFormat numberFormat = NumberFormat.getInstance();
                    numberFormat.setGroupingUsed(false);
                    numberFormat.setMaximumFractionDigits(n);
                    numberFormat.setMinimumFractionDigits(n);
                    numberFormat.setRoundingMode(RoundingMode.HALF_UP);
                    Double d2 = (d + Double.valueOf(object2.toString())) / 2.0;
                    d2 = Double.valueOf(numberFormat.format(d2));
                    if (d2.toString().equals(d.toString()) || d2.toString().equals(object2)) {
                        numberFormat.setMaximumFractionDigits(++n);
                        numberFormat.setMinimumFractionDigits(n);
                        d2 = (d + Double.valueOf(object2.toString())) / 2.0;
                        d2 = Double.valueOf(numberFormat.format(d2));
                    }
                    NameValuePair nameValuePair3 = new NameValuePair(d2 + TransformationStatisticsState.DASH + object, (Object)d2.toString(), 0);
                    int n2 = vector2.indexOf(nameValuePair2);
                    vector2.add(n2 + 1, nameValuePair3);
                    Vector<NameValuePair> vector3 = BinningCustomBase.this.adjustCustomNumericBinning(BinningCustomBase.this.labelsBtn.isSelected(), vector2);
                    BinningCustomBase.this.loadCustomNumericBinning(vector3);
                    binsTableModel = new ExBinsTableModel(vector3, BinningCustomBase.this.isNumericNumbers());
                    BinningCustomBase.this.setupItemsTable(binsTableModel, BinningCustomBase.this._jAttributesTable);
                    BinningCustomBase.this.setExplanation(vector3);
                    vector = binsTableModel.getDataVector();
                    int n3 = -1;
                    for (int i = 0; i < vector.size(); ++i) {
                        NameValuePair nameValuePair4 = (NameValuePair)vector.get(i);
                        if (!nameValuePair4.getValue().equals(nameValuePair3.getValue())) continue;
                        n3 = i;
                        break;
                    }
                    if (n3 != -1) {
                        BinningCustomBase.this._jAttributesTable.setSelectedRowInModel(n3);
                    }
                } else if (BinningCustomBase.this.isCustomDateBinning() || BinningCustomBase.this.isCustomTimestampBinning()) {
                    NameValuePair nameValuePair = (NameValuePair)vector.get(nArray[0]);
                    NameValuePair nameValuePair5 = (NameValuePair)vector.get(nArray[0] - 1);
                    Object object = nameValuePair.getValue();
                    Object object3 = nameValuePair5.getValue();
                    Vector<NameValuePair> vector4 = new Vector<NameValuePair>();
                    vector4.addAll(vector);
                    boolean bl = BinningCustomBase.this.customBinning instanceof TransformationType.Binning.CustomTimestamp;
                    SimpleDateFormat simpleDateFormat = bl ? TimeUtils.getShortSimpleDateFormatZoneRFCTZ() : TimeUtils.getShortSimpleDateFormatZoneRFC2();
                    GregorianCalendar gregorianCalendar = BinningCustomBase.toDate(simpleDateFormat, object, bl);
                    GregorianCalendar gregorianCalendar2 = BinningCustomBase.toDate(simpleDateFormat, object3, bl);
                    Date date = new Date((gregorianCalendar.getTimeInMillis() + gregorianCalendar2.getTimeInMillis()) / 2L);
                    StringBuffer stringBuffer = new StringBuffer();
                    simpleDateFormat.format(date, stringBuffer, new FieldPosition(0));
                    String string = stringBuffer.toString();
                    string = TimeUtils.removeGMT(string);
                    NameValuePair nameValuePair6 = new NameValuePair(string + TransformationStatisticsState.DASH + object, (Object)string, 0);
                    int n = vector4.indexOf(nameValuePair5);
                    vector4.add(n + 1, nameValuePair6);
                    Vector<NameValuePair> vector5 = BinningCustomBase.this.adjustCustomDateBinning(BinningCustomBase.this.labelsBtn.isSelected(), vector4);
                    if (bl) {
                        BinningCustomBase.this.loadCustomTimestampBinning(vector5);
                    } else {
                        BinningCustomBase.this.loadCustomDateBinning(vector5);
                    }
                    binsTableModel = BinningCustomBase.this.isCustomDateBinning() ? new ExBinsTableModel(vector5, BinningCustomBase.this.isDateNumbers()) : new ExBinsTableModel(vector5, BinningCustomBase.this.isTimestampNumbers());
                    BinningCustomBase.this.setupItemsTable(binsTableModel, BinningCustomBase.this._jAttributesTable);
                    BinningCustomBase.this.setExplanation(vector5);
                    vector = binsTableModel.getDataVector();
                    int n4 = -1;
                    for (int i = 0; i < vector.size(); ++i) {
                        NameValuePair nameValuePair7 = (NameValuePair)vector.get(i);
                        if (!nameValuePair7.getValue().equals(nameValuePair6.getValue())) continue;
                        n4 = i;
                        break;
                    }
                    if (n4 != -1) {
                        BinningCustomBase.this._jAttributesTable.setSelectedRowInModel(n4);
                    }
                } else if (BinningCustomBase.this.isCustomCategoricalBinning()) {
                    String string = BinningCustomBase.this.getJTextFieldOther().getText();
                    AddEditCategoricalBinAssignmentDlg addEditCategoricalBinAssignmentDlg = new AddEditCategoricalBinAssignmentDlg(BinningCustomBase.this._state.getContext(), vector, BinningCustomBase.this._state.getDistinctValues(BinningCustomBase.this.srcColumnName), null, null, string);
                    DialogHelper dialogHelper = new DialogHelper(addEditCategoricalBinAssignmentDlg);
                    if (dialogHelper.showAsDialog(BinningCustomBase.this)) {
                        binsTableModel = new BinsTableModel(addEditCategoricalBinAssignmentDlg.getResults(), false);
                        BinningCustomBase.this.setupItemsTable(binsTableModel, BinningCustomBase.this._jAttributesTable);
                        BinningCustomBase.this.loadCustomCategoricBinning(addEditCategoricalBinAssignmentDlg.getResults());
                    }
                }
            }
        });
        this.getComponentWithTitlebar().setControlBar(controlBar);
        this._jAttributesTable.setFillsViewportHeight(true);
        this.resetBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BinningPanel binningPanel;
                if (null != BinningCustomBase.this.labelsBtn && BinningCustomBase.this.labelsBtn.isSelected() && !MessageDialog.optionalConfirm((String)BinningCustomBase.SHOW_BIN_REASSIGNEMNET_WARNING, (Component)Ide.getMainWindow(), (Object)XformDialogsLrb.get("CUSTOM_TRANSFORMATION_DIALOG_LABELS_WARNING"), (String)XformDialogsLrb.get("CUSTOM_TRANSFORMATION_TITLE"), null)) {
                    return;
                }
                int n = BinningCustomBase.this.getBinCount();
                if (n <= 0) {
                    n = 10;
                }
                if ((binningPanel = new BinningPanel(BinningCustomBase.this._state.getContext(), BinningCustomBase.this.srcColumnName, BinningCustomBase.this.srcColumnType, BinningCustomBase.this._state, BinningCustomBase.this.dataType, n, false)).showAsDialog(BinningCustomBase.this)) {
                    LoadDefaultBins loadDefaultBins;
                    TransformationType transformationType = binningPanel.getResultTransformationType();
                    LoadingBinsTableModel loadingBinsTableModel = new LoadingBinsTableModel();
                    BinningCustomBase.this.setupItemsTable(loadingBinsTableModel, BinningCustomBase.this._jAttributesTable);
                    boolean bl = false;
                    if (null != BinningCustomBase.this.getTxtNullValue()) {
                        if (null != transformationType.getBinning()) {
                            if (null != transformationType.getBinning().getCustomNumeric()) {
                                loadDefaultBins = transformationType.getBinning().getCustomNumeric();
                                bl = loadDefaultBins.getBinLabels() != null && loadDefaultBins.getBinLabels().getNumberSequence() != null;
                            } else if (null != transformationType.getBinning().getCustomDate()) {
                                loadDefaultBins = transformationType.getBinning().getCustomDate();
                                bl = loadDefaultBins.getBinLabels() != null && loadDefaultBins.getBinLabels().getNumberSequence() != null;
                            } else if (null != transformationType.getBinning().getCustomTimestamp()) {
                                loadDefaultBins = transformationType.getBinning().getCustomTimestamp();
                                bl = loadDefaultBins.getBinLabels() != null && loadDefaultBins.getBinLabels().getNumberSequence() != null;
                            } else if (null != transformationType.getBinning().getEqualWidth()) {
                                loadDefaultBins = transformationType.getBinning().getEqualWidth();
                                bl = loadDefaultBins.getBinLabels() != null && loadDefaultBins.getBinLabels().getNumberSequence() != null;
                            } else if (null != transformationType.getBinning().getQuantile()) {
                                loadDefaultBins = transformationType.getBinning().getQuantile();
                                bl = loadDefaultBins.getBinLabels() != null && loadDefaultBins.getBinLabels().getNumberSequence() != null;
                            } else if (null != transformationType.getBinning().getDateEqualWidth()) {
                                loadDefaultBins = transformationType.getBinning().getDateEqualWidth();
                                bl = loadDefaultBins.getBinLabels() != null && loadDefaultBins.getBinLabels().getNumberSequence() != null;
                            } else if (null != transformationType.getBinning().getTimestampEqualWidth()) {
                                loadDefaultBins = transformationType.getBinning().getTimestampEqualWidth();
                                bl = loadDefaultBins.getBinLabels() != null && loadDefaultBins.getBinLabels().getNumberSequence() != null;
                            }
                        }
                        BinningCustomBase.this.setNullBinLabelVisible(!bl);
                    }
                    loadDefaultBins = new LoadDefaultBins(transformationType);
                    loadDefaultBins.execute();
                }
            }
        });
        boolean bl = false;
        if (this.isCustomNumericBinning() && this.isNumericNumbers()) {
            bl = true;
        } else if (this.isCustomDateBinning() && this.isDateNumbers()) {
            bl = true;
        } else if (this.isCustomTimestampBinning() && this.isTimestampNumbers()) {
            bl = true;
        }
        this.setNullBinLabelVisible(!bl);
        if (null != this.getTxtNullValue()) {
            String string = StringUtils.trimSingleQuotes(this.transformNulls.getLabel());
            string = StringUtils.getReplacedString(string, "''", "'");
            this.getTxtNullValue().setText(string);
            boolean bl2 = this.transformNulls.isIncludeNulls();
            this.enableNullBins(bl2);
        }
    }

    protected void setNullBinLabelVisible(boolean bl) {
        if (null != this.getTxtNullValue()) {
            this.showEditControl(bl);
            boolean bl2 = this.transformNulls.isIncludeNulls();
            this.enableNullBins(bl2);
            this.updateUI();
        }
    }

    private void showEditControl(boolean bl) {
        if (null != this.getHostPanel()) {
            TransformationType.Binning.CustomTimestamp customTimestamp;
            CardLayout cardLayout = (CardLayout)this.getHostPanel().getLayout();
            if (bl) {
                cardLayout.show(this.getHostPanel(), _EDIT_FIELD);
            } else if (this.customBinning instanceof TransformationType.Binning.CustomNumeric) {
                TransformationType.Binning.CustomNumeric customNumeric = (TransformationType.Binning.CustomNumeric)this.customBinning;
                if (null != customNumeric.getNumericBin() && !customNumeric.getNumericBin().isEmpty()) {
                    this.setExplanation(customNumeric);
                    cardLayout.show(this.getHostPanel(), _EXPLANATION_LABEL);
                }
            } else if (this.customBinning instanceof TransformationType.Binning.CustomDate) {
                TransformationType.Binning.CustomDate customDate = (TransformationType.Binning.CustomDate)this.customBinning;
                if (null != customDate.getDateBin() && !customDate.getDateBin().isEmpty()) {
                    this.setExplanation(customDate);
                    cardLayout.show(this.getHostPanel(), _EXPLANATION_LABEL);
                }
            } else if (this.customBinning instanceof TransformationType.Binning.CustomTimestamp && null != (customTimestamp = (TransformationType.Binning.CustomTimestamp)this.customBinning).getTimestampTimezoneBin() && !customTimestamp.getTimestampTimezoneBin().isEmpty()) {
                this.setExplanation(customTimestamp);
                cardLayout.show(this.getHostPanel(), _EXPLANATION_LABEL);
            }
        }
    }

    private int findMaxNumBinValue(TransformationType.Binning.CustomNumeric customNumeric) {
        int n = 0;
        boolean bl = false;
        if (null != customNumeric.getBinLabels().getNumberSequence()) {
            for (int i = 0; i < customNumeric.getNumericBin().size(); ++i) {
                NumericBin numericBin = (NumericBin)customNumeric.getNumericBin().get(i);
                try {
                    int n2 = Integer.parseInt(numericBin.getBinName());
                    n = Math.max(n2, n);
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                    bl = true;
                }
                if (bl) break;
            }
            if (bl) {
                n = customNumeric.getNumericBin().size();
            }
        } else {
            n = customNumeric.getNumericBin().size();
        }
        if (customNumeric.getBinLabels() != null && customNumeric.getBinLabels().getNumberSequence() != null) {
            return n + 1;
        }
        return n + 2;
    }

    private int findMaxNumBinValue(TransformationType.Binning.CustomDate customDate) {
        int n = 0;
        boolean bl = false;
        if (null != customDate.getBinLabels().getNumberSequence()) {
            for (int i = 0; i < customDate.getDateBin().size(); ++i) {
                DateBin dateBin = (DateBin)customDate.getDateBin().get(i);
                try {
                    int n2 = Integer.parseInt(dateBin.getName());
                    n = Math.max(n2, n);
                }
                catch (Exception exception) {
                    bl = true;
                }
                if (bl) break;
            }
            if (bl) {
                n = customDate.getDateBin().size();
            }
        } else {
            n = customDate.getDateBin().size();
        }
        return n + 1;
    }

    private int findMaxNumBinValue(TransformationType.Binning.CustomTimestamp customTimestamp) {
        int n = 0;
        boolean bl = false;
        if (null != customTimestamp.getBinLabels().getNumberSequence()) {
            for (int i = 0; i < customTimestamp.getTimestampTimezoneBin().size(); ++i) {
                TimestampTimezoneBin timestampTimezoneBin = (TimestampTimezoneBin)customTimestamp.getTimestampTimezoneBin().get(i);
                try {
                    int n2 = Integer.parseInt(timestampTimezoneBin.getName());
                    n = Math.max(n2, n);
                }
                catch (Exception exception) {
                    bl = true;
                }
                if (bl) break;
            }
            if (bl) {
                n = customTimestamp.getTimestampTimezoneBin().size();
            }
        } else {
            n = customTimestamp.getTimestampTimezoneBin().size();
        }
        return n + 1;
    }

    protected int findMaxNumBinValue(Vector<NameValuePair> vector, boolean bl) {
        int n = 0;
        boolean bl2 = false;
        if (bl) {
            for (int i = 0; i < vector.size(); ++i) {
                NameValuePair nameValuePair = vector.get(i);
                try {
                    int n2 = Integer.parseInt(nameValuePair.getName());
                    n = Math.max(n2, n);
                }
                catch (Exception exception) {
                    bl2 = true;
                }
                if (bl2) break;
            }
            if (bl2) {
                n = vector.size();
            }
        } else {
            n = vector.size();
        }
        return n + 1;
    }

    protected abstract void setExplanation(int var1);

    private void setExplanation(TransformationType.Binning.CustomNumeric customNumeric) {
        int n = this.findMaxNumBinValue(customNumeric);
        if (null != this.getLabelExplanation()) {
            this.setExplanation(n);
        }
    }

    private void setExplanation(TransformationType.Binning.CustomDate customDate) {
        int n = this.findMaxNumBinValue(customDate);
        if (null != this.getLabelExplanation()) {
            this.setExplanation(n);
        }
    }

    private void setExplanation(TransformationType.Binning.CustomTimestamp customTimestamp) {
        int n = this.findMaxNumBinValue(customTimestamp);
        if (null != this.getLabelExplanation()) {
            this.setExplanation(n);
        }
    }

    private void setExplanation(Vector<NameValuePair> vector) {
        if (this.customBinning == null) {
            return;
        }
        boolean bl = null != ((TransformationType.Binning.CustomNumeric)this.customBinning).getBinLabels().getNumberSequence();
        int n = this.findMaxNumBinValue(vector, bl);
        if (null != this.getLabelExplanation()) {
            this.setExplanation(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activateDlg() {
        block49: {
            BinningPanel binningPanel;
            int n;
            if (this.isCustomCategoricalBinning()) {
                if (this.customBinning != null && null != ((TransformationType.Binning.CustomCategorical)this.customBinning).getCategoricalBin() && !((TransformationType.Binning.CustomCategorical)this.customBinning).getCategoricalBin().isEmpty()) {
                    return;
                }
            } else if (this.isCustomNumericBinning()) {
                if (this.customBinning != null && null != ((TransformationType.Binning.CustomNumeric)this.customBinning).getNumericBin() && !((TransformationType.Binning.CustomNumeric)this.customBinning).getNumericBin().isEmpty()) {
                    this.setNullBinLabelVisible(!this.isNumericNumbers());
                    return;
                }
            } else if (this.isCustomDateBinning()) {
                if (this.customBinning != null && null != ((TransformationType.Binning.CustomDate)this.customBinning).getDateBin() && !((TransformationType.Binning.CustomDate)this.customBinning).getDateBin().isEmpty()) {
                    this.setNullBinLabelVisible(!this.isDateNumbers());
                    return;
                }
            } else if (this.isCustomTimestampBinning() && this.customBinning != null && null != ((TransformationType.Binning.CustomTimestamp)this.customBinning).getTimestampTimezoneBin() && !((TransformationType.Binning.CustomTimestamp)this.customBinning).getTimestampTimezoneBin().isEmpty()) {
                this.setNullBinLabelVisible(!this.isTimestampNumbers());
                return;
            }
            if ((n = this.getBinCount().intValue()) <= 0) {
                n = 10;
            }
            if (!(binningPanel = new BinningPanel(this._state.getContext(), this.srcColumnName, this.srcColumnType, this._state, this.dataType, n, false)).showAsDialog(this)) break block49;
            TransformationType transformationType = binningPanel.getResultTransformationType();
            String string = null;
            Vector<NameValuePair> vector = null;
            Cursor cursor = this.getCursor();
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                vector = this._state.generateDefaultBinsXform(this.srcColumnName, this.srcColumnType, transformationType.getBinning());
                if (vector == null || vector.isEmpty()) {
                    string = XformDialogsLrb.get("CUSTOM_BINNING_PANEL_NO_BINS");
                } else {
                    Object object;
                    BinsTableModel binsTableModel = null;
                    if (null != transformationType.getBinning().getEqualWidth() || null != transformationType.getBinning().getQuantile()) {
                        object = null != transformationType.getBinning().getEqualWidth() ? transformationType.getBinning().getEqualWidth().getBinLabels() : transformationType.getBinning().getQuantile().getBinLabels();
                        binsTableModel = new ExBinsTableModel(vector, object.getNumberSequence() != null);
                        this.loadCustomNumericBinning(vector);
                        TransformationType.Binning.CustomNumeric customNumeric = (TransformationType.Binning.CustomNumeric)this.customBinning;
                        BinLabels binLabels = new BinLabels();
                        if (null != object.getNumberSequence()) {
                            binLabels.setNumberSequence(new BinLabels.NumberSequence());
                        } else {
                            binLabels.setRange(new BinLabels.Range());
                        }
                        customNumeric.setBinLabels(binLabels);
                        this.setExplanation(customNumeric);
                        this.setNullBinLabelVisible(!this.isNumericNumbers());
                    } else if (null != transformationType.getBinning().getTopN()) {
                        int n2 = -1;
                        for (int i = 0; i < vector.size(); ++i) {
                            if (!vector.get(i).getName().equals(TransformationStatisticsState.LIST_OF_DISTINCT_VALUES)) continue;
                            n2 = i;
                            break;
                        }
                        if (n2 != -1) {
                            this._state.setDistinctValuesFrequencies(this.srcColumnName, ConverterHelper.objectToNameValuePairList(vector.get(n2).getValue()));
                            vector.remove(n2);
                        }
                        binsTableModel = new BinsTableModel(vector, false);
                        this.loadCustomCategoricBinning(vector);
                    } else if (null != transformationType.getBinning().getDateEqualWidth()) {
                        TransformationType.Binning.CustomDate customDate;
                        BinLabels binLabels = transformationType.getBinning().getDateEqualWidth().getBinLabels();
                        binsTableModel = new ExBinsTableModel(vector, binLabels.getNumberSequence() != null);
                        if (this.customBinning instanceof TransformationType.Binning.CustomDate) {
                            this.loadCustomDateBinning(vector);
                            customDate = (TransformationType.Binning.CustomDate)this.customBinning;
                            BinLabels binLabels2 = new BinLabels();
                            if (null != binLabels.getNumberSequence()) {
                                binLabels2.setNumberSequence(new BinLabels.NumberSequence());
                            } else {
                                binLabels2.setRange(new BinLabels.Range());
                            }
                            customDate.setBinLabels(binLabels2);
                            this.setExplanation(customDate);
                            this.setNullBinLabelVisible(!this.isDateNumbers());
                        } else if (this.customBinning instanceof TransformationType.Binning.CustomTimestamp) {
                            this.loadCustomTimestampBinning(vector);
                            customDate = (TransformationType.Binning.CustomTimestamp)this.customBinning;
                            BinLabels binLabels3 = new BinLabels();
                            if (null != binLabels.getNumberSequence()) {
                                binLabels3.setNumberSequence(new BinLabels.NumberSequence());
                            } else {
                                binLabels3.setRange(new BinLabels.Range());
                            }
                            customDate.setBinLabels(binLabels3);
                            this.setExplanation((TransformationType.Binning.CustomTimestamp)customDate);
                            this.setNullBinLabelVisible(!this.isTimestampNumbers());
                        }
                    } else if (null != transformationType.getBinning().getTimestampEqualWidth()) {
                        TransformationType.Binning.CustomDate customDate;
                        BinLabels binLabels = transformationType.getBinning().getTimestampEqualWidth().getBinLabels();
                        binsTableModel = new ExBinsTableModel(vector, binLabels.getNumberSequence() != null);
                        if (this.customBinning instanceof TransformationType.Binning.CustomDate) {
                            this.loadCustomDateBinning(vector);
                            customDate = (TransformationType.Binning.CustomDate)this.customBinning;
                            BinLabels binLabels4 = new BinLabels();
                            if (null != binLabels.getNumberSequence()) {
                                binLabels4.setNumberSequence(new BinLabels.NumberSequence());
                            } else {
                                binLabels4.setRange(new BinLabels.Range());
                            }
                            customDate.setBinLabels(binLabels4);
                            this.setExplanation(customDate);
                            this.setNullBinLabelVisible(!this.isDateNumbers());
                        } else if (this.customBinning instanceof TransformationType.Binning.CustomTimestamp) {
                            this.loadCustomTimestampBinning(vector);
                            customDate = (TransformationType.Binning.CustomTimestamp)this.customBinning;
                            BinLabels binLabels5 = new BinLabels();
                            if (null != binLabels.getNumberSequence()) {
                                binLabels5.setNumberSequence(new BinLabels.NumberSequence());
                            } else {
                                binLabels5.setRange(new BinLabels.Range());
                            }
                            customDate.setBinLabels(binLabels5);
                            this.setExplanation((TransformationType.Binning.CustomTimestamp)customDate);
                            this.setNullBinLabelVisible(!this.isTimestampNumbers());
                        }
                    } else if (null != transformationType.getBinning().getCustomTimestamp()) {
                        BinLabels binLabels = transformationType.getBinning().getDateEqualWidth().getBinLabels();
                        binsTableModel = new ExBinsTableModel(vector, binLabels.getNumberSequence() != null);
                        this.loadCustomTimestampBinning(vector);
                        TransformationType.Binning.CustomTimestamp customTimestamp = (TransformationType.Binning.CustomTimestamp)this.customBinning;
                        BinLabels binLabels6 = new BinLabels();
                        if (null != binLabels.getNumberSequence()) {
                            binLabels6.setNumberSequence(new BinLabels.NumberSequence());
                        } else {
                            binLabels6.setRange(new BinLabels.Range());
                        }
                        customTimestamp.setBinLabels(binLabels6);
                        this.setExplanation(customTimestamp);
                        this.setNullBinLabelVisible(!this.isTimestampNumbers());
                    }
                    if (binsTableModel != null) {
                        this.setupItemsTable(binsTableModel, this._jAttributesTable);
                    }
                    if (this.isCustomCategoricalBinning()) {
                        object = this._jAttributesTable.getSelectedRowsInModel();
                        boolean bl = object != null && ((BinLabels)object).length > 0;
                        this.editBtn.setEnabled(bl);
                    }
                }
                this.setCursor(cursor != null ? cursor : Cursor.getPredefinedCursor(0));
            }
            catch (Exception exception) {
                try {
                    string = exception.getMessage();
                    this.setCursor(cursor != null ? cursor : Cursor.getPredefinedCursor(0));
                }
                catch (Throwable throwable) {
                    this.setCursor(cursor != null ? cursor : Cursor.getPredefinedCursor(0));
                    throw throwable;
                }
            }
            if (string != null) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)XformDialogsLrb.get("CUSTOM_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
                return;
            }
        }
    }

    protected void setupItemsTable(BinsTableModel binsTableModel, GenericTable genericTable) {
        genericTable.setModel((TableModel)((Object)binsTableModel));
        genericTable.setSorted(false);
        genericTable.getSelectionModel().addListSelectionListener(new SelectedItemSelectionHandler(genericTable));
        if (this.isCustomCategoricalBinning()) {
            boolean bl = false;
            int[] nArray = this._jAttributesTable.getSelectedRowsInModel();
            if (nArray != null && nArray.length > 0 && nArray.length == 1) {
                bl = nArray[0] != 0;
            }
            this.editBtn.setEnabled(bl);
        }
    }

    @Override
    public boolean isAuto() {
        return false;
    }

    @Override
    public void setAuto(boolean bl) {
    }

    @Override
    public boolean isLabels() {
        TransformationType.Binning.CustomNumeric customNumeric;
        return !(this.customBinning instanceof TransformationType.Binning.CustomNumeric) || null == (customNumeric = (TransformationType.Binning.CustomNumeric)this.customBinning).getBinLabels().getNumberSequence();
    }

    @Override
    public boolean isDateLabels() {
        if (this.customBinning instanceof TransformationType.Binning.CustomDate) {
            TransformationType.Binning.CustomDate customDate = (TransformationType.Binning.CustomDate)this.customBinning;
            if (null == customDate.getBinLabels()) {
                return false;
            }
            if (null != customDate.getBinLabels().getNumberSequence()) {
                return false;
            }
        } else if (this.customBinning instanceof TransformationType.Binning.CustomTimestamp) {
            TransformationType.Binning.CustomTimestamp customTimestamp = (TransformationType.Binning.CustomTimestamp)this.customBinning;
            if (null == customTimestamp.getBinLabels()) {
                return false;
            }
            if (null != customTimestamp.getBinLabels().getNumberSequence()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void setLabels(boolean bl) {
        if (this.customBinning instanceof TransformationType.Binning.CustomNumeric) {
            TransformationType.Binning.CustomNumeric customNumeric = (TransformationType.Binning.CustomNumeric)this.customBinning;
            if (bl) {
                customNumeric.getBinLabels().setRange(new BinLabels.Range());
            } else {
                customNumeric.getBinLabels().setNumberSequence(new BinLabels.NumberSequence());
            }
        }
    }

    @Override
    public Integer getBinCount() {
        if (this.customBinning != null) {
            Integer n;
            BinsTableModel binsTableModel = (BinsTableModel)((Object)this._jAttributesTable.getModel());
            Vector vector = binsTableModel.getDataVector();
            Integer n2 = n = vector != null && vector.size() > 0 ? Integer.valueOf(vector.size()) : Integer.valueOf(0);
            if (n > 0 && this.isCustomCategoricalBinning()) {
                n = n + 1;
            }
            return n;
        }
        return 0;
    }

    @Override
    public void setBinCount(Integer n) {
    }

    public boolean isCustomBinning() {
        return this.customBinning != null;
    }

    @Override
    public boolean isCustomNumericBinning() {
        if (this.isCustomBinning()) {
            return this.customBinning instanceof TransformationType.Binning.CustomNumeric;
        }
        return false;
    }

    @Override
    public boolean isCustomCategoricalBinning() {
        if (this.isCustomBinning()) {
            return this.customBinning instanceof TransformationType.Binning.CustomCategorical;
        }
        return false;
    }

    @Override
    public boolean isCustomDateBinning() {
        if (this.isCustomBinning()) {
            return this.customBinning instanceof TransformationType.Binning.CustomDate;
        }
        return false;
    }

    @Override
    public boolean isCustomTimestampBinning() {
        if (this.isCustomBinning()) {
            return this.customBinning instanceof TransformationType.Binning.CustomTimestamp;
        }
        return false;
    }

    public Object getCustomBinning() {
        if (this.isCustomCategoricalBinning()) {
            CategoricalBin categoricalBin2;
            TransformationType.Binning.CustomCategorical customCategorical = (TransformationType.Binning.CustomCategorical)this.customBinning;
            List list = customCategorical.getCategoricalBin();
            String string = this.getJTextFieldOther().getText();
            if (string == null) {
                string = _default_other;
            }
            boolean bl = false;
            for (CategoricalBin categoricalBin2 : list) {
                if (!categoricalBin2.isIsOther()) continue;
                categoricalBin2.setName(string);
                bl = true;
                break;
            }
            if (bl) {
                return this.customBinning;
            }
            CategoricalBin categoricalBin3 = new CategoricalBin();
            categoricalBin3.setName(string);
            categoricalBin2 = new StringCollection();
            categoricalBin2.getValue().add(string);
            categoricalBin3.setStringCollectionValues((StringCollection)categoricalBin2);
            categoricalBin3.setIsOther(true);
            list.add(categoricalBin3);
        }
        return this.customBinning;
    }

    protected void loadCustomNumericBinning(List<NameValuePair> list) {
        Vector<NameValuePair> vector = new Vector<NameValuePair>();
        vector.addAll(list);
        this.loadCustomNumericBinning(vector);
    }

    protected void loadCustomNumericBinning(Vector<NameValuePair> vector) {
        if (!this.isCustomNumericBinning()) {
            return;
        }
        TransformationType.Binning.CustomNumeric customNumeric = (TransformationType.Binning.CustomNumeric)this.customBinning;
        List list = customNumeric.getNumericBin();
        list.clear();
        for (int i = 0; i < vector.size(); ++i) {
            Double d;
            Object object;
            NameValuePair nameValuePair = vector.get(i);
            NumericBin numericBin = new NumericBin();
            numericBin.setBinName(nameValuePair.getName());
            if (this.labelsBtn.isSelected() && null != nameValuePair.getEditedName()) {
                numericBin.setBinName(nameValuePair.getEditedName());
            }
            if ((object = nameValuePair.getValue()).equals(TransformationStatisticsState.NO_LOWER_BOUND)) {
                d = vector.get(i + 1);
                try {
                    Double d2 = Double.valueOf(d.getValue().toString());
                    numericBin.setLowerBound(d2.doubleValue());
                }
                catch (Exception exception) {
                    theLogger.log(Level.FINEST, exception.getLocalizedMessage(), exception);
                }
            } else {
                try {
                    d = Double.valueOf(object.toString());
                    numericBin.setLowerBound(d.doubleValue());
                }
                catch (Exception exception) {
                    theLogger.log(Level.FINEST, exception.getLocalizedMessage(), exception);
                }
            }
            list.add(numericBin);
        }
    }

    protected Vector<NameValuePair> adjustCustomNumericBinning(boolean bl, Vector<NameValuePair> vector) {
        if (!this.isCustomNumericBinning()) {
            return new Vector<NameValuePair>();
        }
        boolean bl2 = null != ((TransformationType.Binning.CustomNumeric)this.customBinning).getBinLabels().getNumberSequence();
        Vector<NameValuePair> vector2 = new Vector<NameValuePair>();
        Object object = null;
        int n = 1;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (int i = 0; i < vector.size(); ++i) {
            Object object2;
            Object object3;
            Object object4;
            NameValuePair nameValuePair = vector.get(i);
            Object object5 = nameValuePair.getValue();
            NameValuePair nameValuePair2 = null;
            Object object6 = null;
            if (bl2) {
                object4 = null;
                if (bl && null != nameValuePair.getEditedName()) {
                    object4 = nameValuePair.getEditedName();
                }
                object3 = object4 != null ? object4 : String.valueOf(n);
                object2 = Integer.parseInt((String)object3);
                while (null != hashMap.get(object3)) {
                    object2 = (Integer)object2 + 1;
                    object3 = String.valueOf(object2);
                }
                nameValuePair2 = new NameValuePair((String)object3, object5, n++);
                hashMap.put((String)object3, (Integer)object2);
                nameValuePair2.setEditedName((String)object3);
                object6 = String.valueOf(n - 1);
                nameValuePair2.setRangeValue((String)object6);
            } else {
                if (TransformationStatisticsState.NO_LOWER_BOUND.equals(object5)) {
                    object4 = null;
                    object3 = vector.get(1);
                    object4 = bl ? (null != nameValuePair.getEditedName() ? nameValuePair.getEditedName() : nameValuePair.getName()) : TransformationStatisticsState.UNBOUNDED + object3.getValue();
                    object2 = new NameValuePair((String)object4, (Object)TransformationStatisticsState.NO_LOWER_BOUND, 0);
                    String string = TransformationStatisticsState.UNBOUNDED + object3.getValue();
                    object2.setRangeValue(string);
                    vector2.add(0, (NameValuePair)object2);
                    continue;
                }
                if (object == null) {
                    object = object5;
                }
                if (i < vector.size() - 1) {
                    object4 = vector.get(i + 1);
                    object3 = null;
                    object2 = null;
                    if (bl && null != nameValuePair.getEditedName()) {
                        object3 = object2 = nameValuePair.getEditedName();
                    }
                    if (object3 == null) {
                        object3 = object5.toString() + TransformationStatisticsState.DASH + object4.getValue().toString();
                    }
                    object6 = object5.toString() + TransformationStatisticsState.DASH + object4.getValue().toString();
                    nameValuePair2 = new NameValuePair((String)object3, object5, n++);
                    if (object2 != null) {
                        nameValuePair2.setEditedName((String)object2);
                    }
                    nameValuePair2.setRangeValue((String)object6);
                } else {
                    object4 = null;
                    object3 = null;
                    if (bl && null != nameValuePair.getEditedName()) {
                        object4 = object3 = nameValuePair.getEditedName();
                    }
                    if (object4 == null) {
                        object4 = TransformationStatisticsState.UPPER_BOUND + object5.toString();
                    }
                    object6 = TransformationStatisticsState.UPPER_BOUND + object5.toString();
                    nameValuePair2 = new NameValuePair((String)object4, object5, n++);
                    if (object3 != null) {
                        nameValuePair2.setEditedName((String)object3);
                    }
                    nameValuePair2.setRangeValue((String)object6);
                }
            }
            vector2.add(nameValuePair2);
        }
        return vector2;
    }

    private void loadCustomCategoricBinning(List<NameValuePair> list) {
        Vector<NameValuePair> vector = new Vector<NameValuePair>();
        for (NameValuePair nameValuePair : list) {
            vector.add(nameValuePair);
        }
        this.loadCustomCategoricBinning(vector);
    }

    private void loadCustomCategoricBinning(Vector<NameValuePair> vector) {
        if (!this.isCustomCategoricalBinning()) {
            return;
        }
        TransformationType.Binning.CustomCategorical customCategorical = (TransformationType.Binning.CustomCategorical)this.customBinning;
        List list = customCategorical.getCategoricalBin();
        list.clear();
        for (int i = 0; i < vector.size(); ++i) {
            NameValuePair nameValuePair = vector.get(i);
            CategoricalBin categoricalBin = new CategoricalBin();
            categoricalBin.setName(nameValuePair.getName());
            StringCollection stringCollection = new StringCollection();
            List<String> list2 = ConverterHelper.objectToStringList(nameValuePair.getValue());
            for (String string : list2) {
                stringCollection.getValue().add(string);
            }
            categoricalBin.setStringCollectionValues(stringCollection);
            categoricalBin.setIsOther(false);
            list.add(categoricalBin);
        }
    }

    protected void loadCustomTimestampBinning(List<NameValuePair> list) {
        Vector<NameValuePair> vector = new Vector<NameValuePair>();
        vector.addAll(list);
        this.loadCustomTimestampBinning(vector);
    }

    private void loadCustomTimestampBinning(Vector<NameValuePair> vector) {
        if (!this.isCustomTimestampBinning()) {
            return;
        }
        TransformationType.Binning.CustomTimestamp customTimestamp = (TransformationType.Binning.CustomTimestamp)this.customBinning;
        List list = customTimestamp.getTimestampTimezoneBin();
        list.clear();
        SimpleDateFormat simpleDateFormat = TimeUtils.getShortSimpleDateFormatZoneRFCTZ();
        for (int i = 0; i < vector.size(); ++i) {
            Object object;
            NameValuePair nameValuePair = vector.get(i);
            TimestampTimezoneBin timestampTimezoneBin = new TimestampTimezoneBin();
            timestampTimezoneBin.setName(nameValuePair.getName());
            if (this.labelsBtn.isSelected() && null != nameValuePair.getEditedName()) {
                timestampTimezoneBin.setName(nameValuePair.getEditedName());
            }
            TimestampTimezoneBin.LowerBound lowerBound = new TimestampTimezoneBin.LowerBound();
            Object object2 = nameValuePair.getValue();
            if (object2.equals(TransformationStatisticsState.NO_LOWER_BOUND)) {
                object = vector.get(i + 1);
                try {
                    GregorianCalendar gregorianCalendar = BinningCustomBase.toDate(simpleDateFormat, object.getValue().toString(), true);
                    lowerBound.setValue(TimeUtils.Date2XMLDate(gregorianCalendar));
                    timestampTimezoneBin.setLowerBound(lowerBound);
                }
                catch (Exception exception) {
                    theLogger.log(Level.FINEST, exception.getLocalizedMessage(), exception);
                }
            } else {
                try {
                    if (nameValuePair.getValue() == null) continue;
                    object = BinningCustomBase.toDate(simpleDateFormat, nameValuePair.getValue().toString(), true);
                    lowerBound.setValue(TimeUtils.Date2XMLDate((Calendar)object));
                    timestampTimezoneBin.setLowerBound(lowerBound);
                }
                catch (Exception exception) {
                    theLogger.log(Level.FINEST, exception.getLocalizedMessage(), exception);
                    continue;
                }
            }
            list.add(timestampTimezoneBin);
        }
    }

    protected void loadCustomDateBinning(List<NameValuePair> list) {
        Vector<NameValuePair> vector = new Vector<NameValuePair>();
        vector.addAll(list);
        this.loadCustomDateBinning(vector);
    }

    private void loadCustomDateBinning(Vector<NameValuePair> vector) {
        if (!this.isCustomDateBinning()) {
            return;
        }
        TransformationType.Binning.CustomDate customDate = (TransformationType.Binning.CustomDate)this.customBinning;
        List list = customDate.getDateBin();
        list.clear();
        for (int i = 0; i < vector.size(); ++i) {
            Comparable<Calendar> comparable;
            Object object;
            NameValuePair nameValuePair = vector.get(i);
            DateBin dateBin = new DateBin();
            dateBin.setName(nameValuePair.getName());
            if (this.labelsBtn.isSelected() && null != nameValuePair.getEditedName()) {
                dateBin.setName(nameValuePair.getEditedName());
            }
            DateBin.LowerBound lowerBound = new DateBin.LowerBound();
            Object object2 = nameValuePair.getValue();
            if (object2.equals(TransformationStatisticsState.NO_LOWER_BOUND)) {
                object = vector.get(i + 1);
                try {
                    comparable = TimeUtils.getShortSimpleDateFormatZoneRFC2().parse(object.getValue().toString(), new ParsePosition(0));
                    if (comparable == null) continue;
                    GregorianCalendar gregorianCalendar = new GregorianCalendar();
                    gregorianCalendar.setTimeInMillis(((Date)comparable).getTime());
                    lowerBound.setValue(TimeUtils.Date2XMLDate(gregorianCalendar));
                    dateBin.setLowerBound(lowerBound);
                }
                catch (Exception exception) {
                    theLogger.log(Level.FINEST, exception.getLocalizedMessage(), exception);
                }
            } else {
                try {
                    object = TimeUtils.getShortSimpleDateFormatZoneRFC2().parse(nameValuePair.getValue().toString(), new ParsePosition(0));
                    if (object == null) continue;
                    comparable = new GregorianCalendar();
                    ((Calendar)comparable).setTimeInMillis(((Date)object).getTime());
                    lowerBound.setValue(TimeUtils.Date2XMLDate(comparable));
                    dateBin.setLowerBound(lowerBound);
                }
                catch (Exception exception) {
                    theLogger.log(Level.FINEST, exception.getLocalizedMessage(), exception);
                    continue;
                }
            }
            list.add(dateBin);
        }
    }

    protected Vector<NameValuePair> adjustCustomDateBinning(boolean bl, Vector<NameValuePair> vector) {
        if (!this.isCustomDateBinning() && !this.isCustomTimestampBinning()) {
            return new Vector<NameValuePair>();
        }
        boolean bl2 = this.isCustomDateBinning() ? null != ((TransformationType.Binning.CustomDate)this.customBinning).getBinLabels().getNumberSequence() : null != ((TransformationType.Binning.CustomTimestamp)this.customBinning).getBinLabels().getNumberSequence();
        Vector<NameValuePair> vector2 = new Vector<NameValuePair>();
        Object object = null;
        int n = 1;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (int i = 0; i < vector.size(); ++i) {
            Object object2;
            Object object3;
            Object object4;
            NameValuePair nameValuePair = vector.get(i);
            Object object5 = nameValuePair.getValue();
            NameValuePair nameValuePair2 = null;
            Object object6 = null;
            if (bl2) {
                object4 = null;
                if (bl && null != nameValuePair.getEditedName()) {
                    object4 = nameValuePair.getEditedName();
                }
                object3 = object4 != null ? object4 : String.valueOf(n);
                object2 = Integer.parseInt((String)object3);
                while (null != hashMap.get(object3)) {
                    object2 = (Integer)object2 + 1;
                    object3 = String.valueOf(object2);
                }
                nameValuePair2 = new NameValuePair((String)object3, object5, n++);
                hashMap.put((String)object3, (Integer)object2);
                nameValuePair2.setEditedName((String)object3);
                object6 = String.valueOf(n - 1);
                nameValuePair2.setRangeValue((String)object6);
            } else {
                if (TransformationStatisticsState.NO_LOWER_BOUND.equals(object5)) {
                    object4 = null;
                    object3 = vector.get(1);
                    object4 = bl ? (null != nameValuePair.getEditedName() ? nameValuePair.getEditedName() : nameValuePair.getName()) : TransformationStatisticsState.UNBOUNDED + object3.getValue();
                    object2 = new NameValuePair((String)object4, (Object)TransformationStatisticsState.NO_LOWER_BOUND, 0);
                    String string = TransformationStatisticsState.UNBOUNDED + object3.getValue();
                    object2.setRangeValue(string);
                    vector2.add(0, (NameValuePair)object2);
                    continue;
                }
                if (object == null) {
                    object = object5;
                }
                if (i < vector.size() - 1) {
                    object4 = vector.get(i + 1);
                    object3 = null;
                    object2 = null;
                    if (bl && null != nameValuePair.getEditedName()) {
                        object3 = object2 = nameValuePair.getEditedName();
                    }
                    if (object3 == null) {
                        object3 = object5.toString() + TransformationStatisticsState.DASH + object4.getValue().toString();
                    }
                    object6 = object5.toString() + TransformationStatisticsState.DASH + object4.getValue().toString();
                    nameValuePair2 = new NameValuePair((String)object3, object5, n++);
                    if (object2 != null) {
                        nameValuePair2.setEditedName((String)object2);
                    }
                    nameValuePair2.setRangeValue((String)object6);
                } else {
                    object4 = null;
                    object3 = null;
                    if (bl && null != nameValuePair.getEditedName()) {
                        object4 = object3 = nameValuePair.getEditedName();
                    }
                    if (object4 == null) {
                        object4 = TransformationStatisticsState.UPPER_BOUND + object5.toString();
                    }
                    object6 = TransformationStatisticsState.UPPER_BOUND + object5.toString();
                    nameValuePair2 = new NameValuePair((String)object4, object5, n++);
                    if (object3 != null) {
                        nameValuePair2.setEditedName((String)object3);
                    }
                    nameValuePair2.setRangeValue((String)object6);
                }
            }
            vector2.add(nameValuePair2);
        }
        return vector2;
    }

    @Override
    public String getSelectedBinngType() {
        return this.binningType;
    }

    private static Vector<NameValuePair> fromCustomTimestamptoNameValuePairs(Object object) {
        assert (object instanceof TransformationType.Binning.CustomTimestamp);
        TransformationType.Binning.CustomTimestamp customTimestamp = (TransformationType.Binning.CustomTimestamp)object;
        Vector<NameValuePair> vector = new Vector<NameValuePair>();
        int n = 0;
        NameValuePair nameValuePair = null;
        SimpleDateFormat simpleDateFormat = TimeUtils.getShortSimpleDateFormatZoneRFCTZ();
        for (TimestampTimezoneBin timestampTimezoneBin : customTimestamp.getTimestampTimezoneBin()) {
            Object object2;
            Comparable<Date> comparable;
            GregorianCalendar gregorianCalendar;
            StringBuffer stringBuffer = new StringBuffer();
            if (n == 0) {
                nameValuePair = null != customTimestamp.getBinLabels().getRange() ? new NameValuePair(timestampTimezoneBin.getName(), (Object)TransformationStatisticsState.NO_LOWER_BOUND, n) : new NameValuePair("1", (Object)TransformationStatisticsState.NO_LOWER_BOUND, n);
                gregorianCalendar = (TimestampTimezoneBin)customTimestamp.getTimestampTimezoneBin().get(1);
                comparable = gregorianCalendar.getLowerBound().getValue().toGregorianCalendar();
                simpleDateFormat.setTimeZone(((GregorianCalendar)comparable).getTimeZone());
                object2 = ((Calendar)comparable).getTime();
                simpleDateFormat.format((Date)object2, stringBuffer, new FieldPosition(0));
                String string = TimeUtils.removeGMT(stringBuffer.toString());
                nameValuePair.setRangeValue(string);
            } else {
                gregorianCalendar = timestampTimezoneBin.getLowerBound().getValue().toGregorianCalendar();
                simpleDateFormat.setTimeZone(gregorianCalendar.getTimeZone());
                comparable = gregorianCalendar.getTime();
                simpleDateFormat.format((Date)comparable, stringBuffer, new FieldPosition(0));
                object2 = TimeUtils.removeGMT(stringBuffer.toString());
                nameValuePair = new NameValuePair(timestampTimezoneBin.getName(), object2, n);
                nameValuePair.setRangeValue(BinningCustomBase.calculateRangeValue(customTimestamp, n - 1));
            }
            if (!nameValuePair.getName().equals(nameValuePair.getRangeValue())) {
                nameValuePair.setEditedName(nameValuePair.getName());
            }
            vector.add(nameValuePair);
            ++n;
        }
        return vector;
    }

    private static Vector<NameValuePair> fromCustomDatetoNameValuePairs(Object object) {
        assert (object instanceof TransformationType.Binning.CustomDate);
        TransformationType.Binning.CustomDate customDate = (TransformationType.Binning.CustomDate)object;
        Vector<NameValuePair> vector = new Vector<NameValuePair>();
        int n = 0;
        NameValuePair nameValuePair = null;
        SimpleDateFormat simpleDateFormat = TimeUtils.getShortSimpleDateFormatZoneRFC2();
        for (DateBin dateBin : customDate.getDateBin()) {
            Comparable<StringBuffer> comparable;
            Date date;
            StringBuffer stringBuffer = new StringBuffer();
            if (n == 0) {
                nameValuePair = null != customDate.getBinLabels().getRange() ? new NameValuePair(dateBin.getName(), (Object)TransformationStatisticsState.NO_LOWER_BOUND, n) : new NameValuePair("1", (Object)TransformationStatisticsState.NO_LOWER_BOUND, n);
                date = (DateBin)customDate.getDateBin().get(1);
                comparable = date.getLowerBound().getValue().toGregorianCalendar().getTime();
                StringBuffer stringBuffer2 = simpleDateFormat.format((Date)comparable, stringBuffer, new FieldPosition(0));
                String string = TransformationStatisticsState.UNBOUNDED + stringBuffer2;
                nameValuePair.setRangeValue(string);
            } else {
                date = dateBin.getLowerBound().getValue().toGregorianCalendar().getTime();
                comparable = simpleDateFormat.format(date, stringBuffer, new FieldPosition(0));
                nameValuePair = new NameValuePair(dateBin.getName(), (Object)comparable.toString(), n);
                nameValuePair.setRangeValue(BinningCustomBase.calculateRangeValue(simpleDateFormat, customDate, n));
            }
            if (!nameValuePair.getName().equals(nameValuePair.getRangeValue())) {
                nameValuePair.setEditedName(nameValuePair.getName());
            }
            vector.add(nameValuePair);
            ++n;
        }
        return vector;
    }

    private static Vector<NameValuePair> fromCustomCategoricaltoNameValuePairs(Object object) {
        assert (object instanceof TransformationType.Binning.CustomCategorical);
        TransformationType.Binning.CustomCategorical customCategorical = (TransformationType.Binning.CustomCategorical)object;
        Vector<NameValuePair> vector = new Vector<NameValuePair>();
        int n = 1;
        for (CategoricalBin categoricalBin : customCategorical.getCategoricalBin()) {
            if (categoricalBin.isIsOther()) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : categoricalBin.getStringCollectionValues().getValue()) {
                arrayList.add(string);
            }
            NameValuePair nameValuePair = new NameValuePair(categoricalBin.getName(), arrayList, n++);
            vector.add(nameValuePair);
        }
        return vector;
    }

    private static Vector<NameValuePair> fromCustomNumerictoNameValuePairs(Object object) {
        assert (object instanceof TransformationType.Binning.CustomNumeric);
        TransformationType.Binning.CustomNumeric customNumeric = (TransformationType.Binning.CustomNumeric)object;
        Vector<NameValuePair> vector = new Vector<NameValuePair>();
        int n = 0;
        NameValuePair nameValuePair = null;
        for (NumericBin numericBin : customNumeric.getNumericBin()) {
            if (n == 0) {
                nameValuePair = null != customNumeric.getBinLabels().getRange() ? new NameValuePair(numericBin.getBinName(), (Object)TransformationStatisticsState.NO_LOWER_BOUND, n) : new NameValuePair("1", (Object)TransformationStatisticsState.NO_LOWER_BOUND, n);
                NumericBin numericBin2 = (NumericBin)customNumeric.getNumericBin().get(1);
                String string = TransformationStatisticsState.UNBOUNDED + String.valueOf(numericBin2.getLowerBound());
                nameValuePair.setRangeValue(string);
            } else {
                nameValuePair = new NameValuePair(numericBin.getBinName(), (Object)numericBin.getLowerBound(), n);
                nameValuePair.setRangeValue(BinningCustomBase.calculateRangeValue(customNumeric, n));
            }
            if (!nameValuePair.getName().equals(nameValuePair.getRangeValue())) {
                nameValuePair.setEditedName(nameValuePair.getName());
            }
            vector.add(nameValuePair);
            ++n;
        }
        return vector;
    }

    private static String calculateRangeValue(TransformationType.Binning.CustomNumeric customNumeric, int n) {
        boolean bl;
        Object object = null;
        BinLabels binLabels = customNumeric.getBinLabels();
        boolean bl2 = bl = null != binLabels.getNumberSequence();
        if (bl) {
            object = String.valueOf(n);
        } else {
            NumericBin numericBin = (NumericBin)customNumeric.getNumericBin().get(n);
            if (n < customNumeric.getNumericBin().size() - 1) {
                NumericBin numericBin2 = (NumericBin)customNumeric.getNumericBin().get(n + 1);
                object = String.valueOf(numericBin.getLowerBound()) + TransformationStatisticsState.DASH + String.valueOf(numericBin2.getLowerBound());
            } else {
                object = TransformationStatisticsState.UPPER_BOUND + String.valueOf(numericBin.getLowerBound());
            }
        }
        return object;
    }

    private static String calculateRangeValue(SimpleDateFormat simpleDateFormat, TransformationType.Binning.CustomDate customDate, int n) {
        boolean bl;
        Object object = null;
        BinLabels binLabels = customDate.getBinLabels();
        boolean bl2 = bl = null != binLabels.getNumberSequence();
        if (bl) {
            object = String.valueOf(n);
        } else {
            DateBin dateBin = (DateBin)customDate.getDateBin().get(n);
            if (n < customDate.getDateBin().size() - 1) {
                DateBin dateBin2 = (DateBin)customDate.getDateBin().get(n + 1);
                if (dateBin.getLowerBound().getValue() instanceof XMLGregorianCalendar) {
                    StringBuffer stringBuffer = new StringBuffer();
                    Date date = dateBin.getLowerBound().getValue().toGregorianCalendar().getTime();
                    StringBuffer stringBuffer2 = simpleDateFormat.format(date, stringBuffer, new FieldPosition(0));
                    stringBuffer = new StringBuffer();
                    date = dateBin2.getLowerBound().getValue().toGregorianCalendar().getTime();
                    StringBuffer stringBuffer3 = simpleDateFormat.format(date, stringBuffer, new FieldPosition(0));
                    object = stringBuffer2.toString() + TransformationStatisticsState.DASH + stringBuffer3.toString();
                } else {
                    object = String.valueOf(dateBin.getLowerBound().getValue()) + TransformationStatisticsState.DASH + String.valueOf(dateBin2.getLowerBound());
                }
            } else if (dateBin.getLowerBound().getValue() instanceof XMLGregorianCalendar) {
                StringBuffer stringBuffer = new StringBuffer();
                Date date = dateBin.getLowerBound().getValue().toGregorianCalendar().getTime();
                StringBuffer stringBuffer4 = simpleDateFormat.format(date, stringBuffer, new FieldPosition(0));
                object = TransformationStatisticsState.UPPER_BOUND + stringBuffer4;
            } else {
                object = TransformationStatisticsState.UPPER_BOUND + String.valueOf(dateBin.getLowerBound());
            }
        }
        return object;
    }

    private static String calculateRangeValue(TransformationType.Binning.CustomTimestamp customTimestamp, int n) {
        Object object = null;
        BinLabels binLabels = customTimestamp.getBinLabels();
        boolean bl = null != binLabels.getNumberSequence();
        SimpleDateFormat simpleDateFormat = TimeUtils.getShortSimpleDateFormatZoneRFCTZ();
        if (bl) {
            object = String.valueOf(n);
        } else {
            TimestampTimezoneBin timestampTimezoneBin = (TimestampTimezoneBin)customTimestamp.getTimestampTimezoneBin().get(n);
            if (n < customTimestamp.getTimestampTimezoneBin().size() - 1) {
                TimestampTimezoneBin timestampTimezoneBin2 = (TimestampTimezoneBin)customTimestamp.getTimestampTimezoneBin().get(n + 1);
                if (timestampTimezoneBin.getLowerBound().getValue() instanceof XMLGregorianCalendar) {
                    StringBuffer stringBuffer = new StringBuffer();
                    GregorianCalendar gregorianCalendar = timestampTimezoneBin.getLowerBound().getValue().toGregorianCalendar();
                    simpleDateFormat.setTimeZone(gregorianCalendar.getTimeZone());
                    Date date = gregorianCalendar.getTime();
                    simpleDateFormat.format(date, stringBuffer, new FieldPosition(0));
                    String string = TimeUtils.removeGMT(stringBuffer.toString());
                    stringBuffer = new StringBuffer();
                    gregorianCalendar = timestampTimezoneBin.getLowerBound().getValue().toGregorianCalendar();
                    simpleDateFormat.setTimeZone(gregorianCalendar.getTimeZone());
                    date = gregorianCalendar.getTime();
                    simpleDateFormat.format(date, stringBuffer, new FieldPosition(0));
                    String string2 = TimeUtils.removeGMT(stringBuffer.toString());
                    object = string + TransformationStatisticsState.DASH + string2;
                } else {
                    object = String.valueOf(timestampTimezoneBin.getLowerBound()) + TransformationStatisticsState.DASH + String.valueOf(timestampTimezoneBin2.getLowerBound());
                }
            } else if (timestampTimezoneBin.getLowerBound().getValue() instanceof XMLGregorianCalendar) {
                StringBuffer stringBuffer = new StringBuffer();
                GregorianCalendar gregorianCalendar = timestampTimezoneBin.getLowerBound().getValue().toGregorianCalendar();
                simpleDateFormat.setTimeZone(gregorianCalendar.getTimeZone());
                Date date = gregorianCalendar.getTime();
                simpleDateFormat.format(date, stringBuffer, new FieldPosition(0));
                String string = TimeUtils.removeGMT(stringBuffer.toString());
                object = TransformationStatisticsState.UPPER_BOUND + string;
            } else {
                object = TransformationStatisticsState.UPPER_BOUND + String.valueOf(timestampTimezoneBin.getLowerBound());
            }
        }
        return object;
    }

    private static String gettzString(String string) {
        String string2 = TimeUtils.GMT;
        int n = string.indexOf(string2);
        if (n == -1 && (n = string.lastIndexOf(string2 = "+")) == -1) {
            string2 = "-";
            n = string.lastIndexOf(string2);
        }
        if (n == -1) {
            return null;
        }
        Object object = string.substring(n + string2.length(), string.length());
        object = !string2.equals(TimeUtils.GMT) ? TimeUtils.GMT + string2 + (String)object : TimeUtils.GMT + (String)object;
        return object;
    }

    private static String getGMTString(String string) {
        String string2 = TimeUtils.GMT;
        int n = string.indexOf(string2);
        if (n == -1) {
            string2 = "+";
            n = string.lastIndexOf(string2);
            if (n == -1) {
                string2 = "-";
                n = string.lastIndexOf(string2);
            }
        } else {
            return string;
        }
        if (n == -1) {
            return null;
        }
        Object object = string.substring(n + string2.length(), string.length());
        object = !string2.equals(TimeUtils.GMT) ? TimeUtils.GMT + string2 + (String)object : TimeUtils.GMT + (String)object;
        String string3 = string.substring(0, n) + (String)object;
        return string3;
    }

    public static GregorianCalendar toDate(SimpleDateFormat simpleDateFormat, Object object, boolean bl) {
        Object object2;
        String string = object.toString();
        String string2 = null;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        if (bl) {
            object2 = BinningCustomBase.gettzString(string);
            TimeZone timeZone = null;
            timeZone = object2 != null ? TimeZone.getTimeZone((String)object2) : TimeZone.getDefault();
            simpleDateFormat.setTimeZone(timeZone);
            gregorianCalendar.setTimeZone(timeZone);
            string2 = BinningCustomBase.getGMTString(string);
        } else {
            string2 = string;
        }
        try {
            object2 = simpleDateFormat.parse(string2);
            gregorianCalendar.setTime((Date)object2);
        }
        catch (Exception exception) {
            gregorianCalendar = null;
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return gregorianCalendar;
    }

    class SelectedItemSelectionHandler
    implements ListSelectionListener {
        GenericTable jAttributesTable;

        SelectedItemSelectionHandler(GenericTable genericTable) {
            this.jAttributesTable = genericTable;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            BinsTableModel binsTableModel = (BinsTableModel)((Object)this.jAttributesTable.getModel());
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            if (listSelectionModel.isSelectionEmpty()) {
                bl = false;
                bl2 = false;
                bl3 = false;
            } else {
                int n = binsTableModel.getRowCount();
                int[] nArray = this.jAttributesTable.getSelectedRowsInModel();
                if (nArray != null && nArray.length > 0) {
                    if (nArray.length == 1) {
                        bl3 = true;
                        bl2 = !BinningCustomBase.this.isCustomCategoricalBinning() ? nArray[0] > 1 && nArray[0] <= n - 1 : true;
                    }
                    if (BinningCustomBase.this.isCustomCategoricalBinning()) {
                        bl = true;
                    } else if (nArray.length < n - 2) {
                        bl = true;
                        for (int i = 0; i < nArray.length; ++i) {
                            if (nArray[i] != 0) continue;
                            bl = false;
                            break;
                        }
                    }
                }
            }
            BinningCustomBase.this.removeBtn.setEnabled(bl);
            BinningCustomBase.this.addBtn.setEnabled(bl2);
            BinningCustomBase.this.editBtn.setEnabled(bl3);
        }
    }

    class BinsTableModel
    extends SimpleBaseTableModel {
        protected List<NameValuePair> _data = new ArrayList<NameValuePair>();
        protected Map<String, Integer> _map = new HashMap<String, Integer>();
        protected boolean numeric;

        BinsTableModel() {
            this(new Vector<NameValuePair>(), false);
        }

        BinsTableModel(Vector<NameValuePair> vector, boolean bl) {
            this.numeric = bl;
            if (vector != null && !vector.isEmpty()) {
                for (NameValuePair nameValuePair : vector) {
                    ArrayList<String> arrayList = null;
                    if (nameValuePair.getValue() instanceof List) {
                        arrayList = (ArrayList<String>)nameValuePair.getValue();
                    } else {
                        arrayList = new ArrayList<String>();
                        arrayList.add(nameValuePair.getValue().toString());
                    }
                    if (arrayList == null || arrayList.isEmpty()) continue;
                    NameValuePair nameValuePair2 = new NameValuePair(nameValuePair.getName(), nameValuePair.getValue());
                    nameValuePair2.setEditedName(nameValuePair.getEditedName());
                    nameValuePair2.setRangeValue(nameValuePair.getRangeValue());
                    this._data.add(nameValuePair2);
                    this._map.put(nameValuePair.getName(), nameValuePair.getCount());
                }
            }
            this.setRowCount(this._data.size());
            this.createColumns();
            this.setColumnIdentifiers(BinningCustomBase.this._columnNames);
        }

        protected void createColumns() {
            String[] stringArray;
            if (this.numeric) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = _bin_names;
                stringArray = stringArray2;
                stringArray2[1] = _bin_Lower_bound;
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = _bin_names;
                stringArray = stringArray3;
                stringArray3[1] = _bin_values;
            }
            BinningCustomBase.this._columnNames = stringArray;
        }

        public String getColumnName(int n) {
            if (BinningCustomBase.this._columnNames != null && n <= BinningCustomBase.this._columnNames.length) {
                return BinningCustomBase.this._columnNames[n];
            }
            return "";
        }

        protected String[] getColumnNames() {
            return BinningCustomBase.this._columnNames;
        }

        public int getRowCount() {
            return this._data != null ? this._data.size() : 0;
        }

        public Comparator getColumnSortComparator(int n) {
            if (n == _BIN_NAME) {
                return NameValuePairComparator.getComparator(this._map);
            }
            return super.getColumnSortComparator(n);
        }

        public Vector getDataVector() {
            Vector<NameValuePair> vector = new Vector<NameValuePair>();
            vector.addAll(this._data);
            return vector;
        }

        public int getRow(String string) {
            for (int i = 0; i < this._data.size(); ++i) {
                if (!this._data.get(i).getName().equals(string)) continue;
                return i;
            }
            return -1;
        }

        public void clearRows() {
            this._data.clear();
            this._map.clear();
            this.setRowCount(0);
            this.fireTableDataChanged();
        }

        public void setRowData(NameValuePair nameValuePair, int n) {
            boolean bl = BinningCustomBase.this.labelsBtn.isSelected();
            if (bl) {
                this.setValueAt(nameValuePair.getName(), n, _BIN_NAME);
            }
            this.setValueAt(nameValuePair.getValue(), n, _BIN_VALUE);
        }

        public void setValueAt(Object object, int n, int n2) {
            Object object2;
            boolean bl;
            boolean bl2 = bl = null != BinningCustomBase.this.labelsBtn && !BinningCustomBase.this.labelsBtn.isSelected();
            if (n2 == _BIN_NAME) {
                NameValuePair nameValuePair = this._data.get(n);
                nameValuePair.setName(object.toString());
                if (BinningCustomBase.this.isCustomNumericBinning()) {
                    boolean bl3;
                    BinningCustomBase.this.loadCustomNumericBinning(this._data);
                    boolean bl4 = bl3 = null != ((TransformationType.Binning.CustomNumeric)BinningCustomBase.this.customBinning).getBinLabels().getNumberSequence();
                    if (!bl3 && !bl) {
                        nameValuePair.setEditedName(nameValuePair.getName());
                    }
                } else if (BinningCustomBase.this.isCustomCategoricalBinning()) {
                    BinningCustomBase.this.loadCustomCategoricBinning(this._data);
                } else if (BinningCustomBase.this.isCustomDateBinning()) {
                    boolean bl5;
                    BinningCustomBase.this.loadCustomDateBinning(this._data);
                    boolean bl6 = bl5 = null != ((TransformationType.Binning.CustomDate)BinningCustomBase.this.customBinning).getBinLabels().getNumberSequence();
                    if (!bl5 && !bl) {
                        nameValuePair.setEditedName(nameValuePair.getName());
                    }
                } else if (BinningCustomBase.this.isCustomTimestampBinning()) {
                    boolean bl7;
                    BinningCustomBase.this.loadCustomTimestampBinning(this._data);
                    boolean bl8 = bl7 = null != ((TransformationType.Binning.CustomTimestamp)BinningCustomBase.this.customBinning).getBinLabels().getNumberSequence();
                    if (!bl7 && !bl) {
                        nameValuePair.setEditedName(nameValuePair.getName());
                    }
                } else {
                    return;
                }
                this.fireTableCellUpdated(n, n2);
                return;
            }
            if (n == 0) {
                return;
            }
            NameValuePair nameValuePair = this._data.get(n);
            NameValuePair nameValuePair2 = this._data.get(n - 1);
            NameValuePair nameValuePair3 = n == this._data.size() - 1 ? null : this._data.get(n + 1);
            Object object3 = nameValuePair2.getValue();
            Object object4 = object2 = nameValuePair3 != null ? nameValuePair3.getValue() : TransformationStatisticsState.UNBOUNDED;
            if (BinningCustomBase.this.isCustomNumericBinning()) {
                Vector<NameValuePair> vector;
                boolean bl9;
                Double d;
                Double d2 = null;
                if (object instanceof Double) {
                    d2 = (Double)object;
                } else if (object instanceof String) {
                    d2 = Double.valueOf(object.toString());
                }
                Double d3 = object3.equals(TransformationStatisticsState.NO_LOWER_BOUND) ? null : (d = object3 instanceof String ? Double.valueOf(object3.toString()) : (Double)object3);
                Double d4 = object2.equals(TransformationStatisticsState.UNBOUNDED) ? null : (object2 instanceof String ? Double.valueOf(object2.toString()) : (Double)object2);
                boolean bl10 = false;
                if (d != null && d4 != null) {
                    if (d2 <= d || d2 >= d4) {
                        bl10 = true;
                    }
                } else if (d == null && d4 != null) {
                    if (d2 >= d4) {
                        bl10 = true;
                    }
                } else if (d != null && d4 == null && d2 <= d) {
                    bl10 = true;
                }
                if (bl10) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)XformDialogsLrb.get("CUSTOM_TRANSFORMATION_DIALOG_OUT_OF_BOUNDS_BOUNDS"), (String)XformDialogsLrb.get("CUSTOM_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
                    return;
                }
                boolean bl11 = bl9 = null != ((TransformationType.Binning.CustomNumeric)BinningCustomBase.this.customBinning).getBinLabels().getNumberSequence();
                if (!bl9) {
                    if (bl) {
                        nameValuePair.setName(d2 + TransformationStatisticsState.DASH + (Serializable)(d4 != null ? d4 : TransformationStatisticsState.UNBOUNDED));
                    } else {
                        nameValuePair.setEditedName(nameValuePair.getName());
                    }
                    boolean bl12 = true;
                    if (object3.equals(TransformationStatisticsState.NO_LOWER_BOUND)) {
                        object3 = TransformationStatisticsState.UNBOUNDED;
                        bl12 = false;
                    }
                    if (bl) {
                        vector = object3 + (bl12 ? TransformationStatisticsState.DASH : "") + d2;
                        nameValuePair2.setName((String)((Object)vector));
                    }
                } else if (!bl) {
                    nameValuePair.setEditedName(nameValuePair.getName());
                }
                nameValuePair.setValue((Object)object.toString());
                Vector<NameValuePair> vector2 = new Vector<NameValuePair>();
                for (NameValuePair object5 : this._data) {
                    vector2.add(object5);
                }
                vector = BinningCustomBase.this.adjustCustomNumericBinning(BinningCustomBase.this.labelsBtn.isSelected(), vector2);
                this._data.clear();
                for (NameValuePair nameValuePair4 : vector) {
                    this._data.add(nameValuePair4);
                }
                BinningCustomBase.this.loadCustomNumericBinning(this._data);
            } else if (BinningCustomBase.this.isCustomDateBinning() || BinningCustomBase.this.isCustomTimestampBinning()) {
                Vector<NameValuePair> vector;
                boolean bl13;
                boolean bl14 = BinningCustomBase.this.isCustomTimestampBinning();
                SimpleDateFormat simpleDateFormat = bl14 ? TimeUtils.getShortSimpleDateFormatZoneRFCTZ() : TimeUtils.getShortSimpleDateFormatZoneRFC2();
                GregorianCalendar gregorianCalendar = BinningCustomBase.toDate(simpleDateFormat, object, bl14);
                GregorianCalendar gregorianCalendar2 = object3.equals(TransformationStatisticsState.NO_LOWER_BOUND) ? null : BinningCustomBase.toDate(simpleDateFormat, object3, bl14);
                GregorianCalendar gregorianCalendar3 = object2.equals(TransformationStatisticsState.UNBOUNDED) ? null : BinningCustomBase.toDate(simpleDateFormat, object2, bl14);
                boolean bl15 = false;
                if (gregorianCalendar2 != null && gregorianCalendar3 != null) {
                    if (gregorianCalendar.before(gregorianCalendar2) || gregorianCalendar.after(gregorianCalendar3)) {
                        bl15 = true;
                    }
                } else if (gregorianCalendar2 == null && gregorianCalendar3 != null) {
                    if (gregorianCalendar.after(gregorianCalendar3)) {
                        bl15 = true;
                    }
                } else if (gregorianCalendar2 != null && gregorianCalendar3 == null && gregorianCalendar.before(gregorianCalendar2)) {
                    bl15 = true;
                }
                if (bl15) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)XformDialogsLrb.get("CUSTOM_TRANSFORMATION_DIALOG_OUT_OF_BOUNDS_BOUNDS"), (String)XformDialogsLrb.get("CUSTOM_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
                    return;
                }
                boolean bl12 = BinningCustomBase.this.isCustomDateBinning() ? null != ((TransformationType.Binning.CustomDate)BinningCustomBase.this.customBinning).getBinLabels().getNumberSequence() : (bl13 = null != ((TransformationType.Binning.CustomTimestamp)BinningCustomBase.this.customBinning).getBinLabels().getNumberSequence());
                if (!bl13) {
                    boolean bl16;
                    if (bl) {
                        nameValuePair.setName(gregorianCalendar + TransformationStatisticsState.DASH + (Serializable)(gregorianCalendar3 != null ? gregorianCalendar3 : TransformationStatisticsState.UNBOUNDED));
                    } else {
                        nameValuePair.setEditedName(nameValuePair.getName());
                    }
                    boolean vector3 = true;
                    if (object3.equals(TransformationStatisticsState.NO_LOWER_BOUND)) {
                        object3 = TransformationStatisticsState.UNBOUNDED;
                        bl16 = false;
                    }
                    if (bl) {
                        vector = object3 + (bl16 ? TransformationStatisticsState.DASH : "") + gregorianCalendar;
                        nameValuePair2.setName((String)((Object)vector));
                    }
                } else if (!bl) {
                    nameValuePair.setEditedName(nameValuePair.getName());
                }
                nameValuePair.setValue((Object)object.toString());
                Vector<NameValuePair> vector2 = new Vector<NameValuePair>();
                for (NameValuePair nameValuePair5 : this._data) {
                    vector2.add(nameValuePair5);
                }
                vector = BinningCustomBase.this.adjustCustomDateBinning(BinningCustomBase.this.labelsBtn.isSelected(), vector2);
                this._data.clear();
                for (NameValuePair nameValuePair6 : vector) {
                    this._data.add(nameValuePair6);
                }
                if (BinningCustomBase.this.isCustomDateBinning()) {
                    BinningCustomBase.this.loadCustomDateBinning(this._data);
                } else if (BinningCustomBase.this.isCustomTimestampBinning()) {
                    BinningCustomBase.this.loadCustomTimestampBinning(this._data);
                }
            }
            this.fireTableDataChanged();
        }

        public Object getValueAt(int n, int n2) {
            if (this._data.isEmpty()) {
                return "";
            }
            if (n >= this._data.size()) {
                return "";
            }
            String string = null;
            NameValuePair nameValuePair = this._data.get(n);
            if (n2 == _BIN_NAME) {
                string = nameValuePair.getName();
            } else if (n2 == _BIN_VALUE) {
                if (BinningCustomBase.this.isCustomCategoricalBinning()) {
                    List<String> list = ConverterHelper.objectToStringList(nameValuePair.getValue());
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 0; i < list.size(); ++i) {
                        String string2 = list.get(i);
                        if (i > 0) {
                            stringBuilder.append(",");
                        }
                        stringBuilder.append(string2);
                    }
                    string = stringBuilder.toString();
                } else {
                    string = nameValuePair.getValue().toString();
                }
            }
            return string != null ? string : "";
        }

        public boolean isCellEditable(int n, int n2) {
            if (BinningCustomBase.this.isCustomNumericBinning()) {
                NameValuePair nameValuePair = this._data.get(n);
                Object object = nameValuePair.getValue();
                if (object.equals(TransformationStatisticsState.NO_LOWER_BOUND)) {
                    return false;
                }
                if (n2 == _BIN_VALUE) {
                    return true;
                }
            }
            return BinningCustomBase.this.isCustomCategoricalBinning() && n2 == _BIN_NAME;
        }
    }

    class ExBinsTableModel
    extends BinsTableModel {
        ExBinsTableModel(Vector<NameValuePair> vector, boolean bl) {
            super(vector, bl);
        }

        @Override
        protected void createColumns() {
            BinningCustomBase.this._columnNames = this.numeric ? new String[]{_bin_names, _bin_Lower_bound} : new String[]{_bin_names, _bin_values, _bin_ranges};
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this._data.isEmpty()) {
                return "";
            }
            if (n >= this._data.size()) {
                return "";
            }
            String string = null;
            NameValuePair nameValuePair = (NameValuePair)this._data.get(n);
            if (n2 != _BIN_RANGE) {
                return super.getValueAt(n, n2);
            }
            string = nameValuePair.getRangeValue();
            return string != null ? string : "";
        }
    }

    class EmptyBinsTableModel
    extends BinsTableModel {
        EmptyBinsTableModel() {
            this.setRowCount(0);
            BinningCustomBase.this._columnNames = new String[]{_status};
            this.setColumnIdentifiers(BinningCustomBase.this._columnNames);
            this.setColumnCount(BinningCustomBase.this._columnNames.length);
        }
    }

    class LoadingBinsTableModel
    extends BinsTableModel {
        LoadingBinsTableModel() {
            this._data.add(new NameValuePair(_loading, (Object)"", 0));
            this.setRowCount(1);
            BinningCustomBase.this._columnNames = new String[]{_status};
            this.setColumnIdentifiers(BinningCustomBase.this._columnNames);
            this.setColumnCount(BinningCustomBase.this._columnNames.length);
        }
    }

    class LoadDefaultBins
    extends SwingWorker {
        private Exception _ex;
        private boolean _success = false;
        private String _explanation;
        TransformationType resultType;
        Vector<NameValuePair> pairs;

        LoadDefaultBins(TransformationType transformationType) {
            this.resultType = transformationType;
        }

        protected Object doInBackground() throws Exception {
            try {
                BinningCustomBase.this.editBtn.setEnabled(false);
                this.pairs = BinningCustomBase.this._state.generateDefaultBinsXform(BinningCustomBase.this.srcColumnName, BinningCustomBase.this.srcColumnType, this.resultType.getBinning());
                if (this.pairs != null && !this.pairs.isEmpty()) {
                    this._success = true;
                } else {
                    this._explanation = XformDialogsLrb.get("CUSTOM_BINNING_PANEL_NO_BINS");
                    this._success = false;
                }
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
            return this;
        }

        @Override
        protected void done() {
            super.done();
            if (this._success && this._ex == null) {
                Object object;
                BinsTableModel binsTableModel = null;
                if (null != this.resultType.getBinning().getEqualWidth() || null != this.resultType.getBinning().getQuantile()) {
                    object = null != this.resultType.getBinning().getEqualWidth() ? this.resultType.getBinning().getEqualWidth().getBinLabels() : this.resultType.getBinning().getQuantile().getBinLabels();
                    binsTableModel = new ExBinsTableModel(this.pairs, object.getNumberSequence() != null);
                    BinningCustomBase.this.loadCustomNumericBinning(this.pairs);
                    TransformationType.Binning.CustomNumeric customNumeric = (TransformationType.Binning.CustomNumeric)BinningCustomBase.this.customBinning;
                    BinLabels binLabels = new BinLabels();
                    if (null != object.getNumberSequence()) {
                        binLabels.setNumberSequence(new BinLabels.NumberSequence());
                    } else {
                        binLabels.setRange(new BinLabels.Range());
                    }
                    customNumeric.setBinLabels(binLabels);
                    BinningCustomBase.this.setExplanation(customNumeric);
                } else if (null != this.resultType.getBinning().getTopN()) {
                    int n = -1;
                    for (int i = 0; i < this.pairs.size(); ++i) {
                        if (!this.pairs.get(i).getName().equals(TransformationStatisticsState.LIST_OF_DISTINCT_VALUES)) continue;
                        n = i;
                        break;
                    }
                    if (n != -1) {
                        BinningCustomBase.this._state.setDistinctValuesFrequencies(BinningCustomBase.this.srcColumnName, ConverterHelper.objectToNameValuePairList(this.pairs.get(n).getValue()));
                        this.pairs.remove(n);
                    }
                    binsTableModel = new BinsTableModel(this.pairs, false);
                    BinningCustomBase.this.loadCustomCategoricBinning(this.pairs);
                } else if (null != this.resultType.getBinning().getDateEqualWidth()) {
                    TransformationType.Binning.CustomDate customDate;
                    BinLabels binLabels = this.resultType.getBinning().getDateEqualWidth().getBinLabels();
                    binsTableModel = new ExBinsTableModel(this.pairs, binLabels.getNumberSequence() != null);
                    if (BinningCustomBase.this.customBinning instanceof TransformationType.Binning.CustomDate) {
                        BinningCustomBase.this.loadCustomDateBinning(this.pairs);
                        customDate = (TransformationType.Binning.CustomDate)BinningCustomBase.this.customBinning;
                        BinLabels binLabels2 = new BinLabels();
                        if (null != binLabels.getNumberSequence()) {
                            binLabels2.setNumberSequence(new BinLabels.NumberSequence());
                        } else {
                            binLabels2.setRange(new BinLabels.Range());
                        }
                        customDate.setBinLabels(binLabels2);
                        BinningCustomBase.this.setExplanation(customDate);
                    } else if (BinningCustomBase.this.customBinning instanceof TransformationType.Binning.CustomTimestamp) {
                        BinningCustomBase.this.loadCustomTimestampBinning(this.pairs);
                        customDate = (TransformationType.Binning.CustomTimestamp)BinningCustomBase.this.customBinning;
                        BinLabels binLabels3 = new BinLabels();
                        if (null != binLabels.getNumberSequence()) {
                            binLabels3.setNumberSequence(new BinLabels.NumberSequence());
                        } else {
                            binLabels3.setRange(new BinLabels.Range());
                        }
                        customDate.setBinLabels(binLabels3);
                        BinningCustomBase.this.setExplanation((TransformationType.Binning.CustomTimestamp)customDate);
                    }
                } else if (null != this.resultType.getBinning().getTimestampEqualWidth()) {
                    TransformationType.Binning.CustomDate customDate;
                    BinLabels binLabels = this.resultType.getBinning().getTimestampEqualWidth().getBinLabels();
                    binsTableModel = new ExBinsTableModel(this.pairs, binLabels.getNumberSequence() != null);
                    if (BinningCustomBase.this.customBinning instanceof TransformationType.Binning.CustomDate) {
                        BinningCustomBase.this.loadCustomDateBinning(this.pairs);
                        customDate = (TransformationType.Binning.CustomDate)BinningCustomBase.this.customBinning;
                        BinLabels binLabels4 = new BinLabels();
                        if (null != binLabels.getNumberSequence()) {
                            binLabels4.setNumberSequence(new BinLabels.NumberSequence());
                        } else {
                            binLabels4.setRange(new BinLabels.Range());
                        }
                        customDate.setBinLabels(binLabels4);
                        BinningCustomBase.this.setExplanation(customDate);
                    } else if (BinningCustomBase.this.customBinning instanceof TransformationType.Binning.CustomTimestamp) {
                        BinningCustomBase.this.loadCustomTimestampBinning(this.pairs);
                        customDate = (TransformationType.Binning.CustomTimestamp)BinningCustomBase.this.customBinning;
                        BinLabels binLabels5 = new BinLabels();
                        if (null != binLabels.getNumberSequence()) {
                            binLabels5.setNumberSequence(new BinLabels.NumberSequence());
                        } else {
                            binLabels5.setRange(new BinLabels.Range());
                        }
                        customDate.setBinLabels(binLabels5);
                        BinningCustomBase.this.setExplanation((TransformationType.Binning.CustomTimestamp)customDate);
                    }
                } else if (null != this.resultType.getBinning().getCustomTimestamp()) {
                    BinLabels binLabels = this.resultType.getBinning().getDateEqualWidth().getBinLabels();
                    binsTableModel = new ExBinsTableModel(this.pairs, binLabels.getNumberSequence() != null);
                    BinningCustomBase.this.loadCustomTimestampBinning(this.pairs);
                    TransformationType.Binning.CustomTimestamp customTimestamp = (TransformationType.Binning.CustomTimestamp)BinningCustomBase.this.customBinning;
                    BinLabels binLabels6 = new BinLabels();
                    if (null != binLabels.getNumberSequence()) {
                        binLabels6.setNumberSequence(new BinLabels.NumberSequence());
                    } else {
                        binLabels6.setRange(new BinLabels.Range());
                    }
                    customTimestamp.setBinLabels(binLabels6);
                }
                if (binsTableModel != null) {
                    BinningCustomBase.this.setupItemsTable(binsTableModel, BinningCustomBase.this._jAttributesTable);
                }
                if (BinningCustomBase.this.isCustomCategoricalBinning()) {
                    object = BinningCustomBase.this._jAttributesTable.getSelectedRowsInModel();
                    boolean bl = object != null && ((BinLabels)object).length > 0;
                    BinningCustomBase.this.editBtn.setEnabled(bl);
                }
            } else if (this._explanation != null) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)this._explanation, (String)XformDialogsLrb.get("CUSTOM_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
                EmptyBinsTableModel emptyBinsTableModel = new EmptyBinsTableModel();
                BinningCustomBase.this.setupItemsTable(emptyBinsTableModel, BinningCustomBase.this._jAttributesTable);
            }
        }
    }
}

