/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.workflow.dialog.transformations.MissingValuesStatsPanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.MissingValuesValuePanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationTypes;
import oracle.dmt.dataminer.workflow.dialog.transformations.XformDialogsLrb;
import oracle.dmt.dataminer.workflow.xmlschema.CategoricalStatistic;
import oracle.dmt.dataminer.workflow.xmlschema.DateStatistic;
import oracle.dmt.dataminer.workflow.xmlschema.NumericStatistic;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationOutputAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationType;
import oracle.ide.Context;
import oracle.ide.util.ResourceUtils;

public class MissingValuesPanel
extends JPanel {
    private String selectedMVType;
    private Integer dataType = 0;
    private Object replacementValue;
    private String selectedStats;
    private Context context;
    private JComboBox jComboBoxMValues;
    private JLabel jLabel1;
    private JLabel jLabelMValues;
    private JPanel jPanelMVDetails;
    protected MissingValuesStatsPanel missingValuesStatsPanel;
    protected MissingValuesValuePanel missingValuesValuePanel;

    public MissingValuesPanel(Context context, Integer n) {
        this.dataType = n;
        this.context = context;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public MissingValuesPanel(Context context, TransformationOutputAttribute transformationOutputAttribute) {
        this.context = context;
        this.determineDataType((TransformationSourceAttribute)transformationOutputAttribute);
        this.processXfromedAttribute(transformationOutputAttribute);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public MissingValuesPanel(Context context, TransformationSourceAttribute transformationSourceAttribute, Object object, String string, String string2) {
        this.context = context;
        this.determineDataType(transformationSourceAttribute);
        if (transformationSourceAttribute instanceof TransformationOutputAttribute) {
            this.processXfromedAttribute((TransformationOutputAttribute)transformationSourceAttribute);
        } else {
            this.replacementValue = object;
            this.selectedMVType = string;
            this.selectedStats = string2;
        }
        if (this.replacementValue == null) {
            this.replacementValue = object;
        }
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void determineDataType(TransformationSourceAttribute transformationSourceAttribute) {
        if ("NUMBER".equals(transformationSourceAttribute.getDataType()) || "FLOAT".equals(transformationSourceAttribute.getDataType()) || "BINARY_DOUBLE".equals(transformationSourceAttribute.getDataType()) || "BINARY_FLOAT".equals(transformationSourceAttribute.getDataType())) {
            this.dataType = 1;
        } else if ("VARCHAR2".equals(transformationSourceAttribute.getDataType()) || "CHAR".equals(transformationSourceAttribute.getDataType()) || "NVARCHAR2".equals(transformationSourceAttribute.getDataType()) || "NCHAR".equals(transformationSourceAttribute.getDataType())) {
            this.dataType = 2;
        } else if ("DATE".equals(transformationSourceAttribute.getDataType()) || DatabaseMetadataUtils.isTimestamp(transformationSourceAttribute.getDataType()) || DatabaseMetadataUtils.isTimestampWithLocalTimeZone(transformationSourceAttribute.getDataType())) {
            this.dataType = 3;
        } else if (DatabaseMetadataUtils.isTimestampWithTimeZone(transformationSourceAttribute.getDataType())) {
            this.dataType = 6;
        }
    }

    private void processXfromedAttribute(TransformationOutputAttribute transformationOutputAttribute) {
        TransformationType.MissingValuesCategorical missingValuesCategorical = transformationOutputAttribute.getTransformationElementType().getMissingValuesCategorical();
        TransformationType.MissingValuesNumeric missingValuesNumeric = transformationOutputAttribute.getTransformationElementType().getMissingValuesNumeric();
        TransformationType.MissingValuesDate missingValuesDate = transformationOutputAttribute.getTransformationElementType().getMissingValuesDate();
        if (missingValuesCategorical != null) {
            TransformationType.MissingValuesCategorical.Value value = missingValuesCategorical.getValue();
            CategoricalStatistic categoricalStatistic = missingValuesCategorical.getCategoricalStatistic();
            if (categoricalStatistic != null) {
                this.selectedStats = categoricalStatistic.getReplaceNullsWith();
                this.selectedMVType = TransformationTypes.getTRANSFORMATION_TYPE_MISS_VALUES_STATS();
            } else if (value != null) {
                this.replacementValue = value.getReplaceNullsWith();
                this.selectedMVType = TransformationTypes.getTRANSFORMATION_TYPE_MISS_VALUES_VALUE();
            }
        } else if (missingValuesNumeric != null) {
            TransformationType.MissingValuesNumeric.Value value = missingValuesNumeric.getValue();
            NumericStatistic numericStatistic = missingValuesNumeric.getNumericStatistic();
            if (numericStatistic != null) {
                this.selectedStats = numericStatistic.getReplaceNullsWith();
                this.selectedMVType = TransformationTypes.getTRANSFORMATION_TYPE_MISS_VALUES_STATS();
            } else if (value != null) {
                this.replacementValue = value.getReplaceNullsWith();
                this.selectedMVType = TransformationTypes.getTRANSFORMATION_TYPE_MISS_VALUES_VALUE();
            }
        } else if (missingValuesDate != null) {
            TransformationType.MissingValuesDate.Value value = missingValuesDate.getValue();
            DateStatistic dateStatistic = missingValuesDate.getDateStatistic();
            if (dateStatistic != null) {
                this.selectedStats = dateStatistic.getReplaceNullsWith();
                this.selectedMVType = TransformationTypes.getTRANSFORMATION_TYPE_MISS_VALUES_STATS();
            } else if (value != null) {
                this.replacementValue = value.getReplaceNullsWith();
                this.selectedMVType = TransformationTypes.getTRANSFORMATION_TYPE_MISS_VALUES_VALUE();
            }
        }
    }

    private void initComponents() {
        this.jLabelMValues = new JLabel();
        this.jComboBoxMValues = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jPanelMVDetails = new JPanel();
        this.jLabelMValues.setText("Missing Values:");
        this.jLabelMValues.setMaximumSize(new Dimension(65, 14));
        this.jLabelMValues.setMinimumSize(new Dimension(65, 14));
        this.jLabelMValues.setPreferredSize(new Dimension(65, 14));
        this.jComboBoxMValues.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel1.setText("Replace Nulls With:");
        this.jPanelMVDetails.setLayout(new CardLayout());
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelMVDetails, -1, 394, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jLabel1, -2, 169, -2)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabelMValues, -2, 105, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxMValues, -2, 183, -2))).addGap(92, 92, 92)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelMValues, -2, -1, -2).addComponent(this.jComboBoxMValues, -2, -1, -2)).addGap(11, 11, 11).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelMVDetails, -1, 202, Short.MAX_VALUE).addContainerGap()));
    }

    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jLabelMValues, (Component)this.jComboBoxMValues, (String)XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_MISSING_VALUES"));
        this.jLabel1.setText(XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_MISSING_VALUES_REPLACE_WITH"));
    }

    public void initUI() {
        this.missingValuesStatsPanel = new MissingValuesStatsPanel(this.context, this.selectedStats, this.dataType);
        this.jPanelMVDetails.add(TransformationTypes.getTRANSFORMATION_TYPE_MISS_VALUES_STATS(), this.missingValuesStatsPanel);
        this.missingValuesValuePanel = new MissingValuesValuePanel(this.context, this.replacementValue, this.dataType);
        this.jPanelMVDetails.add(TransformationTypes.getTRANSFORMATION_TYPE_MISS_VALUES_VALUE(), this.missingValuesValuePanel);
        DefaultComboBoxModel<String> defaultComboBoxModel = null;
        defaultComboBoxModel = this.replacementValue == null ? new DefaultComboBoxModel<String>(new String[]{TransformationTypes.getTRANSFORMATION_TYPE_MISS_VALUES_STATS()}) : new DefaultComboBoxModel<String>(new String[]{TransformationTypes.getTRANSFORMATION_TYPE_MISS_VALUES_STATS(), TransformationTypes.getTRANSFORMATION_TYPE_MISS_VALUES_VALUE()});
        this.jComboBoxMValues.setModel(defaultComboBoxModel);
        if (null == this.selectedMVType) {
            this.selectedMVType = (String)this.jComboBoxMValues.getItemAt(0);
        }
        this.jComboBoxMValues.setSelectedItem(this.selectedMVType);
        this.jComboBoxMValues.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MissingValuesPanel.this.selectedMVType = (String)MissingValuesPanel.this.jComboBoxMValues.getSelectedItem();
                MissingValuesPanel.this.showPanel();
            }
        });
        this.showPanel();
    }

    private void showPanel() {
        CardLayout cardLayout = (CardLayout)this.jPanelMVDetails.getLayout();
        cardLayout.show(this.jPanelMVDetails, this.selectedMVType);
    }

    String getMissigValueXformType() {
        return this.selectedMVType;
    }

    Object getReplacementValue() throws Exception {
        return this.missingValuesValuePanel.getReplacementValue();
    }

    String getSelectedStats() {
        return this.missingValuesStatsPanel.getSelectedStats();
    }

    public Integer getDataType() {
        return this.dataType;
    }

    public TransformationType getResultTransformationType() throws Exception {
        TransformationType transformationType = new TransformationType();
        if (this.dataType == 2) {
            CategoricalStatistic categoricalStatistic = null;
            if (this.selectedMVType.equals(TransformationTypes.getTRANSFORMATION_TYPE_MISS_VALUES_STATS())) {
                categoricalStatistic = new CategoricalStatistic();
                categoricalStatistic.setReplaceNullsWith(this.missingValuesStatsPanel.getSelectedStats());
            }
            TransformationType.MissingValuesCategorical missingValuesCategorical = new TransformationType.MissingValuesCategorical();
            transformationType.setMissingValuesCategorical(missingValuesCategorical);
            if (null != categoricalStatistic) {
                missingValuesCategorical.setCategoricalStatistic(categoricalStatistic);
            } else {
                TransformationType.MissingValuesCategorical.Value value = new TransformationType.MissingValuesCategorical.Value();
                value.setReplaceNullsWith(this.missingValuesValuePanel.getReplacementValue().toString());
                missingValuesCategorical.setValue(value);
            }
        } else if (this.dataType == 1) {
            NumericStatistic numericStatistic = null;
            if (this.selectedMVType.equals(TransformationTypes.getTRANSFORMATION_TYPE_MISS_VALUES_STATS())) {
                numericStatistic = new NumericStatistic();
                numericStatistic.setReplaceNullsWith(this.missingValuesStatsPanel.getSelectedStats());
            }
            TransformationType.MissingValuesNumeric missingValuesNumeric = new TransformationType.MissingValuesNumeric();
            transformationType.setMissingValuesNumeric(missingValuesNumeric);
            if (null != numericStatistic) {
                missingValuesNumeric.setNumericStatistic(numericStatistic);
            } else {
                TransformationType.MissingValuesNumeric.Value value = new TransformationType.MissingValuesNumeric.Value();
                value.setReplaceNullsWith(Double.valueOf(this.missingValuesValuePanel.getReplacementValue().toString()));
                missingValuesNumeric.setValue(value);
            }
        } else {
            DateStatistic dateStatistic = null;
            if (this.selectedMVType.equals(TransformationTypes.getTRANSFORMATION_TYPE_MISS_VALUES_STATS())) {
                dateStatistic = new DateStatistic();
                dateStatistic.setReplaceNullsWith(this.missingValuesStatsPanel.getSelectedStats());
            }
            TransformationType.MissingValuesDate missingValuesDate = new TransformationType.MissingValuesDate();
            transformationType.setMissingValuesDate(missingValuesDate);
            if (null != dateStatistic) {
                missingValuesDate.setDateStatistic(dateStatistic);
            } else {
                TransformationType.MissingValuesDate.Value value = new TransformationType.MissingValuesDate.Value();
                value.setReplaceNullsWith((XMLGregorianCalendar)this.replacementValue);
                missingValuesDate.setValue(value);
            }
        }
        return transformationType;
    }
}

