/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect.r;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.controls.CustomPIPopupListener;
import oracle.dmt.dataminer.controls.ToolTipComboBoxRenderer;
import oracle.dmt.dataminer.core.model.common.build.TargetItem;
import oracle.dmt.dataminer.core.utils.comparator.AttributeTypeComparator;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.build.CaseEditRecord;
import oracle.dmt.dataminer.workflow.dialog.build.TargetEditRecord;
import oracle.dmt.dataminer.workflow.inspect.GeneralBuildPIComponentGUI;
import oracle.dmt.dataminer.workflow.inspect.ModelBuildNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.r.RBuildNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.r.RBuildPIComponentHelper;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.ExtensibleBuildNode;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CaseAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.ExtensibleBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningResultType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RBuildNodeType;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;

public class RBuildPIComponentTargetPanel
extends JPanel
implements GeneralBuildPIComponentGUI {
    private static final Logger theLogger = Logger.getLogger(RBuildPIComponentTargetPanel.class.getName());
    private static final String[] FUNCTION_MODEL = new String[]{BuildEditorLrb.get("BUILD_NODE_FUNCTION_HINT"), BuildEditorLrb.get("EXTENSIBLE_CLASSIFICATION_TYPE"), BuildEditorLrb.get("EXTENSIBLE_REGRESSION_TYPE"), BuildEditorLrb.get("EXTENSIBLE_CLUSTERING_TYPE"), BuildEditorLrb.get("EXTENSIBLE_FEATURE_EXTRACTION_TYPE")};
    private DefaultComboBoxModel<TargetItem> targetComboModel;
    private DefaultComboBoxModel<String> functionComboModel;
    private WorkflowNodePropertyProxyModel model;
    private ExtensibleBuildNodeType extensibleMetadata;
    private ExtensibleBuildNode extensibleNode;
    private List<MiningResultType> testResults;
    private RBuildNodeType rNodeMetadata;
    private TargetEditRecord targetEdits;
    private CaseEditRecord caseEdits;
    private List<ModelType> models;
    private boolean clearSearchState = true;
    private boolean loading;
    private JComboBox jCaseCombo;
    private JComboBox<String> jCbxFunction;
    private JComboBox<TargetItem> jCmbTarget;
    private JLabel jLblCaseIds;
    private JLabel jLblFunction;
    private JLabel jLblTarget;
    private JLabel statusCaseIcon;
    private JLabel statusFunctionIcon;
    private JLabel statusTargetIcon;

    public RBuildPIComponentTargetPanel(PropertyModel propertyModel) {
        this.extensibleNode = (ExtensibleBuildNode)this.getTargetNode(propertyModel);
        if (this.extensibleNode == null) {
            return;
        }
        this.extensibleMetadata = (ExtensibleBuildNodeType)this.extensibleNode.getData();
        this.rNodeMetadata = (RBuildNodeType)this.extensibleMetadata;
        this.models = MetaDataHelper.getModelsCollection((BuildNodeType)this.extensibleNode.getData());
        this.model = (WorkflowNodePropertyProxyModel)propertyModel;
        this.testResults = new ArrayList<MiningResultType>();
        if (this.extensibleNode.isSupervisedBuildNode()) {
            ExtensibleBuildNodeType extensibleBuildNodeType = (ExtensibleBuildNodeType)this.extensibleNode.getData();
            MiningFunctionType miningFunctionType = this.extensibleNode.getMiningFunctionType();
            if (extensibleBuildNodeType.getResults() == null) {
                ExtensibleBuildNode.setMiningFunctionType(extensibleBuildNodeType, miningFunctionType);
            }
            if (this.extensibleNode.isClassification()) {
                this.testResults.addAll(extensibleBuildNodeType.getResults().getClassificationResult());
            } else if (this.extensibleNode.isRegression()) {
                this.testResults.addAll(extensibleBuildNodeType.getResults().getRegressionResult());
            }
        }
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jLblTarget = new JLabel();
        this.jCmbTarget = new JComboBox();
        this.jLblCaseIds = new JLabel();
        this.jCaseCombo = new JComboBox();
        this.statusTargetIcon = new JLabel();
        this.statusCaseIcon = new JLabel();
        this.jLblFunction = new JLabel();
        this.jCbxFunction = new JComboBox();
        this.statusFunctionIcon = new JLabel();
        this.jLblTarget.setText("Target:");
        this.jLblTarget.setMinimumSize(new Dimension(75, 18));
        this.jLblTarget.setPreferredSize(new Dimension(75, 20));
        this.jLblCaseIds.setText("Case IDs:");
        this.statusTargetIcon.setText("warningIcon");
        this.statusCaseIcon.setText("warningIcon");
        this.jLblFunction.setText("Function:");
        this.statusFunctionIcon.setText("warningIcon");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLblCaseIds, -2, 55, -2).addComponent(this.jLblTarget, -2, 75, -2).addComponent(this.jLblFunction)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jCaseCombo, 0, 190, Short.MAX_VALUE).addComponent(this.jCmbTarget, 0, 190, Short.MAX_VALUE).addComponent(this.jCbxFunction, 0, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.statusFunctionIcon).addComponent(this.statusTargetIcon).addComponent(this.statusCaseIcon)).addContainerGap(52, Short.MAX_VALUE)));
        groupLayout.linkSize(0, this.jLblCaseIds, this.jLblTarget);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(3, 3, 3).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblFunction).addComponent(this.jCbxFunction, -2, -1, -2).addComponent(this.statusFunctionIcon)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblTarget, -2, -1, -2).addComponent(this.jCmbTarget, -2, -1, -2).addComponent(this.statusTargetIcon)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblCaseIds, -2, 14, -2).addComponent(this.jCaseCombo, -2, -1, -2).addComponent(this.statusCaseIcon)).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.linkSize(1, this.jLblCaseIds, this.jLblTarget);
    }

    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jLblTarget, this.jCmbTarget, (String)(PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_TARGET") + ":"));
        ResourceUtils.resLabel((JLabel)this.jLblCaseIds, (Component)this.jCaseCombo, (String)PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_CASE_IDS"));
        this.initIconResources();
    }

    public void initUI() {
        if (this.extensibleNode == null) {
            return;
        }
        this.loading = true;
        this.loadMiningFunction();
        this.jCbxFunction.addPopupMenuListener(new CustomPIPopupListener(){

            @Override
            public void updatePropertyModel(Object object) {
                MiningFunctionType miningFunctionType = null;
                String string = (String)RBuildPIComponentTargetPanel.this.functionComboModel.getSelectedItem();
                if (BuildEditorLrb.get("BUILD_NODE_FUNCTION_HINT").equals(string)) {
                    RBuildPIComponentTargetPanel.this.statusFunctionIcon.setVisible(true);
                    RBuildPIComponentTargetPanel.this.statusFunctionIcon.setIcon(OracleIcons.getIcon((String)"warning.png"));
                    RBuildPIComponentTargetPanel.this.statusFunctionIcon.setToolTipText(BuildEditorLrb.get("BUILD_NODE_FUNCTION_INVALID_TIP"));
                } else {
                    if (BuildEditorLrb.get("EXTENSIBLE_CLASSIFICATION_TYPE").equals(string)) {
                        miningFunctionType = MiningFunctionType.CLASSIFICATION;
                    } else if (BuildEditorLrb.get("EXTENSIBLE_REGRESSION_TYPE").equals(string)) {
                        miningFunctionType = MiningFunctionType.REGRESSION;
                    } else if (BuildEditorLrb.get("EXTENSIBLE_CLUSTERING_TYPE").equals(string)) {
                        miningFunctionType = MiningFunctionType.CLUSTERING;
                    } else if (BuildEditorLrb.get("EXTENSIBLE_FEATURE_EXTRACTION_TYPE").equals(string)) {
                        miningFunctionType = MiningFunctionType.FEATURE_EXTRACTION;
                    } else assert (false) : "Mining Function Not Supported";
                    RBuildPIComponentTargetPanel.this.statusFunctionIcon.setVisible(false);
                    if (BuildEditorLrb.get("BUILD_NODE_FUNCTION_HINT").equals(RBuildPIComponentTargetPanel.this.functionComboModel.getElementAt(0))) {
                        RBuildPIComponentTargetPanel.this.functionComboModel.removeElementAt(0);
                    }
                }
                RBuildPIComponentTargetPanel.this.setValue(miningFunctionType);
            }
        });
        this.targetComboModel = new DefaultComboBoxModel();
        this.jCmbTarget.setModel(this.targetComboModel);
        if (this.extensibleNode.isSupervisedBuildNode()) {
            this.jCmbTarget.setEnabled(this.isWritable());
            this.initTargetAttributeUI();
        } else {
            this.loadDummyTarget();
        }
        this.jCmbTarget.setRenderer(new ToolTipComboBoxRenderer());
        this.loadCaseIdUI((BuildNodeType)this.extensibleMetadata);
        this.jCaseCombo.addPopupMenuListener(new CustomPIPopupListener(){

            @Override
            public void updatePropertyModel(Object object) {
                if (object instanceof CaseIdItem) {
                    CaseIdItem caseIdItem = (CaseIdItem)object;
                    AttributeType attributeType = caseIdItem.item;
                    RBuildPIComponentTargetPanel.this.caseEdits.getCaseAttributes().getAttribute().clear();
                    RBuildPIComponentTargetPanel.this.caseEdits.getCaseAttributes().getAttribute().add(attributeType);
                    RBuildPIComponentTargetPanel.this.setValue(RBuildPIComponentTargetPanel.this.caseEdits);
                } else {
                    RBuildPIComponentTargetPanel.this.caseEdits.getCaseAttributes().getAttribute().clear();
                    RBuildPIComponentTargetPanel.this.setValue(RBuildPIComponentTargetPanel.this.caseEdits);
                }
            }
        });
        this.jCaseCombo.setEnabled(this.isWritable());
        this.loading = false;
    }

    public void reloadUI(PropertyModel propertyModel) {
        if (this.extensibleNode == null) {
            return;
        }
        this.extensibleMetadata = (ExtensibleBuildNodeType)this.extensibleNode.getData();
        this.rNodeMetadata = (RBuildNodeType)this.extensibleMetadata;
        this.model = (WorkflowNodePropertyProxyModel)propertyModel;
        this.loading = true;
        this.models.clear();
        this.models = MetaDataHelper.getModelsCollection((BuildNodeType)this.extensibleNode.getData());
        this.loadMiningFunction();
        this.testResults.clear();
        if (this.extensibleNode.isSupervisedBuildNode()) {
            this.loadTargetModel();
            this.jCmbTarget.setEnabled(this.isWritable());
            if (this.extensibleNode.isClassification()) {
                this.testResults.addAll(this.extensibleMetadata.getResults().getClassificationResult());
            } else if (this.extensibleNode.isRegression()) {
                this.testResults.addAll(this.extensibleMetadata.getResults().getRegressionResult());
            }
        } else {
            this.loadDummyTarget();
        }
        this.loadCaseIdUI((BuildNodeType)this.extensibleMetadata);
        this.jCaseCombo.setEnabled(this.isWritable());
        this.loading = false;
    }

    @Override
    public boolean getClearState() {
        return this.clearSearchState;
    }

    @Override
    public void setClearState(boolean bl) {
        this.clearSearchState = bl;
    }

    @Override
    public JPanel getGUIComponent() {
        return this;
    }

    @Override
    public boolean isWritable() {
        return RBuildPIComponentHelper.isWritable((PropertyModel)this.model);
    }

    @Override
    public AbstractBuildNode getTargetNode(PropertyModel propertyModel) {
        return RBuildPIComponentHelper.getTargetNode(propertyModel);
    }

    @Override
    public Context getContext(PropertyModel propertyModel) {
        return RBuildPIComponentHelper.getContext(propertyModel);
    }

    private void loadMiningFunction() {
        this.functionComboModel = new DefaultComboBoxModel<String>(FUNCTION_MODEL);
        this.jCbxFunction.setModel(this.functionComboModel);
        MiningFunctionType miningFunctionType = this.extensibleMetadata.getMiningFunction();
        if (miningFunctionType != null) {
            switch (miningFunctionType) {
                case CLASSIFICATION: {
                    this.functionComboModel.setSelectedItem(BuildEditorLrb.get("EXTENSIBLE_CLASSIFICATION_TYPE"));
                    break;
                }
                case REGRESSION: {
                    this.functionComboModel.setSelectedItem(BuildEditorLrb.get("EXTENSIBLE_REGRESSION_TYPE"));
                    break;
                }
                case CLUSTERING: {
                    this.functionComboModel.setSelectedItem(BuildEditorLrb.get("EXTENSIBLE_CLUSTERING_TYPE"));
                    break;
                }
                case FEATURE_EXTRACTION: {
                    this.functionComboModel.setSelectedItem(BuildEditorLrb.get("EXTENSIBLE_FEATURE_EXTRACTION_TYPE"));
                    break;
                }
                default: {
                    assert (false) : "Invalid Option";
                    break;
                }
            }
            if (this.rNodeMetadata.getModels().getRModel().isEmpty()) {
                this.jCbxFunction.setEnabled(this.isWritable());
                this.statusFunctionIcon.setVisible(false);
            } else {
                this.jCbxFunction.setEnabled(false);
                this.statusFunctionIcon.setVisible(true);
                this.statusFunctionIcon.setIcon(OracleIcons.getIcon((String)"info.png"));
                this.statusFunctionIcon.setToolTipText(BuildEditorLrb.get("R_MINING_FUNCTION_CHANGE"));
            }
            this.functionComboModel.removeElementAt(0);
        } else {
            this.statusFunctionIcon.setVisible(true);
            this.statusFunctionIcon.setIcon(OracleIcons.getIcon((String)"warning.png"));
            this.statusFunctionIcon.setToolTipText(BuildEditorLrb.get("BUILD_NODE_FUNCTION_INVALID_TIP"));
        }
    }

    private void loadDummyTarget() {
        this.jCmbTarget.setEnabled(false);
        this.targetComboModel.addElement(TargetItem.NONE);
        this.statusTargetIcon.setIcon(OracleIcons.getIcon((String)"info.png"));
        this.statusTargetIcon.setToolTipText(BuildEditorLrb.get("R_BUILD_NO_TARGET_NEEDED"));
    }

    private void loadTargetModel() {
        List list = this.extensibleMetadata.getMiningAttributes().getMiningAttribute();
        Collections.sort(list, AttributeTypeComparator.getComparator());
        this.targetComboModel.removeAllElements();
        this.targetComboModel.addElement(TargetItem.NONE);
        for (MiningAttributeType miningAttributeType : list) {
            if (!DatabaseMetadataUtils.isTargetCategoricalDataTypeSupported(this.getContext((PropertyModel)this.model), miningAttributeType.getDataType())) continue;
            this.targetComboModel.addElement(new TargetItem(miningAttributeType));
        }
        AttributeType attributeType = this.extensibleMetadata.getTargetAttribute();
        if (attributeType == null) {
            this.jCmbTarget.setSelectedIndex(0);
            this.statusTargetIcon.setVisible(true);
        } else {
            MiningAttributeType miningAttributeType;
            this.targetComboModel.removeElementAt(0);
            if (AttributeStatus.INVALID.equals((Object)attributeType.getStatus())) {
                miningAttributeType = new TargetItem(attributeType);
                this.targetComboModel.addElement((TargetItem)miningAttributeType);
                this.targetComboModel.setSelectedItem(miningAttributeType);
                this.jCmbTarget.setEditable(false);
                this.statusTargetIcon.setVisible(true);
            } else {
                miningAttributeType = new TargetItem(attributeType);
                this.targetComboModel.addElement((TargetItem)miningAttributeType);
                this.targetComboModel.setSelectedItem(miningAttributeType);
                this.statusTargetIcon.setVisible(false);
            }
        }
    }

    private void loadCaseIdUI(BuildNodeType buildNodeType) {
        Object object;
        AttributeType attributeType3;
        AttributeType attributeType2;
        Object object2;
        List list = buildNodeType.getMiningAttributes().getMiningAttribute();
        if (this.caseEdits == null) {
            this.caseEdits = new CaseEditRecord(new CaseAttributes());
        } else {
            object2 = this.caseEdits.getCaseAttributes();
            if (object2 != null && (attributeType2 = this.caseEdits.getCaseAttributes().getAttribute()) != null) {
                attributeType2.clear();
            }
        }
        object2 = buildNodeType.getCaseAttributes().getAttribute();
        attributeType2 = object2.iterator();
        while (attributeType2.hasNext()) {
            attributeType3 = (AttributeType)attributeType2.next();
            object = (AttributeType)MetaDataHelper.copyMetadataObject(attributeType3);
            this.caseEdits.getCaseAttributes().getAttribute().add(object);
        }
        this.jCaseCombo.removeAllItems();
        this.jCaseCombo.addItem(CommonLrb.get("NONE"));
        for (AttributeType attributeType3 : list) {
            if (!DatabaseMetadataUtils.isCaseIdDataTypeSupported(this.getContext((PropertyModel)this.model), attributeType3.getDataType())) continue;
            this.jCaseCombo.addItem(new CaseIdItem((MiningAttributeType)attributeType3));
        }
        this.jCaseCombo.setRenderer(new ToolTipComboBoxRenderer());
        attributeType2 = null;
        if (!object2.isEmpty()) {
            attributeType2 = (AttributeType)object2.get(0);
        } else {
            this.jCaseCombo.setSelectedIndex(0);
        }
        if (attributeType2 != null && AttributeStatus.VALID.equals((Object)attributeType2.getStatus())) {
            boolean bl = false;
            for (int i = 0; i < this.jCaseCombo.getItemCount(); ++i) {
                if (!(this.jCaseCombo.getItemAt(i) instanceof CaseIdItem)) continue;
                CaseIdItem caseIdItem = (CaseIdItem)this.jCaseCombo.getItemAt(i);
                if (!attributeType2.getName().equals(caseIdItem.item.getName()) || !attributeType2.getDataType().equals(caseIdItem.item.getDataType())) continue;
                this.jCaseCombo.setSelectedIndex(i);
                bl = true;
            }
            if (!bl) {
                theLogger.log(Level.WARNING, "Could not find the case id value event though it is valid");
            } else {
                this.statusCaseIcon.setVisible(false);
            }
        } else if (attributeType2 != null && AttributeStatus.INVALID.equals((Object)attributeType2.getStatus())) {
            attributeType3 = MetaDataHelper.createMiningAttributeFrom(attributeType2);
            object = new CaseIdItem((MiningAttributeType)attributeType3);
            this.jCaseCombo.setEditable(true);
            this.jCaseCombo.setSelectedItem(object);
            this.jCaseCombo.setEditable(false);
            this.statusCaseIcon.setVisible(true);
            this.statusCaseIcon.setText("");
        } else if (attributeType2 == null) {
            this.statusCaseIcon.setVisible(true);
            this.statusCaseIcon.setText(BuildEditorLrb.get("BUILD_NODE_CASE_ID_WARN"));
        }
    }

    private void initTargetAttributeUI() {
        this.loadTargetModel();
        this.jCmbTarget.addPopupMenuListener(new CustomPIPopupListener(){

            @Override
            public void updatePropertyModel(Object object) {
                if (!RBuildPIComponentTargetPanel.this.isWritable()) {
                    return;
                }
                if (object instanceof TargetItem) {
                    TargetItem targetItem = (TargetItem)object;
                    AttributeType attributeType = targetItem.getItem();
                    if (RBuildPIComponentTargetPanel.this.targetEdits == null) {
                        RBuildPIComponentTargetPanel.this.targetEdits = new TargetEditRecord();
                    } else {
                        TargetItem targetItem2 = new TargetItem(RBuildPIComponentTargetPanel.this.targetEdits.getTargetAttribute());
                        if (targetItem2.equals((Object)targetItem)) {
                            return;
                        }
                    }
                    RBuildPIComponentTargetPanel.this.targetEdits.setTargetAttribute((AttributeType)MetaDataHelper.copyMetadataObject(attributeType));
                    if (AttributeStatus.INVALID.equals((Object)attributeType.getStatus())) {
                        RBuildPIComponentTargetPanel.this.statusTargetIcon.setVisible(true);
                    } else {
                        RBuildPIComponentTargetPanel.this.statusTargetIcon.setVisible(false);
                    }
                    if (TargetItem.NONE.equals((Object)RBuildPIComponentTargetPanel.this.targetComboModel.getElementAt(0))) {
                        RBuildPIComponentTargetPanel.this.targetComboModel.removeElementAt(0);
                    }
                    RBuildPIComponentTargetPanel.this.setValue(RBuildPIComponentTargetPanel.this.targetEdits);
                }
            }
        });
    }

    private void initIconResources() {
        this.statusFunctionIcon.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this.statusFunctionIcon.setText("");
        this.statusFunctionIcon.setToolTipText(BuildEditorLrb.get("BUILD_NODE_FUNCTION_INVALID_TIP"));
        this.statusTargetIcon.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this.statusTargetIcon.setText("");
        this.statusCaseIcon.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this.statusCaseIcon.setText("");
    }

    private void setValue(TargetEditRecord targetEditRecord) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this.model);
        if (abstractBuildNode == null) {
            return;
        }
        if (targetEditRecord != null) {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property(String.valueOf(RBuildNodePropertyModel.TARGET.index), null, new ComplexProperty("targetAttribute", targetEditRecord.getTargetAttribute()), null, null));
            ArrayList<ModelType> arrayList2 = new ArrayList<ModelType>();
            arrayList2.addAll(this.models);
            arrayList.addAll(this.prepareStatusReady(arrayList2));
            ModelBuildNodePropertyModel.updateTargetModelAttributes((BuildNodeType)((ExtensibleBuildNodeType)abstractBuildNode.getData()), arrayList, RBuildNodePropertyModel.MINING_ATTRIBUTE_SETTINGS.index, targetEditRecord.getTargetAttribute());
            this.model.setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_TARGET"), abstractBuildNode, arrayList);
            this.updateWorkFlow();
        }
    }

    private void setValue(MiningFunctionType miningFunctionType) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this.model);
        ExtensibleBuildNodeType extensibleBuildNodeType = (ExtensibleBuildNodeType)abstractBuildNode.getData();
        if (abstractBuildNode == null) {
            return;
        }
        ArrayList<Property> arrayList = new ArrayList<Property>();
        String string = String.valueOf(RBuildNodePropertyModel.MINING_FUNCTION.index);
        MiningFunctionType miningFunctionType2 = extensibleBuildNodeType.getMiningFunction();
        ComplexProperty complexProperty = new ComplexProperty("miningFunction", miningFunctionType);
        complexProperty.setOldData(miningFunctionType2);
        arrayList.add(new Property(string, null, complexProperty, null, null));
        if (!AbstractBuildNode.isSupervisedFunction(miningFunctionType)) {
            complexProperty = new ComplexProperty("targetAttribute", null);
            complexProperty.setOldData(extensibleBuildNodeType.getTargetAttribute());
            arrayList.add(new Property(String.valueOf(RBuildNodePropertyModel.TARGET.index), null, complexProperty, null, null));
        }
        this.model.setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_MINING_FUNCTION"), abstractBuildNode, arrayList);
        this.updateWorkFlow();
    }

    private void setValue(CaseEditRecord caseEditRecord) {
        if (this.extensibleNode == null) {
            return;
        }
        HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>();
        HashMap<String, ModelStatusType> hashMap2 = new HashMap<String, ModelStatusType>();
        RBuildPIComponentHelper.getMaps((PropertyModel)this.model, hashMap, hashMap2);
        if (caseEditRecord != null) {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            CaseAttributes caseAttributes = new CaseAttributes();
            caseAttributes.getAttribute().addAll(caseEditRecord.getCaseAttributes().getAttribute());
            arrayList.add(new Property(String.valueOf(RBuildNodePropertyModel.CASE_IDS.index), null, new ComplexProperty("caseAttributes", caseAttributes), null, null));
            if (hashMap != null && !hashMap.isEmpty()) {
                arrayList.add(new Property(String.valueOf(RBuildNodePropertyModel.MODELS_RERUN.index), null, new ComplexProperty("modelsRerun", hashMap), null, null));
                if (this.extensibleNode.isSupervisedBuildNode()) {
                    arrayList.add(new Property(String.valueOf(RBuildNodePropertyModel.TESTS_RERUN.index), null, new ComplexProperty("testsRerun", hashMap2), null, null));
                }
                BuildNodeType buildNodeType = (BuildNodeType)this.extensibleNode.getData();
                ModelBuildNodePropertyModel.updateCaseIdModelAttributes(buildNodeType, arrayList, RBuildNodePropertyModel.MINING_ATTRIBUTE_SETTINGS.index, caseAttributes);
            }
            this.model.setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_CASE_ID"), this.extensibleNode, arrayList);
            this.updateWorkFlow();
        }
    }

    private void updateWorkFlow() {
        Editor editor = EditorManager.getEditorManager().getCurrentEditor();
        if (editor instanceof WorkflowEditor) {
            WorkflowEditor workflowEditor = (WorkflowEditor)editor;
            WorkflowNode workflowNode = workflowEditor.getWorkflowNode();
            Node node = workflowEditor.getSelectedDiagramNode();
            if (node != null) {
                workflowEditor.setSelected(workflowNode.getEngine(), node);
            }
        }
    }

    private List<Property> prepareStatusReady(List<ModelType> list) {
        HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>();
        for (ModelType object2 : list) {
            hashMap.put(object2.getId(), ModelStatusType.READY);
        }
        HashMap hashMap2 = new HashMap();
        for (MiningResultType miningResultType : this.testResults) {
            if (hashMap.get(miningResultType.getModelId()) == null) continue;
            hashMap2.put(miningResultType.getModelId(), ModelStatusType.READY);
        }
        ArrayList<Property> arrayList = new ArrayList<Property>();
        if (list != null && !list.isEmpty()) {
            arrayList.add(new Property(String.valueOf(RBuildNodePropertyModel.MODELS_RERUN.index), null, new ComplexProperty("modelsRerun", hashMap), null, null));
            if (this.extensibleNode.isSupervisedBuildNode()) {
                arrayList.add(new Property(String.valueOf(RBuildNodePropertyModel.TESTS_RERUN.index), null, new ComplexProperty("testsRerun", hashMap2), null, null));
            }
        }
        return arrayList;
    }

    private static class CaseIdItem {
        AttributeType item = new AttributeType();

        CaseIdItem(MiningAttributeType miningAttributeType) {
            this.item.setAlias(miningAttributeType.getAlias());
            this.item.setDataType(miningAttributeType.getDataType());
            this.item.setName(miningAttributeType.getName());
            this.item.setStatus(AttributeStatus.fromValue((String)miningAttributeType.getStatus().value()));
        }

        public String toString() {
            return this.item.getName();
        }
    }
}

