/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect.r;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.dmt.dataminer.PreferencesLrb;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.inspect.AbstractNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.NodeProperty;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyGroupImpl;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationResultType;
import oracle.dmt.dataminer.workflow.xmlschema.ExtensibleBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressions;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionResultType;
import oracle.ide.Context;

public class RPartitionedBuildNodePropertyModel
extends AbstractNodePropertyModel {
    private static int ACCURACY_METRIC_SIZE = 1;
    protected static List<NodeProperty> properties = new ArrayList<NodeProperty>();
    public static final NodeProperty MODEL_ADDED_REMOVED;
    public static final NodeProperty ALGORITHM_SETTINGS;
    public static final NodeProperty CASE_IDS;
    public static final NodeProperty MODELS_RERUN;
    public static final NodeProperty MODEL_ANNOTATION;
    public static final NodeProperty MODEL_NAME;
    public static final NodeProperty MODEL_USEFOROUTPUT;
    public static final NodeProperty MINING_ATTRIBUTE_SETTINGS;
    public static final NodeProperty PARTITIONS_MAX_NUM;
    public static final NodeProperty PARTITIONS_EXPRESSION_EDIT;
    public static final NodeProperty MINING_FUNCTION;
    public static final NodeProperty TARGET;
    public static final NodeProperty SPLIT_VALUE;
    public static final NodeProperty SPLIT_DATA_FORMAT;
    public static final NodeProperty GEN_ACCURACY_METRICS_CLAS;
    public static final NodeProperty GEN_ACCURACY_METRICS_REG;
    public static final NodeProperty GEN_RESIDUALS;
    public static final NodeProperty TESTS_RERUN;
    public static final NodeProperty TESTS_ADDED_REMOVED;
    public static final NodeProperty TEST_OPTIONS_CHANGED;
    public static final NodeProperty TEST_SETTINGS_CHANGED;

    public RPartitionedBuildNodePropertyModel(Context context) {
        super(context);
        NodeType nodeType = this.workflowElement.getNode().getData();
        ExtensibleBuildNodeType extensibleBuildNodeType = (ExtensibleBuildNodeType)nodeType;
        MiningFunctionType miningFunctionType = extensibleBuildNodeType.getMiningFunction();
        if (miningFunctionType != null) {
            switch (miningFunctionType) {
                case CLASSIFICATION: 
                case REGRESSION: {
                    NodeProperty nodeProperty = MiningFunctionType.REGRESSION.equals((Object)miningFunctionType) ? GEN_ACCURACY_METRICS_REG : GEN_ACCURACY_METRICS_CLAS;
                    Property property = new Property(nodeProperty.id, nodeProperty.displayName, nodeType.getName(), nodeProperty.description, nodeProperty.group);
                    this.rows.add(property);
                    break;
                }
            }
        }
    }

    @Override
    public String getHelpTopic() {
        return "r_node_pi";
    }

    @Override
    protected int getPropertyEndIndex() {
        return super.getPropertyEndIndex() + ACCURACY_METRIC_SIZE;
    }

    @Override
    protected List<NodeProperty> getNodeProperties() {
        return properties;
    }

    private static void prepareStatusReady(List<Property> list, AbstractBuildNode abstractBuildNode) {
        Object object2;
        List<ModelType> list2 = MetaDataHelper.getModelsCollection((BuildNodeType)abstractBuildNode.getData());
        HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>();
        for (ModelType object22 : list2) {
            hashMap.put(object22.getId(), ModelStatusType.READY);
        }
        if (!hashMap.isEmpty()) {
            list.add(new Property(String.valueOf(RPartitionedBuildNodePropertyModel.MODELS_RERUN.index), null, new ComplexProperty("modelsRerun", hashMap), null, null));
        }
        HashMap hashMap2 = new HashMap();
        List<ClassificationResultType> list3 = MetaDataHelper.getClassificationResultsCollection(abstractBuildNode);
        for (Object object2 : list3) {
            if (null == hashMap.get(object2.getModelId())) continue;
            hashMap2.put(object2.getModelId(), ModelStatusType.READY);
        }
        List<RegressionResultType> list4 = MetaDataHelper.getRegressionResultsCollection(abstractBuildNode);
        object2 = list4.iterator();
        while (object2.hasNext()) {
            RegressionResultType regressionResultType = (RegressionResultType)object2.next();
            if (null == hashMap.get(regressionResultType.getModelId())) continue;
            hashMap2.put(regressionResultType.getModelId(), ModelStatusType.READY);
        }
        if (!hashMap2.isEmpty()) {
            list.add(new Property(String.valueOf(RPartitionedBuildNodePropertyModel.TESTS_RERUN.index), null, new ComplexProperty("testsRerun", hashMap2), null, null));
        }
    }

    public static void updateMaxNumPartitions(List<Property> list, AbstractBuildNode abstractBuildNode, BigInteger bigInteger, BigInteger bigInteger2) {
        ComplexProperty complexProperty = new ComplexProperty("PARTITIONS_MAX_NUM", bigInteger);
        complexProperty.setOldData(bigInteger2);
        list.add(new Property(String.valueOf(RPartitionedBuildNodePropertyModel.PARTITIONS_MAX_NUM.index), null, complexProperty, null, null));
        RPartitionedBuildNodePropertyModel.prepareStatusReady(list, abstractBuildNode);
    }

    public static void updatePartitionColumns(List<Property> list, AbstractBuildNode abstractBuildNode, PartitionExpressions partitionExpressions, PartitionExpressions partitionExpressions2) {
        ComplexProperty complexProperty = new ComplexProperty("PARTITIONS_EXPRESSION_EDIT", partitionExpressions);
        complexProperty.setOldData(partitionExpressions2);
        list.add(new Property(String.valueOf(RPartitionedBuildNodePropertyModel.PARTITIONS_EXPRESSION_EDIT.index), null, complexProperty, null, null));
        RPartitionedBuildNodePropertyModel.prepareStatusReady(list, abstractBuildNode);
    }

    static {
        properties.addAll(AbstractNodePropertyModel.properties);
        int n = properties.size();
        MODEL_ADDED_REMOVED = new NodeProperty("modelAddedorRemoved", PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_VIEW_PROPERTY_MODEL"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_VIEW_PROPERTY_MODEL_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(MODEL_ADDED_REMOVED);
        ALGORITHM_SETTINGS = new NodeProperty("algTreeSettings", PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_ALGORITHM"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_ALGORITHM_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(ALGORITHM_SETTINGS);
        CASE_IDS = new NodeProperty("caseAttributes", PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_CASE_ID"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_CASE_ID_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(CASE_IDS);
        MODELS_RERUN = new NodeProperty("modelsRerun", PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_BUTTON_MARK_FOR_RERUN_BUILD"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_BUTTON_MARK_FOR_RERUN_BUILD"), Groups.CUSTOM_BUILD, n++);
        properties.add(MODELS_RERUN);
        MODEL_ANNOTATION = new NodeProperty("modelAnnotation", PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_ANNOTATION"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_ANNOTATION_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(MODEL_ANNOTATION);
        MODEL_NAME = new NodeProperty("modelName", PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_NAME"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_NAME_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(MODEL_NAME);
        MODEL_USEFOROUTPUT = new NodeProperty("modelUseForOutput", PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_USEFOR_OUTPUT"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_USEFOR_OUTPUT_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(MODEL_USEFOROUTPUT);
        MINING_ATTRIBUTE_SETTINGS = new NodeProperty("miningAttributeSettings", PropertyLrb.get("PI_BUILD_GROUP_BUILD_ATTRIBUTE_USAGE"), PropertyLrb.get("PI_BUILD_GROUP_BUILD_ATTRIBUTE_USAGE_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(MINING_ATTRIBUTE_SETTINGS);
        PARTITIONS_MAX_NUM = new NodeProperty("PARTITIONS_MAX_NUM", PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_NUM_PARTITIONS"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_NUM_PARTITIONS_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(PARTITIONS_MAX_NUM);
        PARTITIONS_EXPRESSION_EDIT = new NodeProperty("PARTITIONS_EXPRESSION_EDIT", PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_PARTITION"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_PARTITION_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(PARTITIONS_EXPRESSION_EDIT);
        MINING_FUNCTION = new NodeProperty("miningFunction", PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_MINING_FUNCTION"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_MINING_FUNCTION_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(MINING_FUNCTION);
        TARGET = new NodeProperty("targetAttribute", PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_TARGET"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_TARGET_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(TARGET);
        SPLIT_VALUE = new NodeProperty("splitValueChanged", PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TEST_SPLIT"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TEST_SPLIT_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(SPLIT_VALUE);
        SPLIT_DATA_FORMAT = new NodeProperty("splitDataFormat", PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TEST_SPLIT_FORMAT"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TEST_SPLIT_FORMAT_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(SPLIT_DATA_FORMAT);
        GEN_RESIDUALS = new NodeProperty("genResiduals", PropertyLrb.get("PI_REGRESS_BUILD_GROUP_TEST_RESIDUALS"), PropertyLrb.get("PI_REGRESS_BUILD_GROUP_TEST_RESIDUALS_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(GEN_RESIDUALS);
        TESTS_RERUN = new NodeProperty("testsRerun", PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_BUTTON_MARK_FOR_RERUN_TEST"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_BUTTON_MARK_FOR_RERUN_TEST"), Groups.CUSTOM_BUILD, n++);
        properties.add(TESTS_RERUN);
        TESTS_ADDED_REMOVED = new NodeProperty("testsRemoved", PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_BUTTON_MARK_FOR_RERUN_TEST"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_BUTTON_MARK_FOR_RERUN_TEST"), Groups.CUSTOM_BUILD, n++);
        properties.add(TESTS_ADDED_REMOVED);
        TEST_OPTIONS_CHANGED = new NodeProperty("testOptionsChanged", PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_OPTIONS_CHANGED"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_OPTIONS_CHANGED_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(TEST_OPTIONS_CHANGED);
        TEST_SETTINGS_CHANGED = new NodeProperty("testSettingsChanged", PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_SETTINGS_CHANGED"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_SETTINGS_CHANGED_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(TEST_SETTINGS_CHANGED);
        GEN_ACCURACY_METRICS_REG = new NodeProperty("genAccuracyMetrics", PropertyLrb.get("PI_REGRESS_BUILD_GROUP_TEST_PERFORMANCE_METRICS"), PropertyLrb.get("PI_REGRESS_BUILD_GROUP_TEST_PERFORMANCE_METRICS_DESCRIPTION"), Groups.CUSTOM_BUILD, n);
        GEN_ACCURACY_METRICS_CLAS = new NodeProperty("genAccuracyMetrics", PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_GEN_ACCURACY_METRICS"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_GEN_ACCURACY_METRICS_DESCRIPTION"), Groups.CUSTOM_BUILD, n);
    }

    private static class Groups {
        private static final PropertyGroupImpl CUSTOM_BUILD = new PropertyGroupImpl(PreferencesLrb.get("PI_BUILD_NODE_GROUP_BUILD_TITLE"));

        private Groups() {
        }
    }
}

