/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect.transformations;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.GraphicalPreferencesSettings;
import oracle.dmt.dataminer.controls.OutputCellEditor;
import oracle.dmt.dataminer.controls.dialog.DialogHelper;
import oracle.dmt.dataminer.controls.renderers.IconCellRenderer;
import oracle.dmt.dataminer.controls.renderers.OutputCellRenderer;
import oracle.dmt.dataminer.dprofiler.DataProfileStatisticsData;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.dialog.transformations.AddCustomTransformsDialogEx;
import oracle.dmt.dataminer.workflow.dialog.transformations.AddTransformsDialog;
import oracle.dmt.dataminer.workflow.dialog.transformations.ApplyTransformWizard;
import oracle.dmt.dataminer.workflow.dialog.transformations.EditCustomTransformsDialog;
import oracle.dmt.dataminer.workflow.dialog.transformations.EditTransformationsAbtractDialog;
import oracle.dmt.dataminer.workflow.dialog.transformations.EditTransformsDialog;
import oracle.dmt.dataminer.workflow.dialog.transformations.FilterProcessor;
import oracle.dmt.dataminer.workflow.dialog.transformations.SearchHelper;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationStatisticsState;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationTypes;
import oracle.dmt.dataminer.workflow.dialog.transformations.XformDialogsLrb;
import oracle.dmt.dataminer.workflow.inspect.PIComponentPanel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.transformations.TransformNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.transformations.TransformationPIPropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.transformations.TransformationSettingsTableModel;
import oracle.dmt.dataminer.workflow.inspect.transformations.WorkflowTransformNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.TransformationNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MapTransformedSource;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.StatsSelection;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationOutputAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.TransformedAttributes;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.RolloverTableRenderer;

public class TransformationNodeAttributesPanel
extends PIComponentPanel
implements FilterProcessor {
    private static final Logger theLogger = Logger.getLogger(TransformationNodeAttributesPanel.class.getName());
    private JButton _removeBtn;
    private JButton _editBtn;
    private JButton _addBtn;
    private JButton _addCustomBtn;
    private JButton _outputTrueBtn;
    private JButton _outputFalseBtn;
    private SearchHelper _searchHelper;
    List<TransformationSourceAttribute> _combinedAttrList = new ArrayList<TransformationSourceAttribute>();
    private DataMinerTable _jAttributesTable = new DataMinerTable();
    private TransformationNode _targetNode;
    private GraphicalPreferencesSettings graphPanelSettings = GraphicalPreferencesSettings.getInstance((PropertyStorage)Preferences.getPreferences());
    private static Icon _editIcon;
    private Map<String, Boolean> _mapAutoGenerate = new HashMap<String, Boolean>();
    private ComponentWithTitlebar<JComponent> jAttributesComponent;

    public TransformationNodeAttributesPanel(PropertyModel propertyModel) {
        super(propertyModel);
        this.initComponents();
        this.initRes();
        this.initUI(propertyModel);
    }

    private void initComponents() {
        this.jAttributesComponent = new ComponentWithTitlebar();
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.jAttributesComponent, -1, 502, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(4, 4, 4).addComponent((Component)this.jAttributesComponent, -1, 296, Short.MAX_VALUE)));
    }

    public void initRes() {
        if (_editIcon == null) {
            _editIcon = InspectorArb.getIcon((int)24);
        }
    }

    public void initUI(PropertyModel propertyModel) {
        MapTransformedSource mapTransformedSource2;
        Object object;
        this._model = (WorkflowTransformNodePropertyProxyModel)propertyModel;
        this._targetNode = (TransformationNode)this.getTargetNode((PropertyModel)this._model);
        NodeType nodeType = this._targetNode.getData();
        TransformationNodeType transformationNodeType = (TransformationNodeType)nodeType;
        TransformationSourceAttributes transformationSourceAttributes = transformationNodeType.getTransformationSourceAttributes();
        TransformedAttributes transformedAttributes = transformationNodeType.getTransformedAttributes();
        if (transformationSourceAttributes != null && (object = transformationSourceAttributes.getTransformationSourceAttributeType()) != null && !object.isEmpty()) {
            this._combinedAttrList.addAll((Collection<TransformationSourceAttribute>)object);
        }
        if (transformedAttributes != null && (object = transformedAttributes.getMapTransformedSourceType()) != null && !object.isEmpty()) {
            for (MapTransformedSource mapTransformedSource2 : object) {
                this._combinedAttrList.add((TransformationSourceAttribute)mapTransformedSource2.getKey());
            }
        }
        object = new PITransformationSettingsTableModel(transformationNodeType.getStatsSelection(), transformationNodeType.getTransformedAttributes(), AttributeTypeHelper.toVector(this._combinedAttrList));
        this.setupItemsTable((TransformationSettingsTableModel)((Object)object));
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this._jAttributesTable));
        this.jAttributesComponent.setComponent((JComponent)jScrollPane);
        this.jAttributesComponent.setLabel(new JLabel(TransformationPIPropertyLrb.get("PI_TABLE_LABEL_COLUMNS")));
        mapTransformedSource2 = new ControlBar();
        this.installItemFilterActions((ControlBar)mapTransformedSource2);
        this._addBtn.setEnabled(false);
        this._addCustomBtn.setEnabled(false);
        this._editBtn.setEnabled(false);
        this._removeBtn.setEnabled(false);
        this._outputTrueBtn.setEnabled(false);
        this._outputFalseBtn.setEnabled(false);
        this.jAttributesComponent.setControlBar((ControlBar)mapTransformedSource2);
        this._jAttributesTable.setFillsViewportHeight(true);
        this._jAttributesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ListSelectionModel listSelectionModel;
                if (!TransformationNodeAttributesPanel.this.isWritable()) {
                    return;
                }
                if (mouseEvent.getClickCount() == 2 && !(listSelectionModel = TransformationNodeAttributesPanel.this._jAttributesTable.getSelectionModel()).isSelectionEmpty() && listSelectionModel.getMinSelectionIndex() == listSelectionModel.getMaxSelectionIndex()) {
                    Context context = TransformationNodeAttributesPanel.this.getContext((PropertyModel)TransformationNodeAttributesPanel.this._model);
                    AbstractNode abstractNode = TransformationNodeAttributesPanel.this._targetNode.findParentNode();
                    int[] nArray = TransformationNodeAttributesPanel.this._jAttributesTable.getSelectedRowsInModel();
                    TransformationSettingsTableModel transformationSettingsTableModel = (TransformationSettingsTableModel)((Object)TransformationNodeAttributesPanel.this._jAttributesTable.getModel());
                    TransformationSourceAttribute transformationSourceAttribute = (TransformationSourceAttribute)transformationSettingsTableModel.getDataVector().get(nArray[0]);
                    try {
                        if (DatabaseMetadataUtils.isACustomDataType(TransformationNodeAttributesPanel.this.getContext((PropertyModel)TransformationNodeAttributesPanel.this._model), transformationSourceAttribute.getDataType())) {
                            if (!(transformationSourceAttribute instanceof TransformationOutputAttribute)) {
                                return;
                            }
                        } else {
                            if (!DatabaseMetadataUtils.isDataTypeSupported(transformationSourceAttribute.getDataType())) {
                                return;
                            }
                            if (DatabaseMetadataUtils.isXMLType(transformationSourceAttribute.getDataType()) ? false == transformationSourceAttribute instanceof TransformationOutputAttribute : DatabaseMetadataUtils.isLOBType(transformationSourceAttribute.getDataType()) || DatabaseMetadataUtils.isBFILEype(transformationSourceAttribute.getDataType()) || "URITYPE".equals(transformationSourceAttribute.getDataType()) || "ROWID".equals(transformationSourceAttribute.getDataType()) || "UROWID".equals(transformationSourceAttribute.getDataType()) || "RAW".equals(transformationSourceAttribute.getDataType())) {
                                return;
                            }
                        }
                    }
                    catch (Exception exception) {
                        ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)"Unexpected Exception");
                        return;
                    }
                    NodeType nodeType = TransformationNodeAttributesPanel.this._targetNode.getData();
                    TransformationNodeType transformationNodeType = (TransformationNodeType)nodeType;
                    TransformationStatisticsState transformationStatisticsState = new TransformationStatisticsState(context, TransformationNodeAttributesPanel.this.graphPanelSettings, TransformationNodeAttributesPanel.this._targetNode, transformationNodeType.getTransformedAttributes(), AttributeTypeHelper.toVector(TransformationNodeAttributesPanel.this._combinedAttrList));
                    if (TransformationNodeAttributesPanel.this.loadAllStats(transformationStatisticsState)) {
                        return;
                    }
                    if (transformationSourceAttribute instanceof TransformationOutputAttribute) {
                        TransformationOutputAttribute transformationOutputAttribute = (TransformationOutputAttribute)transformationSourceAttribute;
                        ArrayList<TransformationSourceAttribute> arrayList = new ArrayList<TransformationSourceAttribute>();
                        arrayList.add(transformationSourceAttribute);
                        MapTransformedSource mapTransformedSource = AttributeTypeHelper.findMapTransformedSource(transformationNodeType.getTransformedAttributes(), (AttributeType)arrayList.get(0));
                        MapTransformedSource mapTransformedSource2 = AttributeTypeHelper.cloneMapTransformedSource(mapTransformedSource);
                        EditTransformationsAbtractDialog editTransformationsAbtractDialog = TransformationTypes.isCustomXform(transformationOutputAttribute.getTransformationElementType()) ? new EditCustomTransformsDialog(TransformationNodeAttributesPanel.this.getContext((PropertyModel)TransformationNodeAttributesPanel.this._model), TransformationNodeAttributesPanel.this._targetNode, (AbstractDataNode)abstractNode, transformationNodeType, transformationStatisticsState, transformationOutputAttribute) : new EditTransformsDialog(TransformationNodeAttributesPanel.this.getContext((PropertyModel)TransformationNodeAttributesPanel.this._model), TransformationNodeAttributesPanel.this._targetNode, (AbstractDataNode)abstractNode, transformationNodeType, transformationStatisticsState, arrayList, true, TransformationNodeAttributesPanel.this._mapAutoGenerate);
                        DialogHelper dialogHelper = new DialogHelper(editTransformationsAbtractDialog);
                        boolean bl = dialogHelper.showAsDialog(TransformationNodeAttributesPanel.this);
                        if (bl) {
                            MapTransformedSource mapTransformedSource3 = AttributeTypeHelper.cloneMapTransformedSource(editTransformationsAbtractDialog.getTransformedAttribute());
                            ArrayList<Property> arrayList2 = new ArrayList<Property>();
                            ComplexProperty complexProperty = new ComplexProperty("editColumn", mapTransformedSource3);
                            complexProperty.setOldData(mapTransformedSource2);
                            arrayList2.add(new Property(String.valueOf(TransformNodePropertyModel.EDIT_COLUMN.index), null, complexProperty, null, null));
                            ComplexProperty complexProperty2 = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
                            complexProperty2.setOldData(TransformationNodeAttributesPanel.this._targetNode.getSQLExpression());
                            arrayList2.add(new Property(String.valueOf(TransformNodePropertyModel.SQL_EXPRESSION.index), null, complexProperty2, null, null));
                            TransformationNodeAttributesPanel.this._model.setValueAt(TransformationPIPropertyLrb.get("PI_TRANSFORMATION_NODE_EDIT_TRANSFORMATION_ELEMENT"), TransformationNodeAttributesPanel.this._targetNode, arrayList2);
                        }
                    } else {
                        Object object2;
                        ArrayList<TransformationSourceAttribute> arrayList = new ArrayList<TransformationSourceAttribute>();
                        arrayList.add(transformationSourceAttribute);
                        List list = transformationNodeType.getTransformedAttributes().getMapTransformedSourceType();
                        TransformedAttributes transformedAttributes = new TransformedAttributes();
                        List list2 = transformedAttributes.getMapTransformedSourceType();
                        TransformedAttributes transformedAttributes2 = new TransformedAttributes();
                        List list3 = transformedAttributes2.getMapTransformedSourceType();
                        for (Object object2 : list) {
                            list3.add(AttributeTypeHelper.cloneMapTransformedSource((MapTransformedSource)object2));
                            list2.add(AttributeTypeHelper.cloneMapTransformedSource((MapTransformedSource)object2));
                        }
                        AddTransformsDialog addTransformsDialog = new AddTransformsDialog(TransformationNodeAttributesPanel.this.getContext((PropertyModel)TransformationNodeAttributesPanel.this._model), TransformationNodeAttributesPanel.this._targetNode, (AbstractDataNode)abstractNode, transformationNodeType, transformationStatisticsState, arrayList, TransformationNodeAttributesPanel.this._mapAutoGenerate);
                        object2 = new DialogHelper(addTransformsDialog);
                        if (((DialogHelper)object2).showAsDialog(TransformationNodeAttributesPanel.this)) {
                            ((TransformationSourceAttribute)arrayList.get(0)).setIsOutput(false);
                            MapTransformedSource mapTransformedSource = addTransformsDialog.getTransformedAttribute();
                            list2.add(mapTransformedSource);
                            ArrayList<Property> arrayList3 = new ArrayList<Property>();
                            ComplexProperty complexProperty = new ComplexProperty("addColumns", transformedAttributes);
                            complexProperty.setOldData(transformedAttributes2);
                            arrayList3.add(new Property(String.valueOf(TransformNodePropertyModel.ADD_COLUMNS.index), null, complexProperty, null, null));
                            ComplexProperty complexProperty3 = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
                            complexProperty3.setOldData(TransformationNodeAttributesPanel.this._targetNode.getSQLExpression());
                            arrayList3.add(new Property(String.valueOf(TransformNodePropertyModel.SQL_EXPRESSION.index), null, complexProperty3, null, null));
                            TransformationNodeAttributesPanel.this._model.setValueAt(TransformationPIPropertyLrb.get("PI_TRANSFORMATION_NODE_ADD_COLUMNS"), TransformationNodeAttributesPanel.this._targetNode, arrayList3);
                        }
                    }
                }
            }
        });
        this.setWritableControls();
    }

    private void setWritableControls() {
        boolean bl = this.isWritable();
        if (!bl) {
            this._addBtn.setEnabled(false);
            this._addCustomBtn.setEnabled(false);
            this._editBtn.setEnabled(false);
            this._removeBtn.setEnabled(false);
            this._outputTrueBtn.setEnabled(false);
            this._outputFalseBtn.setEnabled(false);
        }
        ((TransformationSettingsTableModel)((Object)this._jAttributesTable.getModel())).setWritable(bl);
    }

    private void setupItemsTable(TransformationSettingsTableModel transformationSettingsTableModel) {
        this._jAttributesTable.setModel((TableModel)((Object)transformationSettingsTableModel));
        this._jAttributesTable.setSorted(true);
        this._jAttributesTable.setShowGrid(true);
        this._jAttributesTable.setSortColumn(TransformationSettingsTableModel.COLUMN, true);
        this._jAttributesTable.getSelectionModel().addListSelectionListener(new SelectedItemSelectionHandler(this._jAttributesTable));
        IconCellRenderer iconCellRenderer = new IconCellRenderer(new IconCellRenderer.IconChooser(){

            @Override
            public Icon getIconFor(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                return IconCellRenderer.getIconForAttrStatus(TransformationNodeAttributesPanel.this._combinedAttrList, object);
            }
        });
        TableColumn tableColumn = this._jAttributesTable.getColumnModel().getColumn(TransformationSettingsTableModel.COLUMN);
        tableColumn.setCellRenderer(iconCellRenderer);
        tableColumn = this._jAttributesTable.getColumnModel().getColumn(TransformationSettingsTableModel.OUTPUT);
        tableColumn.setCellEditor(new OutputCellEditor());
        tableColumn.setCellRenderer(new OutputCellRenderer());
        this.setPreferredWidth(transformationSettingsTableModel);
    }

    private void installItemFilterActions(ControlBar controlBar) {
        this._editBtn = new JButton(_editIcon);
        this._editBtn.setToolTipText(XformDialogsLrb.get("TOOLTIP_EDIT_BIN_DEFINITION"));
        this._editBtn.getAccessibleContext().setAccessibleName(InspectorArb.getString((int)23));
        this._editBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    TransformationOutputAttribute transformationOutputAttribute;
                    int[] nArray = TransformationNodeAttributesPanel.this._jAttributesTable.getSelectedRowsInModel();
                    ArrayList<TransformationSourceAttribute> arrayList = new ArrayList<TransformationSourceAttribute>();
                    TransformationSettingsTableModel transformationSettingsTableModel = (TransformationSettingsTableModel)((Object)TransformationNodeAttributesPanel.this._jAttributesTable.getModel());
                    String string = null;
                    String string2 = null;
                    for (int i = 0; i < nArray.length; ++i) {
                        transformationOutputAttribute = (TransformationOutputAttribute)transformationSettingsTableModel.getDataVector().get(nArray[i]);
                        if (string == null) {
                            string = transformationOutputAttribute.getDataType();
                        } else if (!TransformationTypes.isComparabelDataTypes(string, transformationOutputAttribute.getDataType())) {
                            string2 = XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_INCOMPATIBLE_COLUMNS");
                            break;
                        }
                        arrayList.add((TransformationSourceAttribute)transformationOutputAttribute);
                    }
                    if (null != string2) {
                        MessageDialog.error((Component)Ide.getMainWindow(), string2, (String)XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
                        return;
                    }
                    AbstractDataNode abstractDataNode = (AbstractDataNode)TransformationNodeAttributesPanel.this._targetNode.findParentNode();
                    transformationOutputAttribute = TransformationNodeAttributesPanel.this._targetNode.getData();
                    TransformationNodeType transformationNodeType = (TransformationNodeType)transformationOutputAttribute;
                    Context context = TransformationNodeAttributesPanel.this.getContext((PropertyModel)TransformationNodeAttributesPanel.this._model);
                    TransformationStatisticsState transformationStatisticsState = new TransformationStatisticsState(context, TransformationNodeAttributesPanel.this.graphPanelSettings, TransformationNodeAttributesPanel.this._targetNode, transformationNodeType.getTransformedAttributes(), AttributeTypeHelper.toVector(TransformationNodeAttributesPanel.this._combinedAttrList));
                    if (TransformationNodeAttributesPanel.this.loadAllStats(transformationStatisticsState)) {
                        return;
                    }
                    if (arrayList.size() == 1) {
                        TransformationOutputAttribute transformationOutputAttribute2 = (TransformationOutputAttribute)arrayList.get(0);
                        MapTransformedSource mapTransformedSource = AttributeTypeHelper.findMapTransformedSource(transformationNodeType.getTransformedAttributes(), (AttributeType)arrayList.get(0));
                        MapTransformedSource mapTransformedSource2 = AttributeTypeHelper.cloneMapTransformedSource(mapTransformedSource);
                        ArrayList<TransformationSourceAttribute> arrayList2 = new ArrayList<TransformationSourceAttribute>();
                        arrayList2.add((TransformationSourceAttribute)arrayList.get(0));
                        EditTransformationsAbtractDialog editTransformationsAbtractDialog = TransformationTypes.isCustomXform(transformationOutputAttribute2.getTransformationElementType()) ? new EditCustomTransformsDialog(context, TransformationNodeAttributesPanel.this._targetNode, abstractDataNode, (TransformationNodeType)TransformationNodeAttributesPanel.this._targetNode.getData(), transformationStatisticsState, transformationOutputAttribute2) : new EditTransformsDialog(context, TransformationNodeAttributesPanel.this._targetNode, abstractDataNode, (TransformationNodeType)TransformationNodeAttributesPanel.this._targetNode.getData(), transformationStatisticsState, arrayList2, true, TransformationNodeAttributesPanel.this._mapAutoGenerate);
                        DialogHelper dialogHelper = new DialogHelper(editTransformationsAbtractDialog);
                        if (dialogHelper.showAsDialog(TransformationNodeAttributesPanel.this)) {
                            Cursor cursor = TransformationNodeAttributesPanel.this.getCursor();
                            TransformationNodeAttributesPanel.this.setCursor(new Cursor(3));
                            MapTransformedSource mapTransformedSource3 = AttributeTypeHelper.cloneMapTransformedSource(editTransformationsAbtractDialog.getTransformedAttribute());
                            ArrayList<Property> arrayList3 = new ArrayList<Property>();
                            ComplexProperty complexProperty = new ComplexProperty("editColumn", mapTransformedSource3);
                            complexProperty.setOldData(mapTransformedSource2);
                            arrayList3.add(new Property(String.valueOf(TransformNodePropertyModel.EDIT_COLUMN.index), null, complexProperty, null, null));
                            ComplexProperty complexProperty2 = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
                            complexProperty2.setOldData(TransformationNodeAttributesPanel.this._targetNode.getSQLExpression());
                            arrayList3.add(new Property(String.valueOf(TransformNodePropertyModel.SQL_EXPRESSION.index), null, complexProperty2, null, null));
                            TransformationNodeAttributesPanel.this._model.setValueAt(TransformationPIPropertyLrb.get("PI_TRANSFORMATION_NODE_EDIT_TRANSFORMATION_ELEMENT"), TransformationNodeAttributesPanel.this._targetNode, arrayList3);
                            TransformationNodeAttributesPanel.this.setCursor(cursor);
                        }
                    } else {
                        ApplyTransformWizard applyTransformWizard = new ApplyTransformWizard(true);
                        if (applyTransformWizard.runWizard((Component)Ide.getMainWindow(), context, TransformationNodeAttributesPanel.this._targetNode, abstractDataNode, (TransformationNodeType)TransformationNodeAttributesPanel.this._targetNode.getData(), arrayList)) {
                            List<MapTransformedSource> list = applyTransformWizard.getAllXformedColumns();
                            TransformedAttributes transformedAttributes = new TransformedAttributes();
                            transformedAttributes.getMapTransformedSourceType().addAll(list);
                            TransformedAttributes transformedAttributes2 = new TransformedAttributes();
                            transformedAttributes2.getMapTransformedSourceType().addAll(list);
                            ArrayList<Property> arrayList4 = new ArrayList<Property>();
                            ComplexProperty complexProperty = new ComplexProperty("editColumns", transformedAttributes);
                            complexProperty.setOldData(transformedAttributes2);
                            arrayList4.add(new Property(String.valueOf(TransformNodePropertyModel.EDIT_COLUMN.index), null, complexProperty, null, null));
                            ComplexProperty complexProperty3 = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
                            complexProperty3.setOldData(TransformationNodeAttributesPanel.this._targetNode.getSQLExpression());
                            arrayList4.add(new Property(String.valueOf(TransformNodePropertyModel.SQL_EXPRESSION.index), null, complexProperty3, null, null));
                            TransformationNodeAttributesPanel.this._model.setValueAt(TransformationPIPropertyLrb.get("PI_TRANSFORMATION_NODE_EDIT_TRANSFORMATION_ELEMENT"), TransformationNodeAttributesPanel.this._targetNode, arrayList4);
                        }
                    }
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
        });
        controlBar.add((Component)this._editBtn);
        this._removeBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this._removeBtn.setToolTipText(XformDialogsLrb.get("TOOLTIP_REMOVE_BIN_DEFINITION"));
        this._removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object2;
                TransformationOutputAttribute transformationOutputAttribute;
                int[] nArray = TransformationNodeAttributesPanel.this._jAttributesTable.getSelectedRowsInModel();
                HashMap<String, TransformationOutputAttribute> hashMap = new HashMap<String, TransformationOutputAttribute>();
                TransformationSettingsTableModel transformationSettingsTableModel = (TransformationSettingsTableModel)((Object)TransformationNodeAttributesPanel.this._jAttributesTable.getModel());
                for (int i = 0; i < nArray.length; ++i) {
                    transformationOutputAttribute = (TransformationOutputAttribute)transformationSettingsTableModel.getDataVector().get(nArray[i]);
                    hashMap.put(transformationOutputAttribute.getName(), transformationOutputAttribute);
                }
                NodeType nodeType = TransformationNodeAttributesPanel.this._targetNode.getData();
                transformationOutputAttribute = (TransformationNodeType)nodeType;
                List list = transformationOutputAttribute.getTransformedAttributes().getMapTransformedSourceType();
                TransformedAttributes transformedAttributes = new TransformedAttributes();
                List list2 = transformedAttributes.getMapTransformedSourceType();
                TransformedAttributes transformedAttributes2 = new TransformedAttributes();
                List list3 = transformedAttributes2.getMapTransformedSourceType();
                for (Object object2 : list) {
                    list3.add(AttributeTypeHelper.cloneMapTransformedSource((MapTransformedSource)object2));
                    if (null != hashMap.get(object2.getKey().getName())) continue;
                    list2.add(AttributeTypeHelper.cloneMapTransformedSource((MapTransformedSource)object2));
                }
                ArrayList arrayList = new ArrayList();
                object2 = new ComplexProperty("removeColumns", transformedAttributes);
                ((ComplexProperty)object2).setOldData(transformedAttributes2);
                arrayList.add(new Property(String.valueOf(TransformNodePropertyModel.REMOVE_COLUMNS.index), null, object2, null, null));
                ComplexProperty complexProperty = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
                complexProperty.setOldData(TransformationNodeAttributesPanel.this._targetNode.getSQLExpression());
                arrayList.add(new Property(String.valueOf(TransformNodePropertyModel.SQL_EXPRESSION.index), null, complexProperty, null, null));
                TransformationNodeAttributesPanel.this._model.setValueAt(TransformationPIPropertyLrb.get("PI_TRANSFORMATION_NODE_REMOVE_COLUMNS"), TransformationNodeAttributesPanel.this._targetNode, arrayList);
            }
        });
        controlBar.add((Component)this._removeBtn);
        this._addBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
        this._addBtn.setToolTipText(XformDialogsLrb.get("TOOLTIP_ADD_BIN_DEFINITION"));
        this._addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object4;
                TransformedAttributes transformedAttributes;
                Object object2;
                Object object3;
                int[] nArray = TransformationNodeAttributesPanel.this._jAttributesTable.getSelectedRowsInModel();
                ArrayList<TransformationSourceAttribute> arrayList = new ArrayList<TransformationSourceAttribute>();
                String string = null;
                if (nArray != null && nArray.length > 0) {
                    object3 = (TransformationSettingsTableModel)((Object)TransformationNodeAttributesPanel.this._jAttributesTable.getModel());
                    object2 = null;
                    for (int i = 0; i < nArray.length; ++i) {
                        transformedAttributes = (TransformationSourceAttribute)((TransformationSettingsTableModel)((Object)object3)).getDataVector().get(nArray[i]);
                        if (transformedAttributes instanceof TransformationOutputAttribute) {
                            string = XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ORIGINAL_SELECTED_COLUMNS");
                            break;
                        }
                        if (object2 == null) {
                            object2 = transformedAttributes.getDataType();
                        } else if (!TransformationTypes.isComparabelDataTypes((String)object2, transformedAttributes.getDataType())) {
                            string = XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_INCOMPATIBLE_COLUMNS");
                            break;
                        }
                        arrayList.add((TransformationSourceAttribute)transformedAttributes);
                    }
                }
                if (null != string) {
                    MessageDialog.error((Component)Ide.getMainWindow(), string, (String)XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
                    return;
                }
                object3 = TransformationNodeAttributesPanel.this._targetNode.getData();
                object2 = (TransformationNodeType)object3;
                List list = object2.getTransformedAttributes().getMapTransformedSourceType();
                transformedAttributes = new TransformedAttributes();
                List list2 = transformedAttributes.getMapTransformedSourceType();
                TransformedAttributes transformedAttributes2 = new TransformedAttributes();
                List list3 = transformedAttributes2.getMapTransformedSourceType();
                for (Object object4 : list) {
                    list3.add(AttributeTypeHelper.cloneMapTransformedSource(object4));
                    list2.add(AttributeTypeHelper.cloneMapTransformedSource(object4));
                }
                Context context = TransformationNodeAttributesPanel.this.getContext((PropertyModel)TransformationNodeAttributesPanel.this._model);
                object4 = new TransformationStatisticsState(context, TransformationNodeAttributesPanel.this.graphPanelSettings, TransformationNodeAttributesPanel.this._targetNode, object2.getTransformedAttributes(), AttributeTypeHelper.toVector(TransformationNodeAttributesPanel.this._combinedAttrList));
                if (TransformationNodeAttributesPanel.this.loadAllStats((TransformationStatisticsState)object4)) {
                    return;
                }
                AbstractDataNode abstractDataNode = (AbstractDataNode)TransformationNodeAttributesPanel.this._targetNode.findParentNode();
                if (arrayList.size() == 1) {
                    AddTransformsDialog addTransformsDialog = new AddTransformsDialog(context, TransformationNodeAttributesPanel.this._targetNode, abstractDataNode, (TransformationNodeType)object2, (TransformationStatisticsState)object4, (List<TransformationSourceAttribute>)arrayList, TransformationNodeAttributesPanel.this._mapAutoGenerate);
                    DialogHelper dialogHelper = new DialogHelper(addTransformsDialog);
                    if (dialogHelper.showAsDialog(TransformationNodeAttributesPanel.this)) {
                        ((TransformationSourceAttribute)arrayList.get(0)).setIsOutput(false);
                        MapTransformedSource mapTransformedSource = addTransformsDialog.getTransformedAttribute();
                        list2.add(mapTransformedSource);
                        ArrayList<Property> arrayList2 = new ArrayList<Property>();
                        ComplexProperty complexProperty = new ComplexProperty("addColumns", transformedAttributes);
                        complexProperty.setOldData(transformedAttributes2);
                        arrayList2.add(new Property(String.valueOf(TransformNodePropertyModel.ADD_COLUMNS.index), null, complexProperty, null, null));
                        ComplexProperty complexProperty2 = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
                        complexProperty2.setOldData(TransformationNodeAttributesPanel.this._targetNode.getSQLExpression());
                        arrayList2.add(new Property(String.valueOf(TransformNodePropertyModel.SQL_EXPRESSION.index), null, complexProperty2, null, null));
                        TransformationNodeAttributesPanel.this._model.setValueAt(TransformationPIPropertyLrb.get("PI_TRANSFORMATION_NODE_ADD_COLUMNS"), TransformationNodeAttributesPanel.this._targetNode, arrayList2);
                    }
                } else {
                    ApplyTransformWizard applyTransformWizard = new ApplyTransformWizard(true);
                    if (applyTransformWizard.runWizard((Component)Ide.getMainWindow(), context, TransformationNodeAttributesPanel.this._targetNode, abstractDataNode, (TransformationNodeType)TransformationNodeAttributesPanel.this._targetNode.getData(), arrayList)) {
                        List<MapTransformedSource> list4 = applyTransformWizard.getAllXformedColumns();
                        list2.addAll(list4);
                        ArrayList<Property> arrayList3 = new ArrayList<Property>();
                        ComplexProperty complexProperty = new ComplexProperty("addColumns", transformedAttributes);
                        complexProperty.setOldData(transformedAttributes2);
                        arrayList3.add(new Property(String.valueOf(TransformNodePropertyModel.ADD_COLUMNS.index), null, complexProperty, null, null));
                        ComplexProperty complexProperty3 = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
                        complexProperty3.setOldData(TransformationNodeAttributesPanel.this._targetNode.getSQLExpression());
                        arrayList3.add(new Property(String.valueOf(TransformNodePropertyModel.SQL_EXPRESSION.index), null, complexProperty3, null, null));
                        TransformationNodeAttributesPanel.this._model.setValueAt(TransformationPIPropertyLrb.get("PI_TRANSFORMATION_NODE_ADD_COLUMNS"), TransformationNodeAttributesPanel.this._targetNode, arrayList3);
                    }
                }
            }
        });
        controlBar.add((Component)this._addBtn);
        this._addCustomBtn = new JButton(DataMinerIcons.get(Icons.PI_ATTR_GROUP_VALUE_ADD_EXPRESSION));
        this._addCustomBtn.setToolTipText(XformDialogsLrb.get("TOOLTIP_ADD_CUSTOM_XFORM"));
        this._addCustomBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object2;
                NodeType nodeType = TransformationNodeAttributesPanel.this._targetNode.getData();
                TransformationNodeType transformationNodeType = (TransformationNodeType)nodeType;
                List list = transformationNodeType.getTransformedAttributes().getMapTransformedSourceType();
                TransformedAttributes transformedAttributes = new TransformedAttributes();
                List list2 = transformedAttributes.getMapTransformedSourceType();
                TransformedAttributes transformedAttributes2 = new TransformedAttributes();
                List list3 = transformedAttributes2.getMapTransformedSourceType();
                for (Object object2 : list) {
                    list3.add(AttributeTypeHelper.cloneMapTransformedSource(object2));
                    list2.add(AttributeTypeHelper.cloneMapTransformedSource(object2));
                }
                Context context = TransformationNodeAttributesPanel.this.getContext((PropertyModel)TransformationNodeAttributesPanel.this._model);
                object2 = new TransformationStatisticsState(context, TransformationNodeAttributesPanel.this.graphPanelSettings, TransformationNodeAttributesPanel.this._targetNode, transformationNodeType.getTransformedAttributes(), AttributeTypeHelper.toVector(TransformationNodeAttributesPanel.this._combinedAttrList));
                if (TransformationNodeAttributesPanel.this.loadAllStats((TransformationStatisticsState)object2)) {
                    return;
                }
                AbstractDataNode abstractDataNode = (AbstractDataNode)TransformationNodeAttributesPanel.this._targetNode.findParentNode();
                AddCustomTransformsDialogEx addCustomTransformsDialogEx = new AddCustomTransformsDialogEx(context, TransformationNodeAttributesPanel.this._targetNode, abstractDataNode, transformationNodeType, null, (TransformationStatisticsState)object2);
                DialogHelper dialogHelper = new DialogHelper(addCustomTransformsDialogEx);
                if (dialogHelper.showAsDialog(TransformationNodeAttributesPanel.this)) {
                    MapTransformedSource mapTransformedSource = addCustomTransformsDialogEx.getTransformedAttribute();
                    list2.add(mapTransformedSource);
                    ArrayList<Property> arrayList = new ArrayList<Property>();
                    ComplexProperty complexProperty = new ComplexProperty("addColumns", transformedAttributes);
                    complexProperty.setOldData(transformedAttributes2);
                    arrayList.add(new Property(String.valueOf(TransformNodePropertyModel.ADD_COLUMNS.index), null, complexProperty, null, null));
                    ComplexProperty complexProperty2 = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
                    complexProperty2.setOldData(TransformationNodeAttributesPanel.this._targetNode.getSQLExpression());
                    arrayList.add(new Property(String.valueOf(TransformNodePropertyModel.SQL_EXPRESSION.index), null, complexProperty2, null, null));
                    TransformationNodeAttributesPanel.this._model.setValueAt(TransformationPIPropertyLrb.get("PI_TRANSFORMATION_NODE_ADD_COLUMNS"), TransformationNodeAttributesPanel.this._targetNode, arrayList);
                }
            }
        });
        controlBar.add((Component)this._addCustomBtn);
        this._outputTrueBtn = new JButton(OracleIcons.getIcon((String)"messageAsync.png"));
        this._outputTrueBtn.setToolTipText(XformDialogsLrb.get("TOOLTIP_INCLUDE_BIN_DEFINITION"));
        this._outputTrueBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TransformationNodeAttributesPanel.this.setOutputState(true);
            }
        });
        controlBar.add((Component)this._outputTrueBtn);
        this._outputFalseBtn = new JButton(DataMinerIcons.get(Icons.ATTR_IGNORE));
        this._outputFalseBtn.setToolTipText(XformDialogsLrb.get("TOOLTIP_EXCLUDE_BIN_DEFINITION"));
        this._outputFalseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TransformationNodeAttributesPanel.this.setOutputState(false);
            }
        });
        controlBar.add((Component)this._outputFalseBtn);
        if (this._searchHelper == null) {
            this._searchHelper = new SearchHelper(this);
        }
        controlBar.addSeparator();
        Component component = this._searchHelper.createFindPane();
        controlBar.add(component);
    }

    private void setOutputState(boolean bl) {
        int[] nArray = this._jAttributesTable.getSelectedRowsInModel();
        if (nArray != null && nArray.length > 0) {
            Object object;
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            HashMap<String, Boolean> hashMap2 = new HashMap<String, Boolean>();
            TransformationSettingsTableModel transformationSettingsTableModel = (TransformationSettingsTableModel)((Object)this._jAttributesTable.getModel());
            boolean bl2 = true;
            for (int i = 0; i < nArray.length; ++i) {
                object = (TransformationSourceAttribute)transformationSettingsTableModel.getDataVector().get(nArray[i]);
                if (bl2 && object.isIsOutput() != bl) {
                    bl2 = false;
                }
                hashMap.put(object.getName(), object.isIsOutput());
                hashMap2.put(object.getName(), bl);
            }
            if (bl2) {
                return;
            }
            ComplexProperty complexProperty = new ComplexProperty("outputState", hashMap2);
            complexProperty.setOldData(hashMap);
            object = new ArrayList();
            object.add(new Property(String.valueOf(TransformNodePropertyModel.OUTPUT_STATE.index), null, complexProperty, null, null));
            ComplexProperty complexProperty2 = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
            complexProperty2.setOldData(this._targetNode.getSQLExpression());
            object.add(new Property(String.valueOf(TransformNodePropertyModel.SQL_EXPRESSION.index), null, complexProperty2, null, null));
            this._model.setValueAt(TransformationPIPropertyLrb.get("PI_TRANSFORMATION_NODE_OUTPUT_TRANSFORMATION_ELEMENT"), this._targetNode, (List<Property>)object);
        }
    }

    private boolean loadAllStats(TransformationStatisticsState transformationStatisticsState) {
        NodeType nodeType = this._targetNode.getData();
        TransformationNodeType transformationNodeType = (TransformationNodeType)nodeType;
        if (null != transformationNodeType.getInputStatisticTable()) {
            String string = transformationNodeType.getInputStatisticTable().getName();
            StringBuffer stringBuffer = null;
            try {
                this._loadStatistics(string, transformationStatisticsState);
            }
            catch (Exception exception) {
                stringBuffer = new StringBuffer(TransformationPIPropertyLrb.get("PI_ERROR_MESSAGE_CAN_NOT_LOAD_STATISTICS"));
                if (exception != null) {
                    stringBuffer.append(exception.getMessage());
                }
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)stringBuffer.toString(), (String)XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
            }
            return stringBuffer != null;
        }
        return false;
    }

    private void _loadStatistics(String string, TransformationStatisticsState transformationStatisticsState) throws Exception {
        LoadStatsProgressRunnable loadStatsProgressRunnable = new LoadStatsProgressRunnable(string, transformationStatisticsState);
        loadStatsProgressRunnable.setTitle(TransformationPIPropertyLrb.get("PI_TRANSFORMATION_NODE_LOADING_STATISTICS"));
        loadStatsProgressRunnable.setMessage(TransformationPIPropertyLrb.get("PI_TRANSFORMATION_NODE_LOADING_STATISTICS_DETAILS"));
        loadStatsProgressRunnable.start(true);
        if (null != loadStatsProgressRunnable.ex) {
            throw loadStatsProgressRunnable.ex;
        }
    }

    public void updateUI(PropertyModel propertyModel) {
        List list;
        if (!(propertyModel instanceof WorkflowTransformNodePropertyProxyModel)) {
            return;
        }
        this._model = (WorkflowTransformNodePropertyProxyModel)propertyModel;
        this._targetNode = (TransformationNode)this.getTargetNode((PropertyModel)this._model);
        NodeType nodeType = this._targetNode.getData();
        TransformationNodeType transformationNodeType = (TransformationNodeType)nodeType;
        TransformationSourceAttributes transformationSourceAttributes = transformationNodeType.getTransformationSourceAttributes();
        TransformedAttributes transformedAttributes = transformationNodeType.getTransformedAttributes();
        this._combinedAttrList.clear();
        if (transformationSourceAttributes != null && (list = transformationSourceAttributes.getTransformationSourceAttributeType()) != null && !list.isEmpty()) {
            this._combinedAttrList.addAll(list);
        }
        if (transformedAttributes != null && (list = transformedAttributes.getMapTransformedSourceType()) != null && !list.isEmpty()) {
            for (MapTransformedSource mapTransformedSource : list) {
                this._combinedAttrList.add((TransformationSourceAttribute)mapTransformedSource.getKey());
            }
        }
        this.updateTable(transformationNodeType);
        this.setWritableControls();
    }

    private void updateTable(TransformationNodeType transformationNodeType) {
        TableColumnModel tableColumnModel;
        Object object;
        int[] nArray = this._jAttributesTable.getSelectedRowsInModel();
        HashMap<String, TableColumnModel> hashMap = null;
        if (nArray != null && nArray.length > 0) {
            object = (TransformationSettingsTableModel)((Object)this._jAttributesTable.getModel());
            hashMap = new HashMap<String, TableColumnModel>(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                tableColumnModel = (TransformationSourceAttribute)((TransformationSettingsTableModel)((Object)object)).getDataVector().get(nArray[i]);
                hashMap.put(tableColumnModel.getName(), tableColumnModel);
            }
        }
        object = this._jAttributesTable.getVisibleRect();
        TableColumn tableColumn = null;
        tableColumnModel = this._jAttributesTable.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            tableColumn = tableColumnModel.getColumn(i);
            nArray2[i] = tableColumn.getPreferredWidth();
        }
        PITransformationSettingsTableModel pITransformationSettingsTableModel = new PITransformationSettingsTableModel(transformationNodeType.getStatsSelection(), transformationNodeType.getTransformedAttributes(), AttributeTypeHelper.toVector(this._combinedAttrList), this._searchHelper.getSearchText(), this._searchHelper.getCurrentSearchCategory());
        this.setupItemsTable(pITransformationSettingsTableModel);
        if (hashMap != null) {
            Object object2;
            Vector<Integer> vector = new Vector<Integer>();
            Vector vector2 = pITransformationSettingsTableModel.getDataVector();
            for (int i = 0; i < vector2.size(); ++i) {
                object2 = (TransformationSourceAttribute)vector2.get(i);
                if (null == hashMap.get(object2.getName())) continue;
                vector.add(i);
            }
            if (!vector.isEmpty()) {
                Integer[] integerArray = vector.toArray(new Integer[vector.size()]);
                object2 = new int[integerArray.length];
                for (int i = 0; i < integerArray.length; ++i) {
                    object2[i] = (TransformationSourceAttribute)integerArray[i];
                }
                this._jAttributesTable.setSelectedRowsInModel((int[])object2);
            }
        }
        this._jAttributesTable.scrollRectToVisible((Rectangle)object);
        tableColumnModel = this._jAttributesTable.getColumnModel();
        int n2 = tableColumnModel.getColumnCount();
        if (n == n2) {
            for (int i = 0; i < n2; ++i) {
                tableColumn = tableColumnModel.getColumn(i);
                tableColumn.setPreferredWidth(nArray2[i]);
            }
        }
    }

    private void setPreferredWidth(TransformationSettingsTableModel transformationSettingsTableModel) {
        TableColumnModel tableColumnModel = this._jAttributesTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(TransformationSettingsTableModel.COLUMN);
        RolloverTableRenderer rolloverTableRenderer = (RolloverTableRenderer)tableColumn.getCellRenderer();
        DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)rolloverTableRenderer.getBaseRenderer();
        Font font = defaultTableCellRenderer.getFont();
        FontMetrics fontMetrics = defaultTableCellRenderer.getFontMetrics(font);
        String string = transformationSettingsTableModel.getMaxString(TransformationSettingsTableModel.COLUMN);
        int n = fontMetrics.stringWidth(string) + 5;
        tableColumn.setPreferredWidth(n += OracleIcons.getIcon((String)"attribute.png").getIconWidth());
        tableColumn = tableColumnModel.getColumn(TransformationSettingsTableModel.TYPE);
        string = transformationSettingsTableModel.getMaxString(TransformationSettingsTableModel.TYPE);
        n = fontMetrics.stringWidth(string) + 5;
        tableColumn.setPreferredWidth(n);
        tableColumn = tableColumnModel.getColumn(TransformationSettingsTableModel.SOURCE_COLUMN);
        string = transformationSettingsTableModel.getMaxString(TransformationSettingsTableModel.SOURCE_COLUMN);
        n = fontMetrics.stringWidth(string) + 5;
        tableColumn.setPreferredWidth(n);
        tableColumn = tableColumnModel.getColumn(TransformationSettingsTableModel.TRANSFORM);
        string = transformationSettingsTableModel.getMaxString(TransformationSettingsTableModel.TRANSFORM);
        n = fontMetrics.stringWidth(string) + 5;
        tableColumn.setPreferredWidth(n);
        this._jAttributesTable.setAutoResizeMode(3);
    }

    @Override
    public void processFilter(String string) {
        try {
            NodeType nodeType = this._targetNode.getData();
            TransformationNodeType transformationNodeType = (TransformationNodeType)nodeType;
            PITransformationSettingsTableModel pITransformationSettingsTableModel = new PITransformationSettingsTableModel(transformationNodeType.getStatsSelection(), transformationNodeType.getTransformedAttributes(), AttributeTypeHelper.toVector(this._combinedAttrList), string, this._searchHelper.getCurrentSearchCategory());
            this.setupItemsTable(pITransformationSettingsTableModel);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)XformDialogsLrb.get("APPLY_TRANSFORMATION_WIZARD_FILTER_ERROR_TITLE"), (String)XformDialogsLrb.get("APPLY_TRANSFORMATION_WIZARD_FILTER_ERROR_MESSAGE"), null);
        }
    }

    private static class LoadStatsProgressRunnable
    extends ProgressRunnable {
        TransformationStatisticsState state;
        String statisticTable;
        Exception ex;
        List<DataProfileStatisticsData> statsData;

        LoadStatsProgressRunnable(String string, TransformationStatisticsState transformationStatisticsState) {
            this.state = transformationStatisticsState;
            this.statisticTable = string;
        }

        protected Object doWork() throws Exception {
            try {
                this.state.loadExtendedModel(null, 0);
            }
            catch (Exception exception) {
                this.ex = exception;
            }
            return this;
        }

        protected void finish(Object object) {
        }

        protected void doCancel() {
            this.statsData = null;
        }
    }

    class SelectedItemSelectionHandler
    implements ListSelectionListener {
        GenericTable jAttributesTable;

        SelectedItemSelectionHandler(GenericTable genericTable) {
            this.jAttributesTable = genericTable;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = true;
            if (!TransformationNodeAttributesPanel.this.isWritable()) {
                return;
            }
            if (listSelectionModel.isSelectionEmpty()) {
                bl = false;
            } else {
                int[] nArray = this.jAttributesTable.getSelectedRowsInModel();
                if (nArray != null && nArray.length > 0) {
                    bl4 = true;
                    TransformationSettingsTableModel transformationSettingsTableModel = (TransformationSettingsTableModel)((Object)this.jAttributesTable.getModel());
                    TransformationSourceAttribute transformationSourceAttribute = (TransformationSourceAttribute)transformationSettingsTableModel.getDataVector().get(nArray[0]);
                    bl5 = transformationSourceAttribute.getStatus().equals((Object)AttributeStatus.VALID);
                    String string = transformationSourceAttribute.getDataType();
                    boolean bl6 = false;
                    try {
                        bl6 = DatabaseMetadataUtils.isDataTypeSupported(string) && !DatabaseMetadataUtils.isACustomDataType(TransformationNodeAttributesPanel.this.getContext((PropertyModel)TransformationNodeAttributesPanel.this._model), string) && !string.equals("RAW") && !string.equals("LONG RAW") && !string.equals("UROWID") && !string.equals("ROWID") && !string.equals("CLOB") && !string.equals("BLOB") && !string.equals("NCLOB") && !string.equals("BFILE") && !string.equals("XMLTYPE") && !string.equals("URITYPE");
                    }
                    catch (Exception exception) {
                        theLogger.log(Level.FINEST, "Unexpected Exception", exception);
                    }
                    boolean bl7 = transformationSourceAttribute instanceof TransformationOutputAttribute;
                    if (bl7) {
                        if (nArray.length != 1) {
                            bl2 = bl6;
                            bl = bl6;
                        } else {
                            bl2 = true;
                            bl = true;
                        }
                        bl3 = false;
                    } else {
                        bl2 = false;
                        bl3 = bl6;
                    }
                    for (int i = 1; i < nArray.length; ++i) {
                        if (nArray[0] >= transformationSettingsTableModel.getDataVector().size()) continue;
                        TransformationSourceAttribute transformationSourceAttribute2 = (TransformationSourceAttribute)transformationSettingsTableModel.getDataVector().get(nArray[i]);
                        boolean bl8 = transformationSourceAttribute2 instanceof TransformationOutputAttribute;
                        if (!bl8) {
                            bl = false;
                        }
                        if (bl8 == bl7) continue;
                        bl2 = false;
                        bl3 = false;
                        break;
                    }
                }
            }
            TransformationNodeAttributesPanel.this._removeBtn.setEnabled(bl);
            TransformationNodeAttributesPanel.this._editBtn.setEnabled(bl2 && bl5);
            TransformationNodeAttributesPanel.this._addBtn.setEnabled(bl3 && bl5);
            TransformationNodeAttributesPanel.this._addCustomBtn.setEnabled(bl5);
            TransformationNodeAttributesPanel.this._outputTrueBtn.setEnabled(bl4);
            TransformationNodeAttributesPanel.this._outputFalseBtn.setEnabled(bl4);
        }
    }

    private class PITransformationSettingsTableModel
    extends TransformationSettingsTableModel {
        public PITransformationSettingsTableModel(StatsSelection statsSelection, TransformedAttributes transformedAttributes, Vector<TransformationSourceAttribute> vector) {
            this(statsSelection, transformedAttributes, vector, null, 0);
        }

        public PITransformationSettingsTableModel(StatsSelection statsSelection, TransformedAttributes transformedAttributes, Vector<TransformationSourceAttribute> vector, String string, int n) {
            super(statsSelection, transformedAttributes, vector, null, string, n);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 != OUTPUT) {
                return;
            }
            TransformationSourceAttribute transformationSourceAttribute = (TransformationSourceAttribute)this._srcData.get(n);
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            hashMap.put(transformationSourceAttribute.getName(), transformationSourceAttribute.isIsOutput());
            ArrayList<Property> arrayList = new ArrayList<Property>();
            HashMap<String, Boolean> hashMap2 = new HashMap<String, Boolean>();
            hashMap2.put(transformationSourceAttribute.getName(), (Boolean)object);
            ComplexProperty complexProperty = new ComplexProperty("outputState", hashMap2);
            complexProperty.setOldData(hashMap);
            arrayList.add(new Property(String.valueOf(TransformNodePropertyModel.OUTPUT_STATE.index), null, complexProperty, null, null));
            ComplexProperty complexProperty2 = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
            complexProperty2.setOldData(TransformationNodeAttributesPanel.this._targetNode.getSQLExpression());
            arrayList.add(new Property(String.valueOf(TransformNodePropertyModel.SQL_EXPRESSION.index), null, complexProperty2, null, null));
            TransformationNodeAttributesPanel.this._model.setValueAt(TransformationPIPropertyLrb.get("PI_TRANSFORMATION_NODE_OUTPUT_TRANSFORMATION_ELEMENT"), TransformationNodeAttributesPanel.this._targetNode, arrayList);
        }
    }
}

