/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect.transformations;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Locale;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.ControlsLrb;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.dialog.transformations.XformDialogsLrb;
import oracle.dmt.dataminer.workflow.inspect.PIComponentPanel;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.profile.ProfileGroupPIPropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.transformations.TransformNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.transformations.WorkflowTransformNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.DataProfileNode;
import oracle.dmt.dataminer.workflow.model.TransformationNode;
import oracle.dmt.dataminer.workflow.xmlschema.DataProfileSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationNodeType;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;

public class TransformationNodeHistogramPIComponentPanel
extends PIComponentPanel
implements FocusListener {
    private AbstractDataNode _targetNode;
    private JLabel jLabelCatBins;
    private JLabel jLabelDateBins;
    private JLabel jLabelNulls;
    private JLabel jLabelNumBins;
    private JLabel jLabelOther;
    private JTextField jTextFieldDateBins;
    private JTextField jTextFieldNullsLabel;
    private JTextField jTextFieldNunBins;
    private JTextField jTextFieldOtherLabel;
    private JTextField jTextFieldcatBins;

    public TransformationNodeHistogramPIComponentPanel(PropertyModel propertyModel) {
        super(propertyModel);
        this.initComponents();
        this.initRes();
        this.initUI(propertyModel);
    }

    private void initComponents() {
        this.jLabelNumBins = new JLabel();
        this.jTextFieldNunBins = new NumberTextField();
        this.jLabelCatBins = new JLabel();
        this.jTextFieldcatBins = new NumberTextField();
        this.jLabelDateBins = new JLabel();
        this.jTextFieldDateBins = new NumberTextField();
        this.jLabelNulls = new JLabel();
        this.jTextFieldNullsLabel = new JTextField();
        this.jLabelOther = new JLabel();
        this.jTextFieldOtherLabel = new JTextField();
        this.jLabelNumBins.setText("Numerical Bins:");
        this.jTextFieldNunBins.setText("10");
        this.jLabelCatBins.setText("Categoricla Bins:");
        this.jTextFieldcatBins.setText("10");
        this.jLabelDateBins.setText("Date Bins:");
        this.jTextFieldDateBins.setText("10");
        this.jLabelNulls.setText("Null Values Label:");
        this.jTextFieldNullsLabel.setText("Null Bin");
        this.jLabelOther.setText("Other:");
        this.jTextFieldOtherLabel.setText("<Other>");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabelNulls, -2, 101, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldNullsLabel, -2, 169, -2)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabelCatBins, -2, 90, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldcatBins)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabelNumBins, -2, 115, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldNunBins, -2, 52, -2)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabelDateBins, -2, 82, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldDateBins, -1, 52, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabelOther, -2, 93, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldOtherLabel, -2, 169, -2))).addContainerGap(127, Short.MAX_VALUE)));
        groupLayout.linkSize(0, this.jLabelCatBins, this.jLabelDateBins, this.jLabelNulls, this.jLabelNumBins, this.jLabelOther);
        groupLayout.linkSize(0, this.jTextFieldDateBins, this.jTextFieldNunBins, this.jTextFieldcatBins);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(4, 4, 4).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelNumBins).addComponent(this.jTextFieldNunBins, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelCatBins).addComponent(this.jTextFieldcatBins, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelDateBins).addComponent(this.jTextFieldDateBins, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelNulls).addComponent(this.jTextFieldNullsLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelOther, -2, 20, -2).addComponent(this.jTextFieldOtherLabel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.linkSize(1, this.jLabelCatBins, this.jLabelDateBins, this.jLabelNumBins);
        groupLayout.linkSize(1, this.jTextFieldDateBins, this.jTextFieldNunBins, this.jTextFieldcatBins);
    }

    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jLabelNumBins, (Component)this.jTextFieldNunBins, (String)ProfileGroupPIPropertyLrb.get("PI_PROFILE_NODE_SETTINGS_GROUP_NUM_BINS"));
        ResourceUtils.resLabel((JLabel)this.jLabelCatBins, (Component)this.jTextFieldcatBins, (String)ProfileGroupPIPropertyLrb.get("PI_PROFILE_NODE_SETTINGS_GROUP_CAT_BINS"));
        ResourceUtils.resLabel((JLabel)this.jLabelDateBins, (Component)this.jTextFieldDateBins, (String)ProfileGroupPIPropertyLrb.get("PI_PROFILE_NODE_SETTINGS_GROUP_DATE_BINS"));
        ResourceUtils.resLabel((JLabel)this.jLabelNulls, (Component)this.jTextFieldNullsLabel, (String)ProfileGroupPIPropertyLrb.get("PI_PROFILE_NODE_SETTINGS_GROUP_NULL_LABEL"));
        this.jTextFieldNullsLabel.setToolTipText(ProfileGroupPIPropertyLrb.get("PI_PROFILE_NODE_SETTINGS_GROUP_NULL_LABEL_TOOLTIP"));
        ResourceUtils.resLabel((JLabel)this.jLabelOther, (Component)this.jTextFieldOtherLabel, (String)ProfileGroupPIPropertyLrb.get("PI_PROFILE_NODE_SETTINGS_GROUP_OTHER_LABEL"));
        this.jTextFieldOtherLabel.setToolTipText(ProfileGroupPIPropertyLrb.get("PI_PROFILE_NODE_SETTINGS_GROUP_OTHER_LABEL_TOOLTIP"));
    }

    public void initUI(PropertyModel propertyModel) {
        this._model = (WorkflowTransformNodePropertyProxyModel)propertyModel;
        this._targetNode = (AbstractDataNode)this.getTargetNode((PropertyModel)this._model);
        NodeType nodeType = this._targetNode.getData();
        if (!(nodeType instanceof TransformationNodeType)) {
            return;
        }
        TransformationNodeType transformationNodeType = (TransformationNodeType)nodeType;
        DataProfileSettingsType dataProfileSettingsType = transformationNodeType.getDataProfileSettings();
        this.setupTextField(this.jTextFieldNunBins, dataProfileSettingsType.getNumericalBins(), ProfileGroupPIPropertyLrb.get("PI_PROFILE_NODE_SETTINGS_GROUP_NUM_BINS_TOOLTIP"));
        this.setupTextField(this.jTextFieldDateBins, dataProfileSettingsType.getDateBins(), ProfileGroupPIPropertyLrb.get("PI_PROFILE_NODE_SETTINGS_GROUP_DATE_BINS_TOOLTIP"));
        this.setupTextField(this.jTextFieldcatBins, dataProfileSettingsType.getCategoricalBins(), ProfileGroupPIPropertyLrb.get("PI_PROFILE_NODE_SETTINGS_GROUP_CAT_BINS_TOOLTIP"));
        this.setWritableControls();
        String string = transformationNodeType.getNullsLabel();
        if (string == null) {
            string = ControlsLrb.get("DEFAULT_NULL_BIN_LABEL");
        }
        this.jTextFieldNullsLabel.setText(string);
        this.jTextFieldNullsLabel.addFocusListener(this);
        String string2 = transformationNodeType.getOtherLabel();
        if (string2 == null) {
            string2 = XformDialogsLrb.get("CUSTOM_BINNING_PANEL_OTHER_DEFAULT");
        }
        this.jTextFieldOtherLabel.setText(string2);
        this.jTextFieldOtherLabel.addFocusListener(this);
    }

    private void setWritableControls() {
        boolean bl = this.isWritable();
        this.jTextFieldNunBins.setEnabled(bl);
        this.jTextFieldDateBins.setEnabled(bl);
        this.jTextFieldcatBins.setEnabled(bl);
        this.jTextFieldOtherLabel.setEnabled(bl);
        this.jTextFieldNullsLabel.setEnabled(bl);
    }

    public void updateUI(PropertyModel propertyModel) {
        if (!(propertyModel instanceof WorkflowTransformNodePropertyProxyModel)) {
            return;
        }
        this._model = (WorkflowTransformNodePropertyProxyModel)propertyModel;
        this._targetNode = (AbstractDataNode)this.getTargetNode((PropertyModel)this._model);
        NodeType nodeType = this._targetNode.getData();
        if (!(nodeType instanceof TransformationNodeType)) {
            return;
        }
        TransformationNodeType transformationNodeType = (TransformationNodeType)nodeType;
        DataProfileSettingsType dataProfileSettingsType = transformationNodeType.getDataProfileSettings();
        this.setNumber(this.jTextFieldNunBins, dataProfileSettingsType.getNumericalBins());
        this.setNumber(this.jTextFieldDateBins, dataProfileSettingsType.getDateBins());
        this.setNumber(this.jTextFieldcatBins, dataProfileSettingsType.getCategoricalBins());
        String string = transformationNodeType.getNullsLabel();
        if (string == null) {
            string = ControlsLrb.get("DEFAULT_NULL_BIN_LABEL");
        }
        this.jTextFieldNullsLabel.setText(string);
        String string2 = transformationNodeType.getOtherLabel();
        if (string2 == null) {
            string2 = XformDialogsLrb.get("CUSTOM_BINNING_PANEL_OTHER_DEFAULT");
        }
        this.jTextFieldOtherLabel.setText(string2);
        this.setWritableControls();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (!(focusEvent.getSource() instanceof JTextField)) {
            return;
        }
        NodeType nodeType = this._targetNode.getData();
        TransformationNodeType transformationNodeType = (TransformationNodeType)nodeType;
        DataProfileSettingsType dataProfileSettingsType = transformationNodeType.getDataProfileSettings();
        DataProfileSettingsType dataProfileSettingsType2 = new DataProfileSettingsType();
        JTextField jTextField = (JTextField)focusEvent.getSource();
        if (jTextField.equals(this.jTextFieldNullsLabel)) {
            String string = transformationNodeType.getNullsLabel();
            String string2 = this.jTextFieldNullsLabel.getText();
            if (string2.equals(string)) {
                return;
            }
            ComplexProperty complexProperty = new ComplexProperty(DataProfileNode.DATAPROFILE_NULL_LABEL, string2);
            complexProperty.setOldData(string);
            if (this._model instanceof WorkflowNodePropertyProxyModel) {
                WorkflowNodePropertyProxyModel workflowNodePropertyProxyModel = this._model;
                workflowNodePropertyProxyModel.setValueAt(DataProfileNode.DATAPROFILE_NULL_LABEL, this._targetNode, complexProperty, TransformNodePropertyModel.DATAPROFILE_NULL_LABEL.index);
            }
            return;
        }
        if (jTextField.equals(this.jTextFieldOtherLabel)) {
            String string = transformationNodeType.getOtherLabel();
            String string3 = this.jTextFieldOtherLabel.getText();
            if (string3.equals(string)) {
                return;
            }
            ComplexProperty complexProperty = new ComplexProperty(DataProfileNode.DATAPROFILE_OTHER_LABEL, string3);
            complexProperty.setOldData(string);
            if (this._model instanceof WorkflowNodePropertyProxyModel) {
                WorkflowNodePropertyProxyModel workflowNodePropertyProxyModel = this._model;
                workflowNodePropertyProxyModel.setValueAt(DataProfileNode.DATAPROFILE_OTHER_LABEL, this._targetNode, complexProperty, TransformNodePropertyModel.DATAPROFILE_OTHER_LABEL.index);
            }
            return;
        }
        Number number = this.getNumber(jTextField);
        if (number == null) {
            String string = ProfileGroupPIPropertyLrb.get("PI_PROFILE_NODE_PROFILE_SETTINGS_ERROR_NULL_VALUE");
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)ProfileGroupPIPropertyLrb.get("PI_PROFILE_NODE_PROFILE_SETTINGS_ERROR_TITLE"), null);
            return;
        }
        if (number.intValue() < 2) {
            String string = XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_BIN_COUNT_INVALID_2");
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)ProfileGroupPIPropertyLrb.get("PI_PROFILE_NODE_PROFILE_SETTINGS_ERROR_TITLE"), null);
            return;
        }
        int n = number.intValue();
        int n2 = dataProfileSettingsType.getNumericalBins();
        int n3 = dataProfileSettingsType.getCategoricalBins();
        int n4 = dataProfileSettingsType.getDateBins();
        if (jTextField.equals(this.jTextFieldNunBins)) {
            if (n == n2) {
                return;
            }
            n2 = n;
        } else if (jTextField.equals(this.jTextFieldDateBins)) {
            if (n == n4) {
                return;
            }
            n4 = n;
        } else if (jTextField.equals(this.jTextFieldcatBins)) {
            if (n == n3) {
                return;
            }
            n3 = n;
        }
        dataProfileSettingsType2.setNumericalBins(n2);
        dataProfileSettingsType2.setCategoricalBins(n3);
        dataProfileSettingsType2.setDateBins(n4);
        this.updateProfileSettings(dataProfileSettingsType2, dataProfileSettingsType, TransformationNode.DATAPROFILE_SETTINGS);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    private void updateProfileSettings(Object object, Object object2, String string) {
        ComplexProperty complexProperty = new ComplexProperty(string, object);
        complexProperty.setOldData(object2);
        if (this._model instanceof WorkflowTransformNodePropertyProxyModel) {
            WorkflowTransformNodePropertyProxyModel workflowTransformNodePropertyProxyModel = (WorkflowTransformNodePropertyProxyModel)this._model;
            workflowTransformNodePropertyProxyModel.setValueAt(string, this._targetNode, complexProperty, TransformNodePropertyModel.DATAPROFILE_SETTINGS.index);
        }
    }

    private void setupTextField(JTextField jTextField, int n, String string) {
        this.setDataType(jTextField, Integer.class);
        this.setSigned(jTextField, false);
        this.setLocale(jTextField, Locale.getDefault());
        this.setNumber(jTextField, n);
        jTextField.setToolTipText(string);
        jTextField.addFocusListener(this);
    }

    private void setNumber(JTextField jTextField, Number number) {
        ((NumberTextField)jTextField).setNumber(number);
    }

    private void setDataType(JTextField jTextField, Class clazz) {
        ((NumberTextField)jTextField).setDataType(clazz);
    }

    private void setSigned(JTextField jTextField, boolean bl) {
        ((NumberTextField)jTextField).setSigned(bl);
    }

    private void setLocale(JTextField jTextField, Locale locale) {
        jTextField.setLocale(locale);
    }

    private Number getNumber(JTextField jTextField) {
        return ((NumberTextField)jTextField).getNumber();
    }
}

