/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import ilog.views.IlvGraphic;
import ilog.views.IlvLabelInterface;
import ilog.views.IlvPoint;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvLabel;
import ilog.views.graphic.IlvText;
import ilog.views.graphic.IlvZoomableLabel;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvReadFileException;
import ilog.views.sdm.graphic.IlvGeneralLink;
import java.awt.Graphics;
import oracle.diagram.core.graphic.CoreLabel;
import oracle.diagram.core.graphic.CoreText;
import oracle.dmt.dataminer.workflow.model.LinkLrb;

public class DataMinerlLinkGraphic
extends IlvGeneralLink {
    private static final String linkToConstant = LinkLrb.get("LINK_TO");
    private static final String linkFromConstant = LinkLrb.get("LINK_FROM");

    public DataMinerlLinkGraphic() {
    }

    public DataMinerlLinkGraphic(IlvGeneralLink ilvGeneralLink) {
        super(ilvGeneralLink);
    }

    public DataMinerlLinkGraphic(IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2) {
        super(ilvGraphic, ilvGraphic2);
    }

    public DataMinerlLinkGraphic(IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2, boolean bl) {
        super(ilvGraphic, ilvGraphic2, bl);
    }

    public DataMinerlLinkGraphic(IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2, boolean bl, boolean bl2, IlvPoint[] ilvPointArray) {
        super(ilvGraphic, ilvGraphic2, bl, bl2, ilvPointArray);
    }

    public DataMinerlLinkGraphic(IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2, boolean bl, IlvPoint[] ilvPointArray) {
        super(ilvGraphic, ilvGraphic2, bl, ilvPointArray);
    }

    public DataMinerlLinkGraphic(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
    }

    public void setDecorations(IlvGraphic[] ilvGraphicArray) {
        if (ilvGraphicArray != null && ilvGraphicArray.length != 0) {
            IlvGraphic[] ilvGraphicArray2 = new IlvGraphic[ilvGraphicArray.length];
            System.arraycopy(ilvGraphicArray, 0, ilvGraphicArray2, 0, ilvGraphicArray.length);
            for (int i = 0; i < ilvGraphicArray2.length; ++i) {
                ilvGraphicArray2[i] = this.convertLabel(ilvGraphicArray2[i]);
            }
            super.setDecorations(ilvGraphicArray2);
        } else {
            super.setDecorations(ilvGraphicArray);
        }
    }

    public void setDecorations(int n, IlvGraphic ilvGraphic) {
        super.setDecorations(n, this.convertLabel(ilvGraphic));
    }

    private IlvGraphic convertLabel(IlvGraphic ilvGraphic) {
        if (ilvGraphic != null) {
            if (ilvGraphic.getClass().equals(IlvText.class)) {
                return new CoreText((IlvText)ilvGraphic);
            }
            if (ilvGraphic.getClass().equals(IlvLabel.class)) {
                return new CoreLabel((IlvLabel)ilvGraphic);
            }
            if (ilvGraphic.getClass().equals(IlvZoomableLabel.class)) {
                return new CustomZoomableLabel((IlvZoomableLabel)ilvGraphic);
            }
        }
        return ilvGraphic;
    }

    public void setLabel(String string) {
        IlvGraphic[] ilvGraphicArray = this.getDecorations();
        if (ilvGraphicArray == null || ilvGraphicArray.length == 0 || ilvGraphicArray[0] == null) {
            IlvGraphic ilvGraphic = this.createDefaultLabelGraphic(string);
            if (!(ilvGraphic instanceof IlvLabelInterface)) {
                throw new IllegalArgumentException("createDefaultLabelGraphic() must return IlvGraphic that implements IlvLabelInterface");
            }
            this.setDecorations(0, ilvGraphic);
        } else if (ilvGraphicArray[0] != null && ilvGraphicArray[0] instanceof CustomZoomableLabel) {
            CustomZoomableLabel customZoomableLabel = (CustomZoomableLabel)ilvGraphicArray[0];
            this.updateLabelVisibility(customZoomableLabel, string);
        }
        super.setLabel(string);
    }

    protected IlvGraphic createDefaultLabelGraphic(String string) {
        CustomZoomableLabel customZoomableLabel = new CustomZoomableLabel();
        this.updateLabelVisibility(customZoomableLabel, string);
        customZoomableLabel.move(0.0f, 0.0f);
        customZoomableLabel.setAntialiasing(true);
        customZoomableLabel.setMultilineSpacing(-10.0f);
        return customZoomableLabel;
    }

    private void updateLabelVisibility(CustomZoomableLabel customZoomableLabel, String string) {
        if (string.startsWith(linkToConstant) || string.startsWith(linkFromConstant)) {
            customZoomableLabel.setVisible(false);
            customZoomableLabel.setLabel(null);
            customZoomableLabel.resize(0.1f, 0.1f);
        } else {
            customZoomableLabel.setLabel(string);
            customZoomableLabel.setVisible(true);
        }
    }

    public static class CustomZoomableLabel
    extends IlvZoomableLabel {
        public CustomZoomableLabel() {
        }

        public CustomZoomableLabel(IlvInputStream ilvInputStream) throws IlvReadFileException {
            super(ilvInputStream);
        }

        public CustomZoomableLabel(IlvPoint ilvPoint, String string) {
            super(ilvPoint, string);
        }

        public CustomZoomableLabel(IlvPoint ilvPoint, String string, boolean bl) {
            super(ilvPoint, string, bl);
        }

        public CustomZoomableLabel(IlvZoomableLabel ilvZoomableLabel) {
            super(ilvZoomableLabel);
        }

        public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
            if (!this.isVisible()) {
                return;
            }
            super.draw(graphics, ilvTransformer);
        }
    }
}

