/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.parallelquery;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.PreferencesLrb;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.PerformanceOptionsCellRender;
import oracle.dmt.dataminer.controls.dialog.DialogExecutionException;
import oracle.dmt.dataminer.controls.dialog.DialogHelper;
import oracle.dmt.dataminer.controls.dialog.DialogOkExecutor;
import oracle.dmt.dataminer.core.model.generated.server.OdmrObjectNames;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.GeneralLink;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.parallelquery.ParallelQueryPreferences;
import oracle.dmt.dataminer.workflow.parallelquery.ViewDataParallelPanel;
import oracle.dmt.dataminer.workflow.parallelquery.ViewDataProvider;
import oracle.dmt.dataminer.workflow.xmlschema.CreateTableNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataProfileNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.GraphNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ParallelismType;
import oracle.dmt.dataminer.workflow.xmlschema.SQLQueryNodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.DropDownMenuButton;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.jdbc.OracleCallableStatement;
import oracle.sql.ORAData;

public class ParallelTablePanel
extends DefaultTraversablePanel
implements DataminerGUIPanel {
    protected ParallelQueryPreferences PQPreferences;
    protected static final Logger theLogger = Logger.getLogger(ParallelTablePanel.class.getName());
    public static final String SYSTEM_DETERMINED = "System Determined";
    protected static String NAME_COLUMN = WorkflowEditorLrb.get("PARALLEL_TABLE_NODE_COLUMN");
    protected static String TYPE_COLUMN = WorkflowEditorLrb.get("PARALLEL_TABLE_TYPE_COLUMN");
    protected static String NODE_TYPE_COLUMN = WorkflowEditorLrb.get("PARALLEL_TABLE_NODE_TYPE_COLUMN");
    protected static String PARALLEL_ON_COLUMN = WorkflowEditorLrb.get("PARALLEL_TABLE_PARALLLE_COLUMN");
    protected static String PARALLEL_DEGREE_COLUMN = WorkflowEditorLrb.get("PARALLEL_TABLE_DEGREE_COLUMN");
    protected Vector<String> columnNamesEditor = new Vector();
    protected Vector<String> columnNamesPreferences = new Vector();
    protected HashMap<String, AbstractNode> metadata;
    protected WorkflowModel model;
    protected boolean isPreferencePanel = false;
    protected WorkflowNode wfNode;
    protected WorkflowEditor workflowEditor;
    protected List<AbstractNode> selectedNodes;
    protected Context context;
    protected static Map<String, String> excludedNodesParallel = MetaDataHelper.getNodeTypeParallelExcluded();
    private DataMinerTablePanel dataMinerTablePanel1;

    protected void createEditorColumns() {
        this.columnNamesEditor.add(NAME_COLUMN);
        this.columnNamesEditor.add(TYPE_COLUMN);
        this.columnNamesEditor.add(PARALLEL_ON_COLUMN);
        this.columnNamesEditor.add(PARALLEL_DEGREE_COLUMN);
    }

    protected void createPreferncesColumns() {
        this.columnNamesPreferences.add(NODE_TYPE_COLUMN);
        this.columnNamesPreferences.add(PARALLEL_ON_COLUMN);
        this.columnNamesPreferences.add(PARALLEL_DEGREE_COLUMN);
    }

    protected int get_column_idx() {
        return this.getColumnIndex(NAME_COLUMN);
    }

    protected int get_type_idx() {
        return this.getColumnIndex(TYPE_COLUMN);
    }

    protected int get_node_type_idx() {
        return this.getColumnIndex(NODE_TYPE_COLUMN);
    }

    protected int get_parallel_on_idx() {
        return this.getColumnIndex(PARALLEL_ON_COLUMN);
    }

    protected int get_parallel_degree_idx() {
        return this.getColumnIndex(PARALLEL_DEGREE_COLUMN);
    }

    public ParallelTablePanel() {
        this.createPreferncesColumns();
        this.dataMinerTablePanel1 = new DataMinerTablePanel();
        this.setLayout(new BorderLayout());
        this.add(this.dataMinerTablePanel1);
        this.isPreferencePanel = true;
        this.setPreferencesPanelHelpId();
    }

    public ParallelTablePanel(Context context, List<AbstractNode> list) {
        this.createEditorColumns();
        this.dataMinerTablePanel1 = new DataMinerTablePanel();
        this.selectedNodes = list;
        this.setLayout(new BorderLayout());
        this.add(this.dataMinerTablePanel1);
        this.dataMinerTablePanel1.setSize(this.dataMinerTablePanel1.getParent().getWidth(), this.dataMinerTablePanel1.getParent().getHeight());
        this.isPreferencePanel = false;
        this.model = ((WorkflowNode)context.getNode()).getWorkflowModel();
        this.wfNode = (WorkflowNode)context.getNode();
        this.workflowEditor = (WorkflowEditor)context.getView();
        this.context = context;
        this.initUI();
        this.setEditorPanelHelpId();
    }

    protected void setPreferencesPanelHelpId() {
        this.setHelpID("preferences_para");
    }

    protected void setEditorPanelHelpId() {
        this.setHelpID("parallel_settings");
    }

    private void initComponents() {
        this.dataMinerTablePanel1 = new DataMinerTablePanel();
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dataMinerTablePanel1, GroupLayout.Alignment.TRAILING, -1, 750, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.dataMinerTablePanel1, -2, 205, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    @Override
    public void initRes() {
    }

    protected DataMinerTablePanel getInnerTable() {
        return this.dataMinerTablePanel1;
    }

    @Override
    public void initUI() {
        int n = 35;
        boolean bl = this.isPreferencePanel || !this.wfNode.isReadOnly();
        final JButton jButton = new JButton(WorkflowEditorLrb.get("WORKFLOW_PARALLEL_ALL_ON"));
        jButton.setEnabled(bl);
        jButton.setToolTipText(WorkflowEditorLrb.get("PARALLEL_QUERY_ENABLE"));
        final JButton jButton2 = new JButton(WorkflowEditorLrb.get("WORKFLOW_PARALLEL_ALL_OFF"));
        jButton2.setToolTipText(WorkflowEditorLrb.get("PARALLEL_QUERY_DISABLED"));
        jButton2.setEnabled(bl);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ParallelTablePanel.this.setParallelValues(true);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ParallelTablePanel.this.setParallelValues(false);
            }
        });
        final DropDownMenuButton dropDownMenuButton = new DropDownMenuButton();
        dropDownMenuButton.setEnabled(bl);
        dropDownMenuButton.setIcon(OracleIcons.getIcon((String)"action.png"));
        dropDownMenuButton.setToolTipText(WorkflowEditorLrb.get("PARALLEL_NODE_PREFERENCES"));
        dropDownMenuButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    dropDownMenuButton.addPopupItem((Action)new AbstractAction(WorkflowEditorLrb.get("PARALLEL_PREFERENCE_LAUNCH")){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            String[] stringArray = new String[]{PreferencesLrb.get("DATA_MINER_PREFERENCES_KEY"), PreferencesLrb.get("NODE_SETTINGS_PREFERENCES_KEY"), PreferencesLrb.get("PERFORMANCE_QUERY_PREFERENCES_KEY")};
                            Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), stringArray);
                        }
                    });
                    dropDownMenuButton.addPopupItem((Action)new AbstractAction(WorkflowEditorLrb.get("PARALLEL_APPLY_DEFAULT_PREFERENCES")){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            ParallelTablePanel.this.initNonPreferenceTableDefault();
                        }
                    });
                } else if (itemEvent.getStateChange() == 2) {
                    dropDownMenuButton.removeAllPopupItems();
                }
            }
        });
        final JButton jButton3 = new JButton();
        jButton3.setEnabled(bl);
        jButton3.setToolTipText(WorkflowEditorLrb.get("PARALLEL_SETTING"));
        jButton3.setIcon(OracleIcons.getIcon((String)"edit.png"));
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ParallelTablePanel.this.launchEdit();
            }
        });
        if (this.isPreferencePanel) {
            this.getInnerTable().addControlBarComponents(jButton, jButton2, jButton3);
        } else {
            this.getInnerTable().addControlBarComponents(new Component[]{jButton3, dropDownMenuButton});
            this.getInnerTable().addControlBarComponents(jButton, jButton2);
        }
        jButton.setPreferredSize(new Dimension(n, jButton.getHeight()));
        jButton2.setPreferredSize(new Dimension(n, jButton2.getHeight()));
        this.initTable(this.isPreferencePanel);
        if (this.getTable().getSelectedRowCount() <= 0) {
            jButton3.setEnabled(false);
        } else {
            jButton3.setEnabled(true);
        }
        this.getTable().getColumnModel().getColumn(this.get_parallel_on_idx()).setMaxWidth(150);
        this.getTable().setEnabled(bl);
        this.getTable().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("rowSorter".equals(propertyChangeEvent.getPropertyName())) {
                    int n = ParallelTablePanel.this.getTable().getRowCount();
                    if (n <= 0) {
                        jButton.setEnabled(false);
                        jButton2.setEnabled(false);
                        jButton3.setEnabled(false);
                        dropDownMenuButton.setEnabled(false);
                    } else {
                        jButton.setEnabled(true);
                        jButton2.setEnabled(true);
                        dropDownMenuButton.setEnabled(true);
                        if (ParallelTablePanel.this.getTable().getSelectedRowCount() <= 0) {
                            jButton3.setEnabled(false);
                        } else {
                            jButton3.setEnabled(true);
                        }
                    }
                }
            }
        });
        this.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (ParallelTablePanel.this.getTable().getSelectedRowCount() > 0) {
                    jButton3.setEnabled(true);
                } else {
                    jButton3.setEnabled(false);
                }
            }
        });
        this.getTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ParallelTablePanel.this.launchEdit();
                }
            }
        });
        TableColumn tableColumn = this.getTable().getColumnModel().getColumn(this.get_parallel_on_idx());
        tableColumn.setCellRenderer(new PerformanceOptionsCellRender(bl));
    }

    protected void initParallelPanel(ViewDataProvider viewDataProvider) {
        int n = this.getTable().getSelectedRowCount();
        if (n <= 0) {
            viewDataProvider.setParallelEnable(false);
            viewDataProvider.setSystemDetermined();
        } else if (n == 1) {
            int n2 = this.getTable().getSelectedRow();
            int n3 = this.get_parallel_on_idx();
            int n4 = this.get_parallel_degree_idx();
            String string = this.getTable().getValueAt(n2, n3).toString();
            String string2 = this.getTable().getValueAt(n2, n4).toString();
            if (Boolean.parseBoolean(string)) {
                viewDataProvider.setParallelEnable(true);
            } else {
                viewDataProvider.setParallelEnable(false);
            }
            if (SYSTEM_DETERMINED.equals(string2)) {
                viewDataProvider.setSystemDetermined();
            } else {
                viewDataProvider.setDegreeValue(Integer.parseInt(string2));
            }
        } else {
            boolean bl = true;
            int[] nArray = this.getTable().getSelectedRows();
            String string = null;
            String string3 = null;
            for (int i = 0; i < nArray.length; ++i) {
                String string4 = this.getTable().getValueAt(nArray[i], this.get_parallel_on_idx()).toString();
                String string5 = this.getTable().getValueAt(nArray[i], this.get_parallel_degree_idx()).toString();
                if (string == null && string3 == null) {
                    string = string4;
                    string3 = string5;
                    continue;
                }
                if (string.equals(string4) && string3.equals(string5)) continue;
                bl = false;
                break;
            }
            if (bl) {
                if (Boolean.parseBoolean(string)) {
                    viewDataProvider.setParallelEnable(true);
                } else {
                    viewDataProvider.setParallelEnable(false);
                }
                if (SYSTEM_DETERMINED.equals(string3)) {
                    viewDataProvider.setSystemDetermined();
                } else {
                    viewDataProvider.setDegreeValue(Integer.parseInt(string3));
                }
            } else {
                viewDataProvider.setSystemDetermined();
            }
        }
    }

    protected void launchEdit() {
        String string = WorkflowEditorLrb.get("NODE_PARALLEL_DEGREE_DIALOG_TITLE");
        final ViewDataParallelPanel viewDataParallelPanel = new ViewDataParallelPanel(string);
        this.initParallelPanel(viewDataParallelPanel);
        DialogHelper dialogHelper = new DialogHelper(viewDataParallelPanel);
        dialogHelper.setDialogOkExecutor(new DialogOkExecutor(){

            @Override
            public void onOK() throws DialogExecutionException {
                ParallelTablePanel.this.setParallelEnable(viewDataParallelPanel.isParallelEnable());
                if (viewDataParallelPanel.isSystemDetermined()) {
                    ParallelTablePanel.this.setDegreeValue(ParallelTablePanel.SYSTEM_DETERMINED);
                } else {
                    ParallelTablePanel.this.setDegreeValue(viewDataParallelPanel.getDegreeValue());
                }
            }
        });
        dialogHelper.showAsDialog((Component)((Object)this));
    }

    public void setParallelEnable(boolean bl) {
        this.setParallelEnable(bl, this.getTable().getSelectedRows());
    }

    public void setDegreeValue(String string) {
        this.setDegreeValues(string, this.getTable().getSelectedRows());
    }

    private void setParallelEnable(boolean bl, int[] nArray) {
        if (nArray.length > 0) {
            int n = this.get_parallel_on_idx();
            for (int i = 0; i < nArray.length; ++i) {
                this.getTable().setValueAt(bl, nArray[i], n);
            }
        }
    }

    private void setDegreeValues(String string, int[] nArray) {
        if (nArray.length > 0) {
            int n = this.get_parallel_degree_idx();
            for (int i = 0; i < nArray.length; ++i) {
                this.getTable().setValueAt(string, nArray[i], n);
            }
        }
    }

    protected void setParallelValues(boolean bl) {
        int n = this.getTable().getModel().getRowCount();
        int n2 = this.get_parallel_on_idx();
        for (int i = 0; i < n; ++i) {
            this.getTable().setValueAt(bl, i, n2);
        }
    }

    public DataMinerTable getTable() {
        return this.getInnerTable().getTable();
    }

    public void updateToolBarTitle(int n, int n2) {
        this.getInnerTable().setTitle(MessageFormat.format(WorkflowEditorLrb.get("WORKFLOW_TITLE_BAR"), n, n2));
    }

    protected void initTable(boolean bl) {
        if (bl) {
            this.initPreferenceTable();
        } else {
            this.initNonPreferenceTable();
        }
    }

    public void savePreferences(ParallelQueryPreferences parallelQueryPreferences) {
        int n = this.getTable().getModel().getRowCount();
        int n2 = this.get_node_type_idx();
        int n3 = this.get_parallel_on_idx();
        int n4 = this.get_parallel_degree_idx();
        Map<String, String> map = this.reverseMap(MetaDataHelper.getNodeTypeNameMap());
        for (int i = 0; i < n; ++i) {
            String string = this.getTable().getModel().getValueAt(i, n2).toString();
            String string2 = String.valueOf(this.getTable().getModel().getValueAt(i, n3));
            String string3 = this.getTable().getModel().getValueAt(i, n4).toString();
            String string4 = map.get(string);
            parallelQueryPreferences.setProperty(string4, ParallelQueryPreferences.PROPERTY.IS_PARALLEL, string2);
            parallelQueryPreferences.setProperty(string4, ParallelQueryPreferences.PROPERTY.VALUE, string3);
        }
    }

    protected Map<String, String> reverseMap(Map<String, String> map) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            hashMap.put(entry.getValue(), entry.getKey());
        }
        return hashMap;
    }

    protected void initPreferenceTable() {
        Vector vector = new Vector();
        int n = 0;
        int n2 = 0;
        Map<String, String> map = MetaDataHelper.getNodeTypeNameMap();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            Vector<Object> vector2 = new Vector<Object>();
            String string = entry.getKey();
            if (excludedNodesParallel.containsKey(string)) {
                ++n2;
                continue;
            }
            String string2 = entry.getValue();
            vector2.add(string2);
            String string3 = this.PQPreferences.getProperty(string, ParallelQueryPreferences.PROPERTY.IS_PARALLEL);
            if ("true".equals(string3)) {
                ++n;
                vector2.add(true);
            } else {
                vector2.add(false);
            }
            String string4 = this.PQPreferences.getProperty(string, ParallelQueryPreferences.PROPERTY.VALUE);
            if (string4 != null) {
                vector2.add(string4);
            } else {
                vector2.add(SYSTEM_DETERMINED);
            }
            vector.add(vector2);
        }
        this.getInnerTable().setup((TableModel)new ParallelTableModel(vector, this.columnNamesPreferences, vector.size() - n2, n), null, new String[]{NODE_TYPE_COLUMN}, 0);
        this.getTable().setSortColumn(0, true);
        this.updateToolBarTitle(n, vector.size());
    }

    protected int initNonPreferenceTableDefault(int n, ParallelQueryPreferences parallelQueryPreferences) {
        int n2 = this.get_parallel_on_idx();
        int n3 = 0;
        TableModel tableModel = this.getTable().getModel();
        Map<String, String> map = this.reverseMap(MetaDataHelper.getNodeTypeNameMap());
        for (int i = 0; i < n; ++i) {
            String string = (String)tableModel.getValueAt(i, this.get_type_idx());
            String string2 = map.get(string);
            String string3 = parallelQueryPreferences.getProperty(string2, ParallelQueryPreferences.PROPERTY.IS_PARALLEL);
            String string4 = parallelQueryPreferences.getProperty(string2, ParallelQueryPreferences.PROPERTY.VALUE);
            if (string3 != null) {
                if (Boolean.parseBoolean(string3)) {
                    tableModel.setValueAt(Boolean.TRUE, i, n2);
                    ++n3;
                } else {
                    tableModel.setValueAt(Boolean.FALSE, i, n2);
                }
            } else {
                tableModel.setValueAt(Boolean.FALSE, i, n2);
            }
            if (string4 != null) {
                tableModel.setValueAt(string4, i, this.get_parallel_degree_idx());
                continue;
            }
            tableModel.setValueAt(SYSTEM_DETERMINED, i, this.get_parallel_degree_idx());
        }
        return n3;
    }

    protected void initNonPreferenceTableDefault() {
        int n = this.getTable().getRowCount();
        if (this.PQPreferences == null) {
            this.PQPreferences = ParallelQueryPreferences.getInstance();
        }
        int n2 = this.initNonPreferenceTableDefault(n, this.PQPreferences);
        this.updateToolBarTitle(n2, n);
    }

    protected void initNonPreferenceTable() {
        Vector vector = new Vector();
        Enumeration enumeration = this.model.getObjects();
        this.metadata = new HashMap();
        Map<String, String> map = MetaDataHelper.getNodeTypeNameMap();
        int n = 0;
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e instanceof GeneralLink) continue;
            AbstractNode abstractNode = (AbstractNode)e;
            NodeType nodeType = abstractNode.getData();
            Vector<Object> vector2 = new Vector<Object>();
            String string = nodeType.getClass().getName();
            if (excludedNodesParallel.containsKey(string)) {
                ++n2;
                continue;
            }
            this.metadata.put(nodeType.getName(), abstractNode);
            vector2.add(nodeType.getName());
            vector2.add(map.get(string));
            if (nodeType.getParallelism() == null) {
                vector2.add(false);
                vector2.add(SYSTEM_DETERMINED);
            } else {
                if (nodeType.getParallelism().isEnable()) {
                    ++n;
                    vector2.add(true);
                } else {
                    vector2.add(false);
                }
                if (nodeType.getParallelism().getSystemDetermined() != null) {
                    vector2.add(SYSTEM_DETERMINED);
                } else {
                    long l = nodeType.getParallelism().getCustom().getDegree();
                    vector2.add(l);
                }
            }
            vector.add(vector2);
        }
        this.getInnerTable().setup((TableModel)new ParallelTableModel(vector, this.columnNamesEditor, vector.size() - n2, n), null, new String[]{NAME_COLUMN, TYPE_COLUMN}, 0);
        this.getTable().setSortColumn(0, true);
        this.updateToolBarTitle(n, vector.size());
        this.updateSelection();
    }

    protected int addParallelRowValues(Vector<Object> vector, NodeType nodeType, Map<String, String> map) {
        int n = 0;
        String string = nodeType.getClass().getName();
        vector.add(nodeType.getName());
        vector.add(map.get(string));
        if (nodeType.getParallelism() == null) {
            vector.add(false);
            vector.add(SYSTEM_DETERMINED);
        } else {
            if (nodeType.getParallelism().isEnable()) {
                ++n;
                vector.add(true);
            } else {
                vector.add(false);
            }
            if (nodeType.getParallelism().getSystemDetermined() != null) {
                vector.add(SYSTEM_DETERMINED);
            } else {
                long l = nodeType.getParallelism().getCustom().getDegree();
                vector.add(l);
            }
        }
        return n;
    }

    protected void updateSelection() {
        if (this.selectedNodes != null) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (AbstractNode abstractNode : this.selectedNodes) {
                String string = abstractNode.getData().getName();
                int n = this.getRowIndexbyName(string);
                if (n < 0) continue;
                arrayList.add(n);
            }
            this.getTable().setSelectedRowsInModel(this.listToArray(arrayList));
            this.getTable().scrollToSelection();
        }
    }

    private int[] listToArray(List<Integer> list) {
        if (list == null) {
            return new int[0];
        }
        int[] nArray = new int[list.size()];
        int n = 0;
        for (Integer n2 : list) {
            nArray[n++] = n2;
        }
        return nArray;
    }

    private int getRowIndexbyName(String string) {
        int n = this.getTable().getRowCount();
        for (int i = 0; i < n; ++i) {
            String string2 = this.getTable().getModel().getValueAt(i, this.get_column_idx()).toString();
            if (!string.equals(string2)) continue;
            return i;
        }
        return -1;
    }

    public void onEntry(TraversableContext traversableContext) {
        this.initilizePreferences(traversableContext);
        this.initUI();
    }

    public void initilizePreferences(TraversableContext traversableContext) {
        this.PQPreferences = ParallelQueryPreferences.getInstance(traversableContext.getPropertyStorage());
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this.savePreferences(this.PQPreferences);
    }

    public boolean doWork() {
        try {
            if (this.metadata == null) {
                return false;
            }
            final ArrayList<String> arrayList = new ArrayList<String>();
            int n = this.get_column_idx();
            int n2 = this.get_parallel_on_idx();
            int n3 = this.get_parallel_degree_idx();
            int n4 = this.getTable().getRowCount();
            int n5 = 0;
            for (int i = 0; i < n4; ++i) {
                ParallelismType parallelismType = new ParallelismType();
                String string = this.getTable().getValueAt(i, n).toString();
                String string2 = this.getTable().getValueAt(i, n2).toString();
                String string3 = this.getTable().getValueAt(i, n3).toString();
                AbstractNode abstractNode = this.metadata.get(string);
                NodeType nodeType = abstractNode.getData();
                if (string2.equalsIgnoreCase(Boolean.TRUE.toString())) {
                    parallelismType.setEnable(true);
                    ++n5;
                } else {
                    parallelismType.setEnable(false);
                }
                if (string3.equalsIgnoreCase(SYSTEM_DETERMINED)) {
                    parallelismType.setSystemDetermined(new ParallelismType.SystemDetermined());
                } else {
                    ParallelismType.Custom custom = new ParallelismType.Custom();
                    custom.setDegree(Long.parseLong(string3));
                    parallelismType.setCustom(custom);
                }
                if ((nodeType instanceof CreateTableNodeType || nodeType instanceof GraphNodeType || nodeType instanceof SQLQueryNodeType || nodeType instanceof DataProfileNodeType) && nodeType.getStatus() == NodeStatusType.COMPLETE && this.hashChange(nodeType.getParallelism(), parallelismType)) {
                    arrayList.add(nodeType.getId());
                }
                nodeType.setParallelism(parallelismType);
            }
            this.wfNode.markDirty(true);
            if (arrayList.size() > 0) {
                MessageDialog.optionalInformation((String)(this.getClass().getName() + "displaySaveWFRequired"), (Component)((Object)this), (Object)WorkflowEditorLrb.get("SAVE_WORKFLOW_MESSAGE"), (String)WorkflowEditorLrb.get("SAVE_WORKFLOW_TITTLE"), null);
                this.wfNode.addNodeListener(new NodeListener(){

                    public void nodeSaved(NodeEvent nodeEvent) {
                        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
                        if (stringArray.length > 0) {
                            UpdateObjects updateObjects = new UpdateObjects(ParallelTablePanel.this.wfNode.getId(), stringArray);
                            updateObjects.execute();
                            ParallelTablePanel.this.wfNode.removeNodeListener(this);
                        }
                    }
                });
                this.wfNode.save();
            }
            this.workflowEditor.updateParallelToolBarLink();
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            return false;
        }
        return true;
    }

    protected boolean hashChange(ParallelismType parallelismType, ParallelismType parallelismType2) {
        if (parallelismType == null) {
            return true;
        }
        if (parallelismType.isEnable() != parallelismType2.isEnable()) {
            return true;
        }
        if (parallelismType.getSystemDetermined() == null && parallelismType2.getSystemDetermined() == null) {
            return parallelismType.getCustom().getDegree() != parallelismType2.getCustom().getDegree();
        }
        return parallelismType.getSystemDetermined() == null || parallelismType2.getSystemDetermined() == null;
    }

    public int getColumnIndex(String string) {
        return this.getTable().getColumnModel().getColumnIndex(string);
    }

    protected class UpdateObjects
    extends SwingWorker {
        protected BigDecimal workflowId;
        protected String[] parallelNodeIds;

        public UpdateObjects(BigDecimal bigDecimal, String[] stringArray) {
            this.workflowId = bigDecimal;
            this.parallelNodeIds = stringArray;
        }

        protected Object doInBackground() {
            try (SQLHelper sQLHelper = new SQLHelper();){
                sQLHelper.conn = ConnectionFolder.getConnection(ParallelTablePanel.this.context);
                this.updateTableViewObjects(sQLHelper, this.workflowId, this.parallelNodeIds);
            }
            return null;
        }

        @Override
        protected void done() {
        }

        protected void updateTableViewObjects(SQLHelper sQLHelper, BigDecimal bigDecimal, String[] stringArray) {
            OdmrObjectNames[] odmrObjectNamesArray = new OdmrObjectNames[]{new OdmrObjectNames(stringArray)};
            try {
                sQLHelper.cstmt = (OracleCallableStatement)sQLHelper.conn.prepareCall("{call ODMR_UTIL.UPDATE_VIEWS_AND_TABLES(:1,:2)}");
                sQLHelper.cstmt.setBigDecimal(1, bigDecimal);
                sQLHelper.cstmt.setORAData(2, (ORAData)odmrObjectNamesArray[0]);
                sQLHelper.cstmt.execute();
            }
            catch (SQLException sQLException) {
                theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
            }
        }
    }

    protected class ParallelTableModel
    extends DefaultTableModel {
        private int totalRows;
        private int activeParallel;
        private int parallelColumnIndex;

        public ParallelTableModel(Vector vector, Vector vector2, int n, int n2) {
            super(vector, vector2);
            this.totalRows = 0;
            this.activeParallel = 0;
            this.parallelColumnIndex = -1;
            this.totalRows = n;
            this.activeParallel = n2;
            this.parallelColumnIndex = vector2.indexOf(PARALLEL_ON_COLUMN);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == this.parallelColumnIndex;
        }

        public Class getColumnClass(int n) {
            if (n == this.parallelColumnIndex) {
                return Boolean.class;
            }
            return super.getColumnClass(n);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == this.parallelColumnIndex) {
                boolean bl;
                Object object2 = this.getValueAt(n, n2);
                boolean bl2 = bl = !object2.equals(object);
                if (bl) {
                    this.activeParallel = Boolean.TRUE.equals(object) ? ++this.activeParallel : --this.activeParallel;
                    ParallelTablePanel.this.updateToolBarTitle(this.activeParallel, this.totalRows);
                }
            }
            super.setValueAt(object, n, n2);
        }
    }
}

