/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.scheduler;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.scheduler.DialogsLrb;
import oracle.dmt.dataminer.workflow.scheduler.NodesPanel;
import oracle.dmt.dataminer.workflow.scheduler.NotificationPanel;
import oracle.dmt.dataminer.workflow.scheduler.ScheduleWorkflowDialog;
import oracle.dmt.dataminer.workflow.scheduler.SchedulerModel;
import oracle.dmt.dataminer.workflow.scheduler.SettingsPanel;
import oracle.ide.Context;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;

public class AdvancedSettingsPanel
extends DialogDisplayer<AbstractNode> {
    private Logger theLogger = Logger.getLogger(this.getClass().getName());
    private ScheduleWorkflowDialog parent;
    private SchedulerModel model;
    private static String NOTIFICATION_TAB = DialogsLrb.get("SCHEDULER_ADVANCED_NOTIFICATION_TAB");
    private static String SETTINGS_TAB = DialogsLrb.get("SCHEDULER_ADVANCED_SETTINGS_TAB");
    private static String NODES_TAB = DialogsLrb.get("SCHEDULER_ADVANCED_NODES_TAB");
    private NotificationPanel notificationPanel;
    private SettingsPanel settingsPanel;
    private NodesPanel nodesPanel;
    private JTabbedPane jTabbedPane;

    public AdvancedSettingsPanel(Context context, ScheduleWorkflowDialog scheduleWorkflowDialog) {
        super(context, null);
        this.parent = scheduleWorkflowDialog;
        this.model = scheduleWorkflowDialog.getModel();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
    }

    @Override
    public void initUI() {
        HelpUtils.setHelpID((JComponent)this, (String)this.getHelpTopic());
        final class Initialization
        extends ProgressRunnable {
            Initialization() {
            }

            protected Object doWork() throws Exception {
                AdvancedSettingsPanel.this.model.loadJobs();
                AdvancedSettingsPanel.this.model.loadRunNodes();
                AdvancedSettingsPanel.this.notificationPanel = new NotificationPanel(AdvancedSettingsPanel.this.getContext(), AdvancedSettingsPanel.this.parent);
                AdvancedSettingsPanel.this.settingsPanel = new SettingsPanel(AdvancedSettingsPanel.this.getContext(), AdvancedSettingsPanel.this.parent);
                AdvancedSettingsPanel.this.nodesPanel = new NodesPanel(AdvancedSettingsPanel.this.getContext(), AdvancedSettingsPanel.this.parent);
                return null;
            }

            protected void finish(Object object) {
                AdvancedSettingsPanel.this.jTabbedPane.add(NOTIFICATION_TAB, AdvancedSettingsPanel.this.notificationPanel);
                AdvancedSettingsPanel.this.jTabbedPane.add(SETTINGS_TAB, AdvancedSettingsPanel.this.settingsPanel);
                AdvancedSettingsPanel.this.jTabbedPane.add(NODES_TAB, AdvancedSettingsPanel.this.nodesPanel);
            }
        }
        Initialization initialization = new Initialization();
        initialization.setTitle(DialogsLrb.get("SCHEDULER_ADVANCED_DIALOG_TITLE"));
        initialization.setMessage(DialogsLrb.get("SCHEDULER_LOADING"));
        initialization.setCancelable(false);
        try {
            initialization.start(true);
        }
        catch (ProgressException progressException) {
            this.theLogger.log(Level.SEVERE, progressException.getMessage(), progressException);
        }
    }

    public void refreshUI() {
        this.notificationPanel.initUI();
        this.settingsPanel.initUI();
    }

    @Override
    protected String getDialogTitle() {
        return DialogsLrb.get("SCHEDULER_ADVANCED_DIALOG_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        return "scheduler_advanced_dialog";
    }

    @Override
    protected boolean doWork() {
        this.model.setUseNotification(this.notificationPanel.isUseNotification());
        this.model.setEmailRecipients(this.notificationPanel.getRecipients());
        this.model.setEmailSubject(this.notificationPanel.getSubject());
        this.model.setEmailComment(this.notificationPanel.getComment());
        this.model.setUseEventFailed(this.notificationPanel.isUseEventFailed());
        this.model.setUseEventStarted(this.notificationPanel.isUseEventStarted());
        this.model.setUseEventSucceeded(this.notificationPanel.isUseEventSucceeded());
        this.model.setUseEventStopped(this.notificationPanel.isUseEventStopped());
        this.model.setTimeZone(this.settingsPanel.getTimeZone());
        this.model.setJobClass(this.settingsPanel.getJobClass());
        this.model.setJobPriority(this.settingsPanel.getJobPriority());
        this.model.setUseMaxFailures(this.settingsPanel.isUseMaxFailures());
        this.model.setMaxFailures(this.settingsPanel.getMaxFailures());
        this.model.setUseMaxRunDuration(this.settingsPanel.isUseMaxRunDuration());
        this.model.setMaxRunDurationDays(this.settingsPanel.getMaxRunDurationDays());
        this.model.setMaxRunDurationHours(this.settingsPanel.getMaxRunDurationHours());
        this.model.setMaxRunDurationMins(this.settingsPanel.getMaxRunDurationMins());
        this.model.setUseScheduleLimit(this.settingsPanel.isUseScheduleLimit());
        this.model.setScheduleLimitDays(this.settingsPanel.getScheduleLimitDays());
        this.model.setScheduleLimitHours(this.settingsPanel.getScheduleLimitHours());
        this.model.setScheduleLimitMins(this.settingsPanel.getScheduleLimitMins());
        return true;
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    private void initComponents() {
        this.jTabbedPane = new JTabbedPane();
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane, -1, 417, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane, -1, 350, Short.MAX_VALUE).addContainerGap()));
    }
}

