/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import oracle.ide.Ide;
import oracle.ide.config.DTCache;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLPath;
import oracle.ide.util.VersionNumber;
import oracle.javatools.parser.java.v2.JdkVersion;
import oracle.javatools.util.JdkSystemProperties;
import oracle.jdeveloper.java.locator.ModularizedJdkJmodLocator;
import oracle.jdeveloper.java.locator.ModularizedJdkSourceLocator;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.resource.ControlsArb;
import oracle.jdeveloper.resource.LibraryArb;

public final class JDKUtil {
    private static final String ORACLE_HOST = "docs.oracle.com";
    private static final String PATH_PREFIX = "/javase/";
    private static final String PATH_POSTFIX = "/docs/api/";
    private static final String CFG_FILE = "jvm.cfg";

    public static boolean initNewJDK(JDK jdk, URL javaExe) {
        if (jdk != null && new JDKExeFilter().accept(javaExe)) {
            JDKUtil.removeCachedProperties(javaExe);
            return JDKUtil.initJDK(jdk, javaExe);
        }
        return false;
    }

    public static boolean initJDK(JDK jdk, URL javaExe) {
        VersionNumber versionNumber;
        String version = null;
        String clsPath = null;
        String home = null;
        if (jdk != null && new JDKExeFilter().accept(javaExe)) {
            Properties properties = JDKUtil.getSystemProperties(javaExe);
            version = properties.getProperty("java.version");
            clsPath = properties.getProperty("sun.boot.class.path");
            home = properties.getProperty("java.home");
        }
        if (version != null && home != null && ((versionNumber = new VersionNumber(version)).isAfter(new VersionNumber("9"), true) || clsPath != null)) {
            JDKUtil.initJDK(jdk, javaExe, version, clsPath, home);
            return true;
        }
        return false;
    }

    public static void initJDK(JDK jdk, URL exe, String version, String clsPath, String home) {
        String pathVersion;
        URL rootDir;
        VersionNumber ver = new VersionNumber(version);
        boolean isJdk9OrHigher = ver.isAfter(new VersionNumber("9"), true);
        jdk.setJavaVersion(ver);
        jdk.setJavaExecutable(exe);
        URL homeURL = URLFactory.newDirURL((String)home);
        String dirName = URLFileSystem.getFileName((URL)homeURL);
        boolean hasJreDir = "jre".equals(dirName);
        URL uRL = rootDir = hasJreDir ? URLFileSystem.getParent((URL)homeURL) : homeURL;
        if (isJdk9OrHigher) {
            URL jmodURL = URLFactory.newDirURL((URL)rootDir, (String)"jmods");
            ModularizedJdkJmodLocator classLocator = ModularizedJdkJmodLocator.getInstance((URL)jmodURL);
            jdk.setClassPath(classLocator.getClassPath());
            jdk.setExpandedClassPath(classLocator.getExpandedClassPath());
        } else {
            jdk.setClassPath(URLPath.newURLPathFromString((String)clsPath));
            jdk.setExpandedClassPath(new URLPath(jdk.getClassPath()));
        }
        if (isJdk9OrHigher) {
            JDKUtil._setJdk9SourcePath(jdk, rootDir);
        } else {
            URLPath srcPath = JDKUtil._fillSrcPath(rootDir);
            jdk.setSourcePath(srcPath);
            jdk.setExpandedSourcePath(new URLPath(srcPath));
        }
        URLPath docPath = new URLPath();
        JdkVersion jdkVersion = JdkVersion.getJdkVersion((String)ver.toString());
        String string = pathVersion = jdkVersion == JdkVersion.JDK_UNKNOWN || !jdkVersion.isJdk3OrAbove() ? "1.3" : jdkVersion.getVersionString();
        if (pathVersion.startsWith("1.")) {
            pathVersion = pathVersion.substring(2);
        }
        docPath.add(URLFactory.newURL((String)"http", null, (String)ORACLE_HOST, (int)-1, (String)(PATH_PREFIX + pathVersion + PATH_POSTFIX), null, null));
        jdk.setDocPath(docPath);
        URL binDir = URLFactory.newDirURL((URL)rootDir, (String)"bin");
        jdk.setSDKBinDir(binDir);
    }

    static Properties getSystemProperties(JDK jdk) {
        return JDKUtil.getSystemProperties(jdk.getJavaExecutable());
    }

    private static Properties getSystemProperties(URL javaExe) {
        Properties properties = new Properties();
        if (!JDKUtil.getCachedProperties(javaExe, properties)) {
            try {
                URL dir = URLFileSystem.getParent((URL)javaExe);
                URL exec = JDKUtil.getJavaExecutableNoConsole(dir);
                URL classpath = JdkSystemProperties.class.getProtectionDomain().getCodeSource().getLocation();
                if (classpath == null) {
                    JDKUtil.getSystemPropertiesThroughResource(javaExe, exec, properties);
                } else {
                    URLPath cPath = new URLPath(classpath);
                    String cName = JdkSystemProperties.class.getName();
                    if (!JDKUtil._pathValid(exec, cPath, cName)) {
                        return properties;
                    }
                    JDKUtil.getSystemProperties(javaExe, exec, properties, cPath, cName);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getSystemPropertiesThroughResource(URL javaExeName, URL executable, Properties properties) throws Exception {
        File tempDir = JDKUtil.createTempDir();
        try {
            String className = JdkSystemProperties.class.getName();
            String tempFileName = className.replace('.', '/');
            tempFileName = tempFileName + ".class";
            File tempFile = new File(tempDir, tempFileName);
            tempFile.getParentFile().mkdirs();
            InputStream resourceStream = null;
            FileOutputStream outStream = null;
            try {
                int c;
                resourceStream = JdkSystemProperties.class.getResourceAsStream("JdkSystemProperties.class");
                outStream = new FileOutputStream(tempFile);
                while ((c = resourceStream.read()) != -1) {
                    outStream.write(c);
                }
            }
            finally {
                if (resourceStream != null) {
                    resourceStream.close();
                }
                if (outStream != null) {
                    outStream.close();
                }
            }
            URL tempDirURL = URLFactory.newDirURL((File)tempDir);
            URLPath classPath = new URLPath(tempDirURL);
            JDKUtil.getSystemProperties(javaExeName, executable, properties, classPath, className);
        }
        finally {
            JDKUtil.deleteTempDir(tempDir);
        }
    }

    private static void deleteTempDir(File tempDir) {
        File[] children = tempDir.listFiles();
        if (children != null) {
            for (File child : children) {
                if (child.isDirectory()) {
                    JDKUtil.deleteTempDir(child);
                    continue;
                }
                if (child.delete()) continue;
                child.deleteOnExit();
            }
        }
        if (!tempDir.delete()) {
            tempDir.deleteOnExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getSystemProperties(URL javaExeName, URL executable, Properties properties, URLPath classPath, String className) throws Exception {
        File temp = File.createTempFile("system", ".properties");
        try {
            String[] args = new String[]{URLFileSystem.getPlatformPathName((URL)executable), "-classpath", classPath.toString(), className, temp.getPath()};
            Process proc = Runtime.getRuntime().exec(args);
            while (true) {
                try {
                    proc.waitFor();
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    continue;
                }
                break;
            }
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(temp));){
                properties.load(in);
                JDKUtil.putCachedProperties(javaExeName, properties);
            }
        }
        catch (IOException e) {
            if (Ide.getIdeArgs().getCreateUI()) {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), LibraryArb.format(26, e.getMessage()), LibraryArb.getString(25), 2);
            } else {
                System.out.println(LibraryArb.getString(25));
                System.out.println(LibraryArb.format(26, e.getMessage()));
            }
        }
        finally {
            if (!temp.delete()) {
                temp.deleteOnExit();
            }
        }
    }

    private static File createTempDir() throws IOException {
        File tempFile = File.createTempFile("JDKUtil", null);
        File tempBaseDir = tempFile.getParentFile();
        if (!tempFile.delete()) {
            tempFile.deleteOnExit();
        }
        String tempDirName = "JDKUtil" + System.currentTimeMillis();
        for (int counter = 0; counter < 100; ++counter) {
            File tempDir = new File(tempBaseDir, tempDirName + counter);
            if (!tempDir.mkdir()) continue;
            return tempDir;
        }
        throw new IOException("Can't create temporary directory");
    }

    private static boolean getCachedProperties(URL javaExe, Properties properties) {
        String property;
        DTCache cache;
        if (javaExe != null && (cache = Ide.getDTCache()) != null && (property = cache.getString(javaExe.getPath())) != null) {
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(property.getBytes("8859_1"));
                properties.load(in);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private static void removeCachedProperties(URL javaExe) {
        DTCache cache;
        if (javaExe != null && (cache = Ide.getDTCache()) != null) {
            cache.remove(javaExe.getPath());
        }
    }

    private static void putCachedProperties(URL javaExe, Properties properties) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream(512);){
            properties.store(out, null);
            Ide.getDTCache().putString(javaExe.getPath(), out.toString("8859_1"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean _pathValid(URL exec, URLPath cPath, String cName) {
        return URLFileSystem.exists((URL)exec) && URLFileSystem.isRegularFile((URL)exec) && cPath.toQualifiedURL(cName.replace('.', '/') + ".class") != null;
    }

    private static URLPath _fillSrcPath(URL parent) {
        URLPath srcPath = new URLPath();
        String[] archiveName = new String[]{"src.zip", "src.jar"};
        String[] subDirs = new String[]{"", "src/"};
        for (int i = 0; i < archiveName.length; ++i) {
            URL archive = URLFactory.newURL((URL)parent, (String)archiveName[i]);
            if (!URLFileSystem.exists((URL)archive)) continue;
            for (int j = 0; j < subDirs.length; ++j) {
                URL dir = URLFactory.newJarURL((URL)archive, (String)subDirs[j]);
                if (!URLFileSystem.exists((URL)URLFactory.newURL((URL)dir, (String)"java/lang/Object.java"))) continue;
                srcPath.add(dir);
                return srcPath;
            }
        }
        return srcPath;
    }

    private static void _setJdk9SourcePath(JDK jdk, URL home) {
        String archiveName = "lib/src.zip";
        URL archive = URLFactory.newURL((URL)home, (String)archiveName);
        if (URLFileSystem.exists((URL)archive)) {
            ModularizedJdkSourceLocator sourceLocator = ModularizedJdkSourceLocator.getInstance((URL)archive);
            jdk.setSourcePath(sourceLocator.getSourcePath());
            jdk.setExpandedSourcePath(sourceLocator.getExpandedSourcePath());
        } else {
            jdk.setSourcePath(new URLPath());
            jdk.setExpandedSourcePath(new URLPath());
        }
    }

    private static URL _checkLocation(URL dir) {
        if (dir == null) {
            return null;
        }
        URL cfg = URLFactory.newURL((URL)dir, (String)CFG_FILE);
        return cfg != null && URLFileSystem.exists((URL)cfg) ? cfg : null;
    }

    private static URL _findJvmCfg(URL javaHomeLibUrl) {
        URL cfg = JDKUtil._checkLocation(javaHomeLibUrl);
        if (cfg != null) {
            return cfg;
        }
        String arch = System.getProperty("os.arch");
        if ("x86".equals(arch)) {
            arch = "i386";
        }
        if ((cfg = JDKUtil._checkLocation(URLFactory.newDirURL((URL)javaHomeLibUrl, (String)arch))) != null) {
            return cfg;
        }
        return JDKUtil._checkChildren(javaHomeLibUrl);
    }

    private static URL _checkChildren(URL baseURL) {
        URL[] children = URLFileSystem.list((URL)baseURL, (URLFilter)new URLFilter(){

            public boolean accept(URL url) {
                return URLFileSystem.isDirectory((URL)url);
            }
        });
        if (children != null) {
            for (int i = children.length - 1; i >= 0; --i) {
                URL cfg = JDKUtil._checkLocation(children[i]);
                if (cfg != null) {
                    return cfg;
                }
                cfg = JDKUtil._checkChildren(children[i]);
                if (cfg == null) continue;
                return cfg;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getVMChoices(URL SDKBinURL, boolean addOjvm) {
        URL cfg;
        URL parent = URLFileSystem.getParent((URL)SDKBinURL);
        URL homeURL = URLFactory.newDirURL((URL)parent, (String)"jre");
        if (!URLFileSystem.exists((URL)homeURL)) {
            homeURL = parent;
        }
        ArrayList<String> vmList = new ArrayList<String>();
        URL libURL = URLFactory.newURL((URL)homeURL, (String)"lib/");
        if (libURL == null) {
            libURL = homeURL;
        }
        if ((cfg = JDKUtil._findJvmCfg(libURL)) != null) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(cfg.openStream()));
                while (true) {
                    String line;
                    if ((line = reader.readLine()) == null) {
                    }
                    if (line.startsWith("#")) continue;
                    String vmName = null;
                    String attribute = null;
                    StringTokenizer st = new StringTokenizer(line);
                    if (st.hasMoreTokens()) {
                        vmName = st.nextToken();
                        if (st.hasMoreTokens()) {
                            attribute = st.nextToken();
                        }
                    }
                    if (vmName == null || attribute != null && !attribute.equalsIgnoreCase("KNOWN") && !attribute.equalsIgnoreCase("IF_SERVER_CLASS") && !attribute.equalsIgnoreCase("ALIASED_TO")) continue;
                    if (vmName.startsWith("-")) {
                        vmName = vmName.substring(1);
                    }
                    vmList.add(vmName);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception ex) {}
                }
            }
        } else {
            URL[] contents;
            URL binURL = URLFactory.newDirURL((URL)homeURL, (String)"bin");
            if (URLFileSystem.exists((URL)binURL) && (contents = URLFileSystem.list((URL)binURL, (URLFilter)new URLFilter(){

                public boolean accept(URL url) {
                    return URLFileSystem.isDirectory((URL)url) && URLFileSystem.exists((URL)URLFactory.newURL((URL)url, (String)"jvm.dll"));
                }
            })) != null) {
                for (int i = 0; i < contents.length; ++i) {
                    String vmName = URLFileSystem.getFileName((URL)contents[i]);
                    vmList.add(vmName);
                }
                int idx = vmList.indexOf("classic");
                if (idx != -1) {
                    Object o = vmList.remove(idx);
                    vmList.add(0, (String)o);
                }
            }
        }
        return vmList.toArray(new String[vmList.size()]);
    }

    static URL getJavaExecutableNoConsole(URL dir) {
        String[] possibleJava = new String[]{"javaw.exe", "javaw", "java.exe", "java"};
        int length = possibleJava.length;
        for (int i = 0; i < length; ++i) {
            URL javaURL = URLFactory.newURL((URL)dir, (String)possibleJava[i]);
            if (!URLFileSystem.exists((URL)javaURL)) continue;
            return javaURL;
        }
        return null;
    }

    static String getJavaExecutableNoConsolePath(URL dir) {
        URL url = JDKUtil.getJavaExecutableNoConsole(dir);
        return url != null ? URLFileSystem.getPlatformPathName((URL)url) : "java";
    }

    public static class JDKExeFilter
    implements URLFilter {
        public boolean accept(URL url) {
            String fName;
            boolean result = false;
            if (url != null && "file".equals(url.getProtocol()) && URLFileSystem.isRegularFile((URL)url) && (fName = URLFileSystem.getFileName((URL)url)) != null) {
                result = (fName = fName.toLowerCase()).equals("java") || fName.equals("java.exe");
            }
            return result;
        }

        public boolean equals(Object o) {
            return o instanceof JDKExeFilter;
        }

        public String toString() {
            return ControlsArb.getString(53);
        }
    }
}

