/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import oracle.ide.net.URLPath;
import oracle.ide.util.VersionNumber;
import oracle.javatools.exports.common.UnmodifiableMappingListWrapper;
import oracle.javatools.exports.library.ClassPathEntry;
import oracle.javatools.exports.library.ExportLibrary;
import oracle.javatools.exports.library.FileExportLibrary;
import oracle.javatools.exports.library.LibraryDependency;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.marshal.AttributeMarker;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryDefinition;
import oracle.jdeveloper.library.Library;

public final class ManifestLibrary
implements JLibrary,
ExportLibrary {
    private final URL origin;
    private final String id;
    private final String name;
    private final String description;
    private final Set<FileExportLibrary.LibraryFlag> flags;
    private final Map<String, List<URL>> exportSpecificationPaths;
    private final List<URL> remediationCommentsPaths;
    private final URLPath srcPath;
    private final URLPath docPath;
    private final List<LibraryDependency> dependencies;
    private final URLPath classPath;
    private final List<ClassPathEntry> suppliedClassPathEntries;
    private final List<ClassPathEntry> resolvedClassPathEntries;
    private final List<ClassPathEntry> expandedClassPathEntries;
    private final boolean manifestClassPath;
    private final Map<String, String> resolvedRemediationComments;

    public ManifestLibrary(FileExportLibrary library) {
        this.origin = library.getOrigin();
        this.id = library.getId();
        this.name = library.getName();
        this.description = library.getDescription();
        this.flags = library.getFlags();
        this.exportSpecificationPaths = library.getExportSpecificationPaths();
        this.remediationCommentsPaths = library.getRemediationCommentsPaths();
        this.resolvedRemediationComments = library.getResolvedRemediationComments();
        this.srcPath = new URLPath(library.getSourcePath());
        this.docPath = new URLPath(library.getDocPath());
        this.dependencies = library.getDependencies();
        this.classPath = new URLPath(library.getSuppliedClassPath());
        this.suppliedClassPathEntries = library.getSuppliedClassPathEntries();
        this.resolvedClassPathEntries = library.getResolvedClassPathEntries();
        this.expandedClassPathEntries = library.getExpandedClassPathEntries();
        this.manifestClassPath = library.hasManifestClassPath();
    }

    public URL getOrigin() {
        return this.origin;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public Boolean getDeployedByDefault() throws AttributeMarker {
        return this.flags.contains(FileExportLibrary.LibraryFlag.DEPLOYED);
    }

    @Override
    public boolean isLocked() {
        return true;
    }

    public List<ClassPathEntry> getSuppliedClassPathEntries() {
        return this.suppliedClassPathEntries;
    }

    public List<URL> getSuppliedClassPath() {
        return new UnmodifiableMappingListWrapper(this.suppliedClassPathEntries, ClassPathEntry::getUrl);
    }

    public List<ClassPathEntry> getResolvedClassPathEntries() {
        return this.resolvedClassPathEntries;
    }

    public List<URL> getResolvedClassPath() {
        return new UnmodifiableMappingListWrapper(this.resolvedClassPathEntries, ClassPathEntry::getUrl);
    }

    public List<ClassPathEntry> getExpandedClassPathEntries() {
        return this.expandedClassPathEntries;
    }

    public List<URL> getExpandedClassPath() {
        return new UnmodifiableMappingListWrapper(this.expandedClassPathEntries, ClassPathEntry::getUrl);
    }

    public boolean hasManifestClassPath() {
        return false;
    }

    public Map<String, List<URL>> getExportSpecificationPaths() {
        return this.exportSpecificationPaths;
    }

    public List<URL> getRemediationCommentsPaths() {
        return this.remediationCommentsPaths;
    }

    public Map<String, String> getResolvedRemediationComments() {
        return this.resolvedRemediationComments;
    }

    public List<LibraryDependency> getDependencies() {
        return this.dependencies;
    }

    @Override
    public URLPath getClassPath() {
        return this.classPath;
    }

    @Override
    public URLPath getSourcePath() {
        return new URLPath(this.srcPath);
    }

    @Override
    public URLPath getDocPath() {
        return new URLPath(this.docPath);
    }

    public String getShortLabel() {
        return this.name;
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public String getToolTipText() {
        return this.getLongLabel();
    }

    public Icon getIcon() {
        return OracleIcons.getIcon((String)"library.png");
    }

    @Override
    public Object getID() {
        return this.getName();
    }

    @Override
    @Deprecated
    public URLPath getDefaultClassPath() {
        return this.getClassPath();
    }

    @Override
    @Deprecated
    public URLPath getDefaultSourcePath() {
        return this.getSourcePath();
    }

    @Override
    @Deprecated
    public URLPath getDefaultDocPath() {
        return this.getDocPath();
    }

    @Override
    @Deprecated
    public JLibraryDefinition getDefaultLibraryDefinition() {
        return this;
    }

    @Override
    @Deprecated
    public JLibraryDefinition getLibraryDefinition(VersionNumber jdkVer) {
        return this;
    }

    @Override
    public void setDeployedByDefault(Boolean deployed) {
        this.immutable();
    }

    @Override
    public void setClassPath(URLPath clsPath) {
        this.immutable();
    }

    @Override
    @Deprecated
    public void setDefaultClassPath(URLPath clsPath) {
        this.immutable();
    }

    @Override
    @Deprecated
    public void setDefaultDocPath(URLPath docPath) {
        this.immutable();
    }

    @Override
    @Deprecated
    public void setDefaultSourcePath(URLPath srcPath) {
        this.immutable();
    }

    @Override
    public void setDocPath(URLPath docPath) {
        this.immutable();
    }

    @Override
    public void setLocked(boolean isLocked) {
        this.immutable();
    }

    @Override
    public void setName(String name) {
        this.immutable();
    }

    @Override
    public void setSourcePath(URLPath srcPath) {
        this.immutable();
    }

    private void immutable() {
        throw new UnsupportedOperationException("AddinLibrary instances are immutable.");
    }

    @Override
    public boolean equivalent(Library library) {
        if (library == null) {
            return false;
        }
        if (ModelUtil.areDifferent((Object)library.getClassPath(), (Object)this.getClassPath())) {
            return false;
        }
        if (ModelUtil.areDifferent((Object)library.getSourcePath(), (Object)this.getSourcePath())) {
            return false;
        }
        if (ModelUtil.areDifferent((Object)library.getDocPath(), (Object)this.getDocPath())) {
            return false;
        }
        return library.isLocked() == this.isLocked();
    }

    @Override
    public void initFromLibrary(Library library) {
    }
}

