/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.logging;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.adf.share.common.impl.StackTraceAnalyzer;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.logging.BeginEndTracer;
import oracle.adf.share.logging.TraceSpanContext;

public abstract class ADFLoggerExtension {
    private static final String CLASS_NAME = "oracle.adf.share.logging.ADFLoggerExtension";
    protected static final String[] BEGIN_KEYS = new String[]{"Component", "ADF_MESSAGE_CONTEXT_DATA", "ADF_MESSAGE_ACTION_NAME", "ADF_MESSAGE_ACTION_DESC", "ADF_MESSAGE_STATUS", "ADF_MESSAGE_DEFAULT_CONTEXT_DATA"};
    protected static final String[] END_KEYS = new String[]{"ADF_MESSAGE_STATUS", "ADF_MESSAGE_ACTION_NAME"};
    protected static final String[] RELATIVE_KEYS = new String[]{"ADF_MESSAGE_STATUS", "PARENT_REQUEST_ECID"};
    protected static final String[] ADD_MESSAGE_KEYS = new String[]{"Component", "ADF_MESSAGE_CONTEXT_DATA", "ADF_MESSAGE_ACTION_NAME", "ADF_MESSAGE_STATUS"};
    static ClassnameFilter DFLT_FILTER = new DefaultClassnameFilter();
    private static ThreadLocal<ArrayDeque<TraceSpanContext>> beginEndTraceStackTL = new ThreadLocal<ArrayDeque<TraceSpanContext>>(){

        @Override
        protected ArrayDeque<TraceSpanContext> initialValue() {
            return new ArrayDeque<TraceSpanContext>();
        }
    };

    public abstract Logger getLogger(String var1, String var2);

    protected boolean isLoggable(Logger logger, Level level) {
        return logger.isLoggable(level);
    }

    protected LogRecord createLogRecord(Level level, String msg, String loggerClassName) {
        LogRecord rec = new LogRecord(level, msg);
        this.setSourceNames(rec, loggerClassName);
        return rec;
    }

    protected void setSupplAttributes(ADFLogger inst, LogRecord rec, Map<String, String> cntx) {
    }

    protected void unsetSupplAttributes(ADFLogger inst, LogRecord rec, Map<String, String> cntx, String[] keys) {
    }

    protected void encodeContextData(Map<String, String> cntx, Map<String, String> contextData) {
    }

    protected BeginEndTracer getBeginEndTracer() {
        return ADFLogger.TracerHolder.INST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin(ADFLogger inst, Level level, String actionName, Map<String, String> contextData) {
        if (actionName == null) {
            return;
        }
        if (!inst.isLoggable(level)) {
            return;
        }
        Logger logger = inst.getLogger();
        LogRecord rec = this.createLogRecord(level, actionName, inst.getClass().getName());
        Map<String, String> cntx = this.prepareBeginContext(logger, actionName, contextData, rec);
        try {
            this.setSupplAttributes(inst, rec, cntx);
            ArrayDeque<TraceSpanContext> stack = beginEndTraceStackTL.get();
            TraceSpanContext tsc = new TraceSpanContext(inst, level, rec, cntx, stack.size());
            BeginEndTracer tracer = ADFLogger.getBeginEndTracer();
            tracer.beginTraceSpan(tsc);
            stack.push(tsc);
            if (tracer.logSpans()) {
                logger.log(rec);
            }
        }
        finally {
            this.unsetSupplAttributes(inst, rec, cntx, BEGIN_KEYS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(ADFLogger inst, Level level, String actionName) {
        TraceSpanContext key;
        if (!inst.isLoggable(level)) {
            return;
        }
        BeginEndTracer tracer = ADFLogger.getBeginEndTracer();
        ArrayDeque<TraceSpanContext> stack = beginEndTraceStackTL.get();
        TraceSpanContext traceSpanContext = key = "node_end".equals(actionName) ? this.getDeprecatedContext(inst, actionName, stack.peekFirst()) : new TraceSpanContext(inst, actionName);
        if (!stack.contains(key)) {
            if (ADFLogger.stackLogger.isLoggable(Level.WARNING)) {
                ADFLogger.stackLogger.warning("ADFLogger.end without begin( " + inst.getName() + ", " + actionName + " ) not found! Stack was: " + stack + "\n" + ADFLoggerExtension.abbreviatedStackTrace(new IllegalArgumentException().getStackTrace(), inst.getClass().getName()));
            }
            return;
        }
        Logger logger = inst.getLogger();
        while (!stack.isEmpty()) {
            TraceSpanContext tsc = stack.pop();
            tsc.updateCntxItem("ADF_MESSAGE_STATUS", "end");
            tsc.updateCntxItem("ramp.stackSize", "" + stack.size());
            tsc.updateCntxItem("ramp.duration", "" + tsc.recordDuration());
            tracer.endTraceSpan(tsc);
            if (tsc.equals(key)) break;
            if (!tracer.logSpans()) continue;
            LogRecord rec2 = this.createLogRecord(level, tsc.getActionName(), inst.getClass().getName());
            this.setSupplAttributes(inst, rec2, tsc.getLoggingContext());
            logger.log(rec2);
            this.unsetSupplAttributes(inst, rec2, tsc.getLoggingContext(), END_KEYS);
        }
        if (!tracer.logSpans()) {
            return;
        }
        LogRecord rec = this.createLogRecord(level, actionName, inst.getClass().getName());
        HashMap<String, String> cntx = new HashMap<String, String>();
        cntx.put("ADF_MESSAGE_STATUS", "end");
        cntx.put("ADF_MESSAGE_ACTION_NAME", actionName);
        try {
            this.setSupplAttributes(inst, rec, cntx);
            logger.log(rec);
        }
        finally {
            this.unsetSupplAttributes(inst, rec, cntx, END_KEYS);
        }
    }

    private TraceSpanContext getDeprecatedContext(ADFLogger inst, String actionName, TraceSpanContext stackPeek) {
        TraceSpanContext ret = stackPeek;
        if (ret == null) {
            ADFLogger.stackLogger.warning(actionName + " unable to map deprecated end on " + inst.getName());
            ret = new TraceSpanContext(inst, actionName);
        } else {
            actionName = ret.getActionName();
            ADFLogger.stackLogger.config("Deprecated end mapped to " + actionName + " on " + inst.getName());
            ADFLogger prevInst = ret.getADFLogger();
            if (!prevInst.equals(inst)) {
                ADFLogger.stackLogger.warning("Mismatch loggers, prevInst=" + prevInst + " inst=" + inst);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logRelativeADFRequest(ADFLogger inst, String parentEcid) {
        if (!inst.isLoggable(Level.CONFIG)) {
            return;
        }
        LogRecord rec = this.createLogRecord(Level.CONFIG, "Secondary ADF Request", inst.getClass().getName());
        HashMap<String, String> cntx = new HashMap<String, String>();
        cntx.put("ADF_MESSAGE_STATUS", "PARENT_REQUEST_ECID");
        cntx.put("PARENT_REQUEST_ECID", parentEcid);
        try {
            this.setSupplAttributes(inst, rec, cntx);
            inst.getLogger().log(rec);
        }
        finally {
            this.unsetSupplAttributes(inst, rec, cntx, RELATIVE_KEYS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageToRequest(ADFLogger inst, Level level, String actionName, Map<String, String> contextData, String messageTag, Throwable thrown) {
        if (!inst.isLoggable(level)) {
            return;
        }
        BeginEndTracer tracer = ADFLogger.getBeginEndTracer();
        LogRecord rec = this.createLogRecord(level, actionName, inst.getClass().getName());
        rec.setThrown(thrown);
        Map<String, String> cntx = this.prepareMessageContext(contextData, actionName, messageTag, rec);
        try {
            this.setSupplAttributes(inst, rec, cntx);
            ArrayDeque<TraceSpanContext> stack = beginEndTraceStackTL.get();
            if (!stack.isEmpty()) {
                TraceSpanContext tsc = stack.peekFirst();
                tsc.updateCntxItems(cntx, thrown);
                tracer.addTraceData(tsc);
            }
            if (tracer.logSpans()) {
                inst.getLogger().log(rec);
            }
        }
        finally {
            this.unsetSupplAttributes(inst, rec, cntx, ADD_MESSAGE_KEYS);
        }
    }

    protected Map<String, String> prepareBeginContext(Logger logger, String actionName, Map<String, String> contextData, LogRecord rec) {
        ResourceBundle rb = logger.getResourceBundle();
        String actionDesc = "";
        String disCol = "";
        String disColValue = "";
        if (rb != null) {
            String actionNamePrefix = actionName.trim().replace(' ', '_');
            try {
                actionDesc = rb.getString(actionNamePrefix + "_DESC");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            try {
                String val;
                disCol = rb.getString(actionNamePrefix + "_DISPLAY_COL");
                String string = val = contextData != null ? contextData.get(disCol) : null;
                if (val != null) {
                    disColValue = val;
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        HashMap<String, String> cntx = new HashMap<String, String>();
        if (contextData == null || !contextData.containsKey("Component")) {
            cntx.put("Component", rec.getSourceClassName());
        }
        this.encodeContextData(cntx, contextData);
        cntx.put("ADF_MESSAGE_ACTION_NAME", actionName);
        cntx.put("ADF_MESSAGE_ACTION_DESC", actionDesc);
        cntx.put("ADF_MESSAGE_STATUS", "begin");
        if (disCol != null && disCol.trim().length() > 0) {
            cntx.put("ADF_MESSAGE_DEFAULT_CONTEXT_DATA", disCol + "=" + disColValue);
        }
        return cntx;
    }

    protected Map<String, String> prepareMessageContext(Map<String, String> contextData, String actionName, String messageTag, LogRecord rec) {
        HashMap<String, String> cntx = new HashMap<String, String>();
        if (contextData == null || !contextData.containsKey("Component")) {
            cntx.put("Component", rec.getSourceClassName());
        }
        this.encodeContextData(cntx, contextData);
        cntx.put("ADF_MESSAGE_ACTION_NAME", actionName);
        cntx.put("ADF_MESSAGE_STATUS", messageTag);
        if (rec.getThrown() != null) {
            cntx.put("ADF_MESSAGE_THROWABLE", ADFLoggerExtension.abbreviatedStackTrace(rec.getThrown().getStackTrace(), rec.getSourceClassName()));
        }
        return cntx;
    }

    protected void setSourceNames(LogRecord rec, String loggerClassName) {
        String finalLoggerClassName;
        StackTraceElement el;
        if (loggerClassName == null) {
            loggerClassName = "oracle.adf.share.logging.ADFLogger";
        }
        if ((el = new StackTraceAnalyzer().getCallerFrame(new StackTraceAnalyzer.StackTraceElementChecker(finalLoggerClassName = loggerClassName){
            final /* synthetic */ String val$finalLoggerClassName;
            {
                this.val$finalLoggerClassName = string;
            }

            @Override
            public boolean isRelevantFrame(StackTraceElement se) {
                return se.getClassName().equals(this.val$finalLoggerClassName);
            }
        }, new StackTraceAnalyzer.StackTraceElementChecker(){

            @Override
            public boolean isRelevantFrame(StackTraceElement se) {
                String cnam = se.getClassName();
                return cnam.equals(finalLoggerClassName) || cnam.contains(".reflect.");
            }
        })) != null) {
            rec.setSourceClassName(el.getClassName());
            rec.setSourceMethodName(el.getMethodName());
        }
    }

    public static int endRemainingSpansOnThisThread() {
        BeginEndTracer tracer = ADFLogger.getBeginEndTracer();
        ArrayDeque<TraceSpanContext> stack = beginEndTraceStackTL.get();
        int ret = stack.size();
        boolean isInfo = ADFLogger.stackLogger.isLoggable(Level.INFO);
        while (stack.size() > 0) {
            TraceSpanContext tsc = stack.pop();
            String loggerCN = tsc.getADFLogger().getClass().getName();
            tsc.updateCntxItem("ADF_MESSAGE_STATUS", "add_context_data");
            tsc.updateCntxItem("ramp.stackSize", "" + stack.size());
            HashMap<String, String> updates = new HashMap<String, String>(1);
            StackTraceElement[] elems = tsc.created.getStackTrace();
            int ix = ADFLoggerExtension.firstSignificantElement(elems, loggerCN, DFLT_FILTER);
            updates.put("ramp.leaked", "true");
            tsc.updateCntxItems(updates, elems, ix);
            tracer.addTraceData(tsc);
            if (isInfo) {
                ADFLogger.stackLogger.log(Level.INFO, ">>> Ending leaked: " + tsc + "\n" + ADFLoggerExtension.abbreviatedStackTrace(elems, ix, DFLT_FILTER));
            }
            tsc.updateCntxItem("ADF_MESSAGE_STATUS", "end");
            tsc.updateCntxItem("ramp.duration", "" + tsc.recordDuration());
            tracer.endTraceSpan(tsc);
            if (!tracer.logSpans()) continue;
            ADFLogger adfLogger = tsc.getADFLogger();
            ADFLoggerExtension extn = ADFLogger.loggerExtn.get();
            LogRecord rec2 = extn.createLogRecord(tsc.getLevel(), tsc.getActionName(), adfLogger.getClass().getName());
            rec2.setSourceClassName(CLASS_NAME);
            rec2.setSourceMethodName("endRemainingSpansOnThisThread");
            extn.setSupplAttributes(adfLogger, rec2, tsc.getLoggingContext());
            adfLogger.getLogger().log(rec2);
            extn.unsetSupplAttributes(adfLogger, rec2, tsc.getLoggingContext(), END_KEYS);
        }
        return ret;
    }

    static int firstSignificantElement(StackTraceElement[] elems, String markerCN, ClassnameFilter f) {
        boolean foundMarker = false;
        boolean pastMarker = false;
        for (int i = 0; i < elems.length; ++i) {
            StackTraceElement el = elems[i];
            String clnm = el.getClassName();
            if (!foundMarker) {
                if (!clnm.equals(markerCN)) continue;
                foundMarker = true;
                continue;
            }
            if (!pastMarker) {
                if (clnm.equals(markerCN)) continue;
                pastMarker = true;
            }
            if (!f.accept(clnm)) continue;
            return i;
        }
        return 0;
    }

    static String abbreviatedStackTrace(StackTraceElement[] elems, String markerCN) {
        return ADFLoggerExtension.abbreviatedStackTrace(elems, ADFLoggerExtension.firstSignificantElement(elems, markerCN, DFLT_FILTER), DFLT_FILTER);
    }

    static String abbreviatedStackTrace(StackTraceElement[] elems, int ix, ClassnameFilter f) {
        StringBuilder buf = new StringBuilder();
        buf.append("Caused by:");
        for (int i = ix; i < elems.length; ++i) {
            StackTraceElement el = elems[i];
            String clnm = el.getClassName();
            if (!f.accept(clnm)) continue;
            buf.append("\n  " + el.toString());
        }
        return buf.toString();
    }

    protected final ArrayDeque<TraceSpanContext> getStack() {
        return beginEndTraceStackTL.get();
    }

    static class DefaultClassnameFilter
    implements ClassnameFilter {
        DefaultClassnameFilter() {
        }

        @Override
        public boolean accept(String clnm) {
            return clnm.startsWith("java") ? false : (clnm.contains(".reflect.") ? false : (clnm.contains(".maven.") ? false : !clnm.contains("junit")));
        }
    }

    public static interface ClassnameFilter {
        public boolean accept(String var1);
    }
}

