/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.logging.internal.perf;

import java.lang.reflect.Method;
import java.util.logging.Level;
import oracle.adf.share.metrics.Counter;
import oracle.adf.share.metrics.MetricFactory;
import oracle.adf.share.metrics.StateTracker;
import oracle.adf.share.metrics.Timer;

public class BridgedMetricFactory
extends MetricFactory {
    @Override
    public Counter createCounter(Level level, String groupName, String name, String type, String desc) {
        oracle.adf.share.perf.Counter delegate;
        if (groupName != null && groupName.charAt(0) != '/') {
            groupName = "/" + groupName;
        }
        if ((delegate = oracle.adf.share.perf.Counter.createCounter(level, groupName, name, type, desc)).equals(oracle.adf.share.perf.Counter.DUMMY_COUNTER)) {
            return Counter.DUMMY_COUNTER;
        }
        return new BridgedCounter(level, delegate);
    }

    @Override
    public Timer createTimer(Level level, String groupName, String name, String type, String desc) {
        oracle.adf.share.perf.Timer delegate;
        if (groupName != null && groupName.charAt(0) != '/') {
            groupName = "/" + groupName;
        }
        if ((delegate = oracle.adf.share.perf.Timer.createTimer(level, groupName, name, type, desc)).equals(oracle.adf.share.perf.Timer.DUMMY_TIMER)) {
            return Timer.DUMMY_TIMER;
        }
        return new BridgedTimer(level, delegate);
    }

    private static Method initElapsedMethod() {
        try {
            Method m = oracle.adf.share.perf.Timer.class.getDeclaredMethod("getElapsedTime", new Class[0]);
            m.setAccessible(true);
            return m;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    @Override
    public StateTracker createStateTracker(Level level, String groupName, String name, String type, byte valueType, String unit, String desc) {
        oracle.adf.share.perf.StateTracker delegate;
        if (groupName != null && groupName.charAt(0) != '/') {
            groupName = "/" + groupName;
        }
        if (unit == null) {
            unit = "";
        }
        if ((delegate = oracle.adf.share.perf.StateTracker.createStateTracker(level, groupName, name, type, valueType, unit, desc)).equals(oracle.adf.share.perf.StateTracker.DUMMY_STATE_TRACKER)) {
            return StateTracker.DUMMY_STATE_TRACKER;
        }
        return new BridgedStateTracker(level, delegate);
    }

    private static Method initClonedMethod() {
        try {
            Method m = oracle.adf.share.perf.StateTracker.class.getDeclaredMethod("getClonedValue", new Class[0]);
            m.setAccessible(true);
            return m;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    static /* synthetic */ Method access$100() {
        return BridgedMetricFactory.initElapsedMethod();
    }

    static /* synthetic */ Method access$300() {
        return BridgedMetricFactory.initClonedMethod();
    }

    private static class ClonedHolder {
        private static final Method INST = BridgedMetricFactory.access$300();

        private ClonedHolder() {
        }
    }

    private static class BridgedStateTracker
    extends StateTracker {
        private final oracle.adf.share.perf.StateTracker delegate;

        public BridgedStateTracker(Level level, oracle.adf.share.perf.StateTracker delegate) {
            super(level, delegate.mSensorFullName);
            this.delegate = delegate;
        }

        @Override
        public void increment(double increasedAmount) {
            this.delegate.increment(increasedAmount);
        }

        @Override
        public void increment(int increasedAmount) {
            this.delegate.increment(increasedAmount);
        }

        @Override
        public void increment(long increasedAmount) {
            this.delegate.increment(increasedAmount);
        }

        @Override
        public void update(double newValue) {
            this.delegate.update(newValue);
        }

        @Override
        public void update(int newValue) {
            this.delegate.update(newValue);
        }

        @Override
        public void update(long newValue) {
            this.delegate.update(newValue);
        }

        @Override
        public void update(Object newValue) {
            this.delegate.update(newValue);
        }

        @Override
        public void reset() {
            this.delegate.reset();
        }

        @Override
        public void destroy() {
            this.delegate.destroy();
        }

        @Override
        protected Object getClonedValue() {
            try {
                return ClonedHolder.INST.invoke((Object)this.delegate, new Object[0]);
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof BridgedStateTracker) {
                return this.delegate.equals(((BridgedStateTracker)obj).delegate);
            }
            return super.equals(obj);
        }
    }

    private static class ElapsedHolder {
        private static final Method INST = BridgedMetricFactory.access$100();

        private ElapsedHolder() {
        }
    }

    private static class BridgedTimer
    extends Timer {
        private final oracle.adf.share.perf.Timer delegate;

        public BridgedTimer(Level level, oracle.adf.share.perf.Timer delegate) {
            super(level, delegate.mSensorFullName);
            this.delegate = delegate;
        }

        @Override
        public boolean isActive() {
            return this.delegate.isActive();
        }

        @Override
        public void start() {
            this.delegate.start();
        }

        @Override
        public void stop() {
            this.delegate.stop();
        }

        @Override
        public void reset() {
            this.delegate.reset();
        }

        @Override
        public void destroy() {
            this.delegate.destroy();
        }

        @Override
        public void cleanup() {
            this.delegate.cleanup();
        }

        @Override
        protected long getElapsedTime() {
            try {
                return (Long)ElapsedHolder.INST.invoke((Object)this.delegate, new Object[0]);
            }
            catch (Throwable throwable) {
                return 0L;
            }
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof BridgedTimer) {
                return this.delegate.equals(((BridgedTimer)obj).delegate);
            }
            return super.equals(obj);
        }
    }

    private static class BridgedCounter
    extends Counter {
        private final oracle.adf.share.perf.Counter delegate;

        public BridgedCounter(Level level, oracle.adf.share.perf.Counter delegate) {
            super(level, delegate.mSensorFullName);
            this.delegate = delegate;
        }

        @Override
        public void increase() {
            this.delegate.increase();
        }

        @Override
        public long getValue() {
            return this.delegate.getValue();
        }

        @Override
        public void reset() {
            this.delegate.reset();
        }

        @Override
        public void destroy() {
            this.delegate.destroy();
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof BridgedCounter) {
                return this.delegate.equals(((BridgedCounter)obj).delegate);
            }
            return super.equals(obj);
        }
    }
}

