/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.perf.analysis;

import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.TreeSet;
import oracle.adf.share.perf.analysis.Analyzer;
import oracle.adf.share.perf.analysis.CounterResult;
import oracle.adf.share.perf.analysis.SensorResult;
import oracle.adf.share.perf.analysis.SensorTable;
import oracle.adf.share.perf.analysis.SensorTree;
import oracle.adf.share.perf.analysis.StateResult;
import oracle.adf.share.perf.analysis.TimerResult;

class RequestAnalyzer
extends Analyzer {
    private static final int MAX_NUM_REQUESTS = 1000;
    private static int sIdCount = 0;
    private LinkedHashMap mRequests = new LinkedHashMap();
    private Hashtable mMasterSensorTables = new Hashtable();

    RequestAnalyzer() {
    }

    @Override
    void analyseLine(String line) {
        int pos = line.indexOf(" ");
        String ecid = this.removeSeqNum(line.substring(0, pos));
        SensorTable table = (SensorTable)this.mRequests.get(ecid);
        if (table == null) {
            table = new SensorTable();
            this.mRequests.put(ecid, table);
        }
        pos += " ".length();
        int endPos = 0;
        while ((endPos = line.indexOf("[", pos)) != -1) {
            pos = endPos + "[".length();
            endPos = line.indexOf(" ", pos);
            int index = Integer.parseInt(line.substring(pos, endPos));
            pos = endPos + " ".length();
            endPos = line.indexOf(" ", pos);
            String rid = line.substring(pos, endPos);
            pos = endPos + " ".length();
            endPos = line.indexOf(" ", pos);
            long timeStamp = Long.parseLong(line.substring(pos, endPos));
            int startPos = pos = endPos + " ".length();
            while ((endPos = line.indexOf("]", startPos)) + "]".length() < line.length() && line.charAt(endPos + "]".length()) != ' ') {
                startPos = endPos + 1;
            }
            String value = line.substring(pos, endPos);
            pos = endPos + "]".length();
            SensorResult result = null;
            String idx = (String)sSensorTypes.get(index);
            if (idx != null) {
                if (idx.equals("t")) {
                    result = new TimerResult(index);
                } else if (idx.equals("c")) {
                    result = new CounterResult(index);
                } else if (idx.equals("s")) {
                    result = new StateResult(index);
                }
            } else {
                System.out.println("Warning: index " + index + " does not exist in performance index file.");
            }
            if (result == null) continue;
            result.mRID = rid;
            result.mTimeStamp = timeStamp;
            result.setValue(value);
            if (this.isFiltered(result)) continue;
            table.add(result);
        }
        if (this.mRequests.size() >= 1000) {
            Iterator keys = this.mRequests.keySet().iterator();
            for (int count = 0; keys.hasNext() && count < 500; ++count) {
                this.addToMasterTable(keys);
            }
        }
    }

    private void addToMasterTable(Iterator keys) {
        Object value;
        Object key = keys.next();
        SensorTable curTable = (SensorTable)this.mRequests.get(key);
        String url = curTable.getURL();
        if (url == null) {
            return;
        }
        curTable.reBaseTimeStamp();
        if (sDebug) {
            sOut.println("DEBUG: ecid=" + key + " url=" + url);
            sOut.println("=====================================================");
            curTable.print(sOut);
        }
        if ((value = this.mMasterSensorTables.get(url)) == null) {
            if (sExcludeCount > 0) {
                this.mMasterSensorTables.put(url, new Integer(1));
                if (sDebug) {
                    sOut.println("Excluded it from aggregation.");
                }
            } else {
                this.mMasterSensorTables.put(url, curTable);
            }
        } else if (value instanceof Integer) {
            int curCount = (Integer)value;
            if (sExcludeCount < ++curCount) {
                this.mMasterSensorTables.put(url, curTable);
            } else {
                this.mMasterSensorTables.put(url, new Integer(curCount));
                if (sDebug) {
                    sOut.println("Excluded it from aggregation.");
                }
            }
        } else {
            SensorTable masterTable = (SensorTable)value;
            masterTable.aggregate(curTable);
            if (sDebug) {
                sOut.println("DEBUG: after aggregate");
                sOut.println("=====================================================");
                masterTable.print(sOut);
            }
        }
        keys.remove();
    }

    @Override
    void print() {
        Iterator keys = this.mRequests.keySet().iterator();
        while (keys.hasNext()) {
            this.addToMasterTable(keys);
        }
        TreeSet<SensorTree> treeSet = this.convertToTreeSet();
        if (sFormatXml) {
            sOut.println("<?xml version=\"1.0\" ?>");
            sOut.println("<?xml-stylesheet type=\"text/xsl\" href=\"xmlTree.xsl\"?>");
            sOut.println("<!DOCTYPE tree SYSTEM 'tree.dtd'>");
            sOut.println("<tree>");
        } else {
            sOut.println("===================SUMMARY REPORT====================");
            sOut.println();
        }
        Iterator<SensorTree> it = treeSet.iterator();
        int count = 0;
        while (it.hasNext() && count < Analyzer.sNumTopUrls) {
            ++count;
            SensorTree masterTree = it.next();
            String url = masterTree.getURL();
            if (sFormatXml) {
                sOut.println("  <branch id=\"url" + sIdCount++ + "\">");
                sOut.println("    <branchText>(" + masterTree.getSummary() + ") " + RequestAnalyzer.htmlEncode(url) + "</branchText>");
            } else {
                sOut.println("[" + masterTree.getSummary() + "] " + url);
                sOut.println("=====================================================");
            }
            masterTree.print(sOut);
            if (sFormatXml) {
                sOut.println("  </branch>");
                continue;
            }
            sOut.println("=====================================================");
            sOut.println();
        }
        if (sFormatXml) {
            sOut.println("</tree>");
        }
    }

    private TreeSet<SensorTree> convertToTreeSet() {
        if (Analyzer.sIgnoreThreshold > 0) {
            this.removeMinorSensors();
        }
        TreeSet<SensorTree> treeSet = new TreeSet<SensorTree>(new TreeComparator());
        for (String url : this.mMasterSensorTables.keySet()) {
            SensorTable table;
            SensorTree tree;
            Object obj = this.mMasterSensorTables.get(url);
            if (!(obj instanceof SensorTable) || !(tree = (table = (SensorTable)obj).convertToTree()).hasURLThread()) continue;
            tree.setThreadGap();
            tree.setRunningTotal();
            treeSet.add(tree);
        }
        return treeSet;
    }

    private void removeMinorSensors() {
        for (String url : this.mMasterSensorTables.keySet()) {
            Object obj = this.mMasterSensorTables.get(url);
            if (!(obj instanceof SensorTable)) continue;
            SensorTable table = (SensorTable)obj;
            table.removeMinorSensors();
        }
    }

    private String removeSeqNum(String ecid) {
        int idx = ecid.lastIndexOf(44);
        if (idx != -1) {
            ecid = ecid.substring(0, idx);
        }
        return ecid;
    }

    private class TreeComparator
    implements Comparator<SensorTree> {
        private TreeComparator() {
        }

        @Override
        public int compare(SensorTree t1, SensorTree t2) {
            if (t1.getRequestAverageTime() <= t2.getRequestAverageTime()) {
                return 1;
            }
            return -1;
        }
    }
}

