/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.perf.analysis;

import oracle.adf.share.perf.analysis.SensorResult;

class TreeNode {
    SensorResult mResult = null;
    TreeNode mChild = null;
    TreeNode mParent = null;
    TreeNode mNext = null;
    TreeNode mPrev = null;

    TreeNode(SensorResult result) {
        this.mResult = result;
    }

    double getDuration() {
        double duration = 0.0;
        TreeNode node = this;
        while (node != null) {
            duration += (double)(node.mResult.mGap + node.mResult.mElapseTime) / (double)node.mResult.mHit;
            node = node.mNext;
        }
        return duration;
    }

    void setRunningTotal(double initValue) {
        this.mResult.mRunningTotal = initValue + (double)(this.mResult.mElapseTime + this.mResult.mGap) / (double)this.mResult.mHit;
        if (this.mChild != null) {
            this.mChild.setRunningTotal(0.0);
        }
        if (this.mNext != null) {
            this.mNext.setRunningTotal(this.mResult.mRunningTotal);
        }
    }
}

