/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.platform.weblogic;

import java.util.logging.Level;
import oracle.adf.share.platform.AdfAbstractSupport;
import oracle.adf.share.platform.AdfServerPlatformSupport;
import oracle.adf.share.platform.AdfServerPlatformUtil;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.ServerPlatformSupport;
import oracle.jrf.i18n.JRFMessageBundleHelper;

public class WLSAdfServerPlatformSupport
extends AdfServerPlatformSupport {
    protected ServerPlatformSupport svrcomp = null;

    public WLSAdfServerPlatformSupport() throws PortabilityLayerException {
        this.getConcretePlatformSupport();
    }

    @Override
    public Object getConcretePlatformSupport() throws PortabilityLayerException {
        if (this.svrcomp == null) {
            try {
                this.svrcomp = (ServerPlatformSupport)Class.forName("oracle.jrf.wls.WlsJrfInternalPlatform").newInstance();
            }
            catch (Exception ex) {
                throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10020", new String[]{ex.getMessage()}), ex);
            }
        }
        return this.svrcomp;
    }

    public WLSAdfServerPlatformSupport(ServerPlatformSupport svr) {
        this.svrcomp = svr;
    }

    @Override
    public byte[] getCheckSum(String algorithm, byte[] data) throws Exception {
        return AdfServerPlatformUtil.getCheckSum(algorithm, data);
    }

    @Override
    public String getPlatformName() {
        try {
            return super.getPlatformName();
        }
        catch (Throwable t) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(String.valueOf(t));
            }
            return AdfAbstractSupport.PLATFORM_TYPE.WEBLOGIC_PLATFORM.toString();
        }
    }

    @Override
    public String getJtaTransactionXidClassName() {
        return "weblogic.transaction.Transaction";
    }
}

