/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.profiler;

import java.awt.Component;
import java.net.URL;
import oracle.dbtools.raptor.navigator.impl.RunnableSourceNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.profiler.PLSQLController;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.model.Node;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.ora.Oracle11g;
import oracle.jdeveloper.JDeveloperMenuConstants;

public class PLSQLContextMenu
implements ContextMenuListener {
    public void menuWillShow(ContextMenu contextMenu) {
        Node node = oracle.dbtools.raptor.plsql.PLSQLContextMenu.getSingleNode((Context)contextMenu.getContext());
        if (node instanceof RunnableSourceNode) {
            String string;
            if (node instanceof PlSqlNode && "BLOCK".equals(((PlSqlNode)node).getObjectType())) {
                return;
            }
            URL uRL = node.getURL();
            if (!uRL.toString().toLowerCase().startsWith("sqldev.migration") && (string = DBURLFormatHelper.getConnectionName((URL)uRL)) != null) {
                IdeAction ideAction;
                Database database;
                try {
                    database = Connections.getInstance().getDatabase(string, true);
                }
                catch (DBException dBException) {
                    System.out.println(dBException.getAllMessages());
                    return;
                }
                if (database instanceof Oracle11g && (ideAction = PLSQLController.getProfileAction()) != null) {
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ideAction, JDeveloperMenuConstants.WEIGHT_RUN_RUN_FILE), JDeveloperMenuConstants.SECTION_RUN_CTXT_MENU);
                }
            }
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }
}

