/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.sqltrace.parser;

import java.io.PrintStream;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.raptor.sqltrace.parser.EventExecute;
import oracle.dbtools.raptor.sqltrace.parser.IElapsedEvent;
import oracle.dbtools.raptor.sqltrace.parser.IResourceEvent;

public class EventParse
implements IElapsedEvent,
IResourceEvent {
    private static final Logger LOGGER = Logger.getLogger(EventParse.class.getName());
    private static final Pattern PATTERN = Pattern.compile("#([0-9]++):c=([0-9]++),e=([0-9]++),p=([0-9]++),cr=([0-9]++),cu=([0-9]++),mis=([0-9]++),r=([0-9]++),dep=([0-9]++),og=([0-9]++),tim=([0-9]++)");
    private double _curNum;
    private double _time;
    private double _optimizer;
    private double _misses;
    private double _rows;
    private double _depLevel;
    private double _logicalIO;
    private double _phyIO;
    private double _consisIO;
    private double _elapsed;
    private double _cpu;

    public EventParse(String string) {
        string = EventExecute.trimPLH(string);
        Matcher matcher = PATTERN.matcher(string);
        boolean bl = matcher.find();
        if (bl) {
            this._curNum = Double.parseDouble(matcher.group(1));
            this._cpu = Double.parseDouble(matcher.group(2));
            this._elapsed = Double.parseDouble(matcher.group(3));
            this._phyIO = Double.parseDouble(matcher.group(4));
            this._consisIO = Double.parseDouble(matcher.group(5));
            this._logicalIO = Double.parseDouble(matcher.group(6));
            this._misses = Double.parseDouble(matcher.group(7));
            this._rows = Double.parseDouble(matcher.group(8));
            this._depLevel = Double.parseDouble(matcher.group(9));
            this._optimizer = Double.parseDouble(matcher.group(10));
            this._time = Double.parseDouble(matcher.group(11));
        } else {
            LOGGER.severe("no match for line:" + string);
        }
    }

    public String toString() {
        return String.format("PARSE #%d:c=%d,e=%d,p=%d,cr=%d,cu=%d,mis=%d,r=%d,dep=%d,og=%d,tim=%d", this._curNum, this._cpu, this._elapsed, this._phyIO, this._consisIO, this._logicalIO, this._misses, this._rows, this._depLevel, this._optimizer, this._time);
    }

    public static void main(String[] stringArray) {
        String string = "PARSE #51:c=10000,e=3613,p=0,cr=0,cu=0,mis=1,r=0,dep=0,og=0,tim=308762334929";
        EventParse eventParse = new EventParse(string);
        PrintStream printStream = System.out;
        printStream.println("TEST:" + string);
        printStream.println("REST:" + eventParse.toString());
    }

    @Override
    public double getConsistantIO() {
        return this._consisIO;
    }

    public double getCPU() {
        return this._cpu;
    }

    public double getCursorNum() {
        return this._curNum;
    }

    public double getDepLevel() {
        return this._depLevel;
    }

    @Override
    public double getElapsed() {
        return this._elapsed;
    }

    @Override
    public double getLogicalIO() {
        return this._logicalIO;
    }

    @Override
    public double getCacheMisses() {
        return this._misses;
    }

    public double getOptimizer() {
        return this._optimizer;
    }

    @Override
    public double getPhysicalIO() {
        return this._phyIO;
    }

    @Override
    public double getRows() {
        return this._rows;
    }

    @Override
    public double getTime() {
        return this._time;
    }
}

