/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.sqltrace.printers;

import java.io.PrintStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.dbtools.raptor.TuningResources;
import oracle.dbtools.raptor.sqltrace.parser.Bind;
import oracle.dbtools.raptor.sqltrace.parser.EventWait;
import oracle.dbtools.raptor.sqltrace.parser.IElapsedEvent;
import oracle.dbtools.raptor.sqltrace.parser.SqlCursor;
import oracle.dbtools.raptor.sqltrace.parser.SqlTraceUtils;
import oracle.dbtools.raptor.sqltrace.parser.Stat;
import oracle.dbtools.raptor.sqltrace.printers.ISqlCursorPrinter;

public class TemplateBasedPrinter
implements ISqlCursorPrinter {
    @Override
    public void printCursor(PrintStream printStream, SqlCursor sqlCursor) {
        printStream.println(sqlCursor.getSQL());
        printStream.println();
        for (Bind object2 : sqlCursor.getBinds()) {
            printStream.println("Bind#" + object2.getBindNum() + "=" + object2.getValue());
        }
        printStream.println();
        Object object3 = null;
        printStream.println("call      count      cpu    elapsed      disk     query   current       rows");
        printStream.println("-------  ------   ------- --------- --------- --------- ---------  ---------");
        String string = "%-10s%5.0f%10.2f%10.2f%10.0f%10.0f%10.0f%10.0f";
        object3 = String.format(string, TuningResources.getString("TemplateBasedPrinter.23"), Float.valueOf(sqlCursor.getParseCount()), SqlTraceUtils.toSec(sqlCursor.getParseCPU()), SqlTraceUtils.toSec(sqlCursor.getParseElapsed(false)), Float.valueOf(sqlCursor.getParseDisk()), Float.valueOf(sqlCursor.getParseQuery()), Float.valueOf(sqlCursor.getParseCurrent()), Float.valueOf(sqlCursor.getParseRows()));
        printStream.println((String)object3);
        object3 = String.format(string, TuningResources.getString("TemplateBasedPrinter.24"), sqlCursor.getExecuteCount(), SqlTraceUtils.toSec(sqlCursor.getExecuteCPU()), SqlTraceUtils.toSec(sqlCursor.getExecuteElapsed(false)), Float.valueOf(sqlCursor.getExecuteDisk()), Float.valueOf(sqlCursor.getExecuteQuery()), Float.valueOf(sqlCursor.getExecuteCurrent()), Float.valueOf(sqlCursor.getExecuteRows()));
        printStream.println((String)object3);
        object3 = String.format(string, TuningResources.getString("TemplateBasedPrinter.25"), Float.valueOf(sqlCursor.getFetchCount()), SqlTraceUtils.toSec(sqlCursor.getFetchCPU()), SqlTraceUtils.toSec(sqlCursor.getFetchElapsed(false)), Float.valueOf(sqlCursor.getFetchDisk()), Float.valueOf(sqlCursor.getFetchQuery()), Float.valueOf(sqlCursor.getFetchCurrent()), Float.valueOf(sqlCursor.getFetchRows()));
        printStream.println((String)object3);
        printStream.println("--------------------------------------------------------------------------------");
        object3 = String.format(string, TuningResources.getString("TemplateBasedPrinter.27"), sqlCursor.getTotalCount(), SqlTraceUtils.toSec(sqlCursor.getTotalCPU()), SqlTraceUtils.toSec(sqlCursor.getTotalElapsed(false)), Float.valueOf(sqlCursor.getTotalDisk()), Float.valueOf(sqlCursor.getTotalQuery()), Float.valueOf(sqlCursor.getTotalCurrent()), Float.valueOf(sqlCursor.getTotalRows()));
        printStream.println((String)object3);
        printStream.println();
        printStream.println(TuningResources.getString("TemplateBasedPrinter.28") + sqlCursor.getParseMissCount());
        printStream.println(TuningResources.getString("TemplateBasedPrinter.29") + sqlCursor.getExecuteMissCount());
        printStream.println(TuningResources.getString("TemplateBasedPrinter.30") + sqlCursor.getOptimizerGoal());
        printStream.println(TuningResources.getString("TemplateBasedPrinter.31") + sqlCursor.getUid());
        printStream.println(TuningResources.getString("TemplateBasedPrinter.32"));
        printStream.println("-------  ---------------------------------------------------");
        String string2 = TuningResources.getString("TemplateBasedPrinter.34");
        this.printCursorStats(printStream, string2, sqlCursor.getStats(), 0);
        EventWait eventWait = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap<CallSite, Double> hashMap = new HashMap<CallSite, Double>();
        String string3 = null;
        for (IElapsedEvent iElapsedEvent : sqlCursor.getEvents()) {
            if (!(iElapsedEvent instanceof EventWait)) continue;
            eventWait = (EventWait)iElapsedEvent;
            string3 = eventWait.getName().intern();
            if (!arrayList.contains(string3)) {
                arrayList.add(string3);
                hashMap.put((CallSite)((Object)(string3 + ".times")), new Double(1.0));
                hashMap.put((CallSite)((Object)(string3 + ".total")), eventWait.getElapsed());
                hashMap.put((CallSite)((Object)(string3 + ".max")), eventWait.getElapsed());
                continue;
            }
            hashMap.put((CallSite)((Object)(string3 + ".times")), (Double)hashMap.get(string3 + ".times") + 1.0);
            hashMap.put((CallSite)((Object)(string3 + ".total")), (Double)hashMap.get(string3 + ".total") + eventWait.getElapsed());
            if (!((Double)hashMap.get(string3 + ".max") < eventWait.getElapsed())) continue;
            hashMap.put((CallSite)((Object)(string3 + ".max")), eventWait.getElapsed());
        }
        printStream.println(TuningResources.getString("TemplateBasedPrinter.44"));
        printStream.println(TuningResources.getString("TemplateBasedPrinter.45"));
        printStream.println("----------------------------------------   Waited  ----------  ------------");
        for (String string4 : arrayList) {
            printStream.println(String.format("%-38s%11d%12.2f%12.2f", string4, hashMap.get(string4 + ".times"), SqlTraceUtils.toSec((Double)hashMap.get(string4 + ".max")), SqlTraceUtils.toSec((Double)hashMap.get(string4 + ".total"))));
        }
        printStream.println("********************************************************************************");
    }

    @Override
    public void printCursorStats(PrintStream printStream, String string, ArrayList<Stat> arrayList, int n) {
        for (Stat stat : arrayList) {
            printStream.println(String.format(string, stat.getRows(), stat.getOperation()));
            this.printCursorStats(printStream, string, stat.getStats(), n + 1);
        }
    }

    @Override
    public void printCursorsWaitSummary(PrintStream printStream, ArrayList<SqlCursor> arrayList) {
        EventWait eventWait = null;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        HashMap<CallSite, Double> hashMap = new HashMap<CallSite, Double>();
        String string = null;
        for (SqlCursor object : arrayList) {
            for (IElapsedEvent iElapsedEvent : object.getEvents()) {
                if (!(iElapsedEvent instanceof EventWait)) continue;
                eventWait = (EventWait)iElapsedEvent;
                string = eventWait.getName().intern();
                if (!arrayList2.contains(string)) {
                    arrayList2.add(string);
                    hashMap.put((CallSite)((Object)(string + ".times")), new Double(1.0));
                    hashMap.put((CallSite)((Object)(string + ".total")), eventWait.getElapsed());
                    hashMap.put((CallSite)((Object)(string + ".max")), eventWait.getElapsed());
                    continue;
                }
                hashMap.put((CallSite)((Object)(string + ".times")), (Double)hashMap.get(string + ".times") + 1.0);
                hashMap.put((CallSite)((Object)(string + ".total")), (Double)hashMap.get(string + ".total") + eventWait.getElapsed());
                if (!((Double)hashMap.get(string + ".max") < eventWait.getElapsed())) continue;
                hashMap.put((CallSite)((Object)(string + ".max")), eventWait.getElapsed());
            }
        }
        for (String string2 : arrayList2) {
            printStream.println(String.format("%-30s\t%d\t   %.2f\t   %.2f", string2, hashMap.get(string2 + ".times"), SqlTraceUtils.toSec((Double)hashMap.get(string2 + ".max")), SqlTraceUtils.toSec((Double)hashMap.get(string2 + ".total"))));
        }
    }

    @Override
    public void printSummary(PrintStream printStream, ArrayList<SqlCursor> arrayList) {
        printStream.println("********************************************************************************");
        String string = null;
        printStream.println("call      count      cpu    elapsed      disk     query   current       rows");
        printStream.println("-------  ------   ------- --------- --------- --------- ---------  ---------");
        String string2 = "%-10s%5.0f%10.2f%10.2f%10.0f%10.0f%10.0f%10.0f";
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        for (SqlCursor object22 : arrayList) {
            f += object22.getParseCount();
            f2 += object22.getParseCPU();
            f3 += object22.getParseElapsed(false);
            f4 += object22.getParseDisk();
            f5 += object22.getParseQuery();
            f6 += object22.getParseCurrent();
            f7 += object22.getParseRows();
        }
        string = String.format(string2, TuningResources.getString("TemplateBasedPrinter.69"), Float.valueOf(f), SqlTraceUtils.toSec(f2), SqlTraceUtils.toSec(f3), Float.valueOf(f4), Float.valueOf(f5), Float.valueOf(f6), Float.valueOf(f7));
        printStream.println(string);
        f7 = 0.0f;
        f6 = 0.0f;
        f5 = 0.0f;
        f4 = 0.0f;
        f3 = 0.0f;
        f2 = 0.0f;
        f = 0.0f;
        for (SqlCursor sqlCursor : arrayList) {
            f = (float)((double)f + sqlCursor.getExecuteCount());
            f2 += sqlCursor.getExecuteCPU();
            f3 += sqlCursor.getExecuteElapsed(false);
            f4 += sqlCursor.getExecuteDisk();
            f5 += sqlCursor.getExecuteQuery();
            f6 += sqlCursor.getExecuteCurrent();
            f7 += sqlCursor.getExecuteRows();
        }
        string = String.format(string2, TuningResources.getString("TemplateBasedPrinter.70"), Float.valueOf(f), SqlTraceUtils.toSec(f2), SqlTraceUtils.toSec(f3), Float.valueOf(f4), Float.valueOf(f5), Float.valueOf(f6), Float.valueOf(f7));
        printStream.println(string);
        f7 = 0.0f;
        f6 = 0.0f;
        f5 = 0.0f;
        f4 = 0.0f;
        f3 = 0.0f;
        f2 = 0.0f;
        f = 0.0f;
        for (SqlCursor sqlCursor : arrayList) {
            f += sqlCursor.getFetchCount();
            f2 += sqlCursor.getFetchCPU();
            f3 += sqlCursor.getFetchElapsed(false);
            f4 += sqlCursor.getFetchDisk();
            f5 += sqlCursor.getFetchQuery();
            f6 += sqlCursor.getFetchCurrent();
            f7 += sqlCursor.getFetchRows();
        }
        string = String.format(string2, TuningResources.getString("TemplateBasedPrinter.71"), Float.valueOf(f), SqlTraceUtils.toSec(f2), SqlTraceUtils.toSec(f3), Float.valueOf(f4), Float.valueOf(f5), Float.valueOf(f6), Float.valueOf(f7));
        printStream.println(string);
        printStream.println("--------------------------------------------------------------------------------");
        f7 = 0.0f;
        f6 = 0.0f;
        f5 = 0.0f;
        f4 = 0.0f;
        f3 = 0.0f;
        f2 = 0.0f;
        f = 0.0f;
        for (SqlCursor sqlCursor : arrayList) {
            f = (float)((double)f + sqlCursor.getTotalCount());
            f2 += sqlCursor.getTotalCPU();
            f3 += sqlCursor.getTotalElapsed(false);
            f4 += sqlCursor.getTotalDisk();
            f5 += sqlCursor.getTotalQuery();
            f6 += sqlCursor.getTotalCurrent();
            f7 += sqlCursor.getTotalRows();
        }
        string = String.format(string2, TuningResources.getString("TemplateBasedPrinter.73"), Float.valueOf(f), SqlTraceUtils.toSec(f2), SqlTraceUtils.toSec(f3), Float.valueOf(f4), Float.valueOf(f5), Float.valueOf(f6), Float.valueOf(f7));
        printStream.println(string);
        int n = 0;
        for (SqlCursor sqlCursor : arrayList) {
            n = (int)((double)n + sqlCursor.getParseMissCount());
        }
        printStream.println(TuningResources.getString("TemplateBasedPrinter.74") + n);
        n = 0;
        for (SqlCursor sqlCursor : arrayList) {
            n = (int)((double)n + sqlCursor.getExecuteMissCount());
        }
        printStream.println(TuningResources.getString("TemplateBasedPrinter.75") + n);
        Object var13_23 = null;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        HashMap<CallSite, Double> hashMap = new HashMap<CallSite, Double>();
        String string3 = null;
        for (SqlCursor sqlCursor : arrayList) {
            for (IElapsedEvent iElapsedEvent : sqlCursor.getEvents()) {
                if (!(iElapsedEvent instanceof EventWait)) continue;
                EventWait eventWait = (EventWait)iElapsedEvent;
                string3 = eventWait.getName().intern();
                if (!arrayList2.contains(string3)) {
                    arrayList2.add(string3);
                    hashMap.put((CallSite)((Object)(string3 + ".times")), new Double(1.0));
                    hashMap.put((CallSite)((Object)(string3 + ".total")), eventWait.getElapsed());
                    hashMap.put((CallSite)((Object)(string3 + ".max")), eventWait.getElapsed());
                    continue;
                }
                hashMap.put((CallSite)((Object)(string3 + ".times")), (Double)hashMap.get(string3 + ".times") + 1.0);
                hashMap.put((CallSite)((Object)(string3 + ".total")), (Double)hashMap.get(string3 + ".total") + eventWait.getElapsed());
                if (!((Double)hashMap.get(string3 + ".max") < eventWait.getElapsed())) continue;
                hashMap.put((CallSite)((Object)(string3 + ".max")), eventWait.getElapsed());
            }
        }
        printStream.println(TuningResources.getString("TemplateBasedPrinter.85"));
        printStream.println(TuningResources.getString("TemplateBasedPrinter.86"));
        printStream.println("----------------------------------------   Waited  ----------  ------------");
        for (String string4 : arrayList2) {
            printStream.println(String.format("%-38s%11d%12.2f%12.2f", string4, hashMap.get(string4 + ".times"), SqlTraceUtils.toSec((Double)hashMap.get(string4 + ".max")), SqlTraceUtils.toSec((Double)hashMap.get(string4 + ".total"))));
        }
        printStream.println("********************************************************************************");
    }
}

