/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Icon;
import oracle.ide.net.JarIndex;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.resource.IdeIcons;

public class JarURLFileSystemHelper
extends URLFileSystemHelper {
    @Override
    public boolean isBaseURLFor(URL url1, URL url2) {
        URL jarFile2;
        if (!this.isDirectoryPath(url1)) {
            return false;
        }
        URL jarFile1 = URLFileSystem.canonicalize(JarUtil.getJarFileURL(url1));
        if (!URLFileSystem.equals(jarFile1, jarFile2 = URLFileSystem.canonicalize(JarUtil.getJarFileURL(url2)))) {
            return false;
        }
        String entry1 = JarUtil.getJarEntry(url1);
        String entry2 = JarUtil.getJarEntry(url2);
        String resolved1 = URLFactory.resolveRelative(new ArrayList(), entry1, new StringBuffer());
        String resolved2 = URLFactory.resolveRelative(new ArrayList(), entry2, new StringBuffer());
        return resolved2.startsWith(resolved1);
    }

    @Override
    public URL canonicalize(URL url) {
        String oldPath;
        int bangPos;
        if (JarUtil.isJarURL(url) && (bangPos = (oldPath = url.getPath()).indexOf("!/")) >= 0) {
            String urlPath = oldPath.substring(0, bangPos);
            String entryName = oldPath.substring(bangPos + 2);
            URL fileURL = JarUtil.newJarFileURLImpl(urlPath);
            if (fileURL != null) {
                String newFilePath;
                JarIndex index;
                URL newFileURL = URLFileSystem.canonicalize(fileURL);
                String canonicalEntryName = entryName.length() > 0 ? ((index = JarURLFileSystemHelper.tryGetJarIndex(url)) != null ? index.canonicalize(entryName) : entryName) : entryName;
                String oldFilePath = fileURL.getPath();
                if (!oldFilePath.equals(newFilePath = newFileURL.getPath()) || !canonicalEntryName.equals(entryName)) {
                    String basePath = oldFilePath.equals(newFilePath) ? urlPath : urlPath.substring(0, urlPath.indexOf(oldFilePath)) + newFilePath;
                    String newPath = basePath + "!/" + canonicalEntryName;
                    return URLFactory.replacePathPart(url, newPath);
                }
            }
        }
        return url;
    }

    @Override
    public boolean canRead(URL url) {
        return this.exists(url);
    }

    @Override
    public boolean canWrite(URL url) {
        return false;
    }

    @Override
    public boolean canCreate(URL url) {
        return this.exists(url);
    }

    @Override
    public boolean exists(URL url) {
        JarIndex index;
        String entryName = JarUtil.getJarEntry(url);
        if (entryName != null && (index = JarURLFileSystemHelper.tryGetJarIndex(url)) != null) {
            return entryName.length() > 0 ? index.exists(entryName) : URLFileSystem.exists(JarUtil.getJarFileURL(url));
        }
        return false;
    }

    @Override
    public Icon getDefaultIcon(URL url) {
        String jarEntry = JarUtil.getJarEntry(url);
        if (jarEntry != null && jarEntry.length() == 0) {
            return IdeIcons.getIcon(26);
        }
        return super.getDefaultIcon(url);
    }

    @Override
    public String getFileName(URL url) {
        String path = url.getPath();
        int lastBangSlash = path.lastIndexOf("!/");
        if (lastBangSlash == path.length() - 2) {
            int lastSlash = path.lastIndexOf(47, lastBangSlash);
            return path.substring(lastSlash + 1, lastBangSlash);
        }
        return super.getFileName(url);
    }

    @Override
    public long getLength(URL url) {
        JarIndex index = JarURLFileSystemHelper.tryGetJarIndex(url);
        if (index != null) {
            String entryName = JarUtil.getJarEntry(url);
            return index.getSize(entryName);
        }
        return -1L;
    }

    @Override
    public URL getParent(URL url) {
        String path = url.getPath();
        int startIndex = path.indexOf("!/");
        if (startIndex >= 0) {
            int searchStart = startIndex + 2;
            if (path.length() > searchStart) {
                int lastSlash;
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                String newPath = path.substring(0, (lastSlash = path.lastIndexOf("/")) >= searchStart ? lastSlash + 1 : searchStart);
                return URLFactory.replacePathPart(url, newPath);
            }
            path = path.substring(0, path.length() - 2);
            return JarUtil.newJarFileURLImpl(path);
        }
        return null;
    }

    @Override
    public String getPlatformPathName(URL url) {
        URL jarFileURL = JarUtil.getJarFileURL(url);
        String jarName = url != jarFileURL ? URLFileSystem.getPlatformPathName(jarFileURL) : url.toString();
        String entry = JarUtil.getJarEntry(url);
        if (entry == null || entry.length() == 0) {
            return jarName;
        }
        StringBuffer buf = new StringBuffer(jarName);
        buf.append('!').append(File.separatorChar);
        buf.append(entry.replace('/', File.separatorChar));
        return buf.toString();
    }

    @Override
    public boolean isDirectory(URL url) {
        String dirName = JarUtil.getJarEntry(url);
        if (dirName.length() == 0) {
            URL jarFileURL = JarUtil.getJarFileURL(url);
            return URLFileSystem.exists(jarFileURL);
        }
        JarIndex index = JarURLFileSystemHelper.tryGetJarIndex(url);
        return index != null && index.isDirectory(dirName);
    }

    @Override
    public boolean isLocal(URL url) {
        URL jarFileURL = JarUtil.getJarFileURL(url);
        return URLFileSystem.isLocal(jarFileURL);
    }

    @Override
    public long lastModified(URL url) {
        URL jarFileURL = JarUtil.getJarFileURL(url);
        return URLFileSystem.lastModified(jarFileURL);
    }

    @Override
    public URL[] list(URL url) {
        String dirName;
        String[] list;
        JarIndex index = JarURLFileSystemHelper.tryGetJarIndex(url);
        if (index != null && (list = index.list(dirName = JarUtil.getJarEntry(url))) != null) {
            ArrayList<URL> urlList = new ArrayList<URL>();
            for (int i = list.length - 1; i >= 0; --i) {
                URL entryURL = URLFactory.newJarURL(url, list[i]);
                urlList.add(entryURL);
            }
            return urlList.toArray(new URL[urlList.size()]);
        }
        return null;
    }

    @Override
    public InputStream openInputStream(URL url) throws IOException {
        JarIndex index = JarUtil.getJarIndex(url);
        if (index != null) {
            String entryName = JarUtil.getJarEntry(url);
            return index.openInputStream(entryName);
        }
        throw new FileNotFoundException(url != null ? url.toString() : "<null>");
    }

    @Override
    public void rename(URL oldURL, URL newURL) throws IOException {
        String oldJarEntry = JarUtil.getJarEntry(oldURL);
        if (oldJarEntry != null && oldJarEntry.length() != 0) {
            throw new IOException("Rename not supported inside JAR/ZIP files for oldURL: " + oldURL.toString());
        }
        String newJarEntry = JarUtil.getJarEntry(newURL);
        if (newJarEntry != null && newJarEntry.length() != 0) {
            throw new IOException("Rename not supported inside JAR/ZIP files for newURL: " + oldURL.toString());
        }
        URL oldJarFileURL = JarUtil.getJarFileURL(oldURL);
        URL newJarFileURL = JarUtil.getJarFileURL(newURL);
        URLFileSystem.renameEx(oldJarFileURL, newJarFileURL);
    }

    @Override
    public String toRelativeSpec(URL url, URL base) {
        String entry = JarUtil.getJarEntry(url);
        String baseEntry = JarUtil.getJarEntry(base);
        URL jarFileURL = JarUtil.getJarFileURL(url);
        URL baseJarFileURL = JarUtil.getJarFileURL(base);
        if (entry != null && entry.length() != 0 && baseEntry != null && entry.startsWith(baseEntry) && URLFileSystem.equals(jarFileURL, baseJarFileURL)) {
            return super.toRelativeSpec(url, base);
        }
        return url.toString();
    }

    private static JarIndex tryGetJarIndex(URL url) {
        try {
            return JarUtil.getJarIndex(url);
        }
        catch (IOException e) {
            return null;
        }
    }
}

