/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.ide.net.JarUtil;
import oracle.ide.net.NameGenerator;
import oracle.ide.net.ProtocolConstants;
import oracle.ide.net.URLFileSystem;
import oracle.ide.performance.PerformanceLogger;
import oracle.javatools.mt.annotation.CodeSharingSafe;
import oracle.javatools.net.EncoderUtils;
import oracle.javatools.util.Maps;

public final class URLFactory {
    @CodeSharingSafe(value="StaticField")
    private static final Method urlSet = URLFactory.initUrlSet();
    private static final Map<URLPoolKey, URL> pool = new Maps.WeakHashMap<URLPoolKey, URL>();

    public static URL copyURL(URL url) {
        return URLFactory.newURLInternal(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
    }

    public static URL newURL(URL baseURL, String relativeSpec) {
        if (JarUtil.isJarURL(baseURL)) {
            URL jarFileURL = JarUtil.getJarFileURL(baseURL);
            String entry = JarUtil.getJarEntry(baseURL);
            String basePath = URLFileSystem.getPath(jarFileURL) + "!/" + entry;
            String newPath = URLFactory.resolveRelative(basePath, relativeSpec);
            int separator = newPath.indexOf("!/");
            if (separator < 0) {
                return URLFactory.replacePathPart(jarFileURL, newPath);
            }
            String newEntry = newPath.substring(separator + "!/".length());
            return URLFactory.newJarURL(jarFileURL, newEntry);
        }
        String newPath = URLFactory.resolveRelative(baseURL.getPath(), relativeSpec);
        return URLFactory.replacePathPart(baseURL, newPath);
    }

    public static URL newDirURL(URL baseURL, String relativeSpec) {
        if (relativeSpec != null) {
            return relativeSpec.endsWith("/") ? URLFactory.newURL(baseURL, relativeSpec) : URLFactory.newURL(baseURL, relativeSpec + "/");
        }
        return null;
    }

    public static URL newURL(String protocol, String path) {
        int index;
        String query = null;
        int n = index = path != null ? path.indexOf("?") : -1;
        if (index != -1) {
            query = path.substring(index + 1);
            path = path.substring(0, index);
        }
        return URLFactory.newURL(protocol, null, null, -1, path, query, null);
    }

    public static URL newDirURL(String protocol, String dirPath) {
        return dirPath.endsWith("/") ? URLFactory.newURL(protocol, dirPath) : URLFactory.newURL(protocol, dirPath + "/");
    }

    public static URL newUniqueURL(URL baseURL, NameGenerator nameGen) {
        URL url;
        do {
            String name;
            if ((url = URLFactory.newURL(baseURL, name = nameGen.nextName())) != null) continue;
            return null;
        } while (URLFileSystem.isBound(url));
        return url;
    }

    public static URL replaceProtocolPart(URL url, String newProtocol) {
        String userinfo = url.getUserInfo();
        String host = url.getHost();
        int port = url.getPort();
        String path = url.getPath();
        String query = url.getQuery();
        String ref = url.getRef();
        return URLFactory.newURL(newProtocol, userinfo, host, port, path, query, ref);
    }

    public static URL replacePortPart(URL url, int newPort) {
        String protocol = url.getProtocol();
        String userinfo = url.getUserInfo();
        String host = url.getHost();
        String path = url.getPath();
        String query = url.getQuery();
        String ref = url.getRef();
        return URLFactory.newURLInternal(protocol, userinfo, host, newPort, path, query, ref);
    }

    public static URL replaceHostPart(URL url, String newHost) {
        String protocol = url.getProtocol();
        String userinfo = url.getUserInfo();
        int port = url.getPort();
        String path = url.getPath();
        String query = url.getQuery();
        String ref = url.getRef();
        return URLFactory.newURLInternal(protocol, userinfo, newHost, port, path, query, ref);
    }

    public static URL replacePathPart(URL url, String newPath) {
        String protocol = url.getProtocol();
        String userinfo = url.getUserInfo();
        String host = url.getHost();
        int port = url.getPort();
        String query = url.getQuery();
        String ref = url.getRef();
        if ("file".equals(protocol) && host != null && !host.isEmpty() && newPath.startsWith("//")) {
            host = null;
        }
        return URLFactory.newURLInternal(protocol, userinfo, host, port, newPath, query, ref);
    }

    public static URL replaceRefPart(URL url, String newRef) {
        String protocol = url.getProtocol();
        String userinfo = url.getUserInfo();
        String host = url.getHost();
        int port = url.getPort();
        String path = url.getPath();
        String query = url.getQuery();
        return URLFactory.newURLInternal(protocol, userinfo, host, port, path, query, newRef);
    }

    public static URL replaceQueryPart(URL url, String newQuery) {
        String protocol = url.getProtocol();
        String userinfo = url.getUserInfo();
        String host = url.getHost();
        int port = url.getPort();
        String path = url.getPath();
        String ref = url.getRef();
        return URLFactory.newURLInternal(protocol, userinfo, host, port, path, newQuery, ref);
    }

    public static URL encodeURL(URL url) {
        return URLFactory.encodeURL(url, null);
    }

    public static URL encodeURL(URL url, String encoding) {
        URL encodedURL = URLFactory.newURLInternal(url.getProtocol(), URLFactory.encodeStr(url.getUserInfo(), encoding), url.getHost(), url.getPort(), URLFactory.encodeStr(url.getPath(), encoding), URLFactory.encodeQuery(url.getQuery(), encoding), URLFactory.encodeStr(url.getRef(), encoding));
        return encodedURL;
    }

    private static String encodeStr(String s, String encoding) {
        if (s == null || s.length() == 0) {
            return s;
        }
        try {
            return EncoderUtils.encodeString(s, encoding);
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }

    private static String encodeQuery(String query, String encoding) {
        if (query == null || query.length() == 0) {
            return query;
        }
        StringWriter sw = new StringWriter(query.length());
        try {
            EncoderUtils.writeQueryParameters(sw, query, encoding, 0);
        }
        catch (UnsupportedEncodingException uee) {
            return query;
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
        return sw.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL intern(URL url) {
        URLFileSystem.hashCode(url);
        URLPoolKey key = new URLPoolKey(url);
        Map<URLPoolKey, URL> map = pool;
        synchronized (map) {
            URL pooled = pool.get(key);
            if (pooled == null) {
                pool.put(key, url);
                pooled = url;
            }
            return pooled;
        }
    }

    public static URL newURL(String urlSpec) {
        return URLFactory.newURL(urlSpec, false, false);
    }

    public static URL newURL(String urlSpec, boolean forceDir, boolean assumeFile) {
        char firstChar;
        int urlSpecLen;
        if (urlSpec == null) {
            return null;
        }
        if (forceDir && !urlSpec.endsWith("/")) {
            urlSpec = urlSpec + "/";
        }
        if ((urlSpecLen = urlSpec.length()) > 0 && ((firstChar = urlSpec.charAt(0)) == File.separatorChar || firstChar == '/' || urlSpecLen > 1 && urlSpec.charAt(1) == ':' || urlSpec.indexOf(58) < 0 && assumeFile)) {
            return URLFactory.newFileURL(urlSpec);
        }
        if (urlSpec.toLowerCase().startsWith("file:")) {
            return URLFactory.newFileURL(urlSpec.substring(5));
        }
        try {
            return new URL(urlSpec);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static URL newFileURL(String filePath) {
        if (filePath == null) {
            return null;
        }
        String path = URLFactory.sanitizePath(filePath);
        return URLFactory.newURL("file", path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL newFileURL(File file) {
        PerformanceLogger pl = PerformanceLogger.get();
        try {
            pl.startTiming("URLFactory.newFileURL(File)");
            if (file == null) {
                URL uRL = null;
                return uRL;
            }
            String filePath = file.getAbsolutePath();
            if (file.isDirectory()) {
                URL uRL = URLFactory.newDirURL(filePath);
                return uRL;
            }
            URL uRL = URLFactory.newFileURL(filePath);
            return uRL;
        }
        finally {
            pl.stopTiming("URLFactory.newFileURL(File)", "Slow file system for " + file, 2000);
        }
    }

    public static URL newDirURL(String dirPath) {
        if (dirPath == null) {
            return null;
        }
        String path = URLFactory.sanitizePath(dirPath);
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        return URLFactory.newURL("file", path);
    }

    public static URL newDirURL(File dir) {
        return dir != null ? URLFactory.newDirURL(dir.getAbsolutePath()) : null;
    }

    public static URL newIdeURL(String protocol, URL url) {
        if (protocol == null || url == null) {
            return null;
        }
        if (!ProtocolConstants.isIdeProtocol(protocol)) {
            return null;
        }
        String newProtocol = protocol + "." + url.getProtocol();
        return URLFactory.replaceProtocolPart(url, newProtocol);
    }

    public static URL newJarURL(File archiveFile, String entryName) {
        URL archiveURL = URLFactory.newFileURL(archiveFile);
        return URLFactory.newJarURL(archiveURL, entryName);
    }

    public static URL newJarURL(URL archiveURL, String entryName) {
        if (JarUtil.isJarURL(archiveURL)) {
            String path = archiveURL.getPath();
            int bangSlash = path.indexOf("!/");
            if (bangSlash < 0) {
                throw new IllegalArgumentException("Bad jar url: " + archiveURL);
            }
            StringBuffer newPath = new StringBuffer(path);
            if (!path.endsWith("/")) {
                newPath.append('/');
            }
            if (entryName != null) {
                newPath.append(entryName);
            }
            return URLFactory.replacePathPart(archiveURL, newPath.toString());
        }
        StringBuffer path = new StringBuffer(archiveURL.toString());
        path.append("!/");
        if (entryName != null) {
            path.append(entryName);
        }
        return URLFactory.newURL("jar", path.toString());
    }

    public static URL newURL(String protocol, String userinfo, String host, int port, String path, String query, String ref) {
        if ("file".equals(protocol)) {
            protocol = "file";
        } else if ("jar".equals(protocol)) {
            protocol = "jar";
        }
        return URLFactory.newURLInternal(protocol, userinfo, host, port, path, query, ref);
    }

    private static URL newURLInternal(String protocol, String userinfo, String host, int port, String path, String query, String ref) {
        try {
            URL seed = new URL(protocol, "", -1, "");
            host = host == null ? "" : host;
            path = path == null ? "" : path;
            String authority = "";
            if (!host.isEmpty()) {
                authority = port < 0 ? host : host + ":" + port;
            }
            Object[] args = new Object[]{protocol, host, new Integer(port), authority, userinfo, path, query, ref};
            urlSet.invoke((Object)seed, args);
            return seed;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String sanitizePath(String path) {
        int backslash = path.indexOf(92);
        if (backslash < 0) {
            if (path.length() > 0 && path.charAt(0) != '/') {
                path = '/' + path;
            }
        } else if (backslash == 0) {
            path = path.replace('\\', '/');
        } else {
            StringBuilder builder = new StringBuilder();
            int start = path.charAt(0) != '/' ? 0 : 1;
            builder.append('/');
            do {
                builder.append(path, start, backslash);
                builder.append('/');
            } while ((backslash = path.indexOf(92, start = backslash + 1)) > 0);
            builder.append(path, start, path.length());
            path = builder.toString();
        }
        return path;
    }

    static String resolveRelative(ArrayList pathElems, String relPath, StringBuffer newPath) {
        int length;
        boolean lastElemIsRelativeDir = false;
        int pos = 0;
        while (true) {
            String substr;
            int newPos;
            boolean done = (newPos = relPath.indexOf(47, pos)) == -1;
            String string = substr = done ? relPath.substring(pos) : relPath.substring(pos, newPos);
            if (substr.length() > 0) {
                if (substr.equals("..")) {
                    int n = pathElems.size();
                    if (n > 0) {
                        pathElems.remove(n - 1);
                    }
                    lastElemIsRelativeDir = true;
                } else if (substr.equals(".")) {
                    lastElemIsRelativeDir = true;
                } else {
                    pathElems.add(substr);
                    lastElemIsRelativeDir = false;
                }
            }
            if (done) break;
            pos = newPos + 1;
        }
        Iterator iter = pathElems.iterator();
        while (iter.hasNext()) {
            newPath.append(iter.next().toString()).append('/');
        }
        if (!lastElemIsRelativeDir && !relPath.endsWith("/") && relPath.length() != 0 && (length = newPath.length()) > 0) {
            newPath.setLength(length - 1);
        }
        return newPath.toString();
    }

    private static String resolveRelative(String basePath, String relPath) {
        ArrayList<String> pathElems = new ArrayList<String>();
        int pos = 0;
        while (true) {
            String substr;
            int newPos;
            boolean done = (newPos = basePath.indexOf(47, pos)) == -1;
            String string = substr = done ? basePath.substring(pos) : basePath.substring(pos, newPos);
            if (substr.length() > 0 || newPos == pos + 1) {
                pathElems.add(substr);
            }
            if (done) break;
            pos = newPos + 1;
        }
        StringBuffer newPath = new StringBuffer();
        if (basePath.startsWith("//")) {
            newPath.append("//");
        } else if (basePath.startsWith("/")) {
            newPath.append('/');
        }
        return URLFactory.resolveRelative(pathElems, relPath, newPath);
    }

    private URLFactory() {
    }

    private static Method initUrlSet() {
        Class<String> str = String.class;
        try {
            Method urlSet = URL.class.getDeclaredMethod("set", str, str, Integer.TYPE, str, str, str, str, str);
            urlSet.setAccessible(true);
            return urlSet;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException();
        }
    }

    private static final class URLPoolKey
    extends WeakReference<URL> {
        URLPoolKey(URL url) {
            super(url);
        }

        public int hashCode() {
            URL url = (URL)this.get();
            return url == null ? 0 : URLFileSystem.hashCode(url);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof URLPoolKey)) {
                return false;
            }
            URLPoolKey other = (URLPoolKey)obj;
            return URLFileSystem.equals((URL)this.get(), (URL)other.get());
        }
    }
}

