/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.algorithm.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareFailedException;
import oracle.javatools.compare.CompareMergeAlgorithm;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareAlgorithm;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareContributor;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareDifference;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareModel;
import oracle.javatools.compare.algorithm.text.EditableTextCompareContributor;
import oracle.javatools.compare.algorithm.text.TextCompareContributor;

public class TextCompareAlgorithm
extends SequenceCompareAlgorithm
implements CompareMergeAlgorithm {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompareModel merge(CompareContributor first, CompareContributor second, CompareContributor ancestor) throws CompareFailedException {
        TextCompareContributor edit1 = (TextCompareContributor)first;
        TextCompareContributor edit2 = (TextCompareContributor)second;
        TextCompareContributor base = (TextCompareContributor)ancestor;
        SequenceCompareDifference[] edit1Diffs = this.getDifferences(base, edit1);
        if (edit1Diffs == null) {
            throw new CompareFailedException("Too complex");
        }
        SequenceCompareDifference[] edit2Diffs = this.getDifferences(base, edit2);
        if (edit2Diffs == null) {
            throw new CompareFailedException("Too complex");
        }
        ArrayList<SequenceCompareDifference> diffs1 = new ArrayList<SequenceCompareDifference>(Arrays.asList(edit1Diffs));
        ArrayList<SequenceCompareDifference> diffs2 = new ArrayList<SequenceCompareDifference>(Arrays.asList(edit2Diffs));
        Collection<SequenceCompareDifference> mergeableDiffs1 = this.getMergeableDifferences(diffs1, edit1, diffs2, edit2);
        Collection<SequenceCompareDifference> mergeableDiffs2 = this.getMergeableDifferences(diffs2, edit2, diffs1, edit1);
        BitSet lineConflicts = new BitSet();
        BitSet zeroConflicts = new BitSet();
        for (int i = 0; i <= base.getLength(); ++i) {
            SequenceCompareDifference diff1 = this.getDifferenceStartingAtIndex(i, diffs1);
            SequenceCompareDifference diff2 = this.getDifferenceStartingAtIndex(i, diffs2);
            if (diff1 == null && diff2 == null || diff1 != null && mergeableDiffs1.contains(diff1) || diff2 != null && mergeableDiffs2.contains(diff2)) continue;
            int n = 0;
            if (diff1 != null) {
                n = Math.max(n, diff1.getFirstLength());
            }
            if (diff2 != null) {
                n = Math.max(n, diff2.getFirstLength());
            }
            if (n == 0) {
                zeroConflicts.set(i);
                continue;
            }
            lineConflicts.set(i, i + n);
        }
        ArrayList<SequenceCompareDifference> conflictDiffs = new ArrayList<SequenceCompareDifference>();
        int i = 0;
        while (i <= base.getLength()) {
            int end2;
            int end1;
            SequenceCompareDifference conflictDiff = null;
            if (!lineConflicts.get(i) && !zeroConflicts.get(i)) {
                ++i;
                continue;
            }
            conflictDiff = new SequenceCompareDifference(2);
            conflictDiff.setConflict(true);
            conflictDiffs.add(conflictDiff);
            int start1 = i > 0 ? this.getContributorIndexFromBaseIndex(i - 1, edit1Diffs) + 1 : 0;
            int start2 = i > 0 ? this.getContributorIndexFromBaseIndex(i - 1, edit2Diffs) + 1 : 0;
            conflictDiff.setAncestorStart(i);
            if (lineConflicts.get(i)) {
                int j = lineConflicts.nextClearBit(i);
                end1 = this.getContributorIndexFromBaseIndex(j, edit1Diffs);
                end2 = this.getContributorIndexFromBaseIndex(j, edit2Diffs);
                conflictDiff.setAncestorLength(j - i);
                i = j;
            } else {
                end1 = this.getContributorIndexFromBaseIndex(i, edit1Diffs);
                end2 = this.getContributorIndexFromBaseIndex(i, edit2Diffs);
                conflictDiff.setAncestorLength(0);
                ++i;
            }
            conflictDiff.setFirstStart(start1);
            conflictDiff.setFirstLength(end1 - start1);
            conflictDiff.setSecondStart(start2);
            conflictDiff.setSecondLength(end2 - start2);
        }
        TextBuffer textBuffer = TextBufferFactory.createTextBuffer();
        TextBuffer textBuffer2 = base.getTextBuffer();
        textBuffer.writeLock();
        try {
            textBuffer.append(textBuffer2.getString(0, textBuffer2.getLength()).toCharArray());
            textBuffer.setEOLType(textBuffer2.getEOLType());
            ArrayList<TextMutation> mutations = new ArrayList<TextMutation>();
            this.createMutations(textBuffer, mergeableDiffs1, edit1.getTextBuffer(), mutations);
            this.createMutations(textBuffer, mergeableDiffs2, edit2.getTextBuffer(), mutations);
            ArrayList<OffsetMark> conflictOffsets = new ArrayList<OffsetMark>();
            LineMap lineMap = textBuffer.getLineMap();
            for (SequenceCompareDifference diff : conflictDiffs) {
                conflictOffsets.add(textBuffer.addOffsetMark(lineMap.getLineStartOffset(diff.getAncestorStart())));
            }
            Collections.reverse(mutations);
            for (TextMutation mutation : mutations) {
                mutation.execute(textBuffer);
            }
            for (OffsetMark conflictOffsetMark : conflictOffsets) {
                SequenceCompareDifference diff = (SequenceCompareDifference)conflictDiffs.get(conflictOffsets.indexOf(conflictOffsetMark));
                diff.setAncestorStart(lineMap.getLineFromOffset(conflictOffsetMark.getOffset()));
            }
        }
        finally {
            textBuffer.writeUnlock();
        }
        return new SequenceCompareModel(edit1, edit2, new EditableTextCompareContributor(textBuffer), conflictDiffs.toArray(new SequenceCompareDifference[0]));
    }

    private Collection<SequenceCompareDifference> getMergeableDifferences(Collection<SequenceCompareDifference> diffs1, SequenceCompareContributor edit1, Collection<SequenceCompareDifference> diffs2, SequenceCompareContributor edit2) {
        HashSet<SequenceCompareDifference> mergeableDiffs = new HashSet<SequenceCompareDifference>();
        for (SequenceCompareDifference diff : diffs1) {
            SequenceCompareDifference overlappingDiff;
            Collection<SequenceCompareDifference> overlappingDiffs = this.getOverlappingDifferences(diff, diffs2);
            if (overlappingDiffs == null) {
                mergeableDiffs.add(diff);
                continue;
            }
            if (overlappingDiffs == null || overlappingDiffs.size() != 1 || !this.isEqual(diff, edit1, overlappingDiff = overlappingDiffs.iterator().next(), edit2)) continue;
            mergeableDiffs.add(diff);
            diffs2.remove(overlappingDiff);
        }
        return mergeableDiffs;
    }

    private boolean isEqual(SequenceCompareDifference diff1, SequenceCompareContributor edit1, SequenceCompareDifference diff2, SequenceCompareContributor edit2) {
        if (diff1.getFirstStart() != diff2.getFirstStart()) {
            return false;
        }
        if (diff1.getFirstLength() != diff2.getFirstLength()) {
            return false;
        }
        if (diff1.getSecondLength() != diff2.getSecondLength()) {
            return false;
        }
        int i = diff1.getSecondStart();
        int j = diff2.getSecondStart();
        while (i < diff1.getSecondStart() + diff1.getSecondLength()) {
            if (!edit1.equal(i, edit2, j)) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    private void createMutations(TextBuffer textBuffer, Collection<SequenceCompareDifference> mergeableDiffs, TextBuffer contributorTextBuffer, Collection<TextMutation> mutations) {
        LineMap lineMapA = textBuffer.getLineMap();
        LineMap lineMapC = contributorTextBuffer.getLineMap();
        for (SequenceCompareDifference diff : mergeableDiffs) {
            OffsetMark startOffset = textBuffer.addOffsetMark(lineMapA.getLineStartOffset(diff.getFirstStart()), true);
            OffsetMark endOffset = textBuffer.addOffsetMark(lineMapA.getLineStartOffset(diff.getFirstStart() + diff.getFirstLength()), false);
            int i = lineMapC.getLineStartOffset(diff.getSecondStart());
            char[] chars = contributorTextBuffer.getString(i, lineMapC.getLineStartOffset(diff.getSecondStart() + diff.getSecondLength()) - i).toCharArray();
            mutations.add(new TextMutation(startOffset, endOffset, chars));
        }
    }

    private Collection<SequenceCompareDifference> getOverlappingDifferences(SequenceCompareDifference diff, Collection<SequenceCompareDifference> adjacentDiffs) {
        ArrayList<SequenceCompareDifference> differences = null;
        for (SequenceCompareDifference adjacentDiff : adjacentDiffs) {
            if (!this.isOverlap(diff, adjacentDiff)) continue;
            if (differences == null) {
                differences = new ArrayList<SequenceCompareDifference>();
            }
            differences.add(adjacentDiff);
        }
        return differences;
    }

    private boolean isOverlap(SequenceCompareDifference diff, SequenceCompareDifference adjacentDiff) {
        if (diff.getFirstLength() == 0) {
            if (adjacentDiff.getFirstLength() == 0) {
                return adjacentDiff.getFirstStart() == diff.getFirstStart();
            }
            if (adjacentDiff.getFirstLength() > 0) {
                return adjacentDiff.getFirstStart() < diff.getFirstStart() && adjacentDiff.getFirstStart() + adjacentDiff.getFirstLength() > diff.getFirstStart();
            }
        }
        if (diff.getFirstLength() > 0) {
            if (adjacentDiff.getFirstLength() > 0) {
                return adjacentDiff.getFirstStart() < diff.getFirstStart() + diff.getFirstLength() && adjacentDiff.getFirstStart() + adjacentDiff.getFirstLength() > diff.getFirstStart();
            }
            if (adjacentDiff.getFirstLength() == 0) {
                return adjacentDiff.getFirstStart() > diff.getFirstStart() && adjacentDiff.getFirstStart() < diff.getFirstStart() + diff.getFirstLength();
            }
        }
        return false;
    }

    private int getContributorIndexFromBaseIndex(int index, SequenceCompareDifference[] diffs) {
        int i = 0;
        int delta = index;
        for (SequenceCompareDifference diff : diffs) {
            if (diff.getFirstStart() > index) continue;
            i += diff.getSecondLength();
            delta -= diff.getFirstLength();
        }
        return i + delta;
    }

    private SequenceCompareDifference getDifferenceStartingAtIndex(int index, Collection<SequenceCompareDifference> diffs) {
        for (SequenceCompareDifference diff : diffs) {
            if (diff.getStart(ContributorKind.FIRST) != index) continue;
            return diff;
        }
        return null;
    }

    private class TextMutation {
        private final OffsetMark _startOffset;
        private final OffsetMark _endOffset;
        private final char[] _chars;

        TextMutation(OffsetMark startOffset, OffsetMark endOffset, char[] chars) {
            this._startOffset = startOffset;
            this._endOffset = endOffset;
            this._chars = chars;
        }

        void execute(TextBuffer textBuffer) {
            int i = this._startOffset.getOffset();
            textBuffer.remove(i, Math.max(0, this._endOffset.getOffset() - i));
            textBuffer.insert(i, this._chars);
        }
    }
}

