/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.filesystem;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.ClosedFileSystemException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardCopyOption;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import oracle.javatools.filesystem.FileSystemProviderImpl;
import oracle.javatools.filesystem.PathImpl;

public class FileSystemImpl<FileObject>
extends FileSystem {
    protected FileSystemProviderImpl provider;
    protected boolean closed;
    private Set<PathImpl> directories = Collections.synchronizedSet(new HashSet());
    private Set<PathImpl> rootDirectories = Collections.synchronizedSet(new HashSet());
    private Map<PathImpl, FileObject> fileObjects = Collections.synchronizedMap(new HashMap());

    public FileSystemImpl(FileSystemProviderImpl provider) {
        if (provider == null) {
            throw new IllegalArgumentException();
        }
        this.provider = provider;
    }

    @Override
    public FileSystemProviderImpl provider() {
        return this.provider;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public final String getSeparator() {
        return "/";
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        return new HashSet<Path>(this.rootDirectories);
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        return null;
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        HashSet<String> views = new HashSet<String>(1);
        views.add("basic");
        return views;
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        throw new UnsupportedOperationException();
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchService newWatchService() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PathImpl getPath(String first, String ... more) {
        if (this.closed) {
            throw new ClosedFileSystemException();
        }
        return new PathImpl(this, first, more);
    }

    public FileObject getFileObject(PathImpl path) {
        return this.fileObjects.get(path);
    }

    public FileObject putFileObject(PathImpl path, FileObject fileObject) throws IOException {
        if (path == null || path.isDirectory()) {
            throw new IllegalArgumentException();
        }
        this.createDirectory(path.getParent(), new FileAttribute[0]);
        return this.fileObjects.put(path, fileObject);
    }

    DirectoryStream<Path> newDirectoryStream(PathImpl dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        if (this.closed) {
            throw new ClosedFileSystemException();
        }
        if (!this.directories.contains(dir)) {
            throw new NotDirectoryException(dir == null ? "null" : dir.toString());
        }
        final HashSet<Path> paths = new HashSet<Path>(this.fileObjects.size());
        for (PathImpl path : this.fileObjects.keySet()) {
            if (!path.startsWith(dir)) continue;
            Path child = dir.relativize(path);
            child = child.subpath(0, 1);
            child = dir.resolve(child);
            if (filter != null && !filter.accept(child)) continue;
            paths.add(child);
        }
        dir.setLastAccessTime(System.currentTimeMillis());
        return new DirectoryStream<Path>(){
            Set<Path> directoryPaths;
            {
                this.directoryPaths = paths;
            }

            @Override
            public Iterator<Path> iterator() {
                if (!FileSystemImpl.this.isOpen()) {
                    throw new ClosedFileSystemException();
                }
                return this.directoryPaths.iterator();
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    void checkAccess(PathImpl path, AccessMode ... modes) throws IOException {
        if (this.closed) {
            throw new ClosedFileSystemException();
        }
        if (modes == null || modes.length == 0) {
            if (!path.isDirectory() ? this.fileObjects.get(path) == null : !this.directories.contains(path)) {
                throw new NoSuchFileException(path.toString());
            }
        } else {
            for (AccessMode mode : modes) {
                boolean throwException = false;
                switch (mode) {
                    case EXECUTE: {
                        throwException = true;
                        break;
                    }
                    case READ: {
                        if (this.fileObjects.get(path) != null) break;
                        throwException = true;
                        break;
                    }
                    case WRITE: {
                        if (!this.isReadOnly() && !this.directories.contains(path)) break;
                        throwException = true;
                        break;
                    }
                    default: {
                        throwException = true;
                    }
                }
                if (!throwException) continue;
                throw new AccessDeniedException(path.toString());
            }
        }
    }

    void createDirectory(PathImpl dir, FileAttribute<?> ... attrs) throws IOException {
        PathImpl path;
        if (this.closed) {
            throw new ClosedFileSystemException();
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException();
        }
        for (path = dir; path != null; path = path.getParent()) {
            if (this.fileObjects.get(path) == null) continue;
            throw new FileAlreadyExistsException(path.toString());
        }
        path = dir;
        while (path != null) {
            this.directories.add(path);
            PathImpl parentPath = path.getParent();
            if (parentPath == null && path.isAbsolute()) {
                this.rootDirectories.add(path);
            }
            path = parentPath;
        }
    }

    void copyFileObject(PathImpl source, PathImpl target) throws IOException {
        this.createDirectory(target.getParent(), new FileAttribute[0]);
        SeekableByteChannel sourceChannel = this.provider.newByteChannel(source, Collections.emptySet(), new FileAttribute[0]);
        SeekableByteChannel targetChannel = this.provider.newByteChannel(target, Collections.emptySet(), new FileAttribute[0]);
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)sourceChannel.size());
        sourceChannel.read(byteBuffer);
        byteBuffer.rewind();
        targetChannel.write(byteBuffer);
        target.setLastModifiedTime(System.currentTimeMillis());
    }

    void copy(PathImpl source, PathImpl target, CopyOption ... options) throws IOException {
        if (this.closed) {
            throw new ClosedFileSystemException();
        }
        if (source.isDirectory() || target.isDirectory()) {
            throw new IllegalArgumentException();
        }
        source.setLastAccessTime(System.currentTimeMillis());
        if (source.equals(target)) {
            target.setLastModifiedTime(System.currentTimeMillis());
            return;
        }
        if (this.fileObjects.containsKey(target)) {
            boolean replace = false;
            if (options != null) {
                for (CopyOption option : options) {
                    if (!option.equals(StandardCopyOption.REPLACE_EXISTING)) continue;
                    replace = true;
                    break;
                }
            }
            if (!replace) {
                throw new FileAlreadyExistsException(target.toString());
            }
        }
        if (!this.fileObjects.containsKey(source)) {
            throw new NoSuchFileException(source.toString());
        }
        this.copyFileObject(source, target);
    }

    void delete(PathImpl path) throws IOException {
        if (this.closed) {
            throw new ClosedFileSystemException();
        }
        if (!path.isDirectory()) {
            if (this.fileObjects.remove(path) == null) {
                throw new NoSuchFileException(path.toString());
            }
        } else {
            for (PathImpl PathImpl2 : this.fileObjects.keySet()) {
                if (!PathImpl2.startsWith(path)) continue;
                throw new DirectoryNotEmptyException(path.toString());
            }
            if (!this.directories.remove(path)) {
                throw new NoSuchFileException(path.toString());
            }
        }
    }

    void move(PathImpl source, PathImpl target, CopyOption ... options) throws IOException {
        if (this.closed) {
            throw new ClosedFileSystemException();
        }
        this.copy(source, target, options);
        if (!source.equals(target)) {
            this.delete(source);
        }
        long time = System.currentTimeMillis();
        target.setLastModifiedTime(time);
    }

    <A extends BasicFileAttributes> A readAttributes(final PathImpl path, Class<A> type, LinkOption ... options) throws IOException {
        if (this.closed) {
            throw new ClosedFileSystemException();
        }
        if (path == null) {
            throw new NullPointerException();
        }
        return (A)new BasicFileAttributes(){

            @Override
            public FileTime lastModifiedTime() {
                return path.getLastModifiedTime();
            }

            @Override
            public FileTime lastAccessTime() {
                return path.getLastAccessTime();
            }

            @Override
            public FileTime creationTime() {
                return path.getCreationTime();
            }

            @Override
            public boolean isRegularFile() {
                return !this.isDirectory();
            }

            @Override
            public boolean isDirectory() {
                return path.isDirectory();
            }

            @Override
            public boolean isSymbolicLink() {
                return false;
            }

            @Override
            public boolean isOther() {
                return false;
            }

            @Override
            public long size() {
                if (path.isDirectory()) {
                    return 0L;
                }
                try {
                    return FileSystemImpl.this.provider.newByteChannel(path, null, new FileAttribute[0]).size();
                }
                catch (IOException e) {
                    return 0L;
                }
            }

            @Override
            public Object fileKey() {
                return path;
            }
        };
    }
}

