/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.management;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.lang.management.PlatformManagedObject;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import oracle.javatools.mt.annotation.CodeSharingSafe;

public class Memory {
    @CodeSharingSafe(value="StaticField")
    private static volatile PlatformManagedObject hotspotMBean;
    @CodeSharingSafe(value="StaticField")
    private static boolean hotspotMBeanLoaded;

    public static String summary() {
        StringBuilder buffer = new StringBuilder();
        String EOL = System.getProperty("line.separator");
        buffer.append("Memory").append(EOL);
        MemoryMXBean memory = ManagementFactory.getMemoryMXBean();
        buffer.append("  Heap:            ");
        Memory.appendUsage(memory.getHeapMemoryUsage(), buffer).append(EOL);
        buffer.append("  Nonheap:         ");
        Memory.appendUsage(memory.getNonHeapMemoryUsage(), buffer).append(EOL);
        buffer.append("                   ");
        buffer.append(memory.getObjectPendingFinalizationCount());
        buffer.append(" objects pending finalization").append(EOL);
        List<MemoryPoolMXBean> pools = ManagementFactory.getMemoryPoolMXBeans();
        buffer.append("Heap Pools").append(EOL);
        for (MemoryPoolMXBean memoryPoolMXBean : pools) {
            if (memoryPoolMXBean.getType() != MemoryType.HEAP) continue;
            Memory.appendPool(memoryPoolMXBean, buffer);
        }
        buffer.append("Nonheap Pools").append(EOL);
        for (MemoryPoolMXBean memoryPoolMXBean : pools) {
            if (memoryPoolMXBean.getType() != MemoryType.NON_HEAP) continue;
            Memory.appendPool(memoryPoolMXBean, buffer);
        }
        buffer.append("Garbage Collectors").append(EOL);
        List<GarbageCollectorMXBean> collectors = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean collector : collectors) {
            buffer.append("  ");
            String name = collector.getName();
            buffer.append(name);
            for (int i = name.length(); i < 16; ++i) {
                buffer.append(' ');
            }
            buffer.append(" gc count ");
            buffer.append(collector.getCollectionCount());
            buffer.append(", time ");
            buffer.append(collector.getCollectionTime());
            buffer.append("ms, pools ");
            buffer.append(Arrays.toString(collector.getMemoryPoolNames())).append(EOL);
        }
        buffer.append("Other Managers").append(EOL);
        List<MemoryManagerMXBean> list = ManagementFactory.getMemoryManagerMXBeans();
        for (MemoryManagerMXBean manager : list) {
            if (manager instanceof GarbageCollectorMXBean) continue;
            buffer.append("  ");
            String name = manager.getName();
            buffer.append(name);
            for (int i = name.length(); i < 16; ++i) {
                buffer.append(' ');
            }
            buffer.append(" pools ");
            buffer.append(Arrays.toString(manager.getMemoryPoolNames())).append(EOL);
        }
        return buffer.toString();
    }

    private static StringBuilder appendPool(MemoryPoolMXBean pool, StringBuilder buffer) {
        String EOL = System.getProperty("line.separator");
        buffer.append("  ");
        String name = pool.getName();
        buffer.append(name);
        for (int i = name.length(); i < 16; ++i) {
            buffer.append(' ');
        }
        buffer.append(" ");
        Memory.appendUsage(pool.getUsage(), buffer);
        buffer.append(", peak ");
        Memory.append(pool.getPeakUsage().getUsed() >> 20, buffer, 3);
        buffer.append("MB, managers ");
        buffer.append(Arrays.toString(pool.getMemoryManagerNames())).append(EOL);
        return buffer;
    }

    private static StringBuilder appendUsage(MemoryUsage usage, StringBuilder buffer) {
        buffer.append("initial ");
        Memory.append(usage.getInit() >> 20, buffer, 3);
        buffer.append("MB, used ");
        Memory.append(usage.getUsed() >> 20, buffer, 3);
        buffer.append("MB, committed ");
        Memory.append(usage.getCommitted() >> 20, buffer, 3);
        buffer.append("MB, max ");
        Memory.append(usage.getMax() >> 20, buffer, 3);
        buffer.append("MB");
        return buffer;
    }

    private static StringBuilder append(long value, StringBuilder buffer, int width) {
        String text = String.valueOf(value);
        for (int i = text.length(); i < width; ++i) {
            buffer.append(' ');
        }
        buffer.append(text);
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpHeap(String path, boolean live) {
        Class<Memory> clazz = Memory.class;
        synchronized (Memory.class) {
            if (!hotspotMBeanLoaded) {
                hotspotMBeanLoaded = true;
                try {
                    hotspotMBean = (PlatformManagedObject)ManagementFactory.newPlatformMXBeanProxy(ManagementFactory.getPlatformMBeanServer(), "com.sun.management:type=HotSpotDiagnostic", Class.forName("com.sun.management.HotSpotDiagnosticMXBean"));
                }
                catch (RuntimeException e) {
                    Logger.getAnonymousLogger().throwing(Memory.class.getName(), "dumpHeap", e);
                }
                catch (Exception e) {
                    Logger.getAnonymousLogger().throwing(Memory.class.getName(), "dumpHeap", e);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (hotspotMBean != null) {
                try {
                    Method method = hotspotMBean.getClass().getDeclaredMethod("dumpHeap", String.class, Boolean.TYPE);
                    method.invoke((Object)hotspotMBean, path, live);
                }
                catch (RuntimeException e) {
                    Logger.getAnonymousLogger().throwing(Memory.class.getName(), "dumpHeap", e);
                }
                catch (Exception e) {
                    Logger.getAnonymousLogger().throwing(Memory.class.getName(), "dumpHeap", e);
                }
            }
            return;
        }
    }
}

