/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2;

import java.util.HashMap;
import java.util.Map;

public enum JdkVersion {
    JDK_UNKNOWN(0, "1.3"),
    JDK_1_1(1, "1.1"),
    JDK_1_2(2, "1.2"),
    JDK_1_3(3, "1.3"),
    JDK_1_4(4, "1.4"),
    JDK_1_5(5, "1.5"),
    JDK_1_6(6, "1.6"),
    JDK_1_7(7, "1.7"),
    JDK_1_8(8, "1.8"),
    JDK_9(9, "9"),
    JDK_10(10, "10"),
    JDK_11(11, "11"),
    JDK_12(12, "12"),
    JDK_13(13, "13"),
    JDK_14(14, "14"),
    JDK_15(15, "15"),
    JDK_16(16, "16"),
    JDK_17(17, "17"),
    JDK_18(18, "18"),
    JDK_19(19, "19"),
    JDK_20(20, "20"),
    JDK_21(21, "21"),
    JDK_22(22, "22"),
    JDK_23(23, "23"),
    JDK_24(24, "24"),
    JDK_25(25, "25");

    private byte versionNumber;
    private String versionString;
    private static Map<Integer, JdkVersion> versionMap;

    public static JdkVersion getMinVersion() {
        return JDK_1_3;
    }

    public static JdkVersion getMaxVersion() {
        JdkVersion[] jdkVersions = JdkVersion.values();
        return jdkVersions[jdkVersions.length - 1];
    }

    public boolean hasGenerics() {
        return this.versionNumber >= JdkVersion.JDK_1_5.versionNumber;
    }

    public boolean isJdk1OrAbove() {
        return this.versionNumber >= JdkVersion.JDK_1_1.versionNumber;
    }

    public boolean isJdk2OrAbove() {
        return this.versionNumber >= JdkVersion.JDK_1_2.versionNumber;
    }

    public boolean isJdk3OrAbove() {
        return this.versionNumber >= JdkVersion.JDK_1_3.versionNumber;
    }

    public boolean isJdk4OrAbove() {
        return this.versionNumber >= JdkVersion.JDK_1_4.versionNumber;
    }

    public boolean isJdk5OrAbove() {
        return this.versionNumber >= JdkVersion.JDK_1_5.versionNumber;
    }

    public boolean isJdk6OrAbove() {
        return this.versionNumber >= JdkVersion.JDK_1_6.versionNumber;
    }

    public boolean isJdk7OrAbove() {
        return this.versionNumber >= JdkVersion.JDK_1_7.versionNumber;
    }

    public boolean isJdk8OrAbove() {
        return this.versionNumber >= JdkVersion.JDK_1_8.versionNumber;
    }

    public boolean isJdk9OrAbove() {
        return this.versionNumber >= JdkVersion.JDK_9.versionNumber;
    }

    public boolean isHigherVersion(JdkVersion that) {
        return that == null || this.versionNumber > that.versionNumber;
    }

    public boolean isHigherOrEqualVersion(JdkVersion that) {
        return that == null || this.versionNumber >= that.versionNumber;
    }

    public boolean isLowerVersion(JdkVersion that) {
        return that != null && this.versionNumber < that.versionNumber;
    }

    public boolean isLowerOrEqualVersion(JdkVersion that) {
        return that != null && this.versionNumber <= that.versionNumber;
    }

    public static JdkVersion getJdkVersion(byte j2se) {
        switch (j2se) {
            case 1: {
                return JDK_1_1;
            }
            case 2: {
                return JDK_1_2;
            }
            case 3: {
                return JDK_1_3;
            }
            case 4: {
                return JDK_1_4;
            }
            case 5: {
                return JDK_1_5;
            }
            case 6: {
                return JDK_1_6;
            }
            case 7: {
                return JDK_1_7;
            }
            case 8: {
                return JDK_1_8;
            }
            case 9: {
                return JDK_9;
            }
            case 10: {
                return JDK_10;
            }
            case 11: {
                return JDK_11;
            }
            case 12: {
                return JDK_12;
            }
            case 13: {
                return JDK_13;
            }
            case 14: {
                return JDK_14;
            }
            case 15: {
                return JDK_15;
            }
            case 16: {
                return JDK_16;
            }
            case 17: {
                return JDK_17;
            }
            case 18: {
                return JDK_18;
            }
            case 19: {
                return JDK_19;
            }
            case 20: {
                return JDK_20;
            }
            case 21: {
                return JDK_21;
            }
            case 22: {
                return JDK_22;
            }
            case 23: {
                return JDK_23;
            }
            case 24: {
                return JDK_24;
            }
            case 25: {
                return JDK_25;
            }
        }
        return JDK_UNKNOWN;
    }

    public static JdkVersion getJdkVersion(String version) {
        if (version == null) {
            return JDK_UNKNOWN;
        }
        if ((version = version.trim()).length() == 0) {
            return JDK_UNKNOWN;
        }
        boolean sawPeriod = false;
        for (int x = 0; x < version.length(); ++x) {
            char c = version.charAt(x);
            if (c == ' ') {
                return JDK_UNKNOWN;
            }
            if (c == '.') {
                if (sawPeriod || !"1".equals(version.substring(0, x))) {
                    version = version.substring(0, x);
                    break;
                }
                sawPeriod = true;
                continue;
            }
            if (c >= '0' && c <= '9') continue;
            if (x == 0) {
                return JDK_UNKNOWN;
            }
            version = version.substring(0, x);
            break;
        }
        switch (version = version.length() == 0 || version.endsWith(".") ? "" : version) {
            case "1.1": {
                return JDK_1_1;
            }
            case "1.2": {
                return JDK_1_2;
            }
            case "1.3": {
                return JDK_1_3;
            }
            case "1.4": {
                return JDK_1_4;
            }
            case "1.5": {
                return JDK_1_5;
            }
            case "1.6": {
                return JDK_1_6;
            }
            case "1.7": {
                return JDK_1_7;
            }
            case "1.8": {
                return JDK_1_8;
            }
            case "1.9": {
                return JDK_9;
            }
            case "9": {
                return JDK_9;
            }
            case "10": {
                return JDK_10;
            }
            case "11": {
                return JDK_11;
            }
            case "12": {
                return JDK_12;
            }
            case "13": {
                return JDK_13;
            }
            case "14": {
                return JDK_14;
            }
            case "15": {
                return JDK_15;
            }
            case "16": {
                return JDK_16;
            }
            case "17": {
                return JDK_17;
            }
            case "18": {
                return JDK_18;
            }
            case "19": {
                return JDK_19;
            }
            case "20": {
                return JDK_20;
            }
            case "21": {
                return JDK_21;
            }
            case "22": {
                return JDK_22;
            }
            case "23": {
                return JDK_23;
            }
            case "24": {
                return JDK_24;
            }
            case "25": {
                return JDK_25;
            }
        }
        return JDK_UNKNOWN;
    }

    @Deprecated
    public byte getJ2se() {
        switch (this.versionNumber) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 8;
            }
            case 9: {
                return 9;
            }
            case 10: {
                return 10;
            }
            case 11: {
                return 11;
            }
            case 12: {
                return 12;
            }
            case 13: {
                return 13;
            }
            case 14: {
                return 14;
            }
            case 15: {
                return 15;
            }
            case 16: {
                return 16;
            }
            case 17: {
                return 17;
            }
            case 18: {
                return 18;
            }
            case 19: {
                return 19;
            }
            case 20: {
                return 20;
            }
            case 21: {
                return 21;
            }
            case 22: {
                return 22;
            }
            case 23: {
                return 23;
            }
            case 24: {
                return 24;
            }
            case 25: {
                return 25;
            }
        }
        return 0;
    }

    public String getVersionString() {
        return this.versionString;
    }

    public JdkVersion getPreviousVersion() {
        if (this == JDK_UNKNOWN) {
            return this;
        }
        this.generateVersionMap();
        JdkVersion previous = versionMap.get(this.versionNumber - 1);
        return previous != null ? previous : JDK_UNKNOWN;
    }

    public JdkVersion getNextVersion() {
        if (this == JDK_UNKNOWN) {
            return this;
        }
        this.generateVersionMap();
        JdkVersion previous = versionMap.get(this.versionNumber + 1);
        return previous != null ? previous : JDK_UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generateVersionMap() {
        if (versionMap != null) return;
        Class<JdkVersion> clazz = JdkVersion.class;
        synchronized (JdkVersion.class) {
            JdkVersion[] jdkVersions = JdkVersion.values();
            HashMap<Integer, JdkVersion> map = new HashMap<Integer, JdkVersion>(jdkVersions.length);
            for (JdkVersion jdkVersion : jdkVersions) {
                map.put(Integer.valueOf(jdkVersion.versionNumber), jdkVersion);
            }
            versionMap = map;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private JdkVersion(int versionNumber, String versionString) {
        this.versionNumber = (byte)versionNumber;
        this.versionString = versionString;
    }

    public String toString() {
        return this.versionString;
    }
}

