/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.parser.java.v2.common.CastedMethod;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.ParameterizedClass;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.common.QuickLocalVariable;
import oracle.javatools.parser.java.v2.common.QuickMethod;
import oracle.javatools.parser.java.v2.internal.InternalUtilities;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerContext;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerLayer3a;
import oracle.javatools.parser.java.v2.internal.compiler.SelfVariable;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeArgumentSym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ClassCreatorExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.DotExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.InvokeExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.LambdaExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ListExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.MethodCallExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.MethodReferenceExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.SimpleNameExpr;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.JavaWildcardType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceTypeArgument;
import oracle.javatools.parser.java.v2.model.expression.CompiledTmpVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;
import oracle.javatools.parser.java.v2.util.Conversions;

abstract class CompilerLayer3b
extends CompilerLayer3a {
    CompilerLayer3b() {
    }

    public final JavaHasType resolve(Expr e) {
        CompilerLayer3b.panic(e);
        return null;
    }

    public final JavaHasType resolve(SimpleNameExpr e) {
        boolean ambiguous = !e.flag_lvalue();
        return this.resolveName(e, null, ambiguous);
    }

    public final JavaHasType resolve(DotExpr e) {
        boolean ambiguous = !e.flag_lvalue();
        JavaHasType lhs = this.processLhsOperand(e);
        if (lhs == kEmptyResult) {
            Expr lhsSym = e.getLhsOperandSym();
            if (lhsSym != null && lhsSym.flag_maybePackage()) {
                String searchString = e.getQualifiedName();
                if (ambiguous) {
                    JavaType found = this.resolveType(e, searchString);
                    if (found != null) {
                        return found;
                    }
                    if (e.flag_maybePackage()) {
                        return null;
                    }
                }
                if (!this.skipCompilations() && !this.giveErrorAboutLeftMostErrorName(e)) {
                    Sym errorSym = e.symKind == 73 ? e : e.getNameSym();
                    this.error(errorSym, (short)62, e.getName());
                }
                return null;
            }
            return null;
        }
        return this.resolveName(e, lhs, ambiguous);
    }

    private boolean giveErrorAboutLeftMostErrorName(DotExpr dotExpr) {
        if (dotExpr != null && dotExpr.isQualifiedName()) {
            Expr lhsSym = dotExpr.getLhsOperandSym();
            String lhsName = null;
            Sym nameSym = null;
            String shortName = null;
            if (lhsSym.symKind == 65) {
                if (this.giveErrorAboutLeftMostErrorName((DotExpr)lhsSym)) {
                    return true;
                }
                if (((DotExpr)lhsSym).isQualifiedName()) {
                    lhsName = ((DotExpr)lhsSym).getQualifiedName();
                    nameSym = lhsSym.getNameSym();
                    shortName = lhsSym.getNameSym().getName();
                }
            } else if (lhsSym.symKind == 73) {
                lhsName = lhsSym.getName();
                nameSym = lhsSym;
                shortName = lhsName;
            }
            if (lhsName != null && this.getKnownPackage(lhsName) == null && this.resolveType(dotExpr, lhsName) == null) {
                JavaType lhsType;
                if (lhsSym.symKind == 65 && (lhsType = lhsSym.getLhsOperandSym().getResolvedType()) != null) {
                    this.error(nameSym, (short)59, shortName, lhsType, lhsType.getQualifiedName());
                    return true;
                }
                this.error(nameSym, (short)62, shortName);
                return true;
            }
        }
        return false;
    }

    protected JavaPackage getKnownPackage(String name) {
        JavaPackage javaPackage = this.provider.getPackage(name);
        if (javaPackage != null && javaPackage.exists()) {
            return javaPackage;
        }
        return null;
    }

    public final JavaMethod resolve(MethodCallExpr e) {
        JavaMethod method;
        JavaHasType lhs = this.processLhsOperand(e);
        if (lhs == kEmptyResult) {
            return null;
        }
        String name = e.getName();
        if (name.length() == 0) {
            this.error(e, (short)56);
            return null;
        }
        if ("this".equals(name) || "super".equals(name)) {
            method = this.resolveExplicitConstructor(e, lhs, e.getNameSym(), name);
            if (method == null) {
                return null;
            }
        } else {
            JavaType[] resolvedTypeArguments;
            JavaType lhsType;
            JavaType[] typeArguments = this.processTypeArguments(e);
            JavaType[] argumentTypes = this.getArgumentTypes(e, null);
            JavaHasType[] arguments = this.getArguments(e, null, null);
            method = this.resolveMethodCall(e, lhs, typeArguments, arguments, argumentTypes, false);
            if (method == null) {
                return null;
            }
            if (this.jdkVersion.isJdk8OrAbove() && method.isAbstract()) {
                lhsType = lhs != null ? lhs.getResolvedType() : null;
                SourceExpression lhsExpression = e.getLhsOperand();
                if (lhsType != null && lhsType.isInterface() && lhsExpression.getSymbolKind() == 76 && lhsExpression.getExpressionCode() == 49) {
                    this.error(e.getNameSym(), (short)99, name, argumentTypes, lhsType);
                    return null;
                }
            }
            if (typeArguments != null && (resolvedTypeArguments = this.resolveTypeArguments(e.getNameSym(), method, e.isGeneric() ? e.getTypeArguments() : Collections.emptyList())) != null && resolvedTypeArguments.length > 0) {
                method = CommonUtilities.createParameterizedMethod(this.provider, method, resolvedTypeArguments);
                this.checkTypeArguments(method);
            }
            if ("clone".equals(method.getName())) {
                lhsType = lhs != null ? lhs.getResolvedType() : null;
                if (lhsType != null && lhsType.isArray()) {
                    method = CastedMethod.newInstance(method, lhsType);
                }
            } else if ("getClass".equals(method.getName()) && method.getParameters().size() == 0) {
                JavaClass classClass;
                lhsType = null;
                if (lhs != null) {
                    lhsType = lhs.getResolvedType();
                } else {
                    ClassSym classSym = e.getOwningClassSym();
                    if (classSym != null) {
                        lhsType = classSym.getResolvedType();
                    }
                }
                if (lhsType != null && (classClass = this.provider.getClassByVMName("java/lang/Class")) != null) {
                    JavaType wildcard = CommonUtilities.createWildcardType((byte)1, lhsType, this.provider);
                    JavaType returnType = CommonUtilities.createParameterizedType(this.provider, classClass, new JavaType[]{wildcard});
                    method = CastedMethod.newInstance(method, returnType);
                }
            }
        }
        this.compileExceptions(e, method);
        return method;
    }

    public final JavaHasType resolve(LambdaExpr e, JavaType lambdaReturnType, boolean isValueCompatible) {
        Iterator iter;
        JavaMethod targetMethod;
        Collection<JavaType> targetTypes;
        TreeSym errorSym = e.getFormalsSym();
        if (errorSym == null || errorSym.isSkeleton()) {
            errorSym = e;
        }
        if ((targetTypes = CommonUtilities.getTargetType(e, null)).isEmpty()) {
            this.error(errorSym, (short)100);
            return null;
        }
        CompilerContext context = this.getCompilerContext();
        HashMap<JavaMethod, JavaType> targetMethodMap = new HashMap<JavaMethod, JavaType>();
        ArrayList<JavaMethod> targetMethods = new ArrayList<JavaMethod>();
        for (JavaType targetType : targetTypes) {
            targetMethod = CommonUtilities.getFunctionalInterfaceMethod(targetType = this.resolveTypeParametersOfLambdaTarget(e, context, targetType));
            if (targetMethod == null) continue;
            targetMethods.add(targetMethod);
            targetMethodMap.put(targetMethod, targetType);
        }
        if (targetMethods.isEmpty()) {
            this.error(errorSym, (short)100);
            return null;
        }
        if (!e.hasInferredFormalParameters()) {
            JavaType[] lambdaParameterTypes = e.getFormalParameterTypes();
            iter = targetMethods.iterator();
            block1: while (iter.hasNext()) {
                targetMethod = (JavaMethod)iter.next();
                JavaType[] targetMethodParameterTypes = targetMethod.getParameterTypes();
                if (targetMethod.isVarargs() != e.isVarargs() || targetMethodParameterTypes.length != lambdaParameterTypes.length) {
                    iter.remove();
                    continue;
                }
                for (int x = 0; x < lambdaParameterTypes.length; ++x) {
                    boolean targetTypeHasTypeParameter = InternalUtilities.hasTypeParameter(targetMethodParameterTypes[x], null);
                    if (targetMethodParameterTypes[x] != null && (targetTypeHasTypeParameter || targetMethodParameterTypes[x].equals(lambdaParameterTypes[x]))) continue;
                    iter.remove();
                    continue block1;
                }
            }
        } else {
            ArrayList<JavaMethod> output = new ArrayList<JavaMethod>();
            ArrayList<JavaMethod> rejected = new ArrayList<JavaMethod>();
            context.findPotentiallyApplicableMethods(targetMethods.iterator(), null, e.getFormalParameters().size(), output, null, false, rejected, false);
            targetMethods = output;
        }
        if (targetMethods.size() > 0) {
            boolean lambdaReturnTypeIsVoid;
            if (lambdaReturnType != null) {
                lambdaReturnTypeIsVoid = PrimitiveType.getVoidType().equals(lambdaReturnType);
            } else {
                boolean bl = lambdaReturnTypeIsVoid = !isValueCompatible;
            }
            if (lambdaReturnTypeIsVoid) {
                iter = targetMethods.iterator();
                while (iter.hasNext()) {
                    targetMethod = (JavaMethod)iter.next();
                    JavaType targetReturnType = targetMethod.getReturnType();
                    if (targetReturnType != null && PrimitiveType.getVoidType().equals(targetReturnType)) continue;
                    iter.remove();
                }
            } else {
                ArrayList<JavaMethod> targetMethodsCopy = this.weedOutIncompatibleMethods(e, targetMethods, lambdaReturnType, lambdaReturnTypeIsVoid, false);
                if (targetMethodsCopy.size() == 0) {
                    targetMethodsCopy = this.weedOutIncompatibleMethods(e, targetMethods, lambdaReturnType, lambdaReturnTypeIsVoid, true);
                }
                targetMethods = targetMethodsCopy;
            }
        }
        if (targetMethods.size() > 0) {
            if (targetMethods.size() > 1) {
                context.findMostSpecificMethod(targetMethods, e.getFormalParameterTypes(), false);
            }
            if (targetMethods.size() > 1) {
                this.error(errorSym, (short)41);
                return null;
            }
            return targetMethods.get(0);
        }
        this.error(e, (short)101);
        return null;
    }

    private JavaType resolveTypeParametersOfLambdaTarget(LambdaExpr e, CompilerContext context, JavaType originalType) {
        JavaType newType;
        Sym grandParentSym;
        Sym parentSym = e.getParentSym();
        Sym sym = grandParentSym = parentSym != null ? parentSym.getParentSym() : null;
        if (grandParentSym == null || grandParentSym.getSymbolKind() != 69) {
            return originalType;
        }
        MethodCallExpr callExpr = (MethodCallExpr)grandParentSym;
        Collection<JavaType> currentTypeArguments = originalType.getActualTypeArguments();
        JavaType[] newTypeArguments = new JavaType[currentTypeArguments.size()];
        int currentTypeArgCount = -1;
        boolean changed = false;
        for (JavaType currentTypeArgument : currentTypeArguments) {
            int x;
            JavaMethod method;
            String methodName;
            JavaElement owner;
            JavaType unresolvedTypeParam;
            newTypeArguments[++currentTypeArgCount] = currentTypeArgument;
            if (currentTypeArgument == null || (unresolvedTypeParam = this.getUnresolvedTypeParam(currentTypeArgument)) == null || (owner = unresolvedTypeParam.getOwner()) == null || owner.getElementKind() != 8 || (methodName = (method = (JavaMethod)owner).getName()) == null || !methodName.equals(callExpr.getName())) continue;
            Collection<JavaTypeVariable> typeParamCollection = method.getTypeParameters();
            JavaType[] typeParameters = new JavaType[typeParamCollection.size()];
            JavaType[] constraints = new JavaType[typeParameters.length];
            int count = 0;
            Iterator<JavaTypeVariable> iter = typeParamCollection.iterator();
            while (iter.hasNext()) {
                typeParameters[count] = iter.next().getResolvedType();
                constraints[count++] = null;
            }
            Collection<JavaVariable> paramCollection = method.getParameters();
            Iterator<JavaVariable> paramIter = paramCollection.iterator();
            JavaVariable parameter = null;
            for (x = 0; x < callExpr.getArgumentCount() && paramIter.hasNext(); ++x) {
                parameter = paramIter.next();
                SourceExpression argument = callExpr.getArgumentAt(x);
                if (argument instanceof LambdaExpr || argument instanceof MethodReferenceExpr) continue;
                JavaType parameterJavaType = parameter.getResolvedType();
                JavaType argumentJavaType = argument.getResolvedType();
                if (parameterJavaType == null || argumentJavaType == null) continue;
                context.inferFromOneArgument(parameterJavaType, argumentJavaType, typeParameters, constraints);
            }
            for (x = 0; x < typeParameters.length; ++x) {
                if (!typeParameters[x].equals(unresolvedTypeParam) || constraints[x] == null || CompilerLayer3b.hasTypeParameter(constraints[x], null)) continue;
                newTypeArguments[currentTypeArgCount] = constraints[x];
                changed = true;
            }
        }
        if (changed && (newType = originalType.getNonParameterizedType()) != null) {
            newType = CompilerLayer3b.createParameterizedType(this.provider, newType, newTypeArguments);
            return newType;
        }
        return originalType;
    }

    private ArrayList<JavaMethod> weedOutIncompatibleMethods(LambdaExpr lambdaExpr, ArrayList<JavaMethod> output, JavaType lambdaReturnType, boolean lambdaReturnTypeIsVoid, boolean allowBoxing) {
        SourceElement lambdaBody = lambdaExpr.getBody();
        boolean lambdaIsExpression = lambdaBody != null && lambdaBody.getSymbolKind() != 2;
        ArrayList<JavaMethod> outputCopy = new ArrayList<JavaMethod>(output);
        Iterator<JavaMethod> iter = outputCopy.iterator();
        while (iter.hasNext()) {
            JavaMethod targetMethod = iter.next();
            JavaType targetReturnType = targetMethod.getReturnType();
            if (PrimitiveType.getVoidType().equals(targetReturnType)) {
                if (lambdaReturnTypeIsVoid || lambdaIsExpression) continue;
                iter.remove();
                continue;
            }
            if (lambdaReturnType == null || Conversions.applyMethodConversion(lambdaReturnType, targetReturnType, allowBoxing, this.provider, this.jdkVersion)) continue;
            iter.remove();
        }
        return outputCopy;
    }

    public final JavaType resolve(MethodReferenceExpr e) {
        JavaHasType lhs = this.processLhsOperand(e);
        JavaType lhsResolvedType = lhs != null ? lhs.getResolvedType() : null;
        String name = e.getName();
        if (name.length() == 0) {
            this.error(e, (short)56);
            return null;
        }
        if ("new".equals(name)) {
            name = "<init>";
            if (lhsResolvedType != null) {
                if (lhsResolvedType.isAbstract()) {
                    this.error(e, (short)39);
                    return null;
                }
                if (lhsResolvedType.isEnum()) {
                    this.error(e, (short)102);
                }
            }
        }
        JavaType[] typeArguments = this.processTypeArguments(e);
        Collection<JavaType> targetTypes = CommonUtilities.getTargetType(e, null);
        if (targetTypes.isEmpty()) {
            this.error(e, (short)100);
            return null;
        }
        if ("<init>".equals(name) && lhsResolvedType != null && lhsResolvedType.isArray()) {
            for (JavaType targetType : targetTypes) {
                JavaType targetMethodType;
                JavaMethod targetMethod = CommonUtilities.getFunctionalInterfaceMethod(targetType);
                if (targetMethod == null || !Conversions.applyMethodConversion(lhsResolvedType, targetMethodType = targetMethod.getReturnType(), true, this.provider, this.jdkVersion)) continue;
                if (targetType instanceof ParameterizedClass) {
                    QuickLocalVariable parameter = QuickLocalVariable.createLocalVariable(PrimitiveType.getPrimitiveType(4), "count");
                    ArrayList<JavaVariable> parameters = new ArrayList<JavaVariable>();
                    parameters.add(parameter);
                    QuickMethod method = QuickMethod.createMethod(null, '\t', lhsResolvedType, "newInstance", parameters, null);
                    targetType = this.resolveTypeParametersWithMethodReference((ParameterizedClass)targetType, targetMethod, targetMethod.getParameterTypes(), (JavaMethod)method);
                }
                return targetType;
            }
            this.error(e, (short)101);
            return null;
        }
        List<JavaMethod> possibleResolvedMethods = this.resolveMethod(e, name, lhs, typeArguments);
        boolean[] resolutionRequiredBoxing = new boolean[]{false};
        JavaMethod[] resolvedMethod = new JavaMethod[]{null};
        JavaType result = this.resolve(e, lhs, possibleResolvedMethods, targetTypes, e, resolutionRequiredBoxing, resolvedMethod, typeArguments, name);
        e.setResolutionRequiredBoxing(resolutionRequiredBoxing[0]);
        if (result != null && resolvedMethod[0] != null) {
            e.setResolvedMethod(resolvedMethod[0]);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    JavaType resolve(SourceElement scope, JavaHasType lhs, List<JavaMethod> possibleMethodRefMethods, Collection<JavaType> targetTypes, Sym errorSym, boolean[] resolutionRequiredBoxing, JavaMethod[] resolvedMethod, JavaType[] methodReferenceTypeArgs, String methodReferenceName) {
        lhsIsType = lhs instanceof JavaType;
        lhsResolvedType = lhs != null ? lhs.getResolvedType() : null;
        targetMethods = new ArrayList<JavaMethod>();
        targetMethodMap = new HashMap<JavaMethod, JavaType>();
        for (JavaType targetType : targetTypes) {
            targetMethod = CommonUtilities.getFunctionalInterfaceMethod(targetType);
            if (targetMethod == null) continue;
            targetMethods.add(targetMethod);
            targetMethodMap.put(targetMethod, targetType);
        }
        if (targetMethods.isEmpty()) {
            if (errorSym != null) {
                this.error(errorSym, (short)100);
            }
            return null;
        }
        context = this.getCompilerContext();
        resolvedTargetMethodParameterTypes = null;
        voidType = PrimitiveType.getVoidType();
        resolvedObjectsList = new ArrayList<Object[]>(targetMethods.size());
        for (count = 0; count < 2; ++count) {
            for (JavaMethod targetMethod : targetMethods) {
                argumentTypes = targetMethod.getParameterTypes();
                argumentTypesNoFirst = new JavaType[argumentTypes.length > 0 ? argumentTypes.length - 1 : 0];
                for (x = 1; x < argumentTypes.length; ++x) {
                    argumentTypesNoFirst[x - 1] = argumentTypes[x];
                }
                targetParameters = targetMethod.getParameters();
                targetParameterIter = targetParameters.iterator();
                arguments = new JavaHasType[targetParameters.size()];
                argumentsNoFirst = new JavaHasType[targetParameters.size() > 0 ? targetParameters.size() - 1 : 0];
                for (x = 0; x < targetParameters.size(); ++x) {
                    arguments[x] = targetParameterIter.next();
                    if (x <= 0) continue;
                    argumentsNoFirst[x - 1] = arguments[x];
                }
                firstTargetParameterType = targetParameters.size() == 0 ? null : targetParameters.iterator().next().getResolvedType();
                targetReturnType = targetMethod.getReturnType();
                resolvedPossibleMethodRefMethods = null;
                if (firstTargetParameterType != null && lhsIsType) {
                    suppressErrors = context.suppressErrors;
                    context.suppressErrors = true;
                    try {
                        primary = firstTargetParameterType;
                        while (primary != null && primary.getElementKind() == 11) {
                            wildcardType = (JavaWildcardType)primary;
                            bounds = wildcardType.getUpperBounds();
                            if (bounds.isEmpty()) {
                                bounds = wildcardType.getLowerBounds();
                            }
                            primary = bounds.isEmpty() == false ? bounds.iterator().next() : null;
                        }
                        if (primary != null && (resolvedPossibleMethodRefMethods = this.resolveMethod((Sym)scope, methodReferenceName, primary, methodReferenceTypeArgs)).size() != possibleMethodRefMethods.size()) {
                            resolvedPossibleMethodRefMethods = possibleMethodRefMethods;
                        }
                    }
                    finally {
                        context.suppressErrors = suppressErrors;
                    }
                }
                if (resolvedPossibleMethodRefMethods == null) {
                    resolvedPossibleMethodRefMethods = possibleMethodRefMethods;
                }
                resolvedPossibleMethodRefMethodsIter = resolvedPossibleMethodRefMethods.iterator();
                possibleMethodsNoFirstParam = new ArrayList<JavaMethod>();
                possibleMethodsExtraFirstParam = new ArrayList<JavaMethod>();
                possibleMethodsAllParams = new ArrayList<JavaMethod>();
                for (JavaMethod possibleMethod : possibleMethodRefMethods) {
                    block58: {
                        block59: {
                            resolvedPossibleMethod = resolvedPossibleMethodRefMethodsIter.next();
                            if (lhsIsType && !possibleMethod.isStatic() && !possibleMethod.isConstructor()) {
                                possibleMethod = resolvedPossibleMethod;
                            }
                            addExtraArgument = false;
                            possibleMethodReturnType /* !! */  = possibleMethod.isConstructor() != false ? possibleMethod.getOwningClass() : possibleMethod.getReturnType();
                            if (possibleMethodReturnType /* !! */  != null && targetReturnType != null && (voidType.equals(possibleMethodReturnType /* !! */ ) && !voidType.equals(targetReturnType) || !voidType.equals(targetReturnType) && !Conversions.applyMethodConversion(possibleMethodReturnType /* !! */ , targetReturnType, count > 0, this.provider, this.jdkVersion))) continue;
                            possibleMethodParamCount = possibleMethod.getParameters().size();
                            targetParameterCount = targetParameters.size();
                            if (!lhsIsType || possibleMethod.isStatic()) break block58;
                            if (!possibleMethod.isConstructor()) break block59;
                            if (lhsResolvedType == null || lhsResolvedType.isStatic() || lhsResolvedType.getOwningClass() == null) break block58;
                            staticContext = false;
                            classContext = null;
                            block18: for (parent = ((Sym)scope).getParentSym(); parent != null; parent = parent.getParentSym()) {
                                switch (parent.symKind) {
                                    case 5: 
                                    case 19: {
                                        staticContext = parent.isStatic();
                                        ** GOTO lbl88
                                    }
                                    case 3: {
                                        classContext = parent;
                                        break block18;
                                    }
lbl88:
                                    // 2 sources

                                    default: {
                                        continue block18;
                                    }
                                }
                            }
                            owningClass = lhsResolvedType.getOwningClass();
                            if (staticContext || owningClass != classContext) {
                                if (firstTargetParameterType == null || !firstTargetParameterType.equals(owningClass)) {
                                    continue;
                                }
                            } else {
                                addExtraArgument = true;
                            }
                            if (!staticContext && !owningClass.isStatic()) {
                                targetParameterCount = targetParameters.size() + 1;
                            }
                            break block58;
                        }
                        if (firstTargetParameterType == null || !Conversions.applyMethodConversion(lhsResolvedType, firstTargetParameterType, count > 0, this.provider, this.jdkVersion)) continue;
                        targetParameterCount = targetParameters.size() - 1;
                    }
                    paramArgCountOK = false;
                    if (possibleMethod.isVarargs() == targetMethod.isVarargs()) {
                        if (!possibleMethod.isVarargs()) {
                            if (targetParameterCount == possibleMethodParamCount) {
                                paramArgCountOK = true;
                            }
                        } else if (targetParameterCount >= possibleMethodParamCount) {
                            paramArgCountOK = true;
                        }
                    } else if (possibleMethod.isVarargs() && targetParameterCount >= possibleMethod.getParameters().size() - 1) {
                        paramArgCountOK = true;
                    }
                    if (!paramArgCountOK) continue;
                    if (lhsIsType && targetParameterCount < targetParameters.size()) {
                        possibleMethodsNoFirstParam.add(possibleMethod);
                        continue;
                    }
                    if (addExtraArgument) {
                        possibleMethodsExtraFirstParam.add(possibleMethod);
                        continue;
                    }
                    possibleMethodsAllParams.add(possibleMethod);
                }
                suppressErrors = context.suppressErrors;
                context.suppressErrors = true;
                choosenMethod = null;
                choosenMethodConversions = 0;
                try {
                    methodAllParamTypes = argumentTypes;
                    methodAllParam = possibleMethodsAllParams.isEmpty() != false ? null : context.processMethodsImpl(possibleMethodsAllParams, null, arguments, argumentTypes, count == 0, true);
                    methodAllParamConversions = this.countConversions(methodAllParam, argumentTypes, targetReturnType);
                    methodNoFirstParamTypes = argumentTypesNoFirst;
                    methodNoFirstParam = possibleMethodsNoFirstParam.isEmpty() != false ? null : context.processMethodsImpl(possibleMethodsNoFirstParam, null, argumentsNoFirst, argumentTypesNoFirst, count == 0, true);
                    methodNoFirstParamConversions = this.countConversions(methodNoFirstParam, argumentTypesNoFirst, targetReturnType);
                    methodExtraFirstParamTypes = null;
                    methodExtraFirstParam = null;
                    methodExtraFirstParamConversions = 0;
                    if (!possibleMethodsExtraFirstParam.isEmpty()) {
                        possibleMethodExtraFirstParam = (JavaMethod)possibleMethodsExtraFirstParam.get(0);
                        extraJavaTypes = possibleMethodExtraFirstParam.getParameterTypes();
                        extraParameters = possibleMethodExtraFirstParam.getParameters();
                        newArgumentTypes = new JavaType[argumentTypes.length + 1];
                        newArgumentTypes[0] = extraJavaTypes[0];
                        for (a = 0; a < argumentTypes.length; ++a) {
                            newArgumentTypes[a + 1] = argumentTypes[a];
                        }
                        newArguments = new JavaHasType[arguments.length + 1];
                        newArguments[0] = extraParameters.iterator().next();
                        for (a = 0; a < arguments.length; ++a) {
                            newArguments[a + 1] = arguments[a];
                        }
                        methodExtraFirstParamTypes = newArgumentTypes;
                        methodExtraFirstParam = context.processMethodsImpl(possibleMethodsExtraFirstParam, null, newArguments, newArgumentTypes, count == 0, true);
                        methodExtraFirstParamConversions = this.countConversions(methodExtraFirstParam, newArgumentTypes, targetReturnType);
                    }
                    methodCount = 0;
                    if (methodAllParam != null) {
                        ++methodCount;
                    }
                    if (methodNoFirstParam != null) {
                        ++methodCount;
                    }
                    if (methodExtraFirstParam != null) {
                        ++methodCount;
                    }
                    if (methodCount > 1) {
                        context.suppressErrors = false;
                        if (errorSym != null) {
                            this.error(errorSym, (short)41);
                        }
                        var47_59 = null;
                        return var47_59;
                    }
                    if (methodAllParam != null) {
                        choosenMethod = methodAllParam;
                        choosenMethodConversions = methodAllParamConversions;
                        resolvedTargetMethodParameterTypes = methodAllParamTypes;
                    } else if (methodNoFirstParam != null) {
                        choosenMethod = methodNoFirstParam;
                        choosenMethodConversions = methodNoFirstParamConversions;
                        resolvedTargetMethodParameterTypes = methodNoFirstParamTypes;
                    } else {
                        choosenMethod = methodExtraFirstParam;
                        choosenMethodConversions = methodExtraFirstParamConversions;
                        resolvedTargetMethodParameterTypes = methodExtraFirstParamTypes;
                    }
                }
                finally {
                    context.suppressErrors = suppressErrors;
                }
                if (choosenMethod == null) continue;
                resolvedObjects = new Object[]{choosenMethod, targetMethod, choosenMethodConversions, count > 0};
                resolvedObjectsList.add(resolvedObjects);
            }
            if (resolvedObjectsList.size() > 0) break;
        }
        if (resolvedObjectsList.size() > 0) {
            if (resolvedObjectsList.size() > 1) {
                Collections.sort(resolvedObjectsList, new Comparator<Object[]>(){

                    @Override
                    public int compare(Object[] o1, Object[] o2) {
                        int y;
                        int x = (Integer)o1[2];
                        return x < (y = ((Integer)o2[2]).intValue()) ? -1 : (x == y ? 0 : 1);
                    }
                });
                while (resolvedObjectsList.size() > 1) {
                    resolvedObjectsList.remove(1);
                }
            }
            resolvedObjects = (Object[])resolvedObjectsList.get(0);
            resolvedMethod[0] = (JavaMethod)resolvedObjects[0];
            targetType = (JavaType)targetMethodMap.get(resolvedObjects[1]);
            resolutionRequiredBoxing[0] = (Boolean)resolvedObjects[3];
            if (targetType instanceof ParameterizedClass) {
                targetType = this.resolveTypeParametersWithMethodReference((ParameterizedClass)targetType, (JavaMethod)resolvedObjects[1], resolvedTargetMethodParameterTypes, (JavaMethod)resolvedObjects[0]);
            }
            return targetType;
        }
        if (errorSym != null) {
            this.error(errorSym, (short)101);
        }
        return null;
    }

    private int countConversions(JavaMethod resolvedMethod, JavaType[] argumentTypes, JavaType targetReturnType) {
        if (resolvedMethod == null) {
            return 0;
        }
        JavaType resolvedMethodReturnType = resolvedMethod.isConstructor() ? resolvedMethod.getOwningClass() : resolvedMethod.getResolvedType();
        int conversions = this.countConversions(resolvedMethodReturnType, targetReturnType);
        JavaType[] parameterTypes = resolvedMethod.getParameterTypes();
        int parameterTypesLength = parameterTypes.length;
        for (int x = 0; x < argumentTypes.length; ++x) {
            JavaType argumentType = argumentTypes[x];
            JavaType parameterType = null;
            if (x <= parameterTypesLength - 1) {
                parameterType = parameterTypes[x];
            } else if (resolvedMethod.isVarargs() && parameterTypesLength > 0 && (parameterType = parameterTypes[parameterTypesLength - 1]) != null) {
                parameterType = parameterType.isArray() ? parameterType.getComponentType() : null;
            }
            conversions += this.countConversions(argumentType, parameterType);
        }
        return conversions;
    }

    private int countConversions(JavaType subject, JavaType target) {
        PrimitiveType targetUnboxed;
        PrimitiveType subjectUnboxed;
        if (subject == null || target == null) {
            return 1000;
        }
        if (subject.equals(target)) {
            return 0;
        }
        int conversions = 0;
        if (!subject.isPrimitive() && (subjectUnboxed = PrimitiveType.applyUnboxingConversion(subject, this.jdkVersion)) != null) {
            ++conversions;
            subject = subjectUnboxed;
        }
        if (!target.isPrimitive() && (targetUnboxed = PrimitiveType.applyUnboxingConversion(target, this.jdkVersion)) != null) {
            ++conversions;
            target = targetUnboxed;
        }
        conversions = Conversions.applyAssignmentConversion(subject, target, false, null) ? ++conversions : (conversions += 2);
        return conversions;
    }

    private ParameterizedClass resolveTypeParametersWithMethodReference(ParameterizedClass originalType, JavaMethod targetMethod, JavaType[] targetParameterTypes, JavaMethod methodReference) {
        Collection<JavaType> currentTypeArguments = originalType.getActualTypeArguments();
        JavaType[] newTypeArguments = new JavaType[currentTypeArguments.size()];
        int boundArgCount = 0;
        boolean replaceParams = false;
        for (JavaType currentTypeArgument : currentTypeArguments) {
            JavaType unresolvedTypeParam;
            JavaType resolvedTypeArg = null;
            if (currentTypeArgument != null && (unresolvedTypeParam = this.getUnresolvedTypeParam(currentTypeArgument)) != null) {
                resolvedTypeArg = this.resolveTypeParametersWithMethodReference(currentTypeArgument, targetMethod, targetParameterTypes, methodReference);
            }
            if (resolvedTypeArg != null) {
                newTypeArguments[boundArgCount] = resolvedTypeArg;
                replaceParams = true;
            } else {
                newTypeArguments[boundArgCount] = currentTypeArgument;
            }
            ++boundArgCount;
        }
        if (replaceParams) {
            ParameterizedClass newType = (ParameterizedClass)CommonUtilities.createParameterizedType(this.provider, originalType.getTypeErasure(), newTypeArguments);
            newType.setTypeAnnotations(new ArrayList<JavaAnnotation>(originalType.getTypeAnnotations()));
            return newType;
        }
        return originalType;
    }

    private JavaType getUnresolvedTypeParam(JavaType currentTypeArgument) {
        if (currentTypeArgument == null) {
            return null;
        }
        if (currentTypeArgument.isArray()) {
            return this.getUnresolvedTypeParam(currentTypeArgument.getBaseComponentType());
        }
        int typeArgElemKind = currentTypeArgument.getElementKind();
        switch (typeArgElemKind) {
            case 10: {
                return currentTypeArgument;
            }
            case 11: {
                JavaWildcardType wildcard = (JavaWildcardType)currentTypeArgument;
                for (int x = 0; x < 2; ++x) {
                    Collection<JavaType> bounds = x == 0 ? wildcard.getLowerBounds() : wildcard.getUpperBounds();
                    for (JavaType bound : bounds) {
                        JavaType result = this.getUnresolvedTypeParam(bound);
                        if (result == null) continue;
                        return result;
                    }
                }
                break;
            }
            case 3: {
                Collection<JavaType> actualTypeArguments = currentTypeArgument.getActualTypeArguments();
                for (JavaType actualTypeArgument : actualTypeArguments) {
                    JavaType result = this.getUnresolvedTypeParam(actualTypeArgument);
                    if (result == null) continue;
                    return result;
                }
                break;
            }
        }
        return null;
    }

    private JavaType resolveTypeParametersWithMethodReference(JavaType originalTypeArg, JavaMethod targetMethod, JavaType[] targetParameterTypes, JavaMethod methodReference) {
        int x;
        if (originalTypeArg == null) {
            return null;
        }
        JavaType methodRefType = methodReference.isConstructor() ? methodReference.getOwningClass() : methodReference.getResolvedType();
        JavaType matchedType = this.matchTypeParameters(originalTypeArg, targetMethod.getResolvedType(), methodRefType);
        if (matchedType != null) {
            return matchedType;
        }
        JavaType[] methodRefParamTypes = methodReference.getParameterTypes();
        if (methodRefParamTypes.length > 0 && targetParameterTypes.length > 0 && (x = 0) < targetParameterTypes.length) {
            JavaType targetParamType = targetParameterTypes[x];
            if (targetMethod.isVarargs() && x >= targetParameterTypes.length - 1 && targetParamType != null) {
                targetParamType = targetParamType.getComponentType();
            }
            JavaType methodRefParamType = null;
            if (methodReference.isVarargs() && x >= methodRefParamTypes.length - 1) {
                methodRefParamType = methodRefParamTypes[methodRefParamTypes.length - 1];
                if (methodRefParamType != null) {
                    methodRefParamType = methodRefParamType.getComponentType();
                }
            } else if (x < methodRefParamTypes.length) {
                methodRefParamType = methodRefParamTypes[x];
            }
            if ((matchedType = this.matchTypeParameters(originalTypeArg, targetParamType, methodRefParamType)) != null) {
                return matchedType;
            }
            return null;
        }
        return null;
    }

    private JavaType matchTypeParameters(JavaType originalType, JavaType targetType, JavaType methodRefType) {
        if (originalType == null || targetType == null || methodRefType == null) {
            return null;
        }
        if (originalType.isArray() && targetType.isArray() && methodRefType.isArray()) {
            int originalTypeDim = originalType.getArrayDimensions();
            int targetTypeDim = targetType.getArrayDimensions();
            int methodRefTypeDim = methodRefType.getArrayDimensions();
            if (originalTypeDim == targetTypeDim && targetTypeDim == methodRefTypeDim) {
                JavaType baseType = this.matchTypeParameters(originalType.getBaseComponentType(), targetType.getBaseComponentType(), methodRefType.getBaseComponentType());
                if (baseType != null) {
                    return CommonUtilities.createArrayType(this.provider, baseType, originalTypeDim);
                }
                return null;
            }
        }
        int targetElemKind = targetType.getElementKind();
        int originalElemKind = originalType.getElementKind();
        if (targetElemKind == 10) {
            if (originalElemKind == 10) {
                if (originalType.equals(targetType)) {
                    return methodRefType;
                }
                return null;
            }
        } else if (targetElemKind == 11) {
            JavaWildcardType wildcard = (JavaWildcardType)targetType;
            Collection<JavaType> targetBounds = wildcard.getLowerBounds();
            if (targetBounds.isEmpty()) {
                targetBounds = wildcard.getUpperBounds();
            }
            for (JavaType bound : targetBounds) {
                JavaType match = this.matchTypeParameters(originalType, bound, methodRefType);
                if (match == null) continue;
                return match;
            }
            return null;
        }
        if (originalElemKind == 11) {
            JavaWildcardType wildcard = (JavaWildcardType)originalType;
            for (int x = 0; x < 2; ++x) {
                Collection<JavaType> bounds = x == 0 ? wildcard.getLowerBounds() : wildcard.getUpperBounds();
                for (JavaType bound : bounds) {
                    JavaType result = this.matchTypeParameters(bound, targetType, methodRefType);
                    if (result == null) continue;
                    return result;
                }
            }
            return null;
        }
        if (targetType.hasActualTypeArguments() && methodRefType.hasActualTypeArguments() && originalType.hasActualTypeArguments()) {
            Collection<JavaType> targetTypeArgs = targetType.getActualTypeArguments();
            Collection<JavaType> methodRefTypeArgs = methodRefType.getActualTypeArguments();
            Collection<JavaType> originalTypeArgs = originalType.getActualTypeArguments();
            if (targetTypeArgs.size() != methodRefTypeArgs.size() || targetTypeArgs.size() != originalTypeArgs.size()) {
                return null;
            }
            Iterator<JavaType> targetTypeArgsIter = targetTypeArgs.iterator();
            Iterator<JavaType> methodRefTypeArgsIter = methodRefTypeArgs.iterator();
            Iterator<JavaType> originalTypeArgsIter = originalTypeArgs.iterator();
            JavaType[] newTypeArguments = new JavaType[methodRefTypeArgs.size()];
            int boundArgCount = 0;
            boolean replaceType = false;
            while (targetTypeArgsIter.hasNext()) {
                JavaType targetTypeArg = targetTypeArgsIter.next();
                JavaType methodRefTypeArg = methodRefTypeArgsIter.next();
                JavaType originalTypeArg = originalTypeArgsIter.next();
                JavaType matchedType = this.matchTypeParameters(originalTypeArg, targetTypeArg, methodRefTypeArg);
                if (matchedType != null) {
                    newTypeArguments[boundArgCount] = matchedType;
                    replaceType = true;
                } else {
                    newTypeArguments[boundArgCount] = methodRefTypeArg;
                }
                ++boundArgCount;
            }
            if (replaceType) {
                ParameterizedClass newType = (ParameterizedClass)CommonUtilities.createParameterizedType(this.provider, methodRefType.getTypeErasure(), newTypeArguments);
                newType.setTypeAnnotations(new ArrayList<JavaAnnotation>(methodRefType.getTypeAnnotations()));
                return newType;
            }
            return null;
        }
        if (targetType.hasActualTypeArguments() && methodRefType.hasActualTypeArguments() && originalType.getElementKind() == 10) {
            Collection<JavaType> targetTypeArgs = targetType.getActualTypeArguments();
            Collection<JavaType> methodRefTypeArgs = methodRefType.getActualTypeArguments();
            if (targetTypeArgs.size() != methodRefTypeArgs.size()) {
                return null;
            }
            Iterator<JavaType> targetTypeArgsIter = targetTypeArgs.iterator();
            Iterator<JavaType> methodRefTypeArgsIter = methodRefTypeArgs.iterator();
            while (targetTypeArgsIter.hasNext()) {
                JavaType methodRefTypeArg;
                JavaType targetTypeArg = targetTypeArgsIter.next();
                JavaType matchedType = this.matchTypeParameters(originalType, targetTypeArg, methodRefTypeArg = methodRefTypeArgsIter.next());
                if (matchedType == null) continue;
                return matchedType;
            }
            return null;
        }
        return null;
    }

    boolean javaTypeContainsTypeParameter(JavaType javaType, JavaTypeVariable typeParam) {
        if (javaType == null) {
            return false;
        }
        if (javaType.equals(typeParam)) {
            return true;
        }
        if (javaType.getElementKind() == 11) {
            JavaWildcardType wildcard = (JavaWildcardType)javaType;
            for (int x = 0; x < 2; ++x) {
                Collection<JavaType> bounds = x == 0 ? wildcard.getUpperBounds() : wildcard.getLowerBounds();
                for (JavaType boundType : bounds) {
                    JavaType resolvedType;
                    if (boundType == null || !(resolvedType = boundType.getResolvedType()).equals(typeParam)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final JavaHasType resolve(ClassCreatorExpr e) {
        CompilerContext savedContext;
        JavaType targetType;
        ClassSym anonymous = e.getClassSym();
        JavaHasType lhs = this.processLhsOperand(e);
        TypeSym typeSym = e.getTypeSym();
        if (typeSym == null) {
            return null;
        }
        if (lhs == null) {
            JavaType outerClass;
            targetType = (JavaType)typeSym.resolve((CompilerDriver)this);
            if (targetType == null) {
                return null;
            }
            if (!this.skipCompilations() && targetType.hasActualTypeArguments()) {
                Collection<JavaType> typeArgumentTypes = targetType.getActualTypeArguments();
                List<Object> typeArgumentSyms = typeSym.isGeneric() ? typeSym.getTypeArguments() : Collections.emptyList();
                int count = 0;
                for (JavaType actualTypeArgument : typeArgumentTypes) {
                    if (actualTypeArgument != null && actualTypeArgument.getElementKind() == 11) {
                        ClassCreatorExpr errorSym = count < typeArgumentSyms.size() ? (Sym)typeArgumentSyms.get(count) : e;
                        this.error(errorSym, (short)73, targetType.getTypeErasure());
                        break;
                    }
                    ++count;
                }
            }
            if ((outerClass = CompilerLayer3b.getOuterClassOfNonstaticInner(targetType)) != null && (lhs = this.resolveEnclosingScope(e, outerClass)) == null) {
                this.error(e, (short)72, outerClass);
                return targetType.getThisValue();
            }
        } else {
            String name = typeSym.getName();
            if (name.length() == 0) {
                return (JavaHasType)this.error(e, (short)56);
            }
            if (lhs == kEmptyResult) {
                return null;
            }
            savedContext = this.getCompilerContext();
            try {
                this.setCompilerContext(this.newContext(e));
                targetType = this.processInnerCreatorType(e, lhs, name);
            }
            finally {
                this.setCompilerContext(savedContext);
            }
            if (targetType == null) {
                return null;
            }
        }
        JavaType lhsType = null;
        if (lhs != null) {
            lhsType = lhs.getResolvedType();
        }
        savedContext = this.getCompilerContext();
        try {
            boolean interfaceAnonClass;
            JavaMethod constructorMethod = null;
            JavaType[] argumentTypes = null;
            JavaHasType[] arguments = null;
            boolean bl = interfaceAnonClass = anonymous != null && targetType.isInterface() && e.getArgumentCount() == 0;
            if (!interfaceAnonClass) {
                JavaType[] resolvedTypeArguments;
                JavaType[] typeArguments = this.processTypeArguments(e);
                if (e.getChild((byte)67) == null) {
                    CompiledTmpVariable compiledTmpVariable = targetType.getThisValue();
                    return compiledTmpVariable;
                }
                argumentTypes = this.getArgumentTypes(e, lhsType);
                arguments = this.getArguments(e, lhs, lhsType);
                if (targetType.isEnum()) {
                    this.error(e, (short)102);
                }
                if (anonymous != null) {
                    this.setCompilerContext(this.newContext(anonymous.getBodySym()));
                }
                if (anonymous == null && targetType.isAbstract()) {
                    this.error(e, (short)39);
                }
                if ((constructorMethod = this.resolveMethodCall(e, targetType, typeArguments, arguments, argumentTypes)) != null && typeArguments != null && (resolvedTypeArguments = this.resolveTypeArguments(e.getNameSym(), constructorMethod, e.isGeneric() ? e.getTypeArguments() : Collections.emptyList())) != null && resolvedTypeArguments.length > 0) {
                    constructorMethod = CommonUtilities.createParameterizedMethod(this.provider, constructorMethod, resolvedTypeArguments);
                    this.checkTypeArguments(constructorMethod);
                }
            }
            if (targetType.hasTypeParameters() && targetType.hasActualTypeArguments() && targetType.getActualTypeArguments().isEmpty() && targetType.getTypeParameters().size() > 0) {
                int x;
                CompilerContext context = this.getCompilerContext();
                Collection<JavaTypeVariable> typeParameters = targetType.getTypeParameters();
                int tpCount = typeParameters.size();
                JavaTypeVariable[] tpArray = typeParameters.toArray(new JavaTypeVariable[tpCount]);
                JavaType[] constraints = new JavaType[tpCount];
                for (x = 0; x < tpCount; ++x) {
                    constraints[x] = null;
                }
                if (constructorMethod != null) {
                    context.inferTypeArguments(constructorMethod, tpArray, arguments, argumentTypes, targetType, constraints);
                }
                for (x = 0; x < tpCount; ++x) {
                    if (constraints[x] == null) continue;
                    context.fillInMissingConstraints(constraints, tpArray, tpCount);
                    Collection<JavaAnnotation> typeAnnotations = targetType.getTypeAnnotations();
                    targetType = targetType.getTypeErasure();
                    targetType = CommonUtilities.createParameterizedType(this.provider, targetType, constraints);
                    ((ParameterizedClass)targetType).setTypeAnnotations(new ArrayList<JavaAnnotation>(typeAnnotations));
                    break;
                }
            }
            if (constructorMethod != null) {
                this.compileExceptions(e, constructorMethod);
                CastedMethod castedMethod = anonymous != null ? CastedMethod.newInstance(constructorMethod, anonymous) : CastedMethod.newInstance(constructorMethod, targetType);
                CastedMethod castedMethod2 = castedMethod;
                return castedMethod2;
            }
            CompiledTmpVariable compiledTmpVariable = targetType.getThisValue();
            return compiledTmpVariable;
        }
        finally {
            this.setCompilerContext(savedContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JavaMethod resolveExplicitConstructor(MethodCallExpr e, JavaHasType lhs, Sym nameSym, String name) {
        CompilerContext savedContext = this.getCompilerContext();
        try {
            this.setCompilerContext(this.newContext(e));
            JavaMethod javaMethod = this.processExplicitConstructor(e, lhs, nameSym, name);
            return javaMethod;
        }
        finally {
            this.setCompilerContext(savedContext);
        }
    }

    private JavaHasType processLhsOperand(Expr e) {
        Expr lhs = (Expr)e.getLhsOperand();
        if (lhs == null) {
            return null;
        }
        JavaHasType result = (JavaHasType)lhs.resolve((CompilerDriver)this);
        if (result != null) {
            return result;
        }
        return kEmptyResult;
    }

    private JavaType[] getArgumentTypes(Expr e, JavaType firstArgument) {
        return this.getArgumentTypes((ListExpr)e.getChild((byte)67), firstArgument);
    }

    protected JavaType[] getArgumentTypes(ListExpr list, JavaType firstArgument) {
        int opc = list.getOperandCount();
        if (opc == 0) {
            if (firstArgument == null) {
                return JavaType.EMPTY_ARRAY;
            }
            JavaType[] out = new JavaType[]{firstArgument};
            return out;
        }
        if (firstArgument != null) {
            ++opc;
        }
        JavaType[] out = new JavaType[opc];
        int i = 0;
        if (firstArgument != null) {
            out[0] = firstArgument;
            ++i;
        }
        Iterator<SourceExpression> iterator = list.getOperands().iterator();
        while (iterator.hasNext()) {
            Expr operand;
            for (operand = (Expr)iterator.next(); operand != null && operand.getSymbolKind() == 77; operand = (Expr)operand.getFirstOperand()) {
            }
            boolean allowTypes = operand != null && operand.symKind == 79;
            out[i++] = this.processExpressionType(operand, allowTypes);
        }
        return out;
    }

    private JavaMethod processExplicitConstructor(MethodCallExpr e, JavaHasType lhs, Sym nameSym, String name) {
        JavaType outerClass;
        JavaType targetType;
        JavaHasType thisSuper = lhs != null && lhs.getElementKind() == 21 && "this".equals(((SelfVariable)lhs).getName()) ? this.resolveName(e, null, nameSym, name, true) : this.resolveName(e, lhs, nameSym, name, true);
        JavaType javaType = targetType = thisSuper != null ? thisSuper.getResolvedType() : null;
        if (targetType == null) {
            JavaType scope;
            Expr lhsSym = e.getLhsOperandSym();
            JavaType javaType2 = scope = lhsSym != null ? lhsSym.getResolvedType() : null;
            String scopeName = scope != null ? scope.getQualifiedName() : (lhsSym != null ? lhsSym.getUnresolvedType().getSimplifiedName() : null);
            return (JavaMethod)this.error(nameSym, (short)60, name, JavaType.EMPTY_ARRAY, scope, scopeName);
        }
        if (lhs == null && (outerClass = CompilerLayer3b.getOuterClassOfNonstaticInner(targetType)) != null) {
            ClassSym enclosingClass = e.getOwningClassSym();
            if (enclosingClass != null) {
                lhs = this.resolveEnclosingScope(enclosingClass, outerClass);
            }
            if (lhs == null) {
                this.error(e, (short)72, outerClass);
                return null;
            }
        }
        JavaType lhsType = null;
        if (lhs != null) {
            lhsType = lhs.getResolvedType();
        }
        JavaType[] argumentTypes = this.getArgumentTypes(e, lhsType);
        JavaHasType[] arguments = this.getArguments(e, lhs, lhsType);
        JavaMethod method = this.resolveMethodCall(e, targetType, null, arguments, argumentTypes, true);
        this.compileExceptions(e, method);
        return method;
    }

    private JavaHasType[] getArguments(InvokeExpr invokeExpression, JavaHasType lhs, JavaType lhsType) {
        SourceListExpression argumentList;
        boolean hasHiddenArgument = lhsType != null;
        JavaHasType[] arguments = new JavaHasType[invokeExpression.getArgumentCount() + (hasHiddenArgument ? 1 : 0)];
        if (hasHiddenArgument) {
            arguments[0] = lhs;
        }
        if ((argumentList = invokeExpression.getArgumentList()) != null) {
            for (int x = 0; x < argumentList.getOperandCount(); ++x) {
                arguments[x + (hasHiddenArgument ? 1 : 0)] = argumentList.getOperandAt(x);
            }
        }
        return arguments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JavaType[] processTypeArguments(Expr e) {
        JavaType[] array = null;
        if (e.isGeneric()) {
            List<SourceTypeArgument> typeArguments = e.getTypeArguments();
            if (typeArguments.isEmpty()) {
                return array;
            }
            CompilerContext savedContext = this.getCompilerContext();
            try {
                this.setCompilerContext(this.newContext(e));
                array = new JavaType[typeArguments.size()];
                int i = 0;
                for (TypeArgumentSym javaTypeArray : typeArguments) {
                    array[i++] = javaTypeArray.getResolvedType();
                }
                JavaType[] javaTypeArray = array;
                return javaTypeArray;
            }
            finally {
                this.setCompilerContext(savedContext);
            }
        }
        return array;
    }

    @Override
    protected final JavaType processInnerCreatorType(Expr lhsExpr, String name) {
        JavaHasType lhs = this.processExpression(lhsExpr);
        if (lhs == null) {
            return null;
        }
        return this.processInnerCreatorType(lhsExpr, lhs, name);
    }

    protected final JavaType processInnerCreatorType(Sym cookie, JavaHasType lhs, String name) {
        if (lhs instanceof JavaType) {
            this.error(cookie, (short)71, lhs);
            return null;
        }
        JavaType owningType = lhs.getResolvedType();
        if (owningType == null) {
            return null;
        }
        CompilerContext context = this.getCompilerContext();
        if (context != null) {
            return context.findMemberType(owningType, name);
        }
        return null;
    }
}

