/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.FormalParameterSym;
import oracle.javatools.parser.java.v2.internal.symbol.JavaClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.JavaFileSym;
import oracle.javatools.parser.java.v2.internal.symbol.JavaFormalParameterSym;
import oracle.javatools.parser.java.v2.internal.symbol.JavaHasAnnotationsSym;
import oracle.javatools.parser.java.v2.internal.symbol.MethodSym;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.UnresolvedType;

class JavaMethodSym
extends JavaHasAnnotationsSym
implements JavaMethod {
    private MethodSym methodSym;

    JavaMethodSym(MethodSym methodSym) {
        super(methodSym);
        this.methodSym = methodSym;
    }

    public boolean equals(Object o) {
        return this.methodSym.equals(o);
    }

    public int hashCode() {
        return this.methodSym.hashCode();
    }

    @Override
    public boolean isConstructor() {
        return this.methodSym.isConstructor();
    }

    @Override
    public boolean isVarargs() {
        return this.methodSym.isVarargs();
    }

    @Override
    public boolean isNative() {
        return this.methodSym.isNative();
    }

    @Override
    public JavaMethod getMethodErasure() {
        return this;
    }

    @Override
    public JavaType getReturnType() {
        return this.methodSym.getReturnType();
    }

    @Override
    public Collection<JavaVariable> getParameters() {
        Collection<JavaVariable> parameters = this.methodSym.getParameters();
        ArrayList<JavaVariable> wrappedParameters = new ArrayList<JavaVariable>();
        for (JavaVariable javaVariable : parameters) {
            if (javaVariable instanceof FormalParameterSym) {
                wrappedParameters.add(new JavaFormalParameterSym((FormalParameterSym)javaVariable));
                continue;
            }
            wrappedParameters.add(javaVariable);
        }
        return Collections.unmodifiableList(wrappedParameters);
    }

    @Override
    public JavaType[] getParameterTypes() {
        return this.methodSym.getParameterTypes();
    }

    @Override
    public Collection<JavaType> getExceptions() {
        return Collections.unmodifiableCollection(this.methodSym.getExceptions());
    }

    @Override
    public Object getDefaultValue() {
        return this.methodSym.getDefaultValue();
    }

    @Override
    public String getDescriptor() {
        return this.methodSym.getDescriptor();
    }

    @Override
    public String getTypeSignature() {
        return this.methodSym.getTypeSignature();
    }

    @Override
    public String getSignature() {
        return this.methodSym.getSignature();
    }

    @Override
    public boolean hasSubsignatureOf(JavaMethod other) {
        return this.methodSym.hasSubsignatureOf(other);
    }

    @Override
    public Collection<JavaMethod> getOverriddenMethods() {
        return Collections.unmodifiableCollection(this.methodSym.getOverriddenMethods());
    }

    @Override
    public Collection<JavaAnnotation> getReceiverTypeAnnotations() {
        return this.methodSym.getReceiverTypeAnnotations();
    }

    @Override
    public JavaClass getOwningClass() {
        ClassSym classSym = this.methodSym.getOwningClassSym();
        if (classSym != null) {
            return new JavaClassSym(classSym);
        }
        return null;
    }

    @Override
    public boolean isPublic() {
        return this.methodSym.isPublic();
    }

    @Override
    public boolean isProtected() {
        return this.methodSym.isProtected();
    }

    @Override
    public boolean isPrivate() {
        return this.methodSym.isPrivate();
    }

    @Override
    public boolean isStatic() {
        return this.methodSym.isStatic();
    }

    @Override
    public boolean isAbstract() {
        return this.methodSym.isAbstract();
    }

    @Override
    public boolean isPackagePrivate() {
        return this.methodSym.isPackagePrivate();
    }

    @Override
    public String getUniqueIdentifier() {
        return this.methodSym.getUniqueIdentifier();
    }

    @Override
    public int getElementKind() {
        return this.methodSym.getElementKind();
    }

    @Override
    public JavaFile getFile() {
        return new JavaFileSym(this.methodSym.symFile);
    }

    @Override
    public JavaElement getOwner() {
        JavaElement javaElement = this.methodSym.getOwner();
        if (javaElement instanceof ClassSym) {
            return new JavaClassSym((ClassSym)javaElement);
        }
        return javaElement;
    }

    @Override
    public boolean isSourceElement() {
        return false;
    }

    @Override
    public SourceMethod getSourceElement() {
        return this.methodSym.getSourceElement();
    }

    @Override
    public int getModifiers() {
        return this.methodSym.getModifiers();
    }

    @Override
    public boolean isFinal() {
        return this.methodSym.isFinal();
    }

    @Override
    public boolean isSynthetic() {
        return this.methodSym.isSynthetic();
    }

    @Override
    public boolean isHidden() {
        return this.methodSym.isHidden();
    }

    @Override
    public boolean isDeprecated() {
        return this.methodSym.isDeprecated();
    }

    @Override
    public String printCompiledInfo() {
        return this.methodSym.printCompiledInfo();
    }

    @Override
    public JavaType getResolvedType() {
        return this.methodSym.getResolvedType();
    }

    @Override
    public UnresolvedType getUnresolvedType() {
        return this.methodSym.getUnresolvedType();
    }

    @Override
    public String getName() {
        return this.methodSym.getName();
    }

    @Override
    public boolean hasTypeParameters() {
        return this.methodSym.hasTypeParameters();
    }

    @Override
    public Collection<JavaTypeVariable> getTypeParameters() {
        return Collections.unmodifiableCollection(this.methodSym.getTypeParameters());
    }

    @Override
    public JavaTypeVariable getTypeParameter(String name) {
        return this.methodSym.getTypeParameter(name);
    }

    @Override
    public boolean hasActualTypeArguments() {
        return this.methodSym.hasActualTypeArguments();
    }

    @Override
    public Collection<JavaType> getActualTypeArguments() {
        return Collections.unmodifiableCollection(this.methodSym.getActualTypeArguments());
    }

    @Override
    public Collection<JavaClass> getDeclaredAnonymousClasses() {
        return JavaClassSym.wrapClasses(this.methodSym.getDeclaredAnonymousClasses());
    }

    @Override
    public Collection<JavaClass> getDeclaredLocalClasses() {
        return JavaClassSym.wrapClasses(this.methodSym.getDeclaredLocalClasses());
    }

    @Override
    public JavaMethod getNonParameterizedMethod() {
        return this.methodSym.getNonParameterizedMethod();
    }
}

