/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.io.PrintWriter;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceModifier;

public final class ModifierSym
extends Sym
implements SourceModifier {
    public char modifier;

    @Override
    public char getModifier() {
        return this.modifier;
    }

    @Override
    public void setModifier(char value) {
        this.modifier = value;
    }

    @Override
    public String getValue() {
        switch (this.modifier) {
            case '\u0400': {
                return "abstract";
            }
            case '\u0200': {
                return "default";
            }
            case '\u0010': {
                return "final";
            }
            case '\u0100': {
                return "native";
            }
            case '\u0002': {
                return "private";
            }
            case '\u0004': {
                return "protected";
            }
            case '\u0001': {
                return "public";
            }
            case '\b': {
                return "static";
            }
            case '\u0800': {
                return "strictfp";
            }
            case ' ': {
                SourceElement parent = this.getParent();
                if (parent != null && parent.getSymbolKind() == 34) {
                    return "transitive";
                }
                if (parent != null && parent.getSymbolKind() == 32) {
                    return "open";
                }
                return "synchronized";
            }
            case '\u0080': {
                return "transient";
            }
            case '@': {
                SourceElement parent = this.getParent();
                if (parent != null && parent.getSymbolKind() == 34) {
                    return "static";
                }
                return "volatile";
            }
        }
        return "";
    }

    @Override
    public Sym cloneSelf(FileSym targetFile) {
        ModifierSym sym = (ModifierSym)super.cloneSelf(targetFile);
        sym.modifier = this.modifier;
        return sym;
    }

    @Override
    protected void verboseSelf(StringBuilder buffer) {
        buffer.append(' ');
        buffer.append('\"');
        buffer.append(this.getValue());
        buffer.append('\"');
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }

    @Override
    public void print(PrintWriter out, int ignored) {
        out.print(this.getValue());
    }

    @Override
    public void print(PrintWriter out) {
        out.print(this.getValue());
    }
}

