/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.text.DecimalFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import oracle.javatools.mt.annotation.CodeSharingSafe;

public final class Chronometer {
    private static final String TOTAL_PREFIX = "Total elapsed time: ";
    private static final String LAP_TEMPLATE = "Elapsed time for lap %s: %s";
    private static final String UNIT_HOURS = "h";
    private static final String UNIT_MINUTES = "m";
    private static final String UNIT_SECONDS = "s";
    private static final String UNIT_MILLISENCONDS = "ms";
    private static final String UNIT_MICROSENCONDS = "\u00b5s";
    private static final String UNIT_NANOSENCONDS = "ns";
    @CodeSharingSafe(value="StaticField")
    private static final long HOUR_IN_MILLIS = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.HOURS);
    @CodeSharingSafe(value="StaticField")
    private static final long MINUTE_IN_MILLIS = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.MINUTES);
    @CodeSharingSafe(value="StaticField")
    private static final long SECOND_IN_MILLIS = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.SECONDS);
    @CodeSharingSafe(value="StaticField")
    private static final long HOUR_IN_NANOS = TimeUnit.NANOSECONDS.convert(1L, TimeUnit.HOURS);
    @CodeSharingSafe(value="StaticField")
    private static final long MINUTE_IN_NANOS = TimeUnit.NANOSECONDS.convert(1L, TimeUnit.MINUTES);
    @CodeSharingSafe(value="StaticField")
    private static final long SECOND_IN_NANOS = TimeUnit.NANOSECONDS.convert(1L, TimeUnit.SECONDS);
    @CodeSharingSafe(value="StaticField")
    private static final long MILLIS_IN_NANOS = TimeUnit.NANOSECONDS.convert(1L, TimeUnit.MILLISECONDS);
    @CodeSharingSafe(value="StaticField")
    private static final long MICROS_IN_NANOS = TimeUnit.NANOSECONDS.convert(1L, TimeUnit.MICROSECONDS);
    private static final String HOURS_TO_MILLIS_TEMPLATE = "%dh %dm %ds %dms";
    private static final String MINUTES_TO_MILLIS_TEMPLATE = "%dm %ds %dms";
    private static final String SECONDS_TO_MILLIS_TEMPLATE = "%ds %dms";
    private static final String MILLIS_TEMPLATE = "%dms";
    private static final String HOURS_TO_NANOS_TEMPLATE = "%dh %dm %ds %dms %d\u00b5s %dns";
    private static final String MINUTES_TO_NANOS_TEMPLATE = "%dm %ds %dms %d\u00b5s %dns";
    private static final String SECONDS_TO_NANOS_TEMPLATE = "%ds %dms %d\u00b5s %dns";
    private static final String MILLIS_TO_NANOS_TEMPLATE = "%dms %d\u00b5s %dns";
    private static final String MICROS_TO_NANOS_TEMPLATE = "%d\u00b5s %dns";
    private static final String NANOS_TEMPLATE = "%dns";
    private final LinkedHashMap<String, Long> laps = new LinkedHashMap();
    private String currentLap = null;
    private long startTime;
    private long stopTime;
    private long totalElapsed;
    private long elapsedLap;
    private final Precision precision;

    public Chronometer() {
        this(Precision.Milliseconds);
    }

    public Chronometer(Precision precision) {
        this.precision = precision != null ? precision : Precision.Milliseconds;
    }

    public long stop() {
        long now = this.now();
        if (this.isRunning()) {
            this.stopTime = now;
            this.totalElapsed += this.stopTime - this.startTime;
            if (!this.laps.isEmpty()) {
                this.elapsedLap += this.stopTime - this.laps.get(this.currentLap);
            }
        }
        return this.getElapsedTime(now);
    }

    public void reset() {
        this.laps.clear();
        this.currentLap = null;
        this.startTime = 0L;
        this.stopTime = 0L;
        this.totalElapsed = 0L;
        this.elapsedLap = 0L;
    }

    public static Chronometer getStarted() {
        Chronometer c = new Chronometer();
        c.start();
        return c;
    }

    public static Chronometer getStarted(Precision precision) {
        Chronometer c = new Chronometer(precision);
        c.start();
        return c;
    }

    public void start() {
        long now = this.now();
        if (this.isRunning()) {
            throw new IllegalStateException("Chronometer is already running");
        }
        this.startTime = now;
        if (!this.laps.isEmpty()) {
            this.laps.put(this.currentLap, this.startTime);
        }
        this.stopTime = 0L;
    }

    private long now() {
        return this.precision.now();
    }

    public boolean isRunning() {
        return this.startTime > 0L && this.stopTime == 0L;
    }

    public long getElapsedTime() {
        long now = this.now();
        return this.getElapsedTime(now);
    }

    private long getElapsedTime(long relativeTime) {
        return this.isRunning() ? this.totalElapsed + relativeTime - this.startTime : this.totalElapsed;
    }

    public int countLaps() {
        return this.laps.size();
    }

    public void newLap(String label) {
        long now = this.now();
        this.newLap(label, now);
    }

    private void newLap(String label, long now) {
        if (label == null) {
            throw new IllegalArgumentException("Lap label can't be null");
        }
        if (!this.isRunning()) {
            throw new IllegalStateException("Chronometer not started");
        }
        if (!this.laps.isEmpty()) {
            this.laps.put(this.currentLap, this.elapsedLap);
        }
        this.laps.put(label, now);
        this.currentLap = label;
        this.elapsedLap = 0L;
    }

    public long getLap(String label) {
        long now = this.now();
        return this.getLap(label, now);
    }

    private long getLap(String label, long relativeTime) {
        Long lap = this.laps.get(label);
        if (lap == null) {
            return 0L;
        }
        return this.getLap(label, lap, relativeTime);
    }

    private long getLap(String label, long lap, long relativeTime) {
        return !label.equals(this.currentLap) ? lap : (this.stopTime == 0L ? this.elapsedLap + relativeTime - lap : this.elapsedLap);
    }

    public long getCurrentLap() {
        long now = this.now();
        return !this.laps.isEmpty() ? this.getLap(this.currentLap, now) : 0L;
    }

    public static String format(long time) {
        return Precision.Milliseconds.format(time);
    }

    public static String format(long time, Precision precision) {
        return precision.format(time);
    }

    public static String format(long time, TimeUnit precision) {
        return Precision.get(precision).format(time);
    }

    public String dumpTimes() {
        long now = this.now();
        StringBuilder sb = new StringBuilder();
        sb.append(TOTAL_PREFIX);
        sb.append(this.precision.format(this.getElapsedTime(now)));
        if (!this.laps.isEmpty()) {
            sb.append("\n\nLAPS:\n");
            for (Map.Entry<String, Long> entry : this.laps.entrySet()) {
                sb.append("\n");
                String label = entry.getKey();
                sb.append(this.toString(label, this.getLap(label, entry.getValue(), now)));
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    public String toString() {
        long now = this.now();
        return this.precision.format(this.getElapsedTime(now));
    }

    public String toString(String label) {
        long now = this.now();
        return this.toString(label, this.getLap(label, now));
    }

    private String toString(String label, long lap) {
        return String.format(LAP_TEMPLATE, label, this.precision.format(lap));
    }

    public static enum Precision {
        Milliseconds{

            @Override
            long now() {
                return System.currentTimeMillis();
            }

            @Override
            String format(long time) {
                DecimalFormat fmt = new DecimalFormat();
                fmt.setParseIntegerOnly(true);
                if (time < SECOND_IN_MILLIS) {
                    return String.format(Chronometer.MILLIS_TEMPLATE, time);
                }
                if (time < MINUTE_IN_MILLIS) {
                    long s = time / SECOND_IN_MILLIS;
                    long ms = s * SECOND_IN_MILLIS;
                    return String.format(Chronometer.SECONDS_TO_MILLIS_TEMPLATE, s, time - ms);
                }
                if (time < HOUR_IN_MILLIS) {
                    long m = time / MINUTE_IN_MILLIS;
                    long ms = m * MINUTE_IN_MILLIS;
                    long s = time / SECOND_IN_MILLIS % 60L;
                    return String.format(Chronometer.MINUTES_TO_MILLIS_TEMPLATE, m, s, time - (ms += s * SECOND_IN_MILLIS));
                }
                long h = time / HOUR_IN_MILLIS;
                long ms = h * HOUR_IN_MILLIS;
                long m = time / MINUTE_IN_MILLIS % 60L;
                ms += m * MINUTE_IN_MILLIS;
                long s = time / SECOND_IN_MILLIS % 60L;
                return String.format(Chronometer.HOURS_TO_MILLIS_TEMPLATE, h, m, s, time - (ms += s * SECOND_IN_MILLIS));
            }
        }
        ,
        Nanoseconds{

            @Override
            long now() {
                return System.nanoTime();
            }

            @Override
            String format(long time) {
                DecimalFormat fmt = new DecimalFormat();
                fmt.setParseIntegerOnly(true);
                if (time < MICROS_IN_NANOS) {
                    return String.format(Chronometer.NANOS_TEMPLATE, time);
                }
                if (time < MILLIS_IN_NANOS) {
                    long micros = time / MICROS_IN_NANOS;
                    long ns = micros * MICROS_IN_NANOS;
                    return String.format(Chronometer.MICROS_TO_NANOS_TEMPLATE, micros, time - ns);
                }
                if (time < SECOND_IN_NANOS) {
                    long ms = time / MILLIS_IN_NANOS;
                    long ns = ms * MILLIS_IN_NANOS;
                    long micros = time / MICROS_IN_NANOS % TimeUnit.MICROSECONDS.convert(1L, TimeUnit.MILLISECONDS);
                    return String.format(Chronometer.MILLIS_TO_NANOS_TEMPLATE, ms, micros, time - (ns += micros * MICROS_IN_NANOS));
                }
                if (time < MINUTE_IN_NANOS) {
                    long s = time / SECOND_IN_NANOS;
                    long ns = s * SECOND_IN_NANOS;
                    long ms = time / MILLIS_IN_NANOS % TimeUnit.MILLISECONDS.convert(1L, TimeUnit.SECONDS);
                    ns = ms * MILLIS_IN_NANOS;
                    long micros = time / MICROS_IN_NANOS % TimeUnit.MICROSECONDS.convert(1L, TimeUnit.MILLISECONDS);
                    return String.format(Chronometer.SECONDS_TO_NANOS_TEMPLATE, s, ms, micros, time - (ns += micros * MICROS_IN_NANOS));
                }
                if (time < HOUR_IN_NANOS) {
                    long m = time / MINUTE_IN_NANOS;
                    long ns = m * MINUTE_IN_NANOS;
                    long s = time / SECOND_IN_NANOS % TimeUnit.SECONDS.convert(1L, TimeUnit.MINUTES);
                    ns = s * SECOND_IN_NANOS;
                    long ms = time / MILLIS_IN_NANOS % TimeUnit.MILLISECONDS.convert(1L, TimeUnit.SECONDS);
                    ns = ms * MILLIS_IN_NANOS;
                    long micros = time / MICROS_IN_NANOS % TimeUnit.MICROSECONDS.convert(1L, TimeUnit.MILLISECONDS);
                    return String.format(Chronometer.MINUTES_TO_NANOS_TEMPLATE, m, s, ms, micros, time - (ns += micros * MICROS_IN_NANOS));
                }
                long h = time / HOUR_IN_NANOS;
                long ns = h * HOUR_IN_NANOS;
                long m = time / MINUTE_IN_NANOS % TimeUnit.MINUTES.convert(1L, TimeUnit.HOURS);
                ns = m * MINUTE_IN_NANOS;
                long s = time / SECOND_IN_NANOS % TimeUnit.SECONDS.convert(1L, TimeUnit.MINUTES);
                ns = s * SECOND_IN_NANOS;
                long ms = time / MILLIS_IN_NANOS % TimeUnit.MILLISECONDS.convert(1L, TimeUnit.SECONDS);
                ns = ms * MILLIS_IN_NANOS;
                long micros = time / MICROS_IN_NANOS % TimeUnit.MICROSECONDS.convert(1L, TimeUnit.MILLISECONDS);
                return String.format(Chronometer.HOURS_TO_NANOS_TEMPLATE, h, m, s, ms, micros, time - (ns += micros * MICROS_IN_NANOS));
            }
        };

        private static final long serialVersionUID = 1L;

        abstract long now();

        abstract String format(long var1);

        private static Precision get(TimeUnit unit) {
            switch (unit) {
                case DAYS: 
                case HOURS: 
                case MINUTES: 
                case SECONDS: 
                case MILLISECONDS: {
                    return Milliseconds;
                }
            }
            return Nanoseconds;
        }
    }
}

